/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.io;

import com.esri.sde.sdk.client.SeRasterTile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.geotools.arcsde.raster.info.RasterCellType;
import org.geotools.arcsde.raster.io.TileInfo;

abstract class TileDataFetcher {
    private static Map<RasterCellType, TileDataFetcher> tileDataSetters = new HashMap<RasterCellType, TileDataFetcher>();

    TileDataFetcher() {
    }

    public static TileDataFetcher getTileDataFetcher(RasterCellType nativeType, RasterCellType targetCellType) {
        if (nativeType != targetCellType) {
            if (nativeType == RasterCellType.TYPE_1BIT && targetCellType == RasterCellType.TYPE_8BIT_U) {
                return new OneBitTileSetter();
            }
            if (nativeType == RasterCellType.TYPE_8BIT_U && targetCellType == RasterCellType.TYPE_16BIT_U) {
                return new UcharToUshort();
            }
            if (nativeType == RasterCellType.TYPE_16BIT_S && targetCellType == RasterCellType.TYPE_32BIT_S) {
                return new ShortToInt();
            }
            if (nativeType == RasterCellType.TYPE_8BIT_S && targetCellType == RasterCellType.TYPE_16BIT_S) {
                return new ByteToShort();
            }
            if (nativeType == RasterCellType.TYPE_16BIT_U && targetCellType == RasterCellType.TYPE_32BIT_U) {
                return new UShortToUInt();
            }
            if (nativeType == RasterCellType.TYPE_32BIT_U && targetCellType == RasterCellType.TYPE_64BIT_REAL) {
                return new UIntToDouble();
            }
            if (nativeType == RasterCellType.TYPE_32BIT_S && targetCellType == RasterCellType.TYPE_64BIT_REAL) {
                return new IntToDouble();
            }
            throw new IllegalArgumentException("No registered TileDataFetcher for pixel type " + (Object)((Object)nativeType) + " and target type " + (Object)((Object)targetCellType));
        }
        TileDataFetcher tileDataFetcher = tileDataSetters.get((Object)nativeType);
        if (tileDataFetcher == null) {
            throw new IllegalArgumentException("No registered TileDataFetcher for pixel type " + (Object)((Object)nativeType));
        }
        return tileDataFetcher;
    }

    public abstract void setTileData(SeRasterTile var1, TileInfo var2);

    protected final boolean isNoData(int sampleN, byte[] bitmaskData) {
        boolean isNoData = (bitmaskData[sampleN / 8] >> 7 - sampleN % 8 & 1) == 0;
        return isNoData;
    }

    static {
        ByteTileSetter byteTileSetter = new ByteTileSetter();
        tileDataSetters.put(RasterCellType.TYPE_1BIT, new OneBitTileSetter());
        tileDataSetters.put(RasterCellType.TYPE_4BIT, byteTileSetter);
        tileDataSetters.put(RasterCellType.TYPE_8BIT_S, byteTileSetter);
        tileDataSetters.put(RasterCellType.TYPE_8BIT_U, byteTileSetter);
        tileDataSetters.put(RasterCellType.TYPE_16BIT_U, new UShortTileSetter());
        tileDataSetters.put(RasterCellType.TYPE_16BIT_S, new ShortTileSetter());
        tileDataSetters.put(RasterCellType.TYPE_32BIT_S, new IntegerTileSetter());
        tileDataSetters.put(RasterCellType.TYPE_32BIT_U, new UnsignedIntegerTileSetter());
        tileDataSetters.put(RasterCellType.TYPE_32BIT_REAL, new FloatTileSetter());
        tileDataSetters.put(RasterCellType.TYPE_64BIT_REAL, new DoubleTileSetter());
    }

    private static final class UShortToUInt
    extends TileDataFetcher {
        private UShortToUInt() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            int numPixelsRead = tileInfo.getNumPixelsRead();
            int nodata = tileInfo.getNoDataValue().intValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileInfo.getTileDataAsIntegers(), nodata);
            } else {
                int[] tileData = tileInfo.getTileDataAsIntegers();
                try {
                    tile.getPixels(tileData);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                if (hasNoDataPixels) {
                    byte[] bitmaskData = tileInfo.getBitmaskData();
                    for (int pn = 0; pn < numPixelsRead; ++pn) {
                        if (!this.isNoData(pn, bitmaskData)) continue;
                        tileData[pn] = nodata;
                    }
                }
            }
        }
    }

    private static final class UIntToDouble
    extends TileDataFetcher {
        private UIntToDouble() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            int numPixelsRead = tileInfo.getNumPixelsRead();
            double nodata = tileInfo.getNoDataValue().doubleValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileInfo.getTileDataAsDoubles(), nodata);
            } else {
                double[] tileData = tileInfo.getTileDataAsDoubles();
                try {
                    tile.getPixels(tileData);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                if (hasNoDataPixels) {
                    byte[] bitmaskData = tileInfo.getBitmaskData();
                    for (int pn = 0; pn < numPixelsRead; ++pn) {
                        if (!this.isNoData(pn, bitmaskData)) continue;
                        tileData[pn] = nodata;
                    }
                }
            }
        }
    }

    private static final class IntToDouble
    extends TileDataFetcher {
        private int[] cache = new int[0];

        private IntToDouble() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            int numPixelsRead = tileInfo.getNumPixelsRead();
            int numPixels = tileInfo.getNumPixels();
            double nodata = tileInfo.getNoDataValue().doubleValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileInfo.getTileDataAsDoubles(), nodata);
            } else {
                if (this.cache.length < numPixels) {
                    this.cache = new int[numPixels];
                }
                try {
                    tile.getPixels(this.cache);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                double[] tileData = tileInfo.getTileDataAsDoubles();
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                byte[] bitmaskData = tileInfo.getBitmaskData();
                for (int pn = 0; pn < numPixelsRead; ++pn) {
                    tileData[pn] = hasNoDataPixels && this.isNoData(pn, bitmaskData) ? nodata : (double)this.cache[pn];
                }
            }
        }
    }

    private static final class ShortToInt
    extends TileDataFetcher {
        private ShortToInt() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            int numPixelsRead = tileInfo.getNumPixelsRead();
            int nodata = tileInfo.getNoDataValue().intValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileInfo.getTileDataAsIntegers(), nodata);
            } else {
                int[] cache = tileInfo.getTileDataAsIntegers();
                try {
                    tile.getPixels(cache);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                if (hasNoDataPixels) {
                    byte[] bitmaskData = tileInfo.getBitmaskData();
                    for (int pn = 0; pn < numPixelsRead; ++pn) {
                        if (!this.isNoData(pn, bitmaskData)) continue;
                        cache[pn] = nodata;
                    }
                }
            }
        }
    }

    private static final class ByteToShort
    extends TileDataFetcher {
        private ByteToShort() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            int numPixelsRead = tileInfo.getNumPixelsRead();
            short nodata = tileInfo.getNoDataValue().shortValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileInfo.getTileDataAsShorts(), nodata);
            } else {
                byte[] pixelData = tile.getPixelData();
                short[] tileDataShorts = tileInfo.getTileDataAsShorts();
                byte[] bitmaskData = tileInfo.getBitmaskData();
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                for (int pn = 0; pn < numPixelsRead; ++pn) {
                    tileDataShorts[pn] = hasNoDataPixels && this.isNoData(pn, bitmaskData) ? nodata : (short)pixelData[pn];
                }
            }
        }
    }

    private static final class UcharToUshort
    extends TileDataFetcher {
        private UcharToUshort() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            int numPixelsRead = tileInfo.getNumPixelsRead();
            short nodata = (short)(tileInfo.getNoDataValue().intValue() & 0xFFFF);
            short[] tileDataUShorts = tileInfo.getTileDataAsUnsignedShorts();
            if (numPixelsRead == 0) {
                Arrays.fill(tileDataUShorts, nodata);
            } else {
                byte[] pixelData = tile.getPixelData();
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                byte[] bitmaskData = tileInfo.getBitmaskData();
                for (int pn = 0; pn < numPixelsRead; ++pn) {
                    tileDataUShorts[pn] = hasNoDataPixels && this.isNoData(pn, bitmaskData) ? nodata : (short)(pixelData[pn] & 0xFF);
                }
            }
        }
    }

    private static final class DoubleTileSetter
    extends TileDataFetcher {
        private DoubleTileSetter() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            double[] tileData = tileInfo.getTileDataAsDoubles();
            int numPixelsRead = tileInfo.getNumPixelsRead();
            double nodata = tileInfo.getNoDataValue().doubleValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileData, nodata);
            } else {
                try {
                    tile.getPixels(tileData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (tileInfo.hasNoDataPixels()) {
                    byte[] bitmaskData = tileInfo.getBitmaskData();
                    for (int pn = 0; pn < numPixelsRead; ++pn) {
                        if (!this.isNoData(pn, bitmaskData)) continue;
                        tileData[pn] = nodata;
                    }
                }
            }
        }
    }

    private static final class FloatTileSetter
    extends TileDataFetcher {
        private FloatTileSetter() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            float[] tileData = tileInfo.getTileDataAsFloats();
            int numPixelsRead = tileInfo.getNumPixelsRead();
            float nodata = tileInfo.getNoDataValue().floatValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileData, nodata);
            } else {
                try {
                    tile.getPixels(tileData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (tileInfo.hasNoDataPixels()) {
                    byte[] bitmaskData = tileInfo.getBitmaskData();
                    for (int pn = 0; pn < numPixelsRead; ++pn) {
                        if (!this.isNoData(pn, bitmaskData)) continue;
                        tileData[pn] = nodata;
                    }
                }
            }
        }
    }

    private static final class UnsignedIntegerTileSetter
    extends TileDataFetcher {
        private UnsignedIntegerTileSetter() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            double[] tileData = tileInfo.getTileDataAsDoubles();
            int numPixelsRead = tileInfo.getNumPixelsRead();
            double nodata = tileInfo.getNoDataValue().doubleValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileData, nodata);
            } else {
                try {
                    tile.getPixels(tileData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                if (hasNoDataPixels) {
                    byte[] bitmaskData = tileInfo.getBitmaskData();
                    for (int pn = 0; pn < numPixelsRead; ++pn) {
                        if (!this.isNoData(pn, bitmaskData)) continue;
                        tileData[pn] = nodata;
                    }
                }
            }
        }
    }

    private static final class IntegerTileSetter
    extends TileDataFetcher {
        private IntegerTileSetter() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            int[] tileData = tileInfo.getTileDataAsIntegers();
            int numPixelsRead = tileInfo.getNumPixelsRead();
            int nodata = tileInfo.getNoDataValue().intValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileData, nodata);
            } else {
                try {
                    tile.getPixels(tileData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (tileInfo.hasNoDataPixels()) {
                    byte[] bitmaskData = tileInfo.getBitmaskData();
                    for (int pn = 0; pn < numPixelsRead; ++pn) {
                        if (!this.isNoData(pn, bitmaskData)) continue;
                        tileData[pn] = nodata;
                    }
                }
            }
        }
    }

    private static final class ShortTileSetter
    extends TileDataFetcher {
        private ShortTileSetter() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            short[] tileData = tileInfo.getTileDataAsShorts();
            int numPixelsRead = tileInfo.getNumPixelsRead();
            int numPixels = tileInfo.getNumPixels();
            short nodata = tileInfo.getNoDataValue().shortValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileData, nodata);
            } else {
                int[] ints = new int[numPixels];
                try {
                    tile.getPixels(ints);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                byte[] bitmaskData = tileInfo.getBitmaskData();
                for (int pn = 0; pn < numPixels; ++pn) {
                    tileData[pn] = hasNoDataPixels && this.isNoData(pn, bitmaskData) ? nodata : (short)ints[pn];
                }
            }
        }
    }

    private static final class UShortTileSetter
    extends TileDataFetcher {
        private UShortTileSetter() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            short[] tileData = tileInfo.getTileDataAsUnsignedShorts();
            int numPixelsRead = tileInfo.getNumPixelsRead();
            int numPixels = tileInfo.getNumPixels();
            short nodata = (short)(tileInfo.getNoDataValue().intValue() & 0xFFFF);
            if (numPixelsRead == 0) {
                Arrays.fill(tileData, nodata);
            } else {
                int[] ints = new int[numPixels];
                try {
                    tile.getPixels(ints);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                byte[] bitmaskData = tileInfo.getBitmaskData();
                for (int pn = 0; pn < numPixels; ++pn) {
                    tileData[pn] = hasNoDataPixels && this.isNoData(pn, bitmaskData) ? nodata : (short)ints[pn];
                }
            }
        }
    }

    private static final class ByteTileSetter
    extends TileDataFetcher {
        private ByteTileSetter() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            int numPixelsRead = tileInfo.getNumPixelsRead();
            byte nodata = tileInfo.getNoDataValue().byteValue();
            byte[] tileData = tileInfo.getTileDataAsBytes();
            if (numPixelsRead == 0) {
                Arrays.fill(tileData, nodata);
            } else {
                byte[] pixelData = tile.getPixelData();
                System.arraycopy(pixelData, 0, tileData, 0, numPixelsRead);
                if (tileInfo.hasNoDataPixels()) {
                    byte[] bitmaskData = tileInfo.getBitmaskData();
                    for (int pn = 0; pn < numPixelsRead; ++pn) {
                        if (!this.isNoData(pn, bitmaskData)) continue;
                        tileData[pn] = nodata;
                    }
                }
            }
        }
    }

    private static final class OneBitTileSetter
    extends TileDataFetcher {
        private OneBitTileSetter() {
        }

        @Override
        public void setTileData(SeRasterTile tile, TileInfo tileInfo) {
            byte[] tileData = tileInfo.getTileDataAsBytes();
            int numPixelsRead = tileInfo.getNumPixelsRead();
            byte nodata = tileInfo.getNoDataValue().byteValue();
            if (numPixelsRead == 0) {
                Arrays.fill(tileData, nodata);
            } else {
                try {
                    tile.getPixels(tileData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                int bitSet = -1;
                boolean hasNoDataPixels = tileInfo.hasNoDataPixels();
                byte[] bitmaskData = tileInfo.getBitmaskData();
                for (int pn = 0; pn < numPixelsRead; ++pn) {
                    if (hasNoDataPixels && this.isNoData(pn, bitmaskData)) {
                        tileData[pn] = nodata;
                        continue;
                    }
                    if (-1 != tileData[pn]) continue;
                    tileData[pn] = 1;
                }
            }
        }
    }
}

