/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data.view;

import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeSqlConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.geotools.arcsde.session.ISession;
import org.geotools.util.logging.Logging;

public class QueryInfoParser {
    private static final Logger LOGGER = Logging.getLogger((String)QueryInfoParser.class.getPackage().getName());

    public static SeQueryInfo parse(ISession session, PlainSelect select) throws SeException, IOException {
        String[] columns = null;
        String[] tables = null;
        String where = null;
        String orderAndOrGroupByClause = null;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("building SeQueryInfo to reflect " + select);
        }
        columns = QueryInfoParser.getColumns(session, select.getSelectItems());
        tables = QueryInfoParser.getTables(select.getFromItems());
        Expression whereClause = select.getWhere();
        if (whereClause != null) {
            where = whereClause.toString();
        }
        if (select.getGroupByColumnReferences() != null && select.getGroupByColumnReferences().size() > 0) {
            String gb;
            orderAndOrGroupByClause = gb = PlainSelect.getFormatedList((List)select.getGroupByColumnReferences(), (String)" GROUP BY ");
        }
        if (select.getOrderByElements() != null && select.getOrderByElements().size() > 0) {
            String ob = PlainSelect.orderByToString((List)select.getOrderByElements());
            if (orderAndOrGroupByClause == null) {
                orderAndOrGroupByClause = "";
            }
            orderAndOrGroupByClause = orderAndOrGroupByClause + " " + ob;
        }
        SeQueryInfo qinfo = new SeQueryInfo();
        qinfo.setColumns(columns);
        SeSqlConstruct sqlConstruct = new SeSqlConstruct();
        sqlConstruct.setTables(tables);
        if (where != null) {
            sqlConstruct.setWhere(where);
        }
        qinfo.setConstruct(sqlConstruct);
        if (orderAndOrGroupByClause != null) {
            qinfo.setByClause(orderAndOrGroupByClause);
        }
        return qinfo;
    }

    private static String[] getTables(List fromItems) {
        if (fromItems == null) {
            throw new NullPointerException("fromItems");
        }
        ArrayList<String> tableNames = new ArrayList<String>(fromItems.size());
        for (FromItem fromItem : fromItems) {
            String fromItemDef = fromItem.toString();
            tableNames.add(fromItemDef);
        }
        return tableNames.toArray(new String[tableNames.size()]);
    }

    private static String[] getColumns(ISession session, List selectItems) throws IOException {
        if (selectItems == null || selectItems.size() == 0) {
            return null;
        }
        ArrayList<String> colNames = new ArrayList<String>(selectItems.size());
        for (SelectItem item : selectItems) {
            if (item instanceof AllColumns) continue;
            if (item instanceof AllTableColumns) {
                AllTableColumns allTableCols = (AllTableColumns)item;
                Table table = allTableCols.getTable();
                List tableColNames = QueryInfoParser.getTableColumns(session, table);
                colNames.addAll(tableColNames);
                continue;
            }
            if (item instanceof SelectExpressionItem) {
                String stringItem = item.toString();
                colNames.add(stringItem);
                continue;
            }
            throw new RuntimeException("unknown select item type: " + item);
        }
        String[] columns = colNames.toArray(new String[colNames.size()]);
        return columns;
    }

    private static List getTableColumns(ISession session, Table table) throws IOException {
        ArrayList<String> colNames = new ArrayList<String>();
        String tableName = table.getSchemaName() + "." + table.getName();
        SeColumnDefinition[] cols = session.describe(tableName);
        for (int i = 0; i < cols.length; ++i) {
            String colName = cols[i].getName();
            colName = tableName + "." + colName;
            colNames.add(colName);
        }
        return colNames;
    }
}

