/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeShape;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;

public class SeToJTSGeometryFactory
implements com.esri.sde.sdk.geom.GeometryFactory {
    protected static GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    private SeToJTSGeometryFactory delegate;

    public void init(int type, int numParts, int numPoints) {
        if (type == SeShape.TYPE_POLYGON) {
            this.delegate = new PolygonFactory();
        } else if (type == SeShape.TYPE_MULTI_POLYGON) {
            this.delegate = new MultiPolygonFactory();
        } else {
            throw new IllegalArgumentException("Unhandled geometry type: " + type);
        }
        this.delegate.init(numParts, numPoints);
    }

    protected void init(int numParts, int numPoints) {
    }

    public void envelope(double minx, double miny, double maxx, double maxy) {
    }

    public Geometry getGeometry() {
        return this.delegate.getGeometry();
    }

    public void newPart(int numSubParts) {
        this.delegate.newPart(numSubParts);
    }

    public void newSubPart(int numPoints) {
        this.delegate.newSubPart(numPoints);
    }

    public void newPoint(double x, double y) {
        this.delegate.newPoint(x, y);
    }

    public void newPoint(double x, double y, double m) {
        this.newPoint(x, y);
    }

    public void newPoint(double x, double y, double m, double z) {
        this.newPoint(x, y);
    }

    public void partOffsets(int[] partOffsets) {
    }

    private static final class MultiPolygonFactory
    extends SeToJTSGeometryFactory {
        private PolygonFactory polygonFactory;
        private Polygon[] parts;
        private int partNo;

        private MultiPolygonFactory() {
        }

        @Override
        protected void init(int numParts, int numPoints) {
            this.parts = new Polygon[numParts];
            this.polygonFactory = new PolygonFactory();
            this.partNo = -1;
        }

        @Override
        public Geometry getGeometry() {
            if (this.parts.length > 0) {
                this.parts[this.parts.length - 1] = this.polygonFactory.getGeometry();
            }
            MultiPolygon mp = gf.createMultiPolygon(this.parts);
            return mp;
        }

        @Override
        public void newPart(int numSubParts) {
            if (this.partNo > -1) {
                Polygon poly;
                this.parts[this.partNo] = poly = this.polygonFactory.getGeometry();
            }
            ++this.partNo;
            this.polygonFactory.init(1, -1);
            this.polygonFactory.newPart(numSubParts);
        }

        @Override
        public void newSubPart(int numPoints) {
            this.polygonFactory.newSubPart(numPoints);
        }

        @Override
        public void newPoint(double x, double y) {
            this.polygonFactory.newPoint(x, y);
        }
    }

    private static final class PolygonFactory
    extends SeToJTSGeometryFactory {
        private LinearRing[] subparts;
        private CoordinateSequence currCoordSeq;
        private int subPartNo;
        private int currPartNumPoints;
        private int currPointNo;

        private PolygonFactory() {
        }

        @Override
        protected void init(int numParts, int numPoints) {
            this.subPartNo = -1;
            this.currCoordSeq = null;
        }

        public Polygon getGeometry() {
            LinearRing shell = this.subparts[0];
            LinearRing[] holes = null;
            if (this.subparts.length > 1) {
                holes = new LinearRing[this.subparts.length - 1];
                System.arraycopy(this.subparts, 0, holes, 0, holes.length);
            }
            Polygon poly = gf.createPolygon(shell, holes);
            return poly;
        }

        @Override
        public void newPart(int numSubParts) {
            this.subparts = new LinearRing[numSubParts];
            this.subPartNo = -1;
        }

        @Override
        public void newSubPart(int numPoints) {
            ++this.subPartNo;
            this.currPartNumPoints = numPoints;
            this.currPointNo = 0;
            int dimension = 2;
            this.currCoordSeq = JTS.createCS((CoordinateSequenceFactory)gf.getCoordinateSequenceFactory(), (int)numPoints, (int)2);
        }

        @Override
        public void newPoint(double x, double y) {
            this.currCoordSeq.setOrdinate(this.currPointNo, 0, x);
            this.currCoordSeq.setOrdinate(this.currPointNo, 1, y);
            ++this.currPointNo;
            if (this.currPointNo == this.currPartNumPoints) {
                this.subparts[this.subPartNo] = gf.createLinearRing(this.currCoordSeq);
            }
        }
    }
}

