/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.data.ArcSDEQuery;
import org.geotools.arcsde.data.ArcSdeFeatureCollection;
import org.geotools.arcsde.data.ArcSdeResourceInfo;
import org.geotools.arcsde.data.FeatureTypeInfo;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class ArcSdeFeatureSource
implements SimpleFeatureSource {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.data");
    private static final Set<RenderingHints.Key> supportedHints = new HashSet<RenderingHints.Key>();
    protected Transaction transaction = Transaction.AUTO_COMMIT;
    protected FeatureTypeInfo typeInfo;
    protected ArcSDEDataStore dataStore;
    private ArcSdeResourceInfo resourceInfo;
    private QueryCapabilities queryCapabilities;

    public ArcSdeFeatureSource(final FeatureTypeInfo typeInfo, ArcSDEDataStore dataStore) {
        this.typeInfo = typeInfo;
        this.dataStore = dataStore;
        this.queryCapabilities = new QueryCapabilities(){

            public boolean supportsSorting(SortBy[] sortAttributes) {
                SimpleFeatureType featureType = typeInfo.getFeatureType();
                for (SortBy sortBy : sortAttributes) {
                    if (SortBy.NATURAL_ORDER == sortBy || SortBy.REVERSE_ORDER == sortBy) {
                        return false;
                    }
                    String attName = sortBy.getPropertyName().getPropertyName();
                    AttributeDescriptor descriptor = featureType.getDescriptor(attName);
                    if (descriptor == null) {
                        return false;
                    }
                    if (!(descriptor instanceof GeometryDescriptor)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public synchronized ArcSdeResourceInfo getInfo() {
        if (this.resourceInfo == null) {
            this.resourceInfo = new ArcSdeResourceInfo(this.typeInfo, this);
        }
        return this.resourceInfo;
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.queryCapabilities;
    }

    public final void addFeatureListener(FeatureListener listener) {
        this.dataStore.listenerManager.addFeatureListener((FeatureSource)this, listener);
    }

    public final void removeFeatureListener(FeatureListener listener) {
        this.dataStore.listenerManager.removeFeatureListener((FeatureSource)this, listener);
    }

    public final ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ReferencedEnvelope getBounds(Query query) throws IOException {
        ReferencedEnvelope ev;
        Query namedQuery = this.namedQuery(query);
        ISession session = this.getSession();
        try {
            ev = this.getBounds(namedQuery, session);
        }
        finally {
            session.dispose();
        }
        return ev;
    }

    protected ReferencedEnvelope getBounds(Query namedQuery, ISession session) throws DataSourceException, IOException {
        String typeName = this.typeInfo.getFeatureTypeName();
        ArcSdeVersionHandler versionHandler = this.dataStore.getVersionHandler(typeName, this.transaction);
        Envelope ev = ArcSDEQuery.calculateQueryExtent(session, this.typeInfo, namedQuery, versionHandler);
        if (ev != null) {
            GeometryDescriptor defaultGeometry;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("ArcSDE optimized getBounds call returned: " + ev);
            }
            ReferencedEnvelope envelope = (defaultGeometry = this.getSchema().getGeometryDescriptor()) == null ? ReferencedEnvelope.reference((Envelope)ev) : new ReferencedEnvelope(ev, defaultGeometry.getCoordinateReferenceSystem());
            return envelope;
        }
        LOGGER.finer("ArcSDE couldn't process all filters in this query, so optimized getBounds() returns null.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCount(Query query) throws IOException {
        int count;
        Query namedQuery = this.namedQuery(query);
        ISession session = this.getSession();
        try {
            count = this.getCount(namedQuery, session);
        }
        finally {
            session.dispose();
        }
        return count;
    }

    protected int getCount(Query namedQuery, ISession session) throws IOException {
        String typeName = this.typeInfo.getFeatureTypeName();
        ArcSdeVersionHandler versionHandler = this.dataStore.getVersionHandler(typeName, this.transaction);
        int count = ArcSDEQuery.calculateResultCount(session, this.typeInfo, namedQuery, versionHandler);
        return count;
    }

    protected final ISession getSession() throws IOException {
        return this.dataStore.getSession(this.transaction);
    }

    private Query namedQuery(Query query) {
        String localName = this.typeInfo.getFeatureTypeName();
        String typeName = query.getTypeName();
        if (typeName != null && !localName.equals(typeName)) {
            throw new IllegalArgumentException("Wrong type name: " + typeName + " (this is " + localName + ")");
        }
        Query namedQuery = new Query(query);
        namedQuery.setTypeName(localName);
        return namedQuery;
    }

    public final ArcSDEDataStore getDataStore() {
        return this.dataStore;
    }

    public final SimpleFeatureCollection getFeatures(Query query) throws IOException {
        Query namedQuery = this.namedQuery(query);
        SimpleFeatureType queryType = this.dataStore.getQueryType(namedQuery);
        ArcSdeFeatureCollection collection = new ArcSdeFeatureCollection(this, queryType, namedQuery);
        return collection;
    }

    public final SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        Query query = new Query(this.typeInfo.getFeatureTypeName(), filter);
        return this.getFeatures(query);
    }

    public final SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures((Filter)Filter.INCLUDE);
    }

    public final SimpleFeatureType getSchema() {
        return this.typeInfo.getFeatureType();
    }

    public final Set<RenderingHints.Key> getSupportedHints() {
        return supportedHints;
    }

    public ArcSdeVersionHandler getVersionHandler() throws IOException {
        return this.dataStore.getVersionHandler(this.typeInfo.getFeatureTypeName(), this.transaction);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getfeatureReader(SimpleFeatureType targetSchema, Query query) throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.dataStore.getFeatureReader(query, this.transaction, targetSchema);
        return featureReader;
    }

    static {
        supportedHints.add((RenderingHints.Key)Hints.FEATURE_DETACHED);
        supportedHints.add((RenderingHints.Key)Hints.JTS_GEOMETRY_FACTORY);
        supportedHints.add((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        supportedHints.add((RenderingHints.Key)Hints.JTS_PRECISION_MODEL);
        supportedHints.add((RenderingHints.Key)Hints.JTS_SRID);
    }
}

