/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde;

import com.esri.sde.sdk.client.SeError;
import com.esri.sde.sdk.client.SeException;
import java.io.IOException;

public class ArcSdeException
extends IOException {
    private static final long serialVersionUID = -1392514883217797825L;

    public ArcSdeException(SeException cause) {
        this("", cause);
    }

    public ArcSdeException(String msg, SeException cause) {
        super(msg);
        if (cause != null) {
            this.initCause((Throwable)cause);
        }
    }

    public SeException getCause() {
        return (SeException)super.getCause();
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        SeError error = this.getSeError();
        StringBuffer sb = new StringBuffer();
        if (message != null) {
            sb.append(message);
        }
        if (error != null) {
            int sdeError = error.getSdeError();
            String sdeErrMsg = error.getSdeErrMsg();
            String extErrMsg = error.getExtErrMsg();
            String errDesc = error.getErrDesc();
            sb.append("[SDE error ").append(sdeError);
            if (sdeErrMsg != null && !"".equals(sdeErrMsg)) {
                sb.append(" ").append(sdeErrMsg);
            }
            sb.append("]");
            if (errDesc != null && !"".equals(errDesc)) {
                sb.append("[Error desc=").append(errDesc).append("]");
            }
            if (extErrMsg != null && !"".equals(extErrMsg)) {
                sb.append("[Extended desc=").append(extErrMsg).append("]");
            }
        }
        return sb.toString();
    }

    public SeError getSeError() {
        SeException ex = this.getCause();
        if (ex == null) {
            return null;
        }
        return ex.getSeError();
    }

    public static String toMessage(SeException e) {
        StringBuffer buf = new StringBuffer();
        if (e.getSeError() != null) {
            SeError error = e.getSeError();
            buf.append("SDE Error ");
            buf.append(error.getSdeError());
            buf.append(" ");
            buf.append(error.getSdeErrMsg());
            if (error.getExtErrMsg() != null) {
                buf.append("\n");
                buf.append(error.getExtErrMsg());
            }
            if (error.getErrDesc() != null) {
                buf.append("\n");
                buf.append(error.getErrDesc());
            }
        }
        if (e.getMessage() != null) {
            buf.append("\n");
            buf.append(e.getMessage());
        }
        return buf.toString();
    }
}

