/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.opengis.wfs.BaseRequestType;
import net.opengis.wfs.FeatureCollectionType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.feature.FeatureCollection;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public class GML3OutputFormat
extends WFSGetFeatureOutputFormat {
    WFS wfs;
    Data catalog;
    WFSConfiguration configuration;

    public GML3OutputFormat(WFS wfs, Data catalog, WFSConfiguration configuration) {
        super(new HashSet<Object>(Arrays.asList("gml3", "text/xml; subtype=gml/3.1.1")));
        this.wfs = wfs;
        this.catalog = catalog;
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) {
        return "text/xml; subtype=gml/3.1.1";
    }

    public String getCapabilitiesElementName() {
        return "GML3";
    }

    protected void write(FeatureCollectionType results, OutputStream output, Operation getFeature) throws ServiceException, IOException {
        EList featureCollections = results.getFeature();
        HashMap<String, HashSet<FeatureTypeInfo>> ns2metas = new HashMap<String, HashSet<FeatureTypeInfo>>();
        for (FeatureCollection features : featureCollections) {
            SimpleFeatureType featureType = (SimpleFeatureType)features.getSchema();
            String namespaceURI = featureType.getName().getNamespaceURI();
            FeatureTypeInfo meta = this.catalog.getFeatureTypeInfo(featureType.getTypeName(), namespaceURI);
            if (meta == null) {
                throw new WFSException("Could not find feature type " + namespaceURI + ":" + featureType.getTypeName() + " in the GeoServer catalog");
            }
            HashSet<FeatureTypeInfo> metas = (HashSet<FeatureTypeInfo>)ns2metas.get(namespaceURI);
            if (metas == null) {
                metas = new HashSet<FeatureTypeInfo>();
                ns2metas.put(namespaceURI, metas);
            }
            metas.add(meta);
        }
        Encoder encoder = new Encoder((Configuration)this.configuration, this.configuration.schema());
        encoder.setEncoding(this.wfs.getCharSet());
        BaseRequestType gft = (BaseRequestType)getFeature.getParameters()[0];
        String proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)gft.getBaseUrl(), (String)this.wfs.getGeoServer().getProxyBaseUrl());
        encoder.setSchemaLocation("http://www.opengis.net/wfs", ResponseUtils.appendPath((String)proxifiedBaseUrl, (String)"schemas/wfs/1.1.0/wfs.xsd"));
        for (Map.Entry entry : ns2metas.entrySet()) {
            String namespaceURI = (String)entry.getKey();
            Set metas = (Set)entry.getValue();
            StringBuffer typeNames = new StringBuffer();
            Iterator m = metas.iterator();
            while (m.hasNext()) {
                FeatureTypeInfo meta = (FeatureTypeInfo)m.next();
                typeNames.append(meta.getName());
                if (!m.hasNext()) continue;
                typeNames.append(",");
            }
            encoder.setSchemaLocation(namespaceURI, ResponseUtils.appendQueryString((String)(proxifiedBaseUrl + "wfs"), (String)("service=WFS&version=1.1.0&request=DescribeFeatureType&typeName=" + typeNames.toString())));
        }
        encoder.encode((Object)results, org.geoserver.wfs.xml.v1_1_0.WFS.FEATURECOLLECTION, output);
    }
}

