/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.xml.GML2Profile;
import org.geoserver.wfs.xml.GML3Profile;
import org.geoserver.wfs.xml.TypeMappingProfile;
import org.geoserver.wfs.xml.XSProfile;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Schemas;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;

public abstract class FeatureTypeSchemaBuilder {
    static Logger logger = Logging.getLogger((String)"org.geoserver.wfs");
    WFS wfs;
    Data catalog;
    GeoServerResourceLoader resourceLoader;
    protected List profiles;
    protected String gmlNamespace;
    protected String gmlSchemaLocation;
    protected String baseType;
    protected String substitutionGroup;
    protected String describeFeatureTypeBase;
    protected String gmlPrefix;
    protected Configuration xmlConfiguration;

    protected FeatureTypeSchemaBuilder(WFS wfs, Data catalog, GeoServerResourceLoader resourceLoader) {
        this.wfs = wfs;
        this.catalog = catalog;
        this.resourceLoader = resourceLoader;
        this.profiles = new ArrayList();
        this.profiles.add(new XSProfile());
    }

    public XSDSchema build(FeatureTypeInfo featureTypeInfo, String baseUrl) throws IOException {
        return this.build(new FeatureTypeInfo[]{featureTypeInfo}, baseUrl);
    }

    public XSDSchema build(FeatureTypeInfo[] featureTypeInfos, String baseUrl) throws IOException {
        XSDFactory factory = XSDFactory.eINSTANCE;
        XSDSchema schema = factory.createXSDSchema();
        schema.setSchemaForSchemaQNamePrefix("xsd");
        schema.getQNamePrefixToNamespaceMap().put("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setElementFormDefault(XSDForm.get((int)0));
        HashMap<String, ArrayList<FeatureTypeInfo>> ns2featureTypeInfos = new HashMap<String, ArrayList<FeatureTypeInfo>>();
        for (int i = 0; i < featureTypeInfos.length; ++i) {
            String prefix = featureTypeInfos[i].getNameSpace().getPrefix();
            ArrayList<FeatureTypeInfo> l = (ArrayList<FeatureTypeInfo>)ns2featureTypeInfos.get(prefix);
            if (l == null) {
                l = new ArrayList<FeatureTypeInfo>();
            }
            l.add(featureTypeInfos[i]);
            ns2featureTypeInfos.put(prefix, l);
        }
        if (baseUrl == null) {
            baseUrl = this.wfs.getSchemaBaseURL();
        }
        if (!baseUrl.endsWith("wfs") && !baseUrl.endsWith("wfs?")) {
            baseUrl = ResponseUtils.appendPath((String)baseUrl, (String)"wfs");
        }
        if (ns2featureTypeInfos.entrySet().size() == 1) {
            XSDImport imprt = factory.createXSDImport();
            imprt.setNamespace(this.gmlNamespace);
            imprt.setSchemaLocation(ResponseUtils.appendPath((String)ResponseUtils.getParentUrl((String)baseUrl), (String)("schemas/" + this.gmlSchemaLocation)));
            XSDSchema gmlSchema = this.gmlSchema();
            imprt.setResolvedSchema(gmlSchema);
            schema.getContents().add((Object)imprt);
            String targetPrefix = (String)ns2featureTypeInfos.keySet().iterator().next();
            String targetNamespace = this.catalog.getNameSpace(targetPrefix).getURI();
            schema.setTargetNamespace(targetNamespace);
            schema.getQNamePrefixToNamespaceMap().put(targetPrefix, targetNamespace);
            schema.getQNamePrefixToNamespaceMap().put(this.gmlPrefix, this.gmlNamespace);
            schema.getQNamePrefixToNamespaceMap().put("gml", "http://www.opengis.net/gml");
            for (int i = 0; i < featureTypeInfos.length; ++i) {
                this.buildSchemaContent(featureTypeInfos[i], schema, factory);
            }
        } else {
            for (Map.Entry entry : ns2featureTypeInfos.entrySet()) {
                String prefix = (String)entry.getKey();
                List types = (List)entry.getValue();
                StringBuffer queryString = new StringBuffer(this.describeFeatureTypeBase);
                queryString.append("&typeName=");
                Iterator t = types.iterator();
                while (t.hasNext()) {
                    FeatureTypeInfo type = (FeatureTypeInfo)t.next();
                    queryString.append(type.getName());
                    if (!t.hasNext()) continue;
                    queryString.append(",");
                }
                String schemaLocation = ResponseUtils.appendQueryString((String)baseUrl, (String)queryString.toString());
                String namespace = this.catalog.getNameSpace(prefix).getURI();
                XSDImport imprt = factory.createXSDImport();
                imprt.setNamespace(namespace);
                imprt.setSchemaLocation(schemaLocation);
                schema.getContents().add((Object)imprt);
            }
        }
        return schema;
    }

    public XSDSchema addApplicationTypes(XSDSchema wfsSchema) throws IOException {
        Collection featureTypeInfos = this.catalog.getFeatureTypeInfos().values();
        for (FeatureTypeInfo meta : featureTypeInfos) {
            XSDSchema schema = this.build(new FeatureTypeInfo[]{meta}, null);
            String prefix = meta.getNameSpace().getPrefix();
            String namespaceURI = meta.getNameSpace().getURI();
            wfsSchema.getQNamePrefixToNamespaceMap().put(prefix, namespaceURI);
            Iterator t = schema.getTypeDefinitions().iterator();
            while (t.hasNext()) {
                wfsSchema.getTypeDefinitions().add(t.next());
            }
            Iterator e = schema.getElementDeclarations().iterator();
            while (e.hasNext()) {
                wfsSchema.getElementDeclarations().add(e.next());
            }
        }
        return wfsSchema;
    }

    void buildSchemaContent(FeatureTypeInfo featureTypeMeta, XSDSchema schema, XSDFactory factory) throws IOException {
        String prefix = featureTypeMeta.getNameSpace().getPrefix();
        String name = featureTypeMeta.getTypeName();
        File schemaFile = null;
        try {
            schemaFile = this.resourceLoader.find("featureTypes/" + prefix + "_" + name + "/schema.xsd");
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (schemaFile != null) {
            List resolvers = Schemas.findSchemaLocationResolvers((Configuration)this.xmlConfiguration);
            XSDSchema ftSchema = null;
            try {
                ftSchema = Schemas.parse((String)schemaFile.getAbsolutePath(), null, (List)resolvers);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to parse schema: " + schemaFile.getAbsolutePath(), e);
            }
            if (ftSchema != null) {
                EList contents = ftSchema.getContents();
                for (XSDSchemaContent content : contents) {
                    content.setElement(null);
                }
                schema.getContents().addAll((Collection)contents);
                schema.updateElement();
                return;
            }
        }
        SimpleFeatureType featureType = featureTypeMeta.getFeatureType();
        XSDComplexTypeDefinition complexType = factory.createXSDComplexTypeDefinition();
        complexType.setName(featureType.getTypeName() + "Type");
        complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        complexType.setBaseTypeDefinition((XSDTypeDefinition)schema.resolveComplexTypeDefinition(this.gmlNamespace, this.baseType));
        XSDModelGroup group = factory.createXSDModelGroup();
        group.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        List attributes = featureType.getAttributeDescriptors();
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeDescriptor attribute = (AttributeDescriptor)attributes.get(i);
            if (this.filterAttributeType(attribute)) continue;
            XSDElementDeclaration element = factory.createXSDElementDeclaration();
            element.setName(attribute.getLocalName());
            element.setNillable(attribute.isNillable());
            Class binding = attribute.getType().getBinding();
            Name typeName = this.findTypeName(binding);
            if (typeName == null) {
                throw new NullPointerException("Could not find a type for property: " + attribute.getName() + " of type: " + binding.getName());
            }
            XSDTypeDefinition type = schema.resolveTypeDefinition(typeName.getNamespaceURI(), typeName.getLocalPart());
            element.setTypeDefinition(type);
            XSDParticle particle = factory.createXSDParticle();
            particle.setMinOccurs(attribute.getMinOccurs());
            particle.setMaxOccurs(attribute.getMaxOccurs());
            particle.setContent((XSDParticleContent)element);
            group.getContents().add((Object)particle);
        }
        XSDParticle particle = factory.createXSDParticle();
        particle.setContent((XSDParticleContent)group);
        complexType.setContent((XSDComplexTypeContent)particle);
        schema.getContents().add((Object)complexType);
        XSDElementDeclaration element = factory.createXSDElementDeclaration();
        element.setName(name);
        element.setSubstitutionGroupAffiliation(schema.resolveElementDeclaration(this.gmlNamespace, this.substitutionGroup));
        element.setTypeDefinition((XSDTypeDefinition)complexType);
        schema.getContents().add((Object)element);
        schema.updateElement();
        schema.updateElement();
    }

    Name findTypeName(Class binding) {
        for (TypeMappingProfile profile : this.profiles) {
            Name name = profile.name(binding);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    protected abstract XSDSchema gmlSchema();

    protected boolean filterAttributeType(AttributeDescriptor attribute) {
        return "name".equals(attribute.getName()) || "description".equals(attribute.getName()) || "boundedBy".equals(attribute.getName());
    }

    public static final class GML3
    extends FeatureTypeSchemaBuilder {
        private static XSDSchema gml3Schema;

        public GML3(WFS wfs, Data catalog, GeoServerResourceLoader resourceLoader) {
            super(wfs, catalog, resourceLoader);
            this.profiles.add(new GML3Profile());
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlSchemaLocation = "gml/3.1.1/base/gml.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "_Feature";
            this.describeFeatureTypeBase = "request=DescribeFeatureType&version=1.1.0";
            this.gmlPrefix = "gml";
            this.xmlConfiguration = new org.geotools.gml3.GMLConfiguration();
        }

        protected XSDSchema gmlSchema() {
            if (gml3Schema == null) {
                gml3Schema = this.xmlConfiguration.schema();
            }
            return gml3Schema;
        }

        protected boolean filterAttributeType(AttributeDescriptor attribute) {
            return super.filterAttributeType(attribute) || "metaDataProperty".equals(attribute.getName()) || "location".equals(attribute.getName());
        }
    }

    public static final class GML2
    extends FeatureTypeSchemaBuilder {
        private static XSDSchema gml2Schema;

        public GML2(WFS wfs, Data catalog, GeoServerResourceLoader resourceLoader) {
            super(wfs, catalog, resourceLoader);
            this.profiles.add(new GML2Profile());
            this.gmlNamespace = "http://www.opengis.net/gml";
            this.gmlSchemaLocation = "gml/2.1.2/feature.xsd";
            this.baseType = "AbstractFeatureType";
            this.substitutionGroup = "_Feature";
            this.describeFeatureTypeBase = "request=DescribeFeatureType&version=1.1.0";
            this.gmlPrefix = "gml";
            this.xmlConfiguration = new GMLConfiguration();
        }

        protected XSDSchema gmlSchema() {
            if (gml2Schema == null) {
                gml2Schema = this.xmlConfiguration.schema();
            }
            return gml2Schema;
        }
    }
}

