/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wcs.test.WCSTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.vfny.geoserver.wcs.WcsException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GetCapabilitiesTest
extends WCSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog cat = this.getCatalog();
        CoverageStoreInfo csi = cat.getCoverageStoreByName(SystemTestData.WORLD.getLocalPart());
        csi.setEnabled(false);
        cat.save((StoreInfo)csi);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl("src/test/resources/geoserver");
        this.getGeoServer().save(global);
    }

    @Before
    public void revertTasmaniaDem() throws IOException {
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(MockData.TASMANIA_DEM, this.getCatalog());
    }

    @Test
    public void testGetBasic() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wcs?request=GetCapabilities&service=WCS&acceptversions=1.1.1");
        Assert.assertEquals((String)"text/xml", (String)response.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"TrueFalse", (String)"/wcs:Capabilities/ows:OperationsMetadata/ows:Operation[@name=\"GetCoverage\"]/ows:Parameter/ows:AllowedValues", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:Title[text()='World'])", (Document)dom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipMisconfigured() throws Exception {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.setResourceErrorHandling(ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS);
        this.getGeoServer().save(global);
        CoverageInfo cvInfo = this.getCatalog().getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        ReferencedEnvelope BBox = cvInfo.getLatLonBoundingBox();
        try {
            cvInfo.setLatLonBoundingBox(null);
            this.getCatalog().save((ResourceInfo)cvInfo);
            Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=1.1.1");
            this.checkValidationErrors(dom, WCS11_SCHEMA);
            int count = this.getCatalog().getCoverages().size();
            Assert.assertEquals((int)(count - 2), (int)dom.getElementsByTagName("wcs:CoverageSummary").getLength());
        }
        finally {
            cvInfo.setLatLonBoundingBox(BBox);
            this.getCatalog().save((ResourceInfo)cvInfo);
        }
    }

    @Test
    public void testIgnoreWCS10Version() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&version=9.9.9");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"TrueFalse", (String)"/wcs:Capabilities/ows:OperationsMetadata/ows:Operation[@name=\"GetCoverage\"]/ows:Parameter/ows:AllowedValues", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:Title[text()='World'])", (Document)dom);
    }

    @Test
    public void testNamespaceFilter() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptversions=1.1.1&namespace=wcs");
        Element e = dom.getDocumentElement();
        Assert.assertEquals((String)"Capabilities", (String)e.getLocalName());
        XpathEngine xpath = XMLUnit.newXpathEngine();
        Assert.assertTrue((xpath.getMatchingNodes("//wcs:CoverageSummary/ows:Title[starts-with(., wcs)]", dom).getLength() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)0, (int)xpath.getMatchingNodes("//wcs:CoverageSummary/ows:Title[not(starts-with(., wcs))]", dom).getLength());
        dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptversions=1.1.1&namespace=NoThere");
        e = dom.getDocumentElement();
        Assert.assertEquals((String)"Capabilities", (String)e.getLocalName());
        Assert.assertEquals((int)0, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
    }

    @Test
    public void testNoServiceContactInfo() throws Exception {
        this.getGeoServer().getGlobal().setContact((ContactInfo)new ContactInfoImpl());
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
    }

    @Test
    public void testPostBasic() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
    }

    @Test
    public void testUnsupportedVersionPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <ows:AcceptVersions>    <ows:Version>9.9.9</ows:Version>  </ows:AcceptVersions></wcs:GetCapabilities>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
        Assert.assertEquals((String)"ows:ExceptionReport", (String)dom.getFirstChild().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"VersionNegotiationFailed", (String)"ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    @Test
    public void testUnsupportedVersionGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptVersions=9.9.9,8.8.8");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"VersionNegotiationFailed", (String)"ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    @Test
    public void testSupportedVersionGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&acceptVersions=0.5.0,1.1.1");
        Assert.assertEquals((String)"wcs:Capabilities", (String)dom.getFirstChild().getNodeName());
    }

    @Test
    public void testSupportedVersionPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">  <ows:AcceptVersions>    <ows:Version>0.5.0</ows:Version>    <ows:Version>1.1.1</ows:Version>  </ows:AcceptVersions></wcs:GetCapabilities>";
        Document dom = this.postAsDOM("wcs", request);
        Assert.assertEquals((String)"wcs:Capabilities", (String)dom.getFirstChild().getNodeName());
    }

    @Test
    public void testUpdateSequenceInferiorGet() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&updateSequence=-1");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Node root = dom.getFirstChild();
        Assert.assertEquals((String)"wcs:Capabilities", (String)root.getNodeName());
        Assert.assertTrue((root.getChildNodes().getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateSequenceInferiorPost() throws Exception {
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"-1\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Node root = dom.getFirstChild();
        Assert.assertEquals((String)"wcs:Capabilities", (String)root.getNodeName());
        Assert.assertTrue((root.getChildNodes().getLength() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUpdateSequenceEqualsGet() throws Exception {
        long updateIndex = this.getGeoServer().getGlobal().getUpdateSequence();
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&updateSequence=" + Long.toString(updateIndex));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Node root = dom.getFirstChild();
        Assert.assertEquals((String)"wcs:Capabilities", (String)root.getNodeName());
        Assert.assertEquals((int)0, (int)root.getChildNodes().getLength());
    }

    @Test
    public void testUpdateSequenceEqualsPost() throws Exception {
        long updateIndex = this.getGeoServer().getGlobal().getUpdateSequence();
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"" + Long.toString(updateIndex) + "\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        Node root = dom.getFirstChild();
        Assert.assertEquals((String)"wcs:Capabilities", (String)root.getNodeName());
        Assert.assertEquals((int)0, (int)root.getChildNodes().getLength());
    }

    @Test
    public void testUpdateSequenceSuperiorGet() throws Exception {
        long updateIndex = this.getGeoServer().getGlobal().getUpdateSequence() + 1L;
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&updateSequence=" + Long.toString(updateIndex));
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
    }

    @Test
    public void testUpdateSequenceSuperiorPost() throws Exception {
        long updateIndex = this.getGeoServer().getGlobal().getUpdateSequence() + 1L;
        String request = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wcs:GetCapabilities service=\"WCS\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wcs=\"http://www.opengis.net/wcs/1.1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" updateSequence=\"" + Long.toString(updateIndex) + "\"/>";
        Document dom = this.postAsDOM("wcs", request);
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
    }

    @Test
    public void testSectionsBogus() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=Bogus");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        this.checkOws11Exception(dom);
        XMLAssert.assertXpathEvaluatesTo((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)"/ows:ExceptionReport/ows:Exception/@exceptionCode", (Document)dom);
    }

    @Test
    public void testSectionsAll() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=All");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Contents)", (Document)dom);
    }

    @Test
    public void testSchemaLocation() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Capabilities[contains(@xsi:schemaLocation,'http://www.opengis.net/wcs/1.1.1 ')])", (Document)dom);
    }

    @Test
    public void testOneSection() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=ServiceProvider");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wcs:Contents)", (Document)dom);
    }

    @Test
    public void testTwoSection() throws Exception {
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS&sections=ServiceProvider,Contents");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:ServiceIdentification)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ServiceProvider)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//ows:OperationsMetadata)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wcs:Contents)", (Document)dom);
    }

    @Test
    public void testWorkspaceQualified() throws Exception {
        int all = this.getCatalog().getCoverageStores().size() - 1;
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        Assert.assertEquals((int)all, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
        int some = this.getCatalog().getCoverageStoresByWorkspace("cdf").size();
        Assert.assertTrue((some < all ? 1 : 0) != 0);
        dom = this.getAsDOM("cdf/wcs?request=GetCapabilities&service=WCS");
        Assert.assertEquals((int)some, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
    }

    @Test
    public void testLayerQualified() throws Exception {
        int all = this.getCatalog().getCoverageStores().size() - 1;
        Document dom = this.getAsDOM("wcs?request=GetCapabilities&service=WCS");
        Assert.assertEquals((int)all, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
        dom = this.getAsDOM("wcs/BlueMarble/wcs?request=GetCapabilities&service=WCS");
        Assert.assertEquals((int)1, (int)xpath.getMatchingNodes("//wcs:CoverageSummary", dom).getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAdvertisedLayer() throws Exception {
        String layerId = this.getLayerId(MockData.TASMANIA_DEM);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        try {
            Document dom = this.getAsDOM("wcs?request=GetCapabilities");
            XMLAssert.assertXpathExists((String)"//wcs:CoverageSummary[ows:Title='DEM']", (Document)dom);
            layer.setAdvertised(false);
            this.getCatalog().save(layer);
            dom = this.getAsDOM("wcs?request=GetCapabilities");
            XMLAssert.assertXpathNotExists((String)"//wcs:CoverageSummary[ows:Title='DEM']", (Document)dom);
        }
        finally {
            layer.setAdvertised(true);
            this.getCatalog().save(layer);
        }
    }

    @Test
    public void testMetadataLink() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
        ml.setContent("http://www.geoserver.org/tasmania/dem.xml");
        ml.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(ml);
        catalog.save((ResourceInfo)ci);
        Document dom = this.getAsDOM("wcs?request=GetCapabilities");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        String xpathBase = "//wcs:CoverageSummary[wcs:Identifier = '" + MockData.TASMANIA_DEM.getPrefix() + ":" + MockData.TASMANIA_DEM.getLocalPart() + "']/ows:Metadata";
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)(xpathBase + "/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)(xpathBase + "/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org/tasmania/dem.xml", (String)(xpathBase + "/@xlink:href"), (Document)dom);
    }

    @Test
    public void testMetadataLinksTransormToProxyBaseURL() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
        ml.setContent("/metadata?key=value");
        ml.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(ml);
        catalog.save((ResourceInfo)ci);
        String proxyBaseUrl = this.getGeoServer().getGlobal().getSettings().getProxyBaseUrl();
        Document dom = this.getAsDOM("wcs?request=GetCapabilities");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        String xpathBase = "//wcs:CoverageSummary[wcs:Identifier = '" + MockData.TASMANIA_DEM.getPrefix() + ":" + MockData.TASMANIA_DEM.getLocalPart() + "']/ows:Metadata";
        XMLAssert.assertXpathEvaluatesTo((String)"http://www.geoserver.org", (String)(xpathBase + "/@about"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"simple", (String)(xpathBase + "/@xlink:type"), (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)(proxyBaseUrl + "/metadata?key=value"), (String)(xpathBase + "/@xlink:href"), (Document)dom);
    }

    @Test
    public void testNoMetadataTypeAttribute() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(MockData.TASMANIA_DEM));
        MetadataLinkInfo ml = catalog.getFactory().createMetadataLink();
        ml.setContent("http://www.geoserver.org/tasmania/dem.xml");
        ml.setAbout("http://www.geoserver.org");
        ci.getMetadataLinks().add(ml);
        catalog.save((ResourceInfo)ci);
        Document dom = this.getAsDOM("wcs?request=GetCapabilities");
        this.checkValidationErrors(dom, WCS11_SCHEMA);
        String xpathBase = "//wcs:CoverageSummary[wcs:Identifier = '" + MockData.TASMANIA_DEM.getLocalPart() + "']/ows:Metadata";
        XMLAssert.assertXpathNotExists((String)(xpathBase + "/@metadataType"), (Document)dom);
    }
}

