/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.IOException;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestHttpInputWrapper;
import org.geoserver.rest.wrapper.RestListWrapper;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class XStreamXMLMessageConverter
extends XStreamMessageConverter<Object> {
    public XStreamXMLMessageConverter() {
        super(MediaType.APPLICATION_XML, MediaType.TEXT_XML);
    }

    protected boolean supports(Class<?> clazz) {
        return !RestWrapper.class.isAssignableFrom(clazz) || !RestListWrapper.class.isAssignableFrom(clazz);
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        XStreamPersister p = this.xpf.createXMLPersister();
        if (inputMessage instanceof RestHttpInputWrapper) {
            ((RestHttpInputWrapper)inputMessage).configurePersister(p, this);
        }
        p.setCatalog(this.catalog);
        return p.load(inputMessage.getBody(), clazz);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return !RestListWrapper.class.isAssignableFrom(clazz) && RestWrapper.class.isAssignableFrom(clazz) && this.canWrite(mediaType);
    }

    @Override
    protected void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        XStreamPersister xmlPersister = this.xpf.createXMLPersister();
        xmlPersister.setCatalog(this.catalog);
        xmlPersister.setReferenceByName(true);
        xmlPersister.setExcludeIds();
        if (o instanceof RestWrapper) {
            RestWrapper wrapper = (RestWrapper)o;
            wrapper.configurePersister(xmlPersister, this);
            o = wrapper.getObject();
        }
        xmlPersister.save(o, outputMessage.getBody());
    }

    @Override
    public String getExtension() {
        return "xml";
    }

    @Override
    public String getMediaType() {
        return "application/xml";
    }

    @Override
    protected XStream createXStreamInstance() {
        return new SecureXStream();
    }

    @Override
    public void encodeLink(String link, HierarchicalStreamWriter writer) {
        this.encodeAlternateAtomLink(link, writer);
    }

    @Override
    public void encodeCollectionLink(String link, HierarchicalStreamWriter writer) {
        this.encodeAlternateAtomLink(link, writer);
    }
}

