/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.IOException;
import org.geoserver.config.util.SecureXStream;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestHttpInputWrapper;
import org.geoserver.rest.wrapper.RestListWrapper;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class XStreamJSONMessageConverter
extends XStreamMessageConverter<Object> {
    static final MediaType TEXT_JSON = MediaType.valueOf((String)"text/json");

    public XStreamJSONMessageConverter() {
        super(MediaType.APPLICATION_JSON, TEXT_JSON);
    }

    @Override
    public String getExtension() {
        return "json";
    }

    @Override
    public String getMediaType() {
        return "application/json";
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        XStreamPersister p = this.xpf.createJSONPersister();
        p.setCatalog(this.catalog);
        if (inputMessage instanceof RestHttpInputWrapper) {
            ((RestHttpInputWrapper)inputMessage).configurePersister(p, this);
        }
        return p.load(inputMessage.getBody(), clazz);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return !RestListWrapper.class.isAssignableFrom(clazz) && RestWrapper.class.isAssignableFrom(clazz) && this.canWrite(mediaType);
    }

    @Override
    public void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        XStreamPersister xmlPersister = this.xpf.createJSONPersister();
        xmlPersister.setCatalog(this.catalog);
        xmlPersister.setReferenceByName(true);
        xmlPersister.setExcludeIds();
        if (o instanceof RestWrapper) {
            ((RestWrapper)o).configurePersister(xmlPersister, this);
            o = ((RestWrapper)o).getObject();
        }
        xmlPersister.save(o, outputMessage.getBody());
    }

    @Override
    public void encodeLink(String link, HierarchicalStreamWriter writer) {
        writer.startNode("href");
        writer.setValue(this.href(link));
        writer.endNode();
    }

    @Override
    public void encodeCollectionLink(String link, HierarchicalStreamWriter writer) {
        writer.setValue(this.href(link));
    }

    @Override
    protected XStream createXStreamInstance() {
        return new SecureXStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
    }
}

