/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest.converters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.Version;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class StyleWriterConverter
extends BaseMessageConverter<Object> {
    private final Version version;
    private final StyleHandler handler;

    public StyleWriterConverter(String mimeType, Version version, StyleHandler handler) {
        super(MediaType.valueOf((String)mimeType));
        this.handler = handler;
        this.version = version;
    }

    protected boolean supports(Class<?> clazz) {
        return RestWrapper.class.isAssignableFrom(clazz) || Style.class.isAssignableFrom(clazz) || StyleInfo.class.isAssignableFrom(clazz);
    }

    protected boolean canRead(MediaType mediaType) {
        return false;
    }

    @Override
    public void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        StyleInfo style;
        if (object instanceof RestWrapper) {
            object = ((RestWrapper)object).getObject();
        }
        if (object instanceof StyleInfo) {
            style = (StyleInfo)object;
            if (this.handler.getFormat().equalsIgnoreCase(style.getFormat())) {
                this.copyDefinition(style, outputMessage.getBody());
                return;
            }
        }
        style = object instanceof StyleInfo ? ((StyleInfo)object).getStyle() : (Style)object;
        StyledLayerDescriptor sld = Styles.sld((Style)style);
        this.handler.encode(sld, this.version, false, outputMessage.getBody());
    }

    void copyDefinition(StyleInfo style, OutputStream out) throws IOException {
        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerExtensions.bean(GeoServerDataDirectory.class);
        Resource resource = dd.style(style);
        try (InputStream in = resource.in();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    public String toString() {
        return "StyleWriterConverter [version=" + this.version + ", handler=" + this.handler + "]";
    }
}

