/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.DispatcherCallback;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestException;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpStatus;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestControllerAdvice
extends ResponseEntityExceptionHandler {
    static final Logger LOGGER = Logging.getLogger(RestControllerAdvice.class);

    private void notifyExceptionToCallbacks(WebRequest webRequest, HttpServletResponse response, Exception ex) {
        if (!(webRequest instanceof ServletWebRequest)) {
            return;
        }
        HttpServletRequest request = ((ServletWebRequest)webRequest).getRequest();
        this.notifyExceptionToCallbacks(request, response, ex);
    }

    private void notifyExceptionToCallbacks(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        List callbacks = GeoServerExtensions.extensions(DispatcherCallback.class);
        for (DispatcherCallback callback : callbacks) {
            callback.exception(request, response, ex);
        }
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public void handleResourceNotFound(ResourceNotFoundException e, HttpServletResponse response, WebRequest request, OutputStream os) throws IOException {
        this.notifyExceptionToCallbacks(request, response, (Exception)e);
        String quietOnNotFound = request.getParameter("quietOnNotFound");
        String message = e.getMessage();
        if (Boolean.parseBoolean(quietOnNotFound)) {
            message = "";
        } else {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        response.setStatus(404);
        StreamUtils.copy((String)message, (Charset)Charset.forName("UTF-8"), (OutputStream)os);
    }

    @ExceptionHandler(value={RestException.class})
    public void handleRestException(RestException e, HttpServletResponse response, WebRequest request, OutputStream os) throws IOException {
        LOGGER.log(Level.SEVERE, e.getMessage(), e);
        this.notifyExceptionToCallbacks(request, response, (Exception)e);
        if (e.getStatus().is4xxClientError()) {
            response.sendError(e.getStatus().value(), e.getMessage());
        } else {
            response.setStatus(e.getStatus().value());
        }
        StreamUtils.copy((String)e.getMessage(), (Charset)Charset.forName("UTF-8"), (OutputStream)os);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public void handleGeneralException(Exception e, HttpServletRequest request, HttpServletResponse response, OutputStream os) throws IOException {
        LOGGER.log(Level.SEVERE, e.getMessage(), e);
        this.notifyExceptionToCallbacks(request, response, e);
        response.setStatus(500);
        StreamUtils.copy((String)e.getMessage(), (Charset)Charset.forName("UTF-8"), (OutputStream)os);
    }
}

