/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.Styles;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.rest.CallbackInterceptor;
import org.geoserver.rest.MediaTypeCallback;
import org.geoserver.rest.RestInterceptor;
import org.geoserver.rest.converters.BaseMessageConverter;
import org.geoserver.rest.converters.FreemarkerHTMLMessageConverter;
import org.geoserver.rest.converters.InputStreamConverter;
import org.geoserver.rest.converters.StyleReaderConverter;
import org.geoserver.rest.converters.StyleWriterConverter;
import org.geoserver.rest.converters.XStreamCatalogListConverter;
import org.geoserver.rest.converters.XStreamJSONMessageConverter;
import org.geoserver.rest.converters.XStreamXMLMessageConverter;
import org.geotools.util.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.util.UrlPathHelper;
import org.xml.sax.EntityResolver;

@Configuration
public class RestConfiguration
extends WebMvcConfigurationSupport {
    private ContentNegotiationManager contentNegotiationManager;
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    public ContentNegotiationManager mvcContentNegotiationManager() {
        if (this.contentNegotiationManager == null) {
            this.contentNegotiationManager = super.mvcContentNegotiationManager();
            this.contentNegotiationManager.getStrategies().add(0, new DelegatingContentNegotiationStrategy());
        }
        return this.contentNegotiationManager;
    }

    protected void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        Catalog catalog = (Catalog)this.applicationContext.getBean("catalog");
        List gsConverters = GeoServerExtensions.extensions(BaseMessageConverter.class);
        gsConverters.add(new FreemarkerHTMLMessageConverter("UTF-8"));
        gsConverters.add(new XStreamXMLMessageConverter());
        gsConverters.add(new XStreamJSONMessageConverter());
        gsConverters.add(new XStreamCatalogListConverter.XMLXStreamListConverter());
        gsConverters.add(new XStreamCatalogListConverter.JSONXStreamListConverter());
        gsConverters.add(new InputStreamConverter());
        EntityResolver entityResolver = catalog.getResourcePool().getEntityResolver();
        for (StyleHandler sh : Styles.handlers()) {
            for (Version ver : sh.getVersions()) {
                gsConverters.add(new StyleReaderConverter(sh.mimeType(ver), ver, sh, entityResolver));
                gsConverters.add(new StyleWriterConverter(sh.mimeType(ver), ver, sh));
            }
        }
        if (this.applicationContext.containsBean("gwcConverter")) {
            converters.add((HttpMessageConverter)this.applicationContext.getBean("gwcConverter"));
        }
        gsConverters.sort(Comparator.comparingInt(BaseMessageConverter::getPriority));
        for (BaseMessageConverter converter : gsConverters) {
            converters.add(converter);
        }
        super.addDefaultHttpMessageConverters(converters);
    }

    protected void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new RestInterceptor());
        registry.addInterceptor((HandlerInterceptor)new CallbackInterceptor());
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        List styleHandlers = GeoServerExtensions.extensions(StyleHandler.class);
        for (StyleHandler handler : styleHandlers) {
            if (handler.getVersions() == null || handler.getVersions().size() <= 0) continue;
            List versions = handler.getVersions();
            Version firstVersion = (Version)versions.get(versions.size() - 1);
            configurer.mediaType(handler.getFormat(), MediaType.valueOf((String)handler.mimeType(firstVersion)));
        }
        configurer.mediaType("sld", MediaType.valueOf((String)"application/vnd.ogc.sld+xml"));
        configurer.mediaType("html", MediaType.TEXT_HTML);
        configurer.mediaType("xml", MediaType.APPLICATION_XML);
        configurer.mediaType("json", MediaType.APPLICATION_JSON);
        configurer.mediaType("xslt", MediaType.valueOf((String)"application/xslt+xml"));
        configurer.mediaType("ftl", MediaType.TEXT_PLAIN);
        configurer.mediaType("xml", MediaType.APPLICATION_XML);
        configurer.favorParameter(true);
        List callbacks = GeoServerExtensions.extensions(MediaTypeCallback.class);
        for (MediaTypeCallback callback : callbacks) {
            callback.configure(configurer);
        }
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUrlPathHelper((UrlPathHelper)new GeoServerUrlPathHelper());
        configurer.getUrlPathHelper().setAlwaysUseFullPath(true);
    }

    protected void addFormatters(FormatterRegistry registry) {
        for (Converter converter : GeoServerExtensions.extensions(Converter.class)) {
            registry.addConverter(converter);
        }
    }

    static class GeoServerUrlPathHelper
    extends UrlPathHelper {
        public GeoServerUrlPathHelper() {
            this.setAlwaysUseFullPath(true);
            this.setDefaultEncoding("UTF-8");
        }

        public String decodeRequestString(HttpServletRequest request, String source) {
            try {
                return URLDecoder.decode(source, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    }

    private static class DelegatingContentNegotiationStrategy
    implements ContentNegotiationStrategy {
        private DelegatingContentNegotiationStrategy() {
        }

        public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
            List strategies = GeoServerExtensions.extensions(ContentNegotiationStrategy.class);
            for (ContentNegotiationStrategy strategy : strategies) {
                List mediaTypes;
                if (strategy instanceof ContentNegotiationManager || strategy instanceof DelegatingContentNegotiationStrategy || (mediaTypes = strategy.resolveMediaTypes(webRequest)).size() <= 0) continue;
                return mediaTypes;
            }
            return MEDIA_TYPE_ALL_LIST;
        }
    }
}

