/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.rest.ObjectToMapWrapper;
import org.geoserver.rest.RequestInfo;
import org.geoserver.rest.RestException;
import org.geoserver.rest.converters.FreemarkerHTMLMessageConverter;
import org.geoserver.rest.converters.XStreamMessageConverter;
import org.geoserver.rest.wrapper.RestHttpInputWrapper;
import org.geoserver.rest.wrapper.RestListWrapper;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geoserver.rest.wrapper.RestWrapperAdapter;
import org.geoserver.template.TemplateUtils;
import org.geotools.util.logging.Logging;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

public abstract class RestBaseController
implements RequestBodyAdvice {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.rest");
    public static final String ROOT_PATH = "/rest";
    protected String encoding = "UTF-8";
    protected String pathPrefix = "ftl-templates";

    protected <T> Configuration createConfiguration(Class<T> clazz) {
        Configuration cfg = TemplateUtils.getSafeConfiguration();
        cfg.setObjectWrapper(this.createObjectWrapper(clazz));
        cfg.setClassForTemplateLoading(this.getClass(), this.pathPrefix);
        if (this.encoding != null) {
            cfg.setDefaultEncoding(this.encoding);
        }
        return cfg;
    }

    protected <T> ObjectWrapper createObjectWrapper(Class<T> clazz) {
        return new ObjectToMapWrapper<T>(clazz);
    }

    protected Template getTemplate(Object o, Class clazz) {
        Template template = null;
        Configuration configuration = this.createConfiguration(clazz);
        String templateName = this.getTemplateName(o);
        if (templateName != null && (template = this.tryLoadTemplate(configuration, templateName)) == null) {
            template = this.tryLoadTemplate(configuration, templateName + ".ftl");
        }
        RequestInfo requestInfo = RequestInfo.get();
        if (template == null && requestInfo != null) {
            int i;
            String pagePath = requestInfo.getPagePath();
            String r = pagePath.substring(pagePath.lastIndexOf(47) + 1);
            if (r.equals("")) {
                pagePath = pagePath.substring(0, pagePath.length() - 1);
                r = pagePath.substring(pagePath.lastIndexOf(47) + 1);
            }
            if ((i = r.lastIndexOf(".")) != -1) {
                r = r.substring(0, i);
            }
            template = this.tryLoadTemplate(configuration, r + ".ftl");
        }
        while (template == null && clazz != null) {
            template = this.tryLoadTemplate(configuration, clazz.getSimpleName() + ".ftl");
            if (template == null) {
                template = this.tryLoadTemplate(configuration, clazz.getSimpleName().toLowerCase() + ".ftl");
            }
            if (template == null) {
                Class<?> interfaze;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (template = this.tryLoadTemplate(configuration, (interfaze = classArray[i]).getSimpleName() + ".ftl")) == null; ++i) {
                }
            }
            if (clazz.getSuperclass() == Object.class) break;
            clazz = clazz.getSuperclass();
        }
        templateName = template != null ? template.getName() : "Object.ftl";
        return this.tryLoadTemplate(configuration, templateName);
    }

    protected Template tryLoadTemplate(Configuration configuration, String templateName) {
        try {
            return configuration.getTemplate(templateName);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IOException io) {
            LOGGER.log(Level.FINE, "Failed to lookup template " + templateName, io);
            return null;
        }
    }

    protected String getTemplateName(Object object) {
        return null;
    }

    protected <T> RestWrapper<T> wrapList(Collection<T> list, Class<T> clazz) {
        return new RestListWrapper<T>(list, clazz, this, this.getTemplate(list, clazz));
    }

    protected <T> RestWrapper<T> wrapObject(T object, Class<T> clazz) {
        return new RestWrapperAdapter<T>(object, clazz, this, this.getTemplate(object, clazz));
    }

    protected <T> RestWrapper<T> wrapObject(T object, Class<T> clazz, String errorMessage, Boolean quietOnNotFound) {
        String string = errorMessage = quietOnNotFound != null && quietOnNotFound != false ? "" : errorMessage;
        if (object == null) {
            throw new RestException(errorMessage, HttpStatus.NOT_FOUND);
        }
        return new RestWrapperAdapter<T>(object, clazz, this, this.getTemplate(object, clazz));
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return false;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        if (!(inputMessage instanceof RestHttpInputWrapper)) {
            return new RestHttpInputWrapper(inputMessage, this);
        }
        return inputMessage;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public void configurePersister(XStreamPersister persister, XStreamMessageConverter converter) {
    }

    public void configureFreemarker(FreemarkerHTMLMessageConverter converter, Template template) {
    }
}

