/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.rest;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.rest.DispatcherCallbackAdapter;
import org.geotools.filter.function.EnvFunction;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class EnviromentInjectionCallback
extends DispatcherCallbackAdapter {
    @Override
    public void init(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, String> envVars = new HashMap<String, String>();
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && !(auth instanceof AnonymousAuthenticationToken)) {
            String name = auth.getName();
            envVars.put("GSUSER", name);
        }
        if (envVars.size() > 0) {
            EnvFunction.setLocalValues(envVars);
        }
    }

    @Override
    public void finished(HttpServletRequest request, HttpServletResponse response) {
        EnvFunction.clearLocalValues();
    }
}

