/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import org.geoserver.platform.resource.Paths;
import org.junit.Assert;
import org.junit.Test;

public class PathsTest {
    final String BASE = "";
    final String DIRECTORY = "directory";
    final String FILE = "directory/file.txt";
    final String SIDECAR = "directory/file.prj";
    final String FILE2 = "directory/file2.txt";
    final String SUBFOLDER = "directory/folder";
    final String FILE3 = "directory/folder/file3.txt";

    @Test
    public void pathTest() {
        Assert.assertEquals((long)2L, (long)Paths.names((String)"a/b").size());
        Assert.assertEquals((long)1L, (long)Paths.names((String)"a/").size());
        Assert.assertEquals((long)1L, (long)Paths.names((String)"a").size());
        Assert.assertEquals((long)0L, (long)Paths.names((String)"").size());
        Assert.assertEquals((Object)"", (Object)Paths.path((String[])new String[]{""}));
        Assert.assertEquals((Object)"directory/file.txt", (Object)Paths.path((String[])new String[]{"directory", "file.txt"}));
        Assert.assertEquals((Object)"directory/folder/file3.txt", (Object)Paths.path((String[])new String[]{"directory/folder", "file3.txt"}));
        Assert.assertNull((Object)Paths.path((String[])new String[]{null}));
        Assert.assertEquals((Object)"foo", (Object)Paths.path((String[])new String[]{"foo/"}));
        try {
            Assert.assertEquals((Object)"foo", (Object)Paths.path((String[])new String[]{".", "foo"}));
            Assert.fail((String)". invalid relative path");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Assert.assertEquals((Object)"foo", (Object)Paths.path((String[])new String[]{"foo/bar", ".."}));
            Assert.fail((String)".. invalid relative path");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (String name : new String[]{"foo", "foo.txt", "directory/bar"}) {
            Assert.assertEquals((Object)name, (Object)Paths.path((boolean)true, (String[])new String[]{name}));
            Assert.assertEquals((Object)name, (Object)Paths.path((boolean)false, (String[])new String[]{name}));
        }
        for (String name : new String[]{".", "..", "foo\\"}) {
            try {
                Assert.assertEquals((Object)name, (Object)Paths.path((boolean)true, (String[])new String[]{name}));
                Assert.fail((String)("invalid: " + name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                Assert.assertEquals((Object)name, (Object)Paths.path((boolean)false, (String[])new String[]{name}));
                Assert.fail((String)("invalid: " + name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (char c : "*:,'&?\"<>|".toCharArray()) {
            for (String prefix : new String[]{"foo", ""}) {
                for (String suffix : new String[]{"bar", ""}) {
                    String name = prefix + c + suffix;
                    try {
                        Assert.assertEquals((Object)name, (Object)Paths.path((boolean)true, (String[])new String[]{name}));
                        Assert.fail((String)("invalid: " + name));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    Assert.assertEquals((Object)name, (Object)Paths.path((boolean)false, (String[])new String[]{name}));
                }
            }
        }
    }

    @Test
    public void validTest() {
        for (String name : new String[]{"foo", "foo.txt", "directory/bar"}) {
            Assert.assertEquals((Object)name, (Object)Paths.valid((boolean)true, (String)name));
            Assert.assertEquals((Object)name, (Object)Paths.valid((boolean)false, (String)name));
        }
        for (String name : new String[]{".", "..", "foo\\"}) {
            try {
                Assert.assertEquals((Object)name, (Object)Paths.valid((boolean)true, (String)name));
                Assert.fail((String)("invalid: " + name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                Assert.assertEquals((Object)name, (Object)Paths.valid((boolean)false, (String)name));
                Assert.fail((String)("invalid: " + name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (char c : "*:,'&?\"<>|".toCharArray()) {
            for (String prefix : new String[]{"foo", ""}) {
                for (String suffix : new String[]{"bar", ""}) {
                    String name = prefix + c + suffix;
                    try {
                        Assert.assertEquals((Object)name, (Object)Paths.valid((boolean)true, (String)name));
                        Assert.fail((String)("invalid: " + name));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    Assert.assertEquals((Object)name, (Object)Paths.valid((boolean)false, (String)name));
                }
            }
        }
    }

    @Test
    public void parentTest() {
        Assert.assertEquals((Object)"directory", (Object)Paths.parent((String)"directory/file.txt"));
        Assert.assertEquals((Object)"", (Object)Paths.parent((String)"directory"));
        Assert.assertNull((Object)Paths.parent((String)""));
        Assert.assertNull(null, (Object)Paths.parent(null));
        Assert.assertEquals((Object)"foo", (Object)Paths.parent((String)"foo/"));
    }

    @Test
    public void naming() {
        Assert.assertEquals((Object)"file.txt", (Object)Paths.name((String)"directory/file.txt"));
        Assert.assertEquals((Object)"txt", (Object)Paths.extension((String)"directory/file.txt"));
        Assert.assertEquals((Object)"directory/file.txt", (Object)Paths.sidecar((String)"directory/file", (String)"txt"));
        Assert.assertEquals((Object)"directory/file.prj", (Object)Paths.sidecar((String)"directory/file.txt", (String)"prj"));
    }

    @Test
    public void convert1() {
        File folder = new File("folder");
        File file1 = new File("file1");
        File file2 = new File(folder, "file2");
        Assert.assertEquals((Object)"folder", (Object)Paths.convert((String)folder.getPath()));
        Assert.assertEquals((Object)"folder/file2", (Object)Paths.convert((String)file2.getPath()));
        Assert.assertEquals((Object)"file1", (Object)Paths.convert((String)file1.getPath()));
    }

    @Test
    public void convert2() {
        File home = new File(System.getProperty("user.home"));
        File directory = new File(home, "directory");
        File folder = new File(directory, "folder");
        File file1 = new File(directory, "file1");
        File file2 = new File(folder, "file2");
        File relative = new File(new File(".."), "file1");
        Assert.assertEquals((Object)"folder", (Object)Paths.convert((File)directory, (File)folder));
        Assert.assertEquals((Object)"folder/file2", (Object)Paths.convert((File)directory, (File)file2));
        Assert.assertEquals((Object)"file1", (Object)Paths.convert((File)directory, (File)file1));
        String relativePath = relative.getPath();
        Assert.assertEquals((Object)"file1", (Object)Paths.convert((File)directory, (File)folder, (String)relativePath));
    }
}

