/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotification;
import org.geoserver.platform.resource.ResourceTheoryTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.theories.DataPoints;
import org.junit.rules.TemporaryFolder;

public class FileSystemResourceTheoryTest
extends ResourceTheoryTest {
    FileSystemResourceStore store;
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @DataPoints
    public static String[] testPaths() {
        return new String[]{"FileA", "FileB", "DirC", "DirC/FileD", "DirE", "UndefF", "DirC/UndefF", "DirE/UndefF", "DirE/UndefG/UndefH/UndefI"};
    }

    @Override
    protected Resource getResource(String path) throws Exception {
        return this.store.get(path);
    }

    @Before
    public void setUp() throws Exception {
        this.folder.newFile("FileA");
        this.folder.newFile("FileB");
        File c = this.folder.newFolder("DirC");
        new File(c, "FileD").createNewFile();
        this.folder.newFolder("DirE");
        this.store = new FileSystemResourceStore(this.folder.getRoot());
    }

    @Test
    public void invalid() {
        try {
            Resource resource = this.store.get("..");
            Assert.assertNotNull((Object)resource);
            Assert.fail((String)".. invalid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void fileEvents() throws Exception {
        File fileD = Paths.toFile((File)this.store.baseDirectory, (String)"DirC/FileD");
        AwaitResourceListener listener = new AwaitResourceListener();
        this.store.get("DirC/FileD").addListener((ResourceListener)listener);
        this.store.watcher.schedule(30L, TimeUnit.MILLISECONDS);
        long before = fileD.lastModified();
        long after = this.touch(fileD);
        Assert.assertTrue((String)"touched", (after > before ? 1 : 0) != 0);
        ResourceNotification n = (ResourceNotification)listener.await(5L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"detected event", (Object)n);
        Assert.assertEquals((String)"file modified", (Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)n.getKind());
        Assert.assertTrue((String)"Resource only", (boolean)n.events().isEmpty());
        listener.reset();
        fileD.delete();
        n = (ResourceNotification)listener.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"file removed", (Object)ResourceNotification.Kind.ENTRY_DELETE, (Object)n.getKind());
        listener.reset();
        fileD.createNewFile();
        n = (ResourceNotification)listener.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"file created", (Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)n.getKind());
        this.store.get("DirC/FileD").removeListener((ResourceListener)listener);
    }

    private long touch(File file) throws InterruptedException {
        long origional = file.lastModified();
        if (origional == 0L) {
            return 0L;
        }
        Thread.sleep(2000L);
        long modifided = System.currentTimeMillis();
        file.setLastModified(modifided);
        modifided = file.lastModified();
        while (modifided - origional < 2000L) {
            file.setLastModified(System.currentTimeMillis());
            Thread.sleep(1000L);
            modifided = file.lastModified();
        }
        return modifided;
    }

    @Test
    public void eventNotification() throws InterruptedException {
        AwaitResourceListener listener = new AwaitResourceListener();
        ResourceNotification n = (ResourceNotification)listener.await(5L, TimeUnit.SECONDS);
        Assert.assertNull((String)"No events expected", (Object)n);
    }

    @Test
    public void directoryEvents() throws Exception {
        File fileA = Paths.toFile((File)this.store.baseDirectory, (String)"FileA");
        File fileB = Paths.toFile((File)this.store.baseDirectory, (String)"FileB");
        File dirC = Paths.toFile((File)this.store.baseDirectory, (String)"DirC");
        File fileD = Paths.toFile((File)this.store.baseDirectory, (String)"DirC/FileD");
        File dirE = Paths.toFile((File)this.store.baseDirectory, (String)"DirE");
        AwaitResourceListener listener = new AwaitResourceListener();
        this.store.get("").addListener((ResourceListener)listener);
        this.store.watcher.schedule(30L, TimeUnit.MILLISECONDS);
        long before = fileB.lastModified();
        long after = this.touch(fileB);
        Assert.assertTrue((String)"touched", (after > before ? 1 : 0) != 0);
        ResourceNotification n = (ResourceNotification)listener.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)n.getKind());
        Assert.assertEquals((Object)"", (Object)n.getPath());
        Assert.assertEquals((long)1L, (long)n.events().size());
        ResourceNotification.Event e = (ResourceNotification.Event)n.events().get(0);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)e.getKind());
        Assert.assertEquals((Object)"FileB", (Object)e.getPath());
        listener.reset();
        fileA.delete();
        n = (ResourceNotification)listener.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)n.getKind());
        Assert.assertEquals((Object)"", (Object)n.getPath());
        e = (ResourceNotification.Event)n.events().get(0);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_DELETE, (Object)e.getKind());
        Assert.assertEquals((Object)"FileA", (Object)e.getPath());
        listener.reset();
        fileA.createNewFile();
        n = (ResourceNotification)listener.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_MODIFY, (Object)n.getKind());
        Assert.assertEquals((Object)"", (Object)n.getPath());
        e = (ResourceNotification.Event)n.events().get(0);
        Assert.assertEquals((Object)ResourceNotification.Kind.ENTRY_CREATE, (Object)e.getKind());
        Assert.assertEquals((Object)"FileA", (Object)e.getPath());
        this.store.get("").removeListener((ResourceListener)listener);
    }

    @Override
    protected Resource getDirectory() {
        try {
            this.folder.newFolder("NonTestDir");
        }
        catch (IOException e) {
            Assert.fail();
        }
        return this.store.get("NonTestDir");
    }

    @Override
    protected Resource getResource() {
        try {
            this.folder.newFile("NonTestFile");
        }
        catch (IOException e) {
            Assert.fail();
        }
        return this.store.get("NonTestFile");
    }

    @Override
    protected Resource getUndefined() {
        return this.store.get("NonTestUndef");
    }

    static abstract class Await<T> {
        Lock lock = new ReentrantLock(true);
        Condition condition = this.lock.newCondition();
        private T event = null;

        Await() {
        }

        public void notify(T notification) {
            this.lock.lock();
            try {
                if (this.event == null) {
                    this.event = notification;
                }
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        public T await() throws InterruptedException {
            return this.await(5L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T await(long howlong, TimeUnit unit) throws InterruptedException {
            long DELAY = unit.convert(howlong, TimeUnit.MILLISECONDS);
            this.lock.lock();
            try {
                if (this.event == null) {
                    long mark = System.currentTimeMillis();
                    while (this.event == null) {
                        long check = System.currentTimeMillis();
                        if (mark + DELAY < check) {
                            T t = null;
                            return t;
                        }
                        boolean bl = this.condition.await(1L, TimeUnit.SECONDS);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
            return this.event;
        }

        public void reset() {
            this.lock.lock();
            try {
                this.event = null;
            }
            finally {
                this.lock.unlock();
            }
        }

        public String toString() {
            return "Await [event=" + this.event + "]";
        }
    }

    static class AwaitResourceListener
    extends Await<ResourceNotification>
    implements ResourceListener {
        AwaitResourceListener() {
        }

        public void changed(ResourceNotification notify) {
            this.notify(notify);
        }
    }
}

