/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.IOException;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSystemResourceStoreTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void renameSameFileName() throws IOException, InterruptedException {
        String sameName = "Filea";
        this.attemptRenameFile(sameName, sameName);
        Assert.assertEquals((Object)sameName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameFileNamesCaseDiffer() throws IOException, InterruptedException {
        String newName = "Filea";
        this.attemptRenameFile("FileA", newName);
        Assert.assertEquals((Object)newName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameFileNamesDiffer() throws IOException, InterruptedException {
        String newName = "FileB";
        this.attemptRenameFile("FileA", newName);
        Assert.assertEquals((Object)newName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameSameDirName() throws IOException, InterruptedException {
        String sameName = "Dira";
        this.attemptRenameDir(sameName, sameName);
        Assert.assertEquals((Object)sameName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameDirNamesCaseDiffer() throws IOException, InterruptedException {
        String newName = "Dira";
        this.attemptRenameDir("DirA", newName);
        Assert.assertEquals((Object)newName, (Object)this.folder.getRoot().list()[0]);
    }

    @Test
    public void renameDirNamesDiffer() throws IOException, InterruptedException {
        String newName = "DirB";
        this.attemptRenameDir("DirA", newName);
        Assert.assertEquals((Object)newName, (Object)this.folder.getRoot().list()[0]);
    }

    private void attemptRenameDir(String oldName, String newName) throws IOException {
        File toBeRenamed = this.folder.newFolder(oldName);
        this.attemptRename(oldName, newName);
    }

    private void attemptRenameFile(String oldName, String newName) throws IOException {
        File toBeRenamed = this.folder.newFile(oldName);
        this.attemptRename(oldName, newName);
    }

    private void attemptRename(String oldName, String newName) throws IOException {
        Assert.assertEquals((long)1L, (long)this.folder.getRoot().list().length);
        FileSystemResourceStore toTest = new FileSystemResourceStore(this.folder.getRoot());
        toTest.move(oldName, newName);
        Assert.assertEquals((long)1L, (long)this.folder.getRoot().list().length);
    }
}

