/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.exception;

import java.util.Locale;
import junit.framework.Assert;
import org.geoserver.platform.exception.GeoServerException;
import org.geoserver.platform.exception.GeoServerExceptions;
import org.geoserver.platform.exception.IGeoServerException;
import org.geoserver.platform.exception.TestException;
import org.junit.Test;

public class GeoServerExceptionsTest {
    @Test
    public void test() throws Exception {
        GeoServerException e = new TestException().id("hi");
        Assert.assertEquals((String)"hello", (String)GeoServerExceptions.localize((IGeoServerException)e));
    }

    @Test
    public void testLocale() throws Exception {
        GeoServerException e = new TestException().id("hi");
        Assert.assertEquals((String)"bonjour", (String)GeoServerExceptions.localize((IGeoServerException)e, (Locale)Locale.FRENCH));
    }

    @Test
    public void testUnknownLocale() throws Exception {
        GeoServerException e = new TestException().id("hi");
        Assert.assertEquals((String)"hello", (String)GeoServerExceptions.localize((IGeoServerException)e, (Locale)Locale.GERMAN));
    }

    @Test
    public void testWithArgs() throws Exception {
        GeoServerException e = new TestException().id("hey").args(new Object[]{"neo"});
        Assert.assertEquals((String)"hello neo", (String)GeoServerExceptions.localize((IGeoServerException)e));
        Assert.assertEquals((String)"bonjour neo", (String)GeoServerExceptions.localize((IGeoServerException)e, (Locale)Locale.FRENCH));
    }

    @Test
    public void testWithNewDefault() throws Exception {
        Locale old = Locale.getDefault();
        Locale.setDefault(Locale.FRENCH);
        try {
            Assert.assertEquals((String)"bonjour", (String)GeoServerExceptions.localize((IGeoServerException)new TestException().id("hi")));
        }
        finally {
            Locale.setDefault(old);
        }
    }
}

