/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.HashMap;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.geoserver.platform.ExtensionFilter;
import org.geoserver.platform.ExtensionProvider;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.SystemEnvironmentStatus;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class SystemEnvironmentTest {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.platform");

    @Test
    public void testSystemPropertiesStatus() {
        String key = System.getenv().keySet().iterator().next();
        String value = System.getenv(key);
        SystemEnvironmentStatus status = new SystemEnvironmentStatus();
        Assert.assertTrue((boolean)status.getMessage().isPresent());
        Assert.assertTrue((boolean)((String)status.getMessage().get()).contains(key));
        Assert.assertTrue((boolean)((String)status.getMessage().get()).contains(value));
    }

    @Test
    public void testGeoServerEnvironmentDefaultValue() {
        System.clearProperty("ALLOW_ENV_PARAMETRIZATION");
        String sysProperty = System.getProperty("ALLOW_ENV_PARAMETRIZATION");
        GeoServerResourceLoader loader = (GeoServerResourceLoader)EasyMock.createMockBuilder(GeoServerResourceLoader.class).withConstructor().createMock();
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerResourceLoader.class)).andReturn((Object)new String[]{"geoServerLoader"}).anyTimes();
        HashMap<String, GeoServerResourceLoader> genvMap = new HashMap<String, GeoServerResourceLoader>();
        genvMap.put("geoServerLoader", loader);
        EasyMock.expect((Object)appContext.getBeansOfType(GeoServerResourceLoader.class)).andReturn(genvMap).anyTimes();
        EasyMock.expect((Object)appContext.getBean("geoServerLoader")).andReturn((Object)loader).anyTimes();
        EasyMock.expect((Object)appContext.isSingleton("geoServerLoader")).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoServerExtensions gsext = new GeoServerExtensions();
        gsext.setApplicationContext(appContext);
        if (sysProperty == null || !Boolean.valueOf(sysProperty).booleanValue()) {
            GeoServerEnvironment genv = new GeoServerEnvironment();
            Assert.assertTrue((!GeoServerEnvironment.ALLOW_ENV_PARAMETRIZATION ? 1 : 0) != 0);
        }
    }
}

