/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.easymock.EasyMock;
import org.geoserver.platform.ExtensionFilter;
import org.geoserver.platform.ExtensionProvider;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class GeoServerEnvironmentTest {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.platform");

    @Before
    public void setUp() throws Exception {
        Assume.assumeThat((Object)System.getenv("GEOSERVER_DATA_DIR"), (Matcher)CoreMatchers.nullValue());
        System.setProperty("TEST_SYS_PROPERTY", "ABC");
        System.setProperty("ALLOW_ENV_PARAMETRIZATION", "false");
        ServletContext context = (ServletContext)EasyMock.createMock(ServletContext.class);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_REQUIRE_FILE")).andReturn(null);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_DATA_DIR")).andReturn(null);
        EasyMock.expect((Object)context.getInitParameter("GEOSERVER_DATA_ROOT")).andReturn(null);
        EasyMock.expect((Object)context.getRealPath("/data")).andReturn((Object)"data");
        EasyMock.replay((Object[])new Object[]{context});
        System.setProperty("GEOSERVER_REQUIRE_FILE", "pom.xml");
        try {
            Assert.assertEquals((Object)"data", (Object)GeoServerResourceLoader.lookupGeoServerDataDirectory((ServletContext)context));
        }
        finally {
            System.clearProperty("GEOSERVER_REQUIRE_FILE");
        }
        GeoServerResourceLoader loader = (GeoServerResourceLoader)EasyMock.createMockBuilder(GeoServerResourceLoader.class).withConstructor().createMock();
        ApplicationContext appContext = (ApplicationContext)EasyMock.createMock(ApplicationContext.class);
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionFilter.class)).andReturn((Object)new String[0]).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(ExtensionProvider.class)).andReturn((Object)new String[0]).anyTimes();
        EasyMock.expect((Object)appContext.getBeanNamesForType(GeoServerResourceLoader.class)).andReturn((Object)new String[]{"geoServerLoader"}).anyTimes();
        HashMap<String, GeoServerResourceLoader> genvMap = new HashMap<String, GeoServerResourceLoader>();
        genvMap.put("geoServerLoader", loader);
        EasyMock.expect((Object)appContext.getBeansOfType(GeoServerResourceLoader.class)).andReturn(genvMap).anyTimes();
        EasyMock.expect((Object)appContext.getBean("geoServerLoader")).andReturn((Object)loader).anyTimes();
        EasyMock.expect((Object)appContext.isSingleton("geoServerLoader")).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{appContext});
        GeoServerExtensions gsext = new GeoServerExtensions();
        gsext.setApplicationContext(appContext);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("TEST_SYS_PROPERTY");
        System.clearProperty("ALLOW_ENV_PARAMETRIZATION");
    }

    @Test
    public void testSystemProperty() {
        GeoServerEnvironment genv = new GeoServerEnvironment();
        LOGGER.info("GeoServerEnvironment = " + GeoServerEnvironment.ALLOW_ENV_PARAMETRIZATION);
        Assert.assertEquals((Object)"ABC", (Object)genv.resolveValue((Object)"${TEST_SYS_PROPERTY}"));
        Assert.assertEquals((Object)"${TEST_PROPERTY}", (Object)genv.resolveValue((Object)"${TEST_PROPERTY}"));
    }
}

