/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.digest.DigestUtils;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.Resource;

public class MemoryLockProvider
implements LockProvider {
    Lock[] locks;

    public MemoryLockProvider() {
        this(1024);
    }

    public MemoryLockProvider(int concurrency) {
        this.locks = new Lock[concurrency];
        for (int i = 0; i < this.locks.length; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    @Override
    public Resource.Lock acquire(String lockKey) {
        final int idx = this.getIndex(lockKey);
        this.locks[idx].lock();
        return new Resource.Lock(){
            boolean released = false;

            @Override
            public void release() {
                if (!this.released) {
                    this.released = true;
                    MemoryLockProvider.this.locks[idx].unlock();
                }
            }

            public String toString() {
                return "MemoryLock " + idx;
            }
        };
    }

    private int getIndex(String lockKey) {
        int idx = Math.abs(DigestUtils.shaHex((String)lockKey).hashCode() % this.locks.length);
        return idx;
    }

    public String toString() {
        return "MemoryLockProvider";
    }
}

