/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.ResourceNotification;
import org.geoserver.platform.resource.ResourceNotificationDispatcher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class FileSystemWatcher
implements ResourceNotificationDispatcher,
DisposableBean {
    private ScheduledExecutorService pool;
    private FileExtractor fileExtractor;
    protected long lastmodified;
    CopyOnWriteArrayList<Watch> watchers = new CopyOnWriteArrayList();
    private Runnable sync = new Runnable(){

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            for (Watch watch : FileSystemWatcher.this.watchers) {
                if (watch.getListeners().isEmpty()) {
                    FileSystemWatcher.this.watchers.remove(watch);
                    continue;
                }
                Delta delta = watch.changed(now);
                if (delta == null) continue;
                List<ResourceNotification.Event> events = ResourceNotification.delta(watch.file, delta.created, delta.removed, delta.modified);
                ResourceNotification notify = new ResourceNotification(watch.getPath(), delta.kind, watch.last, events);
                for (ResourceListener listener : watch.getListeners()) {
                    try {
                        listener.changed(notify);
                    }
                    catch (Throwable t) {
                        Logger logger = Logger.getLogger(listener.getClass().getPackage().getName());
                        logger.log(Level.FINE, "Unable to notify " + watch + ":" + t.getMessage(), t);
                    }
                }
            }
        }
    };
    private ScheduledFuture<?> monitor;
    private TimeUnit unit = TimeUnit.SECONDS;
    private long delay = 10L;
    private static CustomizableThreadFactory tFactory = new CustomizableThreadFactory("FileSystemWatcher-");

    FileSystemWatcher(FileExtractor fileExtractor) {
        this.pool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)tFactory);
        this.fileExtractor = fileExtractor;
    }

    FileSystemWatcher() {
        this(new FileExtractor(){

            @Override
            public File getFile(String path) {
                return new File(path.replace('/', File.separatorChar));
            }
        });
    }

    private Watch watch(File file, String path) {
        if (file == null || path == null) {
            return null;
        }
        for (Watch watch : this.watchers) {
            if (!watch.isMatch(file, path)) continue;
            return watch;
        }
        return null;
    }

    @Override
    public synchronized void addListener(String path, ResourceListener listener) {
        File file = this.fileExtractor.getFile(path);
        if (file == null) {
            throw new NullPointerException("File to watch is required");
        }
        if (path == null) {
            throw new NullPointerException("Path for notification is required");
        }
        Watch watch = this.watch(file, path);
        if (watch == null) {
            watch = new Watch(file, path);
            this.watchers.add(watch);
            if (this.monitor == null) {
                this.monitor = this.pool.scheduleWithFixedDelay(this.sync, this.delay, this.delay, this.unit);
            }
        }
        watch.addListener(listener);
    }

    @Override
    public synchronized boolean removeListener(String path, ResourceListener listener) {
        File file = this.fileExtractor.getFile(path);
        if (file == null) {
            throw new NullPointerException("File to watch is required");
        }
        if (path == null) {
            throw new NullPointerException("Path for notification is required");
        }
        Watch watch = this.watch(file, path);
        boolean removed = false;
        if (watch != null) {
            watch.removeListener(listener);
            if (watch.getListeners().isEmpty()) {
                removed = this.watchers.remove(watch);
            }
        }
        if (removed && this.watchers.isEmpty() && this.monitor != null) {
            this.monitor.cancel(false);
            this.monitor = null;
        }
        return removed;
    }

    void schedule(long delay, TimeUnit unit) {
        this.delay = delay;
        this.unit = unit;
        if (this.monitor != null) {
            this.monitor.cancel(false);
            this.monitor = this.pool.scheduleWithFixedDelay(this.sync, delay, delay, unit);
        }
    }

    public void destroy() throws Exception {
        this.pool.shutdown();
    }

    @Override
    public void changed(ResourceNotification notification) {
        throw new UnsupportedOperationException();
    }

    static {
        tFactory.setDaemon(true);
    }

    private class Watch
    implements Comparable<Watch> {
        final File file;
        final String path;
        List<ResourceListener> listeners = new CopyOnWriteArrayList<ResourceListener>();
        long last = 0L;
        boolean exsists;
        File[] contents;

        public Watch(File file, String path) {
            this.file = file;
            this.path = path;
            this.exsists = file.exists();
            long l = this.last = this.exsists ? file.lastModified() : 0L;
            if (file.isDirectory()) {
                this.contents = file.listFiles();
            }
        }

        public void addListener(ResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ResourceListener listener) {
            this.listeners.remove(listener);
        }

        public String getPath() {
            return this.path;
        }

        public List<ResourceListener> getListeners() {
            return this.listeners;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Watch other = (Watch)obj;
            if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public String toString() {
            return "Watch [path=" + this.path + ", file=" + this.file + ", listeners=" + this.listeners.size() + "]";
        }

        @Override
        public int compareTo(Watch other) {
            return this.path.compareTo(other.path);
        }

        public Delta changed(long now) {
            if (!this.file.exists()) {
                if (this.exsists) {
                    this.exsists = false;
                    if (this.contents != null) {
                        List<File> deleted = Arrays.asList(this.contents);
                        this.last = now;
                        this.contents = null;
                        return new Delta(this.file, ResourceNotification.Kind.ENTRY_DELETE, null, deleted, null);
                    }
                    this.last = now;
                    return new Delta(this.file, ResourceNotification.Kind.ENTRY_DELETE);
                }
                return null;
            }
            if (this.file.isFile()) {
                long fileModified = this.file.lastModified();
                if (fileModified > this.last || !this.exsists) {
                    if (this.exsists) {
                        this.last = fileModified;
                        return new Delta(this.file, ResourceNotification.Kind.ENTRY_MODIFY);
                    }
                    this.exsists = true;
                    this.last = fileModified;
                    return new Delta(this.file, ResourceNotification.Kind.ENTRY_CREATE);
                }
                return null;
            }
            if (this.file.isDirectory()) {
                ResourceNotification.Kind kind = null;
                long fileModified = this.file.lastModified();
                if (fileModified > this.last || !this.exsists) {
                    kind = this.exsists ? ResourceNotification.Kind.ENTRY_MODIFY : ResourceNotification.Kind.ENTRY_CREATE;
                    this.exsists = true;
                }
                File[] files = this.file.listFiles();
                ArrayList<File> removed = new ArrayList<File>(files.length);
                ArrayList<File> created = new ArrayList<File>(files.length);
                ArrayList<File> modified = new ArrayList<File>(files.length);
                removed.addAll(Arrays.asList(this.contents));
                removed.removeAll(Arrays.asList(files));
                if (!removed.isEmpty()) {
                    fileModified = Math.max(fileModified, this.last + 1L);
                }
                created.addAll(Arrays.asList(files));
                created.removeAll(Arrays.asList(this.contents));
                for (File check : created) {
                    long checkModified = check.lastModified();
                    fileModified = Math.max(fileModified, checkModified);
                }
                ArrayList<File> review = new ArrayList<File>(files.length);
                review.addAll(Arrays.asList(files));
                review.removeAll(created);
                for (File check : review) {
                    long checkModified = check.lastModified();
                    if (checkModified <= this.last) continue;
                    modified.add(check);
                    fileModified = Math.max(fileModified, checkModified);
                }
                if (kind == null) {
                    if (removed.isEmpty() && created.isEmpty() && modified.isEmpty()) {
                        return null;
                    }
                    kind = ResourceNotification.Kind.ENTRY_MODIFY;
                }
                this.last = fileModified;
                this.contents = files;
                return new Delta(this.file, kind, created, removed, modified);
            }
            return null;
        }

        public boolean isMatch(File file, String path) {
            if (this.file == null ? file != null : !this.file.equals(file)) {
                return false;
            }
            return !(this.path == null ? path != null : !this.path.equals(path));
        }
    }

    static class Delta {
        final File context;
        final ResourceNotification.Kind kind;
        final List<File> created;
        final List<File> removed;
        final List<File> modified;

        public Delta(File context, ResourceNotification.Kind kind) {
            this.context = context;
            this.kind = kind;
            this.created = null;
            this.removed = null;
            this.modified = null;
        }

        public Delta(File context, ResourceNotification.Kind kind, List<File> created, List<File> removed, List<File> modified) {
            this.context = context;
            this.kind = ResourceNotification.Kind.ENTRY_MODIFY;
            this.created = created != null ? created : Collections.EMPTY_LIST;
            this.removed = removed != null ? removed : Collections.EMPTY_LIST;
            this.modified = modified != null ? modified : Collections.EMPTY_LIST;
        }

        public String toString() {
            return "Delta [context=" + this.context + ", created=" + this.created + ", removed=" + this.removed + ", modified=" + this.modified + "]";
        }
    }

    static interface FileExtractor {
        public File getFile(String var1);
    }
}

