/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.Optional;
import org.geoserver.platform.ModuleStatus;
import sun.java2d.pipe.RenderingEngine;

public class RenderingEngineStatus
implements ModuleStatus {
    private static final String UNKNOWN = "unknown";
    private String engine;
    private String provider;

    public RenderingEngineStatus() {
        Class<?> renderer;
        try {
            renderer = RenderingEngine.getInstance().getClass();
        }
        catch (Throwable e) {
            this.engine = UNKNOWN;
            this.provider = UNKNOWN;
            return;
        }
        this.engine = renderer.getSimpleName();
        Package pkg = renderer.getPackage();
        this.provider = pkg.getName().contains("marlin") ? "Marlin" : (pkg.getName().contains("sun.dc") ? "OracleJDK" : (pkg.getName().contains("sun.java2d") ? "OpenJDK" : pkg.getName()));
    }

    @Override
    public String getModule() {
        return "jvm";
    }

    @Override
    public Optional<String> getComponent() {
        return Optional.ofNullable("java2d");
    }

    @Override
    public String getName() {
        return "Rendering Engine";
    }

    @Override
    public Optional<String> getVersion() {
        return Optional.ofNullable(System.getProperty("java.version"));
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public Optional<String> getMessage() {
        StringBuilder msg = new StringBuilder();
        msg.append("Java 2D configured with ");
        msg.append(this.engine);
        msg.append(".\n");
        msg.append("Provider: ");
        msg.append(this.provider);
        msg.append("\n");
        String config = System.getProperty("sun.java2d.renderer");
        if (config != null) {
            msg.append("Configuration: -Dsun.java2d.renderer=");
            msg.append(config);
        }
        return Optional.of(msg.toString());
    }

    @Override
    public Optional<String> getDocumentation() {
        return Optional.empty();
    }
}

