/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.platform.ExtensionFilter;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.ExtensionProvider;
import org.geoserver.platform.resource.Paths;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.context.WebApplicationContext;

public class GeoServerExtensions
implements ApplicationContextAware,
ApplicationListener {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.platform");
    static SoftValueHashMap<Class, String[]> extensionsCache = new SoftValueHashMap(40);
    static ConcurrentHashMap<String, Object> singletonBeanCache = new ConcurrentHashMap();
    static ConcurrentHashMap<String, String> propertyCache = new ConcurrentHashMap();
    static ConcurrentHashMap<String, File> fileCache = new ConcurrentHashMap();
    static SoftValueHashMap<Class, List<Object>> spiCache = new SoftValueHashMap(40);
    static boolean isSpringContext = true;
    static ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        isSpringContext = true;
        GeoServerExtensions.context = context;
        extensionsCache.clear();
        singletonBeanCache.clear();
        propertyCache.clear();
    }

    public static final <T> List<T> extensions(Class<T> extensionPoint, ApplicationContext context) {
        ArrayList spiExtensions;
        Collection<String> names = GeoServerExtensions.extensionNames(extensionPoint, context);
        List<Object> filters = ExtensionFilter.class.isAssignableFrom(extensionPoint) ? Collections.emptyList() : GeoServerExtensions.extensions(ExtensionFilter.class, context);
        ArrayList<Object> result = new ArrayList<Object>(names.size());
        for (String name : names) {
            Object bean;
            if (GeoServerExtensions.excludeBean(name, bean = GeoServerExtensions.getBean(context, name), filters)) continue;
            result.add(bean);
        }
        if (!ExtensionProvider.class.isAssignableFrom(extensionPoint) && !ExtensionFilter.class.isAssignableFrom(extensionPoint)) {
            ArrayList<T> secondary = new ArrayList<T>();
            for (ExtensionProvider xp : GeoServerExtensions.extensions(ExtensionProvider.class, context)) {
                try {
                    if (!extensionPoint.isAssignableFrom(xp.getExtensionPoint())) continue;
                    secondary.addAll(xp.getExtensions(extensionPoint));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Extension provider threw exception", e);
                }
            }
            GeoServerExtensions.filter(secondary, filters, result);
        }
        if ((spiExtensions = (ArrayList)spiCache.get(extensionPoint)) == null) {
            spiExtensions = new ArrayList();
            ServiceLoader.load(extensionPoint).iterator().forEachRemaining(spiExtensions::add);
            spiCache.put(extensionPoint, spiExtensions);
        }
        GeoServerExtensions.filter(spiExtensions, filters, result);
        Collections.sort(result, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int p1 = 100;
                if (o1 instanceof ExtensionPriority) {
                    p1 = ((ExtensionPriority)o1).getPriority();
                }
                int p2 = 100;
                if (o2 instanceof ExtensionPriority) {
                    p2 = ((ExtensionPriority)o2).getPriority();
                }
                return p1 - p2;
            }
        });
        return result;
    }

    public static <T> Collection<String> extensionNames(Class<T> extensionPoint) {
        return GeoServerExtensions.extensionNames(extensionPoint, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> Collection<String> extensionNames(Class<T> extensionPoint, ApplicationContext context) {
        String[] names = GeoServerExtensions.context == context ? (String[])extensionsCache.get(extensionPoint) : null;
        if (names != null) return Arrays.asList(names);
        GeoServerExtensions.checkContext(context, extensionPoint.getSimpleName());
        if (context == null) return Collections.emptyList();
        try {
            names = context.getBeanNamesForType(extensionPoint);
            if (names == null) {
                names = new String[]{};
            }
            if (GeoServerExtensions.context != context) return Arrays.asList(names);
            extensionsCache.put(extensionPoint, (Object)names);
            return Arrays.asList(names);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "bean lookup error", e);
            return Collections.emptyList();
        }
    }

    private static Object getBean(ApplicationContext context, String name) {
        Object bean = singletonBeanCache.get(name);
        if (bean == null && context != null && (bean = context.getBean(name)) != null && context.isSingleton(name)) {
            singletonBeanCache.put(name, bean);
        }
        return bean;
    }

    private static void filter(List objects, List<ExtensionFilter> filters, List result) {
        for (Object bean : objects) {
            if (GeoServerExtensions.excludeBean(null, bean, filters)) continue;
            result.add(bean);
        }
    }

    private static boolean excludeBean(String beanId, Object bean, List<ExtensionFilter> filters) {
        for (ExtensionFilter filter : filters) {
            if (!filter.exclude(beanId, bean)) continue;
            return true;
        }
        return false;
    }

    public static final <T> List<T> extensions(Class<T> extensionPoint) {
        return GeoServerExtensions.extensions(extensionPoint, context);
    }

    public static final Object bean(String name) {
        return GeoServerExtensions.bean(name, context);
    }

    public static final Object bean(String name, ApplicationContext context) {
        GeoServerExtensions.checkContext(context, name);
        if (context != null) {
            return GeoServerExtensions.getBean(context, name);
        }
        Object bean = singletonBeanCache.get(name);
        return bean;
    }

    public static final <T> T bean(Class<T> type) throws IllegalArgumentException {
        GeoServerExtensions.checkContext(context, type.getSimpleName());
        return GeoServerExtensions.bean(type, context);
    }

    public static final <T> T bean(Class<T> type, ApplicationContext context) throws IllegalArgumentException {
        List<T> beans = GeoServerExtensions.extensions(type, context);
        if (beans.isEmpty()) {
            return null;
        }
        if (beans.size() > 1) {
            throw new MultipleBeansException(type, GeoServerExtensions.extensionNames(type, context));
        }
        return beans.get(0);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            extensionsCache.clear();
            singletonBeanCache.clear();
        }
    }

    static void checkContext(ApplicationContext context, String bean) {
        if (context == null && isSpringContext) {
            LOGGER.warning("Extension lookup '" + bean + "', but ApplicationContext is unset.");
        }
    }

    public static String getProperty(String propertyName) {
        return GeoServerExtensions.getProperty(propertyName, context);
    }

    public static String getProperty(String propertyName, ApplicationContext context) {
        if (context instanceof WebApplicationContext) {
            return GeoServerExtensions.getProperty(propertyName, ((WebApplicationContext)context).getServletContext());
        }
        return GeoServerExtensions.getProperty(propertyName, (ServletContext)null);
    }

    public static String getProperty(String propertyName, ServletContext context) {
        String[] typeStrs = new String[]{"Property override", "Java environment variable ", "Servlet context parameter ", "System environment variable "};
        String result = null;
        for (int j = 0; j < typeStrs.length; ++j) {
            switch (j) {
                case 0: {
                    result = propertyCache.get(propertyName);
                    break;
                }
                case 1: {
                    result = System.getProperty(propertyName);
                    break;
                }
                case 2: {
                    if (context == null) break;
                    result = context.getInitParameter(propertyName);
                    break;
                }
                case 3: {
                    result = System.getenv(propertyName);
                }
            }
            if (result != null && !result.equalsIgnoreCase("")) break;
            LOGGER.finer("Found " + typeStrs[j] + ": '" + propertyName + "' to be unset");
        }
        return result;
    }

    public static File file(String path) {
        if (fileCache.containsKey(path)) {
            return fileCache.get(path);
        }
        if (context instanceof WebApplicationContext) {
            ServletContext servletContext = ((WebApplicationContext)context).getServletContext();
            String filepath = servletContext.getRealPath(path);
            if (filepath != null) {
                File file = new File(filepath);
                if (file.exists()) {
                    return file;
                }
            } else {
                int index = 0;
                List<String> items = Paths.names(path);
                if (index < items.size()) {
                    filepath = servletContext.getRealPath(items.get(index));
                    ++index;
                    if (filepath != null) {
                        File file = new File(filepath);
                        while (index < items.size()) {
                            file = new File(file, items.get(index));
                            ++index;
                        }
                        return file;
                    }
                }
            }
        }
        return null;
    }

    public static class MultipleBeansException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -8039187466594032626L;
        private final Class<?> extensionPoint;
        private final Collection<String> availableBeans;

        public MultipleBeansException(Class<?> extensionPoint, Collection<String> availableBeans) {
            super("Multiple beans of type " + extensionPoint.getName());
            this.extensionPoint = extensionPoint;
            this.availableBeans = availableBeans;
        }

        public Class<?> getExtensionPoint() {
            return this.extensionPoint;
        }

        public Collection<String> getAvailableBeans() {
            return this.availableBeans;
        }
    }
}

