/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;

public class KvpUtils {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests.readers");
    public static final Tokenizer KEYWORD_DELIMITER = new Tokenizer("&");
    public static final Tokenizer VALUE_DELIMITER = new Tokenizer("=");
    public static final Tokenizer OUTER_DELIMETER = new Tokenizer("\\)\\("){

        @Override
        public List readFlat(String rawList) {
            ArrayList<String> list = new ArrayList<String>(super.readFlat(rawList));
            int len = list.size();
            if (len > 0) {
                String last;
                String first = (String)list.get(0);
                if (first.startsWith("(")) {
                    list.set(0, first.substring(1));
                }
                if ((last = (String)list.get(len - 1)).endsWith(")")) {
                    list.set(len - 1, last.substring(0, last.length() - 1));
                }
            }
            return list;
        }
    };
    public static final Tokenizer INNER_DELIMETER = new Tokenizer(",");
    public static final Tokenizer CQL_DELIMITER = new Tokenizer(";");

    public static List getTypesFromFids(String rawFidList) {
        ArrayList<String> typeList = new ArrayList<String>();
        List unparsed = KvpUtils.readNested(rawFidList);
        ListIterator i = unparsed.listIterator();
        while (i.hasNext()) {
            List ids = (List)i.next();
            ListIterator innerIterator = ids.listIterator();
            while (innerIterator.hasNext()) {
                String fid = innerIterator.next().toString();
                LOGGER.finer("looking at featureId" + fid);
                String typeName = fid.substring(0, fid.lastIndexOf("."));
                LOGGER.finer("adding typename: " + typeName + " from fid");
                typeList.add(typeName);
            }
        }
        return typeList;
    }

    public static List readFlat(String rawList) {
        return KvpUtils.readFlat(rawList, INNER_DELIMETER);
    }

    public static List readFlat(String rawList, Tokenizer tokenizer) {
        return tokenizer.readFlat(rawList);
    }

    public static List readFlat(String rawList, String delimiter) {
        Tokenizer delim;
        if (KvpUtils.KEYWORD_DELIMITER.getRegExp().equals(delimiter)) {
            delim = KEYWORD_DELIMITER;
        } else if (KvpUtils.VALUE_DELIMITER.getRegExp().equals(delimiter)) {
            delim = VALUE_DELIMITER;
        } else if (KvpUtils.OUTER_DELIMETER.getRegExp().equals(delimiter)) {
            delim = OUTER_DELIMETER;
        } else if (KvpUtils.INNER_DELIMETER.getRegExp().equals(delimiter)) {
            delim = INNER_DELIMETER;
        } else if (KvpUtils.CQL_DELIMITER.getRegExp().equals(delimiter)) {
            delim = CQL_DELIMITER;
        } else {
            LOGGER.fine("Using not a well known kvp tokenization delimiter: " + delimiter);
            delim = new Tokenizer(delimiter);
        }
        return KvpUtils.readFlat(rawList, delim);
    }

    public static List readNested(String rawList) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("reading nested: " + rawList);
        }
        ArrayList<List> kvpList = new ArrayList<List>(10);
        if (rawList == null) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found implicit all requested");
            }
            kvpList.add(Collections.EMPTY_LIST);
            return kvpList;
        }
        if (rawList.equals("*")) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("found explicit all requested");
            }
            kvpList.add(Collections.EMPTY_LIST);
            return kvpList;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("found explicit requested");
        }
        if (rawList.startsWith("(")) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("reading complex list");
            }
            List outerList = KvpUtils.readFlat(rawList, OUTER_DELIMETER);
            ListIterator i = outerList.listIterator();
            while (i.hasNext()) {
                kvpList.add(KvpUtils.readFlat((String)i.next(), INNER_DELIMETER));
            }
        } else {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("reading simple list");
            }
            kvpList.add(KvpUtils.readFlat(rawList, INNER_DELIMETER));
        }
        return kvpList;
    }

    public static String clean(String raw) {
        LOGGER.finest("raw request: " + raw);
        String clean = null;
        if (raw != null) {
            try {
                clean = URLDecoder.decode(raw, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.finer("Bad encoding for decoder " + e);
            }
        } else {
            return "";
        }
        LOGGER.finest("cleaned request: " + raw);
        return clean;
    }

    public static KvpMap normalize(Map kvp) {
        if (kvp == null) {
            return null;
        }
        KvpMap normalizedKvp = new KvpMap();
        for (Map.Entry entry : kvp.entrySet()) {
            String key = (String)entry.getKey();
            Object value = null;
            if (entry.getValue() instanceof String) {
                value = KvpUtils.trim((String)entry.getValue());
            } else if (entry.getValue() instanceof String[]) {
                String[] values = (String[])entry.getValue();
                LinkedHashSet<String> normalized = new LinkedHashSet<String>();
                for (String v : values) {
                    if ((v = KvpUtils.trim(v)) == null) continue;
                    normalized.add(v);
                }
                value = normalized.size() == 0 ? null : (normalized.size() == 1 ? normalized.iterator().next() : normalized.toArray(new String[normalized.size()]));
            }
            normalizedKvp.put(key.toLowerCase(), value);
        }
        return normalizedKvp;
    }

    private static String trim(String value) {
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    public static List<Throwable> parse(Map kvp) {
        List parsers = GeoServerExtensions.extensions(KvpParser.class);
        String service = KvpUtils.getSingleValue(kvp, "service");
        String version = KvpUtils.getSingleValue(kvp, "version");
        String request = KvpUtils.getSingleValue(kvp, "request");
        KvpUtils.purgeParsers(parsers, service, version, request);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (Map.Entry entry : kvp.entrySet()) {
            String key = (String)entry.getKey();
            KvpParser parser = KvpUtils.findParser(key, service, request, version, parsers);
            ArrayList<Object> parsed = null;
            if (parser != null) {
                try {
                    if (entry.getValue() instanceof String) {
                        String value = (String)entry.getValue();
                        parsed = parser.parse(value);
                    } else {
                        String[] values = (String[])entry.getValue();
                        ArrayList<Object> result = new ArrayList<Object>();
                        for (String v : values) {
                            result.add(parser.parse(v));
                        }
                        parsed = result;
                    }
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
            if (parsed == null) continue;
            entry.setValue(parsed);
        }
        return errors;
    }

    public static void purgeParsers(List<KvpParser> parsers, String service, String version, String request) {
        Iterator<KvpParser> p = parsers.iterator();
        while (p.hasNext()) {
            KvpParser parser = p.next();
            if (parser.getService() != null && !parser.getService().equalsIgnoreCase(service)) {
                p.remove();
                continue;
            }
            if (parser.getVersion() != null && !parser.getVersion().toString().equals(version)) {
                p.remove();
                continue;
            }
            if (parser.getRequest() == null || parser.getRequest().equalsIgnoreCase(request)) continue;
            p.remove();
        }
    }

    public static KvpParser findParser(String key, String service, String request, String version, Collection<KvpParser> parsers) {
        KvpParser parser = null;
        for (KvpParser candidate : parsers) {
            if (!key.equalsIgnoreCase(candidate.getKey())) continue;
            if (parser == null) {
                parser = candidate;
                continue;
            }
            String trgService = candidate.getService();
            if (trgService == null || !trgService.equalsIgnoreCase(service)) continue;
            String curService = parser.getService();
            if (curService == null) {
                parser = candidate;
                continue;
            }
            Version curVersion = parser.getVersion();
            Version trgVersion = candidate.getVersion();
            if (trgVersion != null) {
                if (curVersion != null || !trgVersion.toString().equals(version)) continue;
                parser = candidate;
                continue;
            }
            if (curVersion != null) continue;
            throw new IllegalStateException("Multiple kvp parsers: " + parser + "," + candidate);
        }
        return parser;
    }

    public static Object parseKey(String key, String value, String service, String request, String version, List<KvpParser> parsers) throws Exception {
        KvpParser parser = KvpUtils.findParser(key, service, request, version, parsers);
        if (parser == null) {
            return null;
        }
        return parser.parse(value);
    }

    public static String getSingleValue(Map kvp, String key) {
        Object value = kvp.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        Object[] strings = (String[])value;
        if (strings.length == 0) {
            return null;
        }
        String result = strings[0];
        for (int i = 1; i < strings.length; ++i) {
            if (result.equals(strings[i])) continue;
            throw new ServiceException("Single value expected for request parameter " + key + " but instead found: " + Arrays.toString(strings), "InvalidParameterValue", key);
        }
        return result;
    }

    public static Map<String, Object> parseQueryString(String path) {
        int index = path.indexOf(63);
        if (index == -1) {
            return Collections.EMPTY_MAP;
        }
        String queryString = path.substring(index + 1);
        StringTokenizer st = new StringTokenizer(queryString, "&");
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (st.hasMoreTokens()) {
            String[] array;
            String value;
            String token = st.nextToken();
            int idx = token.indexOf(61);
            String[] keyValuePair = idx > 0 ? new String[]{token.substring(0, idx), token.substring(idx + 1)} : new String[]{token};
            if (keyValuePair.length > 1) {
                try {
                    keyValuePair[1] = URLDecoder.decode(keyValuePair[1], "ISO-8859-1");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Totally unexpected... is your JVM busted?", e);
                }
            }
            String key = keyValuePair[0];
            String string = value = keyValuePair.length > 1 ? keyValuePair[1] : "";
            if (result.get(key) == null) {
                result.put(key, value);
                continue;
            }
            Object oldValue = result.get(key);
            if (oldValue instanceof String) {
                array = new String[]{(String)oldValue, value};
            } else {
                String[] oldArray = (String[])oldValue;
                array = new String[oldArray.length + 1];
                System.arraycopy(oldArray, 0, array, 0, oldArray.length);
                array[oldArray.length] = value;
            }
            result.put(key, array);
        }
        return result;
    }

    public static List<String> escapedTokens(String s, char separator) {
        return KvpUtils.escapedTokens(s, separator, 0);
    }

    public static List<String> escapedTokens(String s, char separator, int maxTokens) {
        if (s == null) {
            throw new IllegalArgumentException("The String to parse may not be null.");
        }
        if (separator == '\\') {
            throw new IllegalArgumentException("The separator may not be a backslash.");
        }
        if (maxTokens <= 0) {
            maxTokens = Integer.MAX_VALUE;
        }
        ArrayList<String> ret = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        int tokenCount = 1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && !escaped && tokenCount < maxTokens) {
                ret.add(sb.toString());
                sb.setLength(0);
                ++tokenCount;
                continue;
            }
            if (escaped) {
                escaped = false;
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            sb.append(c);
        }
        if (escaped) {
            throw new IllegalStateException("The specified String ends with an incomplete escape sequence.");
        }
        ret.add(sb.toString());
        return ret;
    }

    public static String unescape(String s) {
        if (s == null) {
            throw new IllegalArgumentException("The String to unescape may not be null.");
        }
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (escaped) {
                escaped = false;
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            sb.append(c);
        }
        if (escaped) {
            throw new IllegalArgumentException("The specified String ends with an incomplete escape sequence.");
        }
        return sb.toString();
    }

    public static String caseInsensitiveParam(Map params, String paramname, String defaultValue) {
        String value = defaultValue;
        for (Map.Entry o : params.entrySet()) {
            Map.Entry entry = o;
            if (!(entry.getKey() instanceof String) || !paramname.equalsIgnoreCase((String)entry.getKey())) continue;
            Object obj = entry.getValue();
            value = obj instanceof String ? (String)obj : (obj instanceof String[] ? ((String[])obj)[0].toLowerCase() : value);
        }
        return value;
    }

    public static void merge(Map options, Map addition) {
        for (Map.Entry o : addition.entrySet()) {
            Map.Entry entry = o;
            if (entry.getValue() == null) {
                options.remove(entry.getKey());
                continue;
            }
            options.put(entry.getKey(), entry.getValue());
        }
    }

    public static String firstValue(Map kvp, String param) {
        Object o = kvp.get(param);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        String[] values = (String[])o;
        if (values.length >= 0) {
            return values[0];
        }
        return null;
    }

    public static class Tokenizer {
        private String regExp;

        public Tokenizer(String regExp) {
            this.regExp = regExp;
        }

        private String getRegExp() {
            return this.regExp;
        }

        public String toString() {
            return this.getRegExp();
        }

        public List readFlat(String rawList) {
            if (rawList == null || rawList.trim().equals("")) {
                return Collections.EMPTY_LIST;
            }
            if (rawList.equals("*")) {
                return Collections.EMPTY_LIST;
            }
            String[] split = rawList.split(this.getRegExp(), -1);
            return new ArrayList<String>(Arrays.asList(split));
        }
    }
}

