/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;

public class XmlObjectEncodingResponse
extends Response {
    protected String elementName;
    protected Class<?> xmlConfiguration;

    public XmlObjectEncodingResponse(Class<?> binding, String elementName, Class<?> xmlConfiguration) {
        super(binding);
        this.elementName = elementName;
        this.xmlConfiguration = xmlConfiguration;
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "application/xml";
    }

    @Override
    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        try {
            Configuration c = (Configuration)this.xmlConfiguration.newInstance();
            Encoder e = new Encoder(c);
            for (Map.Entry<String, String> entry : this.getSchemaLocations().entrySet()) {
                e.setSchemaLocation(entry.getKey(), entry.getValue());
            }
            this.configureEncoder(e, this.elementName, this.xmlConfiguration);
            e.encode(value, new QName(c.getXSD().getNamespaceURI(), this.elementName), output);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    protected void configureEncoder(Encoder encoder, String elementName, Class<?> xmlConfiguration) {
    }

    protected Map<String, String> getSchemaLocations() {
        return Collections.emptyMap();
    }
}

