/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class KvpRequestReader {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.ows");
    private Class requestBean;
    protected Set<String> filter;
    boolean hasRepeatedParameters = false;

    public KvpRequestReader(Class requestBean) {
        if (requestBean == null) {
            throw new NullPointerException();
        }
        this.requestBean = requestBean;
    }

    public final Class getRequestBean() {
        return this.requestBean;
    }

    public void setFilter(Set<String> filter) {
        this.filter = filter;
    }

    public Set<String> getFilter() {
        return this.filter;
    }

    public Object createRequest() throws Exception {
        return this.getRequestBean().newInstance();
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        for (Map.Entry entry : kvp.entrySet()) {
            Class<?> valueClass;
            Object rawValue;
            String property = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || this.filter(property)) continue;
            if (!this.hasRepeatedParameters && (rawValue = rawKvp.get(property)) instanceof String[]) {
                throw new ServiceException("Found multiple, inconsistent values for parameter " + property + ": " + Arrays.toString((String[])rawValue), "InvalidParameterValue", property);
            }
            Class<?> targetClass = request.getClass();
            Method setter = OwsUtils.setter(targetClass, property, valueClass = value.getClass());
            if (setter == null && (setter = OwsUtils.setter(request.getClass(), property, null)) != null) {
                Class<?> target = setter.getParameterTypes()[0];
                Object converted = Converters.convert(value, target);
                if (converted != null) {
                    value = converted;
                } else {
                    setter = null;
                }
            }
            if (setter == null) continue;
            setter.invoke(request, value);
        }
        return request;
    }

    protected boolean filter(String kvp) {
        if (this.filter == null) {
            return false;
        }
        for (String f : this.filter) {
            if (!f.equalsIgnoreCase(kvp)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof KvpRequestReader) {
            KvpRequestReader other = (KvpRequestReader)obj;
            return this.requestBean == other.requestBean;
        }
        return false;
    }

    public final int hashCode() {
        return this.requestBean.hashCode();
    }

    protected void setRepeatedParameters(boolean hasRepeatedParameters) {
        this.hasRepeatedParameters = hasRepeatedParameters;
    }
}

