/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geoserver.feature.DecoratingFeatureCollection;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetypingFeatureCollection
extends DecoratingFeatureCollection {
    SimpleFeatureType target;

    public RetypingFeatureCollection(FeatureCollection<SimpleFeatureType, SimpleFeature> delegate, SimpleFeatureType target) {
        super(delegate);
        this.target = target;
    }

    public SimpleFeatureType getSchema() {
        return this.target;
    }

    public Iterator<SimpleFeature> iterator() {
        return new RetypingIterator(this.delegate.iterator(), this.target);
    }

    public void close(Iterator<SimpleFeature> iterator) {
        RetypingIterator retyping = (RetypingIterator)iterator;
        this.delegate.close(retyping.delegate);
    }

    public FeatureIterator<SimpleFeature> features() {
        return new DelegateFeatureIterator((FeatureCollection)this, this.iterator());
    }

    public void close(FeatureIterator<SimpleFeature> iterator) {
        DelegateFeatureIterator delegate = (DelegateFeatureIterator)iterator;
        delegate.close();
    }

    static SimpleFeature retype(SimpleFeature source, SimpleFeatureType target) throws IllegalAttributeException {
        Object[] attributes = new Object[target.getAttributeCount()];
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = target.getDescriptor(i);
            Object value = null;
            if (source.getFeatureType().getDescriptor(attributeType.getName()) != null) {
                value = source.getAttribute(attributeType.getName());
            }
            attributes[i] = value;
        }
        FeatureId id = RetypingFeatureCollection.reTypeId(source.getIdentifier(), source.getFeatureType(), target);
        return SimpleFeatureBuilder.build((SimpleFeatureType)target, (Object[])attributes, (String)id.getID());
    }

    public static FeatureId reTypeId(FeatureId sourceId, SimpleFeatureType original, SimpleFeatureType target) {
        String originalTypeName = original.getName().getLocalPart();
        String destTypeName = target.getName().getLocalPart();
        if (destTypeName.equals(originalTypeName)) {
            return sourceId;
        }
        String prefix = originalTypeName + ".";
        if (sourceId.getID().startsWith(prefix)) {
            return new FeatureIdImpl(destTypeName + "." + sourceId.getID().substring(prefix.length()));
        }
        return sourceId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetypingFeatureWriter
    implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
        FeatureWriter<SimpleFeatureType, SimpleFeature> delegate;
        SimpleFeatureType target;
        private SimpleFeature current;
        private SimpleFeature retyped;

        public RetypingFeatureWriter(FeatureWriter<SimpleFeatureType, SimpleFeature> delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.target = target;
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate = null;
            this.target = null;
        }

        public SimpleFeatureType getFeatureType() {
            return this.target;
        }

        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws IOException {
            try {
                this.current = (SimpleFeature)this.delegate.next();
                this.retyped = RetypingFeatureCollection.retype(this.current, this.target);
                return this.retyped;
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException("Error occurred while retyping feature").initCause(e);
            }
        }

        public void remove() throws IOException {
            this.delegate.write();
        }

        public void write() throws IOException {
            try {
                for (int i = 0; i < this.target.getAttributeCount(); ++i) {
                    AttributeDescriptor at = this.target.getDescriptor(i);
                    Object value = this.retyped.getAttribute(i);
                    this.current.setAttribute(at.getLocalName(), value);
                }
                this.delegate.write();
            }
            catch (IllegalAttributeException e) {
                throw (IOException)new IOException("Error occurred while retyping feature").initCause(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetypingFeatureReader
    implements FeatureReader<SimpleFeatureType, SimpleFeature> {
        FeatureReader<SimpleFeatureType, SimpleFeature> delegate;
        SimpleFeatureType target;

        public RetypingFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.target = target;
        }

        public void close() throws IOException {
            this.delegate.close();
            this.delegate = null;
            this.target = null;
        }

        public SimpleFeatureType getFeatureType() {
            return this.target;
        }

        public boolean hasNext() throws IOException {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
            return RetypingFeatureCollection.retype((SimpleFeature)this.delegate.next(), this.target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RetypingIterator
    implements Iterator<SimpleFeature> {
        SimpleFeatureType target;
        Iterator<SimpleFeature> delegate;

        public RetypingIterator(Iterator<SimpleFeature> delegate, SimpleFeatureType target) {
            this.delegate = delegate;
            this.target = target;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SimpleFeature next() {
            try {
                return RetypingFeatureCollection.retype(this.delegate.next(), this.target);
            }
            catch (IllegalAttributeException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

