/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.SlowThread;
import org.getopt.luke.Util;
import org.getopt.luke.plugins.VocabChart;
import thinlet.Thinlet;

public class ZipfAnalysisPlugin
extends LukePlugin {
    VocabChart chart = null;
    String selectedField;

    @Override
    public String getXULName() {
        return "/xml/zipf-plugin.xml";
    }

    @Override
    public String getPluginName() {
        return "Zipf distributions";
    }

    @Override
    public String getPluginInfo() {
        return "Tool for showing term popularity distributions, by Mark Harwood";
    }

    @Override
    public String getPluginHome() {
        return "mailto:mharwood@apache.org";
    }

    @Override
    public void setMyUi(Object ui) {
        super.setMyUi(ui);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean init() throws Exception {
        Object combobox = this.app.find(this.myUi, "fields");
        this.app.removeAll(combobox);
        Object bean = this.app.find(this.myUi, "vocabchart");
        Object container = this.app.getParent(bean);
        this.chart = new VocabChart(this.app, container);
        this.app.setComponent(bean, "bean", this.chart);
        IndexReader reader = this.getReader();
        if (reader != null) {
            Collection<String> fieldNames = Util.fieldNames(reader, true);
            String firstField = null;
            for (String fieldName : fieldNames) {
                if (firstField == null) {
                    firstField = fieldName;
                }
                Object choice = Thinlet.create("choice");
                this.app.setString(choice, "text", fieldName);
                this.app.add(combobox, choice);
            }
            this.app.setInteger(combobox, "selected", 0);
            this.app.setString(combobox, "text", firstField);
        }
        return true;
    }

    public void cleanChart() {
        this.chart.setScores(null);
        this.chart.invalidate();
        this.app.repaint();
    }

    public void analyze() {
        Object combobox = this.app.find(this.myUi, "fields");
        final String field = this.app.getString(combobox, "text");
        IndexReader reader = this.getReader();
        if (reader == null) {
            this.app.showStatus("No index loaded");
            this.cleanChart();
            return;
        }
        SlowThread st = new SlowThread(this.app){

            @Override
            public void execute() {
                try {
                    int i;
                    int termsPerBucket;
                    int numBuckets = 100;
                    TermsEnum te = MultiFields.getTerms(ZipfAnalysisPlugin.this.ir, field).iterator(null);
                    ArrayList<TermCount> terms = new ArrayList<TermCount>();
                    int longTailDfStart = 1;
                    int longTailDfEnd = 1000;
                    int[] longTailTermDfCounts = new int[longTailDfEnd - longTailDfStart + 1];
                    int numUniqueTerms = 0;
                    while (te.next() != null) {
                        ++numUniqueTerms;
                        int df = te.docFreq();
                        if (df <= longTailDfEnd) {
                            int i2;
                            int n = i2 = df - longTailDfStart;
                            longTailTermDfCounts[n] = longTailTermDfCounts[n] + 1;
                            continue;
                        }
                        terms.add(new TermCount(new Term(field, te.term().utf8ToString()), df));
                    }
                    Object[] sortedTerms = terms.toArray(new TermCount[terms.size()]);
                    Arrays.sort(sortedTerms);
                    if (numUniqueTerms < 100) {
                        termsPerBucket = 1;
                        numBuckets = numUniqueTerms;
                    } else {
                        termsPerBucket = numUniqueTerms / numBuckets;
                    }
                    ArrayList<Bucket> buckets = new ArrayList<Bucket>();
                    Bucket currentBucket = new Bucket();
                    buckets.add(currentBucket);
                    for (i = 0; i < sortedTerms.length; ++i) {
                        currentBucket.addTermDf(((TermCount)sortedTerms[i]).df);
                        if (currentBucket.numTermsInThisBucket < termsPerBucket) continue;
                        currentBucket = new Bucket();
                        buckets.add(currentBucket);
                    }
                    for (i = longTailTermDfCounts.length - 1; i >= 0; --i) {
                        int df = i + longTailDfStart;
                        int numTerms = longTailTermDfCounts[i];
                        for (int t = 0; t < numTerms; ++t) {
                            currentBucket.addTermDf(df);
                            if (currentBucket.numTermsInThisBucket < termsPerBucket) continue;
                            currentBucket = new Bucket();
                            buckets.add(currentBucket);
                        }
                    }
                    if (currentBucket.numTermsInThisBucket == 0) {
                        buckets.remove(currentBucket);
                    }
                    Bucket[] bucketsResult = buckets.toArray(new Bucket[buckets.size()]);
                    float[] termBucketTotals = new float[bucketsResult.length];
                    int maxDf = 0;
                    for (int i3 = 0; i3 < bucketsResult.length; ++i3) {
                        termBucketTotals[i3] = bucketsResult[i3].getAverageDf();
                        maxDf = (int)Math.max((float)maxDf, termBucketTotals[i3]);
                    }
                    Object maxdf = ZipfAnalysisPlugin.this.app.find(ZipfAnalysisPlugin.this.myUi, "maxdf");
                    ZipfAnalysisPlugin.this.app.setString(maxdf, "text", "" + maxDf);
                    Object maxterm = ZipfAnalysisPlugin.this.app.find(ZipfAnalysisPlugin.this.myUi, "maxterm");
                    Object midterm = ZipfAnalysisPlugin.this.app.find(ZipfAnalysisPlugin.this.myUi, "midterm");
                    ZipfAnalysisPlugin.this.app.setString(maxterm, "text", numUniqueTerms + "");
                    ZipfAnalysisPlugin.this.app.setString(midterm, "text", numUniqueTerms / 2 + "");
                    ZipfAnalysisPlugin.this.chart.setScores(termBucketTotals);
                    ZipfAnalysisPlugin.this.chart.invalidate();
                    ZipfAnalysisPlugin.this.app.repaint();
                }
                catch (Exception e) {
                    ZipfAnalysisPlugin.this.app.showStatus("ERROR: " + e.getMessage());
                }
            }
        };
        if (this.app.isSlowAccess()) {
            st.start();
        } else {
            st.execute();
        }
    }

    public String getSelectedField() {
        return this.selectedField;
    }

    public void setSelectedField(String selectedField) {
        this.selectedField = selectedField;
    }

    static class TermCount
    implements Comparable {
        int df = 0;
        int termCount = 0;
        private Term term;

        public TermCount(Term term, int df) {
            this.term = term;
            this.df = df;
        }

        public int compareTo(Object o) {
            TermCount other = (TermCount)o;
            if (this.df > other.df) {
                return -1;
            }
            if (this.df < other.df) {
                return 1;
            }
            return 0;
        }
    }

    static class Bucket {
        int maxDf;
        int minDf = Integer.MAX_VALUE;
        int totalDf;
        int numTermsInThisBucket;

        Bucket() {
        }

        public void addTermDf(int df) {
            this.totalDf += df;
            ++this.numTermsInThisBucket;
            this.maxDf = Math.max(df, this.maxDf);
            this.minDf = Math.min(df, this.minDf);
        }

        public int getAverageDf() {
            if (this.numTermsInThisBucket == 0) {
                return 0;
            }
            return this.totalDf / this.numTermsInThisBucket;
        }

        public String toString() {
            return this.maxDf + " maxDf in " + this.numTermsInThisBucket + " terms";
        }
    }
}

