/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import org.getopt.luke.Luke;

public class VocabChart
extends Component {
    Image offScrImg = null;
    int offScrWidth;
    int offScrHeight;
    private float[] scores;
    private int xBorder = 2;
    private int yBorder = 2;
    private int minRowHeight = 20;
    float max = 0.0f;
    float total = 0.0f;
    Luke app = null;
    Object container = null;

    public VocabChart() {
    }

    public VocabChart(Luke app, Object container) {
        this.app = app;
        this.container = container;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.app == null) {
            return new Dimension(500, 300);
        }
        return this.app.getSize(this.container, 2, 2);
    }

    @Override
    public void update(Graphics rg) {
        this.paint(rg);
    }

    @Override
    public void paint(Graphics rg) {
        Dimension d = this.getSize();
        this.offScrWidth = d.width;
        this.offScrHeight = d.height;
        int availWidth = this.offScrWidth - this.xBorder * 2;
        int availHeight = this.offScrHeight - this.yBorder * 2;
        Graphics og = rg;
        og.setColor(Color.white);
        og.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.scores == null) {
            return;
        }
        int numRows = 1;
        while (this.scores.length > availWidth * numRows && numRows * this.yBorder + numRows * this.minRowHeight < availHeight) {
            ++numRows;
        }
        int rowHeight = availHeight / numRows - this.yBorder;
        float x = this.xBorder;
        float y = this.yBorder + rowHeight;
        float pixelsPerBar = (float)(numRows * availWidth) / (float)this.scores.length;
        int intPixelsPerBar = Math.max(1, (int)pixelsPerBar - 1);
        x = this.xBorder;
        y = this.yBorder + rowHeight;
        for (int i = 0; i < this.scores.length; ++i) {
            og.setColor(Color.BLUE);
            if (this.scores[i] > 0.0f) {
                int height = (int)((float)rowHeight * (this.scores[i] / this.max));
                og.fillRect((int)x, (int)y - height, intPixelsPerBar, height);
            }
            og.setColor(Color.BLACK);
            int len = 2;
            if (i % 5 == 0) {
                len = 4;
            }
            og.drawLine((int)x, (int)y, (int)x, (int)y + len);
            x += pixelsPerBar;
            if (!(x > (float)availWidth)) continue;
            x = this.xBorder;
            y += (float)(rowHeight + this.yBorder);
        }
    }

    public int getMinRowHeight() {
        return this.minRowHeight;
    }

    public void setMinRowHeight(int minRowHeight) {
        this.minRowHeight = minRowHeight;
    }

    public float[] getScores() {
        return this.scores;
    }

    public void setScores(float[] scores) {
        this.scores = scores;
        this.max = 0.0f;
        this.total = 0.0f;
        if (scores != null) {
            for (int i = 0; i < scores.length; ++i) {
                this.max = Math.max(scores[i], this.max);
                this.total += scores[i];
            }
        }
    }

    public int getXBorder() {
        return this.xBorder;
    }

    public void setXBorder(int border) {
        this.xBorder = border;
    }

    public int getYBorder() {
        return this.yBorder;
    }

    public void setYBorder(int border) {
        this.yBorder = border;
    }
}

