/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.plugins.CustomSimilarity;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class SimilarityDesignerPlugin
extends LukePlugin {
    private CustomSimilarity similarity = null;
    private JFileChooser fd = new JFileChooser();

    public SimilarityDesignerPlugin() throws Exception {
        this.fd.setFileSelectionMode(0);
        this.fd.setFileHidingEnabled(false);
        this.fd.setCurrentDirectory(new File(System.getProperty("user.dir")));
    }

    @Override
    public String getXULName() {
        return "/xml/sd-plugin.xml";
    }

    @Override
    public String getPluginName() {
        return "Custom Similarity";
    }

    @Override
    public String getPluginInfo() {
        return "Custom Similarity Designer; by Andrzej Bialecki";
    }

    @Override
    public String getPluginHome() {
        return "mailto:ab@getopt.org";
    }

    @Override
    public boolean init() throws Exception {
        if (this.similarity != null) {
            this.app.setCustomSimilarity(this.similarity);
        }
        return true;
    }

    public void actionLoadSample(Object menu) {
        StringBuffer sb = new StringBuffer();
        String name = this.app.getString(menu, "text");
        try {
            InputStream is = this.getClass().getResourceAsStream("/xml/" + name);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            Object simText = this.app.find(this.myUi, "simText");
            this.app.setString(simText, "text", sb.toString());
            this.actionCompileSimilarity();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.app.errorMsg("Loading failed: " + e.getMessage());
            return;
        }
    }

    public void actionNew() {
        Object simText = this.app.find(this.myUi, "simText");
        this.app.setString(simText, "text", "");
        this.invalidate();
    }

    public void invalidate() {
        this.app.setCustomSimilarity(null);
        Object simStatus = this.app.find(this.myUi, "simStatus");
        this.app.setString(simStatus, "text", "Needs Compile");
        this.app.setColor(simStatus, "foreground", Color.red);
    }

    public void actionCompileSimilarity() {
        Object simText = this.app.find(this.myUi, "simText");
        String script = this.app.getString(simText, "text");
        Object cbCompInt = this.app.find(this.myUi, "cbCompInt");
        int level = this.app.getBoolean(cbCompInt, "selected") ? -1 : 9;
        Context cx = Context.enter();
        cx.setOptimizationLevel(level);
        PrintStream out = null;
        Object selOutput = this.app.find(this.myUi, "selOutput");
        String sel = this.app.getString(selOutput, "text");
        if (sel.equals("System.out")) {
            out = System.out;
        } else if (sel.equals("System.err")) {
            out = System.err;
        }
        Object simStatus = this.app.find(this.myUi, "simStatus");
        try {
            ScriptableObject scope = cx.initStandardObjects();
            cx.evaluateString(scope, script, "<cmd>", 1, null);
            if (this.similarity != null) {
                this.similarity.destroy();
            }
            this.similarity = new CustomSimilarity(cx, scope, out);
            this.app.setCustomSimilarity(this.similarity);
            this.app.setString(simStatus, "text", "OK");
            this.app.setColor(simStatus, "foreground", Color.green);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.app.setCustomSimilarity(null);
            this.app.setString(simStatus, "text", "ERROR");
            this.app.setColor(simStatus, "foreground", Color.red);
            this.app.errorMsg("Compile failed:\n" + e.getMessage());
        }
    }

    public void actionSaveFile() {
        this.fd.setDialogType(1);
        this.fd.setDialogTitle("Select Output File");
        int res = this.fd.showOpenDialog(this.app);
        File file = null;
        if (res == 0) {
            file = this.fd.getSelectedFile();
        }
        if (file == null || file.isDirectory()) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            Object simText = this.app.find(this.myUi, "simText");
            String script = this.app.getString(simText, "text");
            fos.write(script.getBytes("UTF-8"));
            fos.flush();
            fos.close();
            this.app.showStatus("Saved OK.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.app.errorMsg("Could not save '" + file.toString() + ": " + e.getMessage());
            return;
        }
    }

    public void actionOpenFile() {
        this.fd.setDialogType(0);
        this.fd.setDialogTitle("Select Input File");
        int res = this.fd.showOpenDialog(this.app);
        File file = null;
        if (res == 0) {
            file = this.fd.getSelectedFile();
        }
        if (file == null || file.isDirectory()) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            Object simText = this.app.find(this.myUi, "simText");
            this.app.setString(simText, "text", sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.app.errorMsg("Could not open '" + file.toString() + ": " + e.getMessage());
            return;
        }
    }
}

