/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;

public class Shell
extends ImporterTopLevel {
    private PrintWriter stdout = null;
    private PrintWriter stderr = null;
    private InputStream stdin = null;
    private boolean quitting;

    public Shell(PrintWriter stdout, PrintWriter stderr, InputStream stdin) {
        this.stdin = stdin;
        this.stderr = stderr;
        this.stdout = stdout;
        String[] names = new String[]{"print", "quit", "version", "load", "help"};
        this.defineFunctionProperties(names, Shell.class, 2);
        Shell.putProperty((Scriptable)this, "stdout", (Object)stdout);
        Shell.putProperty((Scriptable)this, "stderr", (Object)stderr);
        Shell.putProperty((Scriptable)this, "stdin", (Object)stdin);
        stderr.println(Context.enter().getImplementationVersion());
        Context.exit();
    }

    public void destroy() {
        Context.exit();
    }

    @Override
    public String getClassName() {
        return "global";
    }

    public void help() {
        this.p("");
        this.p("Object                 Description");
        this.p("=======                ===========");
        this.p("app                    current Luke instance.");
        this.p("dir                    currently open Directory.");
        this.p("ir                     currently open IndexReader.");
        this.p("myUi                   this plugin's UI object.");
        this.p("");
        this.p("Command                Description");
        this.p("=======                ===========");
        this.p("defineClass(className) Define an extension using the Java class");
        this.p("                       named with the string argument. ");
        this.p("                       Uses ScriptableObject.defineClass(). ");
        this.p("load(['foo.js', ...])  Load JavaScript source files named by ");
        this.p("                       string arguments. ");
        this.p("loadClass(className)   Load a class named by a string argument.");
        this.p("                       The class must be a script compiled to a");
        this.p("                       class file. ");
        this.p("print([expr ...])      Evaluate and print expressions. ");
        this.p("version([number])      Get or set the JavaScript version number.");
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object out = thisObj.get("stdout", thisObj);
        if (out == null || out == Scriptable.NOT_FOUND) {
            return;
        }
        PrintWriter writer = (PrintWriter)out;
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                writer.print(" ");
            }
            String s = Context.toString(args[i]);
            writer.print(s);
        }
        writer.println();
    }

    public void quit() {
        this.quitting = true;
    }

    public static double version(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double result = cx.getLanguageVersion();
        if (args.length > 0) {
            double d = Context.toNumber(args[0]);
            cx.setLanguageVersion((int)d);
        }
        return result;
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Shell shell = (Shell)Shell.getTopLevelScope(thisObj);
        for (int i = 0; i < args.length; ++i) {
            shell.processSource(cx, new File(Context.toString(args[i])));
        }
    }

    public void prompt() {
        this.stderr.print("js> ");
        this.stderr.flush();
    }

    public Context getContext() {
        Context cx = Context.getCurrentContext();
        if (cx == null) {
            cx = Context.enter();
            cx.initStandardObjects(this);
            cx.setLanguageVersion(120);
        }
        return cx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSource(Context cx, File filename) {
        FileReader in = null;
        try {
            in = new FileReader(filename);
        }
        catch (FileNotFoundException ex) {
            this.stderr.println("ERROR: Couldn't open file \"" + filename + "\".");
            return;
        }
        try {
            cx.evaluateReader(this, in, filename.toString(), 1, null);
        }
        catch (WrappedException we) {
            this.stderr.println(we.getWrappedException().toString());
            we.printStackTrace();
        }
        catch (EvaluatorException ee) {
            this.stderr.println("js: " + ee.getMessage());
        }
        catch (JavaScriptException jse) {
            this.stderr.println("js: " + jse.getMessage());
        }
        catch (IOException ioe) {
            this.stderr.println(ioe.toString());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                this.stderr.println(ioe.toString());
            }
        }
        System.gc();
    }

    public void processSource(Context cx, String script) {
        try {
            Object result = cx.evaluateString(this, script, "<stdin>", 0, null);
            if (result != cx.getUndefinedValue()) {
                this.stderr.println(Context.toString(result));
            }
        }
        catch (WrappedException we) {
            this.stderr.println(we.getWrappedException().toString());
            we.printStackTrace();
        }
        catch (EvaluatorException ee) {
            this.stderr.println("js: " + ee.getMessage());
        }
        catch (Exception jse) {
            this.stderr.println("js: " + jse.getMessage());
        }
        this.prompt();
        System.gc();
    }

    private void p(String s) {
        this.stdout.println(s);
    }
}

