/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.util.StringUtils;
import org.apache.lucene.index.BaseCompositeReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.getopt.luke.Luke;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.SlowThread;
import org.getopt.luke.plugins.FsDirectory;
import org.getopt.luke.plugins.IOReporter;

public class HadoopPlugin
extends LukePlugin {
    private String lastMsg = "?";
    private Object ioTable;
    private Object btOpen;
    private Object bar;
    private Object status;
    private Object indexUri;
    private Object total;
    private Object bufSize;
    private IndexReader myIr = null;
    private int parts = 0;
    private int bufferSize = 4096;
    TreeMap<String, Row> ioData = new TreeMap();
    boolean flip = false;
    boolean opening = false;
    long totalBytes = 0L;

    @Override
    public String getPluginHome() {
        return "mailto:ab@getopt.org";
    }

    @Override
    public String getPluginInfo() {
        return "Open indexes located on any filesystem supported by Hadoop.";
    }

    @Override
    public String getPluginName() {
        return "Hadoop Plugin";
    }

    @Override
    public String getXULName() {
        return "/xml/hadoop.xml";
    }

    @Override
    public boolean init() throws Exception {
        this.status = this.app.find(this.myUi, "status");
        this.app.setString(this.status, "text", this.lastMsg);
        this.ioTable = this.app.find(this.myUi, "ioTable");
        this.bar = this.app.find(this.myUi, "bar");
        this.btOpen = this.app.find(this.myUi, "btOpen");
        this.indexUri = this.app.find(this.myUi, "indexUri");
        this.total = this.app.find(this.myUi, "totalBytes");
        this.bufSize = this.app.find(this.myUi, "bufSize");
        if (this.ir != this.myIr) {
            this.lastMsg = "?";
            this.ioData.clear();
            this.app.removeAll(this.ioTable);
            this.app.setInteger(this.bar, "value", 0);
            this.totalBytes = 0L;
            this.app.setString(this.total, "text", "");
        }
        this.app.setString(this.status, "text", this.lastMsg);
        return false;
    }

    public void actionClear() {
        this.totalBytes = 0L;
        this.app.setString(this.total, "text", String.valueOf(this.totalBytes));
        for (Map.Entry<String, Row> e : this.ioData.entrySet()) {
            e.getValue().setCounter(0L);
        }
    }

    public void actionOpen() {
        final String uriTxt = this.app.getString(this.indexUri, "text");
        if (uriTxt.trim().length() == 0) {
            this.lastMsg = "Empty index path.";
            this.app.errorMsg(this.lastMsg);
            return;
        }
        try {
            this.bufferSize = Integer.parseInt(this.app.getString(this.bufSize, "text"));
        }
        catch (Exception e) {
            // empty catch block
        }
        SlowThread st = new SlowThread(this.app){

            @Override
            public void execute() {
                HadoopPlugin.this.openIndex(uriTxt);
            }
        };
        st.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openIndex(String uriTxt) {
        this.app.removeAll(this.ioTable);
        this.ioData.clear();
        this.actionClear();
        this.opening = true;
        this.parts = 0;
        this.myIr = null;
        try {
            Configuration conf = new Configuration();
            conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
            conf.set("fs.file.impl", LocalFileSystem.class.getName());
            Path path = new Path(uriTxt);
            FileSystem fs = path.getFileSystem(conf);
            if (!fs.exists(path) || fs.isFile(path)) {
                this.lastMsg = "Path doesn't exist or is a regular file.";
                this.app.errorMsg(this.lastMsg);
                return;
            }
            BaseCompositeReader r = null;
            FileStatus[] stats = fs.listStatus(path);
            boolean hasParts = true;
            for (FileStatus s : stats) {
                if (s.isDirectory() && s.getPath().getName().startsWith("part-")) continue;
                hasParts = false;
                break;
            }
            if (hasParts) {
                this.parts = stats.length;
                ArrayList<DirectoryReader> readers = new ArrayList<DirectoryReader>(stats.length);
                for (int i = 0; i < stats.length; ++i) {
                    this.app.setString(this.status, "text", "Opening part " + (i + 1) + " of " + stats.length + " ...");
                    this.app.putProperty(this.bar, "part", new Integer(i));
                    FsDirectory fsdir = new FsDirectory(fs, stats[i].getPath(), false, conf, new DataReporter(stats[i].getPath()), this.bufferSize);
                    DirectoryReader reader = DirectoryReader.open(fsdir);
                    readers.add(reader);
                }
                r = new MultiReader(readers.toArray(new IndexReader[readers.size()]));
                this.lastMsg = "OK - sharded index (" + readers.size() + " parts)";
            } else {
                this.parts = 1;
                this.app.setString(this.status, "text", "Opening single index ...");
                FsDirectory fsdir = new FsDirectory(fs, path, false, conf, new DataReporter(path), this.bufferSize);
                r = DirectoryReader.open(fsdir);
                this.lastMsg = "OK - single index.";
            }
            this.myIr = r;
            this.app.setSlowAccess(true);
            this.app.setIndexReader(r, path.toUri().toString());
            this.app.showStatus(this.lastMsg);
            this.app.setInteger(this.bar, "value", 100);
        }
        catch (Exception e) {
            this.app.errorMsg("Error: " + StringUtils.stringifyException(e));
            this.app.setInteger(this.bar, "value", 0);
            return;
        }
        finally {
            this.opening = false;
        }
    }

    private void updateStatus(Path dir, String name, long bytes, boolean read) {
        Row row;
        if (this.opening) {
            Integer Part2 = (Integer)this.app.getProperty(this.bar, "part");
            if (this.parts > 1) {
                int delta = 100 / this.parts;
                int part = this.flip ? Part2 : Part2 + 1;
                int val = delta * part;
                this.app.setInteger(this.bar, "value", val);
            } else if (this.flip) {
                this.app.setInteger(this.bar, "value", 100);
            } else {
                this.app.setInteger(this.bar, "value", 10);
            }
            this.flip = !this.flip;
        }
        String key = this.parts > 1 ? dir.getName() : name;
        if (!read) {
            key = key + " (cache)";
        }
        if ((row = this.ioData.get(key)) == null) {
            this.app.removeAll(this.ioTable);
            row = new Row(key, bytes);
            this.ioData.put(key, row);
            ArrayList<String> keys = new ArrayList<String>(this.ioData.keySet());
            Collections.sort(keys);
            for (String k : keys) {
                this.app.add(this.ioTable, this.ioData.get((Object)k).tableRow);
            }
        } else {
            row.incrCounter(bytes);
        }
        this.totalBytes += bytes;
        this.app.setString(this.total, "text", String.valueOf(this.totalBytes));
        this.app.showSlowStatus("Read", bytes);
    }

    private class DataReporter
    implements IOReporter {
        private Path path;
        private String pathName;

        public DataReporter(Path path) {
            this.path = path;
            this.pathName = path.getName();
        }

        @Override
        public void reportIO(String name, long bytes, boolean read) {
            HadoopPlugin.this.updateStatus(this.path, name, bytes, read);
        }

        @Override
        public void reportStatus(String msg) {
        }
    }

    private class Row {
        Object tableRow;
        Object counterCell;
        long counter;

        public Row(String name, long counter) {
            this.counter = counter;
            HadoopPlugin.this.app;
            this.tableRow = Luke.create("row");
            HadoopPlugin.this.app;
            this.counterCell = Luke.create("cell");
            HadoopPlugin.this.app.add(this.tableRow, this.counterCell);
            HadoopPlugin.this.app.setChoice(this.counterCell, "alignment", "right");
            HadoopPlugin.this.app.setString(this.counterCell, "text", String.valueOf(counter));
            HadoopPlugin.this.app;
            Object cell = Luke.create("cell");
            HadoopPlugin.this.app.add(this.tableRow, cell);
            HadoopPlugin.this.app.setString(cell, "text", " " + name);
        }

        public void incrCounter(long bytes) {
            this.setCounter(this.counter + bytes);
        }

        public void setCounter(long bytes) {
            this.counter = bytes;
            HadoopPlugin.this.app.setString(this.counterCell, "text", String.valueOf(this.counter));
        }
    }
}

