/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.plugins;

import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.getopt.luke.Luke;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.Util;

public class AnalyzerToolPlugin
extends LukePlugin {
    @Override
    public String getXULName() {
        return "/xml/at-plugin.xml";
    }

    @Override
    public String getPluginName() {
        return "Analyzer Tool";
    }

    @Override
    public String getPluginInfo() {
        return "Tool for analyzing analyzers, by Mark Harwood";
    }

    @Override
    public String getPluginHome() {
        return "mailto:mharwood@apache.org";
    }

    @Override
    public void setMyUi(Object ui) {
        super.setMyUi(ui);
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean init() throws Exception {
        Object combobox = this.app.find(this.myUi, "analyzers");
        this.app.removeAll(combobox);
        String firstClass = "";
        Class[] analyzers = this.app.getAnalyzers();
        for (int i = 0; i < analyzers.length; ++i) {
            Object choice = Luke.create("choice");
            this.app.setString(choice, "text", analyzers[i].getName());
            if (i == 0) {
                firstClass = analyzers[i].getName();
            }
            this.app.add(combobox, choice);
        }
        this.app.setInteger(combobox, "selected", 0);
        this.app.setString(combobox, "text", firstClass);
        Object aVersion = this.app.find(this.myUi, "aVersion");
        this.app.removeAll(aVersion);
        Version[] values = new Version[]{Version.LUCENE_3_0_0, Version.LUCENE_3_1_0, Version.LUCENE_3_2_0, Version.LUCENE_3_3_0, Version.LUCENE_3_4_0, Version.LUCENE_3_5_0, Version.LUCENE_3_6_0, Version.LUCENE_4_0_0, Version.LUCENE_4_1_0, Version.LUCENE_4_2_0, Version.LUCENE_4_3_0, Version.LUCENE_4_4_0, Version.LUCENE_4_5_0, Version.LUCENE_4_6_0, Version.LUCENE_4_7_0, Version.LUCENE_4_8_0, Version.LUCENE_4_9_0, Version.LUCENE_4_10_0, Version.LATEST};
        for (int i = 0; i < values.length; ++i) {
            Version v = values[i];
            Object choice = Luke.create("choice");
            this.app.setString(choice, "text", v.toString());
            this.app.putProperty(choice, "version", v);
            this.app.add(aVersion, choice);
            if (!v.equals(Luke.LV)) continue;
            this.app.setInteger(aVersion, "selected", i);
        }
        return true;
    }

    public void analyze() {
        try {
            Object combobox = this.app.find(this.myUi, "analyzers");
            Object resultsList = this.app.find(this.myUi, "resultsList");
            Object inputText = this.app.find(this.myUi, "inputText");
            String classname = this.app.getString(combobox, "text");
            Object choice = this.app.getSelectedItem(this.app.find(this.myUi, "aVersion"));
            Version v = (Version)this.app.getProperty(choice, "version");
            Class<?> clazz = Class.forName(classname);
            Analyzer analyzer = null;
            try {
                Constructor<?> c = clazz.getConstructor(Version.class);
                analyzer = (Analyzer)c.newInstance(v);
            }
            catch (Throwable t) {
                try {
                    analyzer = (Analyzer)clazz.newInstance();
                }
                catch (Throwable t1) {
                    t1.printStackTrace();
                    this.app.showStatus("Couldn't instantiate analyzer - public 0-arg or 1-arg constructor(Version) required");
                    return;
                }
            }
            TokenStream ts = analyzer.tokenStream("text", new StringReader(this.app.getString(inputText, "text")));
            ts.reset();
            this.app.removeAll(resultsList);
            while (ts.incrementToken()) {
                Object row = Luke.create("item");
                this.app.setString(row, "text", ts.getAttribute(CharTermAttribute.class).toString());
                this.app.add(resultsList, row);
                this.app.putProperty(row, "state", ts.cloneAttributes());
            }
            ts.close();
        }
        catch (Throwable t) {
            this.app.showStatus("Error analyzing:" + t.getMessage());
        }
        this.tokenChange();
    }

    public void tokenChange() {
        Object table = this.app.find(this.myUi, "tokenAtts");
        this.app.removeAll(table);
        Object list = this.app.find("resultsList");
        Object row = this.app.getSelectedItem(list);
        if (row == null) {
            return;
        }
        AttributeSource as = (AttributeSource)this.app.getProperty(row, "state");
        if (as == null) {
            return;
        }
        Iterator<Class<? extends Attribute>> it = as.getAttributeClassesIterator();
        while (it.hasNext()) {
            Attribute att;
            String implClass;
            Class<? extends Attribute> cl = it.next();
            String attClass = cl.getName();
            if (attClass.startsWith("org.apache.lucene.")) {
                attClass = cl.getSimpleName();
            }
            if ((implClass = (att = as.getAttribute(cl)).getClass().getName()).startsWith("org.apache.lucene.")) {
                implClass = att.getClass().getSimpleName();
            }
            Object r = Luke.create("row");
            Object cell = Luke.create("cell");
            this.app.add(table, r);
            this.app.add(r, cell);
            this.app.setString(cell, "text", attClass);
            cell = Luke.create("cell");
            this.app.add(r, cell);
            this.app.setString(cell, "text", implClass);
            cell = Luke.create("cell");
            this.app.add(r, cell);
            String val = null;
            if (attClass.equals("CharTermAttribute")) {
                val = ((CharTermAttribute)att).toString();
            } else if (attClass.equals("FlagsAttribute")) {
                val = Integer.toHexString(((FlagsAttribute)att).getFlags());
            } else if (attClass.equals("OffsetAttribute")) {
                OffsetAttribute off = (OffsetAttribute)att;
                val = off.startOffset() + "-" + off.endOffset();
            } else {
                BytesRef payload;
                val = attClass.equals("PayloadAttribute") ? ((payload = ((PayloadAttribute)att).getPayload()) != null ? Util.bytesToHex(payload.bytes, payload.offset, payload.length, false) : "") : (attClass.equals("PositionIncrementAttribute") ? ((PositionIncrementAttribute)att).getPositionIncrement() + "" : (attClass.equals("TypeAttribute") ? ((TypeAttribute)att).type() : (attClass.equals("KeywordAttribute") ? Boolean.toString(((KeywordAttribute)att).isKeyword()) : att.toString())));
            }
            this.app.setString(cell, "text", val);
        }
        Object inputText = this.app.find(this.myUi, "inputText");
        if (as.hasAttribute(OffsetAttribute.class)) {
            OffsetAttribute off = as.getAttribute(OffsetAttribute.class);
            this.app.setInteger(inputText, "start", 0);
            this.app.setInteger(inputText, "end", off.endOffset());
            this.app.setInteger(inputText, "start", off.startOffset());
            this.app.requestFocus(inputText);
        }
    }
}

