/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.decoders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import org.apache.lucene.document.Field;
import org.apache.solr.schema.FieldType;
import org.getopt.luke.ClassFinder;
import org.getopt.luke.decoders.Decoder;

public class SolrDecoder
implements Decoder {
    private static final String solr_prefix = "org.apache.solr.schema.";
    private static final TreeMap<String, FieldType> types = new TreeMap();
    private static String[] typeNames = new String[0];
    private FieldType fieldType;
    private String name;

    public static final String[] getTypes() {
        return typeNames;
    }

    public SolrDecoder(String type) throws Exception {
        this.fieldType = types.get(type);
        if (this.fieldType == null && type.startsWith("solr.")) {
            String name = solr_prefix + type.substring(5);
            this.fieldType = types.get(name);
        }
        if (this.fieldType == null) {
            throw new Exception("Unknown Solr FieldType: " + type);
        }
        this.name = type;
    }

    @Override
    public String decodeTerm(String fieldName, Object value) throws Exception {
        return this.fieldType.indexedToReadable(value.toString());
    }

    @Override
    public String decodeStored(String fieldName, Field value) throws Exception {
        return this.fieldType.storedToReadable(value);
    }

    public String toString() {
        return this.name;
    }

    static {
        try {
            Class[] classes = ClassFinder.getInstantiableSubclasses(FieldType.class);
            if (classes == null || classes.length == 0) {
                throw new ClassNotFoundException("Missing Solr types???");
            }
            for (Class cls : classes) {
                FieldType ft = (FieldType)cls.newInstance();
                String name = cls.getName();
                types.put(name, ft);
            }
            ArrayList<String> names = new ArrayList<String>();
            for (String n : types.keySet()) {
                if (!n.startsWith(solr_prefix)) continue;
                names.add("solr." + n.substring(solr_prefix.length()));
            }
            Collections.sort(names);
            typeNames = names.toArray(new String[names.size()]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

