/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke.decoders;

import org.apache.lucene.document.Field;
import org.apache.lucene.util.BytesRef;
import org.getopt.luke.Util;
import org.getopt.luke.decoders.Decoder;

public class BinaryDecoder
implements Decoder {
    @Override
    public String decodeTerm(String fieldName, Object value) throws Exception {
        if (value instanceof BytesRef) {
            return Util.bytesToHex((BytesRef)value, false);
        }
        byte[] data = value instanceof byte[] ? (byte[])value : value.toString().getBytes();
        return Util.bytesToHex(data, 0, data.length, false);
    }

    @Override
    public String decodeStored(String fieldName, Field value) throws Exception {
        if (value.binaryValue() != null) {
            return this.decodeTerm(fieldName, value.binaryValue());
        }
        return this.decodeTerm(fieldName, value);
    }

    public String toString() {
        return "binary";
    }
}

