/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexGate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.misc.SweetSpotSimilarity;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.xml.CoreParser;
import org.apache.lucene.queryparser.xml.CorePlusExtensionsParser;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.payloads.PayloadNearQuery;
import org.apache.lucene.search.payloads.PayloadTermQuery;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.store.CompoundFileDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Transition;
import org.getopt.luke.AccessibleHitCollector;
import org.getopt.luke.AccessibleTopHitCollector;
import org.getopt.luke.AllHitsCollector;
import org.getopt.luke.BrowserLauncher;
import org.getopt.luke.ClassFinder;
import org.getopt.luke.CountLimitedHitCollector;
import org.getopt.luke.DocReconstructor;
import org.getopt.luke.FieldTermCount;
import org.getopt.luke.GrowableStringArray;
import org.getopt.luke.HighFreqTerms;
import org.getopt.luke.IndexInfo;
import org.getopt.luke.IntPair;
import org.getopt.luke.IntervalLimitedCollector;
import org.getopt.luke.KeepAllIndexDeletionPolicy;
import org.getopt.luke.KeepLastIndexDeletionPolicy;
import org.getopt.luke.LimitedException;
import org.getopt.luke.LukePlugin;
import org.getopt.luke.PanelPrintWriter;
import org.getopt.luke.Prefs;
import org.getopt.luke.Progress;
import org.getopt.luke.ProgressNotification;
import org.getopt.luke.Ranges;
import org.getopt.luke.SlowThread;
import org.getopt.luke.TermStats;
import org.getopt.luke.TermVectorMapper;
import org.getopt.luke.Util;
import org.getopt.luke.XMLExporter;
import org.getopt.luke.decoders.BinaryDecoder;
import org.getopt.luke.decoders.DateDecoder;
import org.getopt.luke.decoders.Decoder;
import org.getopt.luke.decoders.NumIntDecoder;
import org.getopt.luke.decoders.NumLongDecoder;
import org.getopt.luke.decoders.SolrDecoder;
import org.getopt.luke.decoders.StringDecoder;
import org.getopt.luke.plugins.ScriptingPlugin;
import org.getopt.luke.xmlQuery.CorePlusExtensionsParserFactory;
import org.getopt.luke.xmlQuery.XmlQueryParserFactory;
import thinlet.FrameLauncher;
import thinlet.Thinlet;

public class Luke
extends Thinlet
implements ClipboardOwner {
    private static final long serialVersionUID = -470469999079073156L;
    public static Version LV = Version.LATEST;
    private Directory dir = null;
    String pName = null;
    private IndexReader ir = null;
    private AtomicReader ar = null;
    private IndexSearcher is = null;
    private boolean slowAccess = false;
    private List<String> fn = null;
    private String[] idxFields = null;
    private FieldInfos infos = null;
    private IndexInfo idxInfo = null;
    private Map<String, FieldTermCount> termCounts;
    private List<LukePlugin> plugins = new ArrayList<LukePlugin>();
    private Object errorDlg = null;
    private Object infoDlg = null;
    private Object statmsg = null;
    private Object slowstatus = null;
    private Object slowmsg = null;
    private boolean readOnly = false;
    private boolean ram = false;
    private boolean keepCommits = false;
    private int tiiDiv = 1;
    private IndexCommit currentCommit = null;
    private Similarity similarity = null;
    private Object lastST;
    private HashMap<String, Decoder> decoders = new HashMap();
    private Decoder defDecoder = new StringDecoder();
    public static final int THEME_DEFAULT = 0;
    public static final int THEME_GRAY = 1;
    public static final int THEME_SANDSTONE = 2;
    public static final int THEME_SKY = 3;
    public static final int THEME_NAVY = 4;
    public int[][] themes = new int[][]{{15526352, 0, 16119024, 9542554, 0xB0B0B0, 0xEEEEEE, 0xB9B9B9, 0xFF8080, 0xC5C5DD}, {0xE6E6E6, 0, 0xFFFFFF, 0x909090, 0xB0B0B0, 0xEDEDED, 0xB9B9B9, 0x89899A, 0xC5C5DD}, {0xEEEECC, 0, 0xFFFFFF, 0x999966, 11579542, 15592907, 0xCCCC99, 0xCC6600, 0xFFCC66}, {0xF0F0FF, 160, 0xFFFFFF, 0x8080FF, 0xB0B0B0, 0xEDEDED, 0xB0B0FF, 0xFF0000, 16638176}, {6518230, 0xFFFFFF, 8359901, 14082037, 10267365, 0x666666, 13209, 0xFF3333, 0x666666}};
    private int numTerms = 0;
    private static boolean exitOnDestroy = false;
    private Class[] analyzers = null;
    private String baseDir = null;
    private Class[] defaultAnalyzers = new Class[]{SimpleAnalyzer.class, StandardAnalyzer.class, StopAnalyzer.class, WhitespaceAnalyzer.class};
    private static final String MSG_NOINDEX = "FAILED: No index, or index is closed. Reopen it.";
    private static final String MSG_READONLY = "FAILED: Read-Only index.";
    private static final String MSG_EMPTY_INDEX = "Index is empty.";
    private static final String MSG_CONV_ERROR = "Some values could not be properly represented in this format. They are marked in grey and presented as a hex dump.";
    private static final String MSG_LUCENE3828 = "Sorry. This functionality doesn't work with Lucene trunk. See LUCENE-3828 for more details.";
    public static final boolean verboseMode = false;
    Thread statusThread = null;
    long lastUpdate = 0L;
    long statusSleep = 0L;
    long lastSlowUpdate = 0L;
    long lastSlowCounter = 0L;
    Thread slowThread = null;
    long slowSleep = 0L;
    Class defaultDirImpl = null;
    XMLExporter exporter = null;
    Document doc = null;
    int iNum;
    Font courier = null;
    int resStart = 0;
    int resCount = 20;
    LimitedException le = null;
    private DecimalFormat df = new DecimalFormat("0.0000");
    private String xmlQueryParserFactoryClassName = CorePlusExtensionsParserFactory.class.getName();
    private static TFIDFSimilarity defaultSimilarity = new DefaultSimilarity();

    public Luke() {
        Prefs.load();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setTheme(Prefs.getInteger("luke.theme", 0));
        String fontName = Prefs.getProperty("luke.fontname", "SansSerif");
        String fontSize = Prefs.getProperty("luke.fontsize", "12.0");
        float fsize = 12.0f;
        try {
            fsize = Float.parseFloat(fontSize);
        }
        catch (Exception e) {
            // empty catch block
        }
        Font f = new Font(fontName, 0, (int)fsize);
        this.setFont(f);
        this.addComponent(this, "/xml/luke.xml", null, null);
        this.errorDlg = this.addComponent(null, "/xml/error.xml", null, null);
        this.infoDlg = this.addComponent(null, "/xml/info.xml", null, null);
        this.statmsg = this.find("statmsg");
        this.slowstatus = this.find("slowstat");
        this.slowmsg = this.find(this.slowstatus, "slowmsg");
        try {
            Class[] an = ClassFinder.getInstantiableSubclasses(Analyzer.class);
            if (an == null || an.length == 0) {
                System.err.println("No analyzers???");
                this.analyzers = this.defaultAnalyzers;
            } else {
                this.analyzers = an;
            }
            Object cbType = this.find("cbType");
            this.populateAnalyzers(cbType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initSolrTypes();
        this.loadPlugins();
    }

    private void initSolrTypes() {
        String[] solrTypes = SolrDecoder.getTypes();
        Object cbDec = this.find("cbDec");
        Font f = this.getFont(cbDec, "font");
        for (String s : solrTypes) {
            Object choice = Luke.create("choice");
            this.setFont(choice, f);
            this.setString(choice, "name", s);
            this.setString(choice, "text", s);
            this.add(cbDec, choice);
        }
    }

    public void setTheme(int which) {
        if (which < 0 || which >= this.themes.length) {
            which = 0;
        }
        int[] t = this.themes[which];
        this.setColors(t[0], t[1], t[2], t[3], t[4], t[5], t[6], t[7], t[8]);
        Prefs.setProperty("luke.theme", which + "");
    }

    public void actionTheme(Object menu) {
        String which = (String)this.getProperty(menu, "t");
        int t = 0;
        try {
            t = Integer.parseInt(which);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setTheme(t);
    }

    public void populateAnalyzers(Object combo) {
        int i;
        this.removeAll(combo);
        Object[] aNames = new String[this.analyzers.length];
        for (i = 0; i < this.analyzers.length; ++i) {
            aNames[i] = this.analyzers[i].getName();
        }
        Arrays.sort(aNames);
        for (i = 0; i < aNames.length; ++i) {
            Object choice = Luke.create("choice");
            this.setString(choice, "text", (String)aNames[i]);
            this.add(combo, choice);
            if (i != 0) continue;
            this.setString(combo, "text", (String)aNames[i]);
        }
        int lastAnalyzerIdx = 0;
        String lastAnalyzer = Prefs.getProperty("luke.analyzer");
        if (lastAnalyzer != null) {
            lastAnalyzerIdx = this.getIndex(combo, lastAnalyzer);
        }
        if (lastAnalyzerIdx < 0) {
            lastAnalyzerIdx = 0;
        }
        this.setInteger(combo, "selected", lastAnalyzerIdx);
    }

    public Class[] getAnalyzers() {
        return this.analyzers;
    }

    private void loadPlugins() {
        ArrayList pluginClasses = new ArrayList();
        try {
            Class[] classes = ClassFinder.getInstantiableSubclasses(LukePlugin.class);
            if (classes != null && classes.length > 0) {
                pluginClasses.addAll(Arrays.asList(classes));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            InputStream is = this.getClass().getResourceAsStream("/.plugins");
            if (is != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().equals("")) continue;
                    try {
                        Class<?> clazz = Class.forName(line.trim());
                        if (!clazz.getSuperclass().equals(LukePlugin.class) || pluginClasses.contains(clazz)) continue;
                        pluginClasses.add(clazz);
                    }
                    catch (Throwable x) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            StringBuffer errors = new StringBuffer("Unable to load some plugins:");
            boolean failures = false;
            for (int i = 0; i < pluginClasses.size(); ++i) {
                try {
                    LukePlugin plugin = (LukePlugin)((Class)pluginClasses.get(i)).getConstructor(new Class[0]).newInstance(new Object[0]);
                    String xul = plugin.getXULName();
                    if (xul == null) continue;
                    Object ui = this.parse(xul, (Object)plugin);
                    plugin.setApplication(this);
                    plugin.setMyUi(ui);
                    this.plugins.add(plugin);
                    continue;
                }
                catch (Exception e) {
                    failures = true;
                    e.printStackTrace();
                    errors.append("\n" + pluginClasses.get(i).toString());
                }
            }
            if (failures) {
                this.errorMsg(errors.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg(e.toString());
        }
        if (this.plugins.size() == 0) {
            return;
        }
        this.initPlugins();
    }

    private void addPluginTab(Object tabs, LukePlugin plugin) {
        Object tab = Luke.create("tab");
        this.setColor(tab, "foreground", new Color(24576));
        this.setString(tab, "text", plugin.getPluginName());
        this.setFont(tab, this.getFont().deriveFont(1));
        this.add(tabs, tab);
        Object panel = Luke.create("panel");
        this.setInteger(panel, "gap", 2);
        this.setInteger(panel, "weightx", 1);
        this.setInteger(panel, "weighty", 1);
        this.setChoice(panel, "halign", "fill");
        this.setChoice(panel, "valign", "fill");
        this.setInteger(panel, "columns", 1);
        this.add(tab, panel);
        Object infobar = Luke.create("panel");
        this.setInteger(infobar, "gap", 8);
        this.setInteger(infobar, "top", 2);
        this.setInteger(infobar, "bottom", 2);
        this.setInteger(infobar, "weightx", 1);
        this.setChoice(infobar, "halign", "fill");
        this.setColor(infobar, "background", new Color(0xC0F0C0));
        this.add(panel, infobar);
        Object label = Luke.create("label");
        this.setString(label, "text", plugin.getPluginInfo());
        this.add(infobar, label);
        Object link = Luke.create("button");
        this.setChoice(link, "type", "link");
        this.setString(link, "text", plugin.getPluginHome());
        this.putProperty(link, "url", plugin.getPluginHome());
        this.setMethod(link, "action", "goUrl(this)", infobar, this);
        this.add(infobar, link);
        this.add(panel, Luke.create("separator"));
        this.add(panel, plugin.getMyUi());
    }

    public List<LukePlugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }

    public LukePlugin getPlugin(String className) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            LukePlugin plugin = this.plugins.get(i);
            if (!plugin.getClass().getName().equals(className)) continue;
            return plugin;
        }
        return null;
    }

    public void showStatus(final String msg) {
        if (this.statusThread != null && this.statusThread.isAlive()) {
            this.setString(this.statmsg, "text", msg);
            this.statusSleep = 5000L;
        } else {
            this.statusThread = new Thread(){

                @Override
                public void run() {
                    Luke.this.statusSleep = 5000L;
                    Luke.this.setString(Luke.this.statmsg, "text", msg);
                    while (Luke.this.statusSleep > 0L) {
                        try {
                            1.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Luke.this.statusSleep -= 500L;
                    }
                    Luke.this.setString(Luke.this.statmsg, "text", "");
                }
            };
            this.statusThread.start();
        }
    }

    public void showSearchStatus(String msg) {
        this.setString(this.lastST, "text", msg);
        this.showStatus(msg);
    }

    public void showSlowStatus(final String msg, final long counter) {
        if (this.slowThread != null && this.slowThread.isAlive()) {
            this.lastSlowCounter += counter;
            this.setString(this.slowmsg, "text", msg + " " + this.lastSlowCounter);
            this.slowSleep = 5000L;
        } else {
            this.slowThread = new Thread(){

                @Override
                public void run() {
                    Luke.this.slowSleep = 5000L;
                    Luke.this.lastSlowCounter = counter;
                    Luke.this.setBoolean(Luke.this.slowstatus, "visible", true);
                    Luke.this.setString(Luke.this.slowmsg, "text", msg + " " + Luke.this.lastSlowCounter);
                    while (Luke.this.slowSleep > 0L) {
                        try {
                            2.sleep(500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Luke.this.slowSleep -= 500L;
                    }
                    Luke.this.setString(Luke.this.slowmsg, "text", "");
                    Luke.this.setBoolean(Luke.this.slowstatus, "visible", false);
                }
            };
            this.slowThread.start();
        }
    }

    public Object addComponent(Object parent, String compView, String handlerStr, Object[] argv) {
        Object res = null;
        Object handler = null;
        try {
            if (handlerStr != null) {
                handler = argv == null ? Class.forName(handlerStr).getConstructor(Thinlet.class).newInstance(this) : Class.forName(handlerStr).getConstructor(Thinlet.class, Object[].class).newInstance(this, argv);
            }
            res = handler != null ? this.parse(compView, handler) : this.parse(compView);
            if (parent != null) {
                if (parent instanceof Thinlet) {
                    this.add(res);
                } else {
                    this.add(parent, res);
                }
            }
            return res;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.errorMsg(exc.getMessage());
            return null;
        }
    }

    public void errorMsg(String msg) {
        Object fMsg = this.find(this.errorDlg, "msg");
        this.setString(fMsg, "text", msg);
        this.add(this.errorDlg);
    }

    public void infoMsg(String msg) {
        Object fMsg = this.find(this.infoDlg, "msg");
        this.setString(fMsg, "text", msg);
        this.add(this.infoDlg);
    }

    public void actionOpen() {
        Object dialog = this.addComponent(this, "/xml/lukeinit.xml", null, null);
        Object path = this.find(dialog, "path");
        if (this.baseDir != null) {
            this.setString(path, "text", this.baseDir);
        } else {
            this.setString(path, "text", System.getProperty("user.dir"));
        }
    }

    public void openBrowse(Object path) {
        JFileChooser fd = new JFileChooser();
        fd.setDialogType(0);
        fd.setDialogTitle("Select Index directory");
        fd.setFileSelectionMode(2);
        fd.setFileHidingEnabled(false);
        String strPath = this.getString(path, "text");
        if (strPath != null) {
            strPath.trim();
        }
        if (strPath != null && strPath.length() > 0) {
            fd.setCurrentDirectory(new File(strPath));
        } else if (this.baseDir != null) {
            fd.setCurrentDirectory(new File(this.baseDir));
        } else {
            fd.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        int res = fd.showOpenDialog(this);
        File iDir = null;
        if (res == 0) {
            iDir = fd.getSelectedFile();
        }
        if (iDir != null && iDir.exists()) {
            if (!iDir.isDirectory()) {
                iDir = iDir.getParentFile();
            }
            this.setString(path, "text", iDir.toString());
        }
    }

    public void saveBrowse(Object path, Object startButton) {
        JFileChooser fd = new JFileChooser();
        fd.setDialogType(1);
        fd.setDialogTitle("Select Output File");
        fd.setFileSelectionMode(0);
        fd.setFileHidingEnabled(false);
        String strPath = this.getString(path, "text");
        if (strPath != null) {
            strPath.trim();
        }
        if (strPath != null && strPath.length() > 0) {
            fd.setCurrentDirectory(new File(strPath));
        } else if (this.baseDir != null) {
            fd.setCurrentDirectory(new File(this.baseDir));
        } else {
            fd.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        int res = fd.showSaveDialog(this);
        this.setBoolean(startButton, "enabled", false);
        File iFile = null;
        if (res == 0) {
            iFile = fd.getSelectedFile();
        }
        if (iFile != null) {
            this.setString(path, "text", iFile.toString());
            this.setBoolean(startButton, "enabled", true);
        }
    }

    public void setupInit(Object dialog) {
        Object path = this.find(dialog, "path");
        this.syncMRU(path);
    }

    public void openOk(Object dialog) {
        Object path = this.find(dialog, "path");
        this.pName = this.getString(path, "text").trim();
        boolean force = this.getBoolean(this.find(dialog, "force"), "selected");
        boolean noReader = this.getBoolean(this.find(dialog, "cbNoReader"), "selected");
        this.tiiDiv = 1;
        try {
            this.tiiDiv = Integer.parseInt(this.getString(this.find(dialog, "tiiDiv"), "text"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object dirImpl = this.getSelectedItem(this.find(dialog, "dirImpl"));
        String dirClass = null;
        if (dirImpl == null) {
            dirClass = FSDirectory.class.getName();
        } else {
            String name = this.getString(dirImpl, "name");
            if (name == null) {
                dirClass = this.getString(dirImpl, "text");
            } else if (name.equals("fs")) {
                dirClass = FSDirectory.class.getName();
            } else if (name.equals("mmap")) {
                dirClass = MMapDirectory.class.getName();
            } else if (name.equals("niofs")) {
                dirClass = NIOFSDirectory.class.getName();
            }
        }
        if (this.pName == null || this.pName.trim().equals("")) {
            this.errorMsg("Invalid path.");
            return;
        }
        this.readOnly = this.getBoolean(this.find(dialog, "ro"), "selected");
        this.ram = this.getBoolean(this.find(dialog, "ram"), "selected");
        this.keepCommits = this.getBoolean(this.find(dialog, "cbKeepCommits"), "selected");
        this.slowAccess = this.getBoolean(this.find(dialog, "cbSlowIO"), "selected");
        this.decoders.clear();
        this.currentCommit = null;
        Prefs.addToMruList(this.pName);
        this.syncMRU(path);
        this.remove(dialog);
        if (noReader) {
            this.removeAll();
            this.addComponent(this, "/xml/luke.xml", null, null);
            try {
                Directory d = this.openDirectory(dirClass, this.pName, false);
                if (DirectoryReader.indexExists(d)) {
                    throw new Exception("there is no valid Lucene index in this directory.");
                }
                this.dir = d;
                this.initOverview();
                this.infoMsg("There is no IndexReader - most actions are disabled. You can open IndexReader from current Directory using 'Re-Open'");
            }
            catch (Exception e) {
                this.errorMsg("ERROR: " + e.toString());
            }
        } else {
            this.openIndex(this.pName, force, dirClass, this.readOnly, this.ram, this.keepCommits, null, this.tiiDiv);
        }
    }

    public void actionClose() {
        if (this.ir != null) {
            try {
                if (this.is != null) {
                    this.is = null;
                }
                this.ir.close();
                if (this.ar != null) {
                    this.ar.close();
                }
                if (this.dir != null) {
                    this.dir.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMsg("Close failed: " + e.getMessage());
            }
        }
        this.ir = null;
        this.ar = null;
        this.dir = null;
        this.is = null;
        this.removeAll();
        this.addComponent(this, "/xml/luke.xml", null, null);
        this.initPlugins();
    }

    public void actionCommit() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (!(this.ir instanceof DirectoryReader)) {
            this.showStatus("Commit not possible with " + this.ir.getClass().getSimpleName());
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            IndexCommit commit = ((DirectoryReader)this.ir).getIndexCommit();
            Map<String, String> userData = commit.getUserData();
            TreeMap<String, String> ud = new TreeMap<String, String>(userData);
            Object dialog = this.addComponent(this, "/xml/commit.xml", null, null);
            this.putProperty(dialog, "userData", ud);
            this._showUserData(dialog);
        }
        catch (Exception e) {
            this.errorMsg("Exception retrieving user data: " + e.toString());
        }
    }

    private void _showUserData(Object dialog) {
        Object table = this.find(dialog, "data");
        this.removeAll(table);
        Map ud = (Map)this.getProperty(dialog, "userData");
        for (Map.Entry e : ud.entrySet()) {
            Object row = Luke.create("row");
            this.putProperty(row, "key", e.getKey());
            this.add(table, row);
            Object cell = Luke.create("cell");
            this.setString(cell, "text", (String)e.getKey());
            this.add(row, cell);
            cell = Luke.create("cell");
            this.setString(cell, "text", (String)e.getValue());
            this.add(row, cell);
        }
    }

    public void putUserData(Object dialog) {
        Object key = this.find(dialog, "key");
        Object value = this.find(dialog, "value");
        String k = this.getString(key, "text");
        String v = this.getString(value, "text");
        if (k.equals("")) {
            this.showStatus("Cannot add empty key.");
            return;
        }
        Map ud = (Map)this.getProperty(dialog, "userData");
        ud.put(k, v);
        this._showUserData(dialog);
    }

    public void deleteUserData(Object dialog) {
        Object table = this.find(dialog, "data");
        Map ud = (Map)this.getProperty(dialog, "userData");
        Object[] rows = this.getSelectedItems(table);
        if (rows == null || rows.length == 0) {
            return;
        }
        for (Object row : rows) {
            Object key = this.getProperty(row, "key");
            ud.remove(key);
        }
        this._showUserData(dialog);
    }

    private IndexWriter createIndexWriter() {
        try {
            IndexWriterConfig cfg = new IndexWriterConfig(LV, new WhitespaceAnalyzer(LV));
            IndexDeletionPolicy policy = this.keepCommits ? new KeepAllIndexDeletionPolicy() : new KeepLastIndexDeletionPolicy();
            cfg.setIndexDeletionPolicy(policy);
            cfg.setUseCompoundFile(IndexGate.preferCompoundFormat(this.dir));
            IndexWriter iw = new IndexWriter(this.dir, cfg);
            return iw;
        }
        catch (Exception e) {
            this.errorMsg("Error creating IndexWriter: " + e.toString());
            return null;
        }
    }

    private void refreshAfterWrite() throws Exception {
        this.actionReopen();
    }

    public void commitUserData(Object dialog) {
        Map userData = (Map)this.getProperty(dialog, "userData");
        this.remove(dialog);
        if (!(this.ir instanceof DirectoryReader)) {
            this.errorMsg("Not possible with " + this.ir.getClass().getSimpleName());
            return;
        }
        try {
            IndexWriter iw = this.createIndexWriter();
            iw.commit();
            iw.close();
            this.refreshAfterWrite();
        }
        catch (Exception e) {
            this.errorMsg("Error: " + e.toString());
        }
    }

    public void actionReopen() {
        if (this.dir == null) {
            return;
        }
        this.openIndex(this.pName, false, this.dir.getClass().getName(), this.readOnly, this.ram, this.keepCommits, this.currentCommit, this.tiiDiv);
    }

    public void openIndex(String name, boolean force, String dirImpl, boolean ro, boolean ramdir, boolean keepCommits, IndexCommit point, int tiiDivisor) {
        this.pName = name;
        this.readOnly = ro;
        this.removeAll();
        File baseFileDir = new File(name);
        this.baseDir = baseFileDir.toString();
        this.addComponent(this, "/xml/luke.xml", null, null);
        this.statmsg = this.find("statmsg");
        if (this.dir != null) {
            try {
                if (this.ir != null) {
                    this.ir.close();
                }
                if (this.ar != null) {
                    this.ar.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.dir != null) {
                    this.dir.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList<Directory> dirs = new ArrayList<Directory>();
        Throwable lastException = null;
        try {
            Directory d = this.openDirectory(dirImpl, this.pName, false);
            if (IndexWriter.isLocked(d) && !ro) {
                if (force) {
                    IndexWriter.unlock(d);
                } else {
                    this.errorMsg("Index is locked. Try 'Force unlock' when opening.");
                    d.close();
                    d = null;
                    return;
                }
            }
            boolean existsSingle = false;
            try {
                new SegmentInfos().read(d);
                existsSingle = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                lastException = e;
            }
            if (!existsSingle) {
                File[] files;
                for (File f : files = baseFileDir.listFiles()) {
                    if (f.isFile()) continue;
                    Directory d1 = this.openDirectory(dirImpl, f.toString(), false);
                    if (IndexWriter.isLocked(d1) && !ro) {
                        if (force) {
                            IndexWriter.unlock(d1);
                        } else {
                            this.errorMsg("Index is locked. Try 'Force unlock' when opening.");
                            d1.close();
                            d1 = null;
                            return;
                        }
                    }
                    existsSingle = false;
                    try {
                        new SegmentInfos().read(d1);
                        existsSingle = true;
                    }
                    catch (Throwable e) {
                        lastException = e;
                        e.printStackTrace();
                    }
                    if (!existsSingle) {
                        d1.close();
                        continue;
                    }
                    dirs.add(d1);
                }
            } else {
                dirs.add(d);
            }
            if (dirs.size() == 0) {
                if (lastException != null) {
                    this.errorMsg("Invalid directory at the location, check console for more information. Last exception:\n" + lastException.toString());
                } else {
                    this.errorMsg("No valid directory at the location, try another location.\nCheck console for other possible causes.");
                }
                return;
            }
            if (ramdir) {
                this.showStatus("Loading index into RAMDirectory ...");
                RAMDirectory dir1 = new RAMDirectory();
                IndexWriterConfig cfg = new IndexWriterConfig(LV, new WhitespaceAnalyzer(LV));
                IndexWriter iw1 = new IndexWriter(dir1, cfg);
                iw1.addIndexes(dirs.toArray(new Directory[dirs.size()]));
                iw1.close();
                this.showStatus("RAMDirectory loading done!");
                if (this.dir != null) {
                    this.dir.close();
                }
                dirs.clear();
                dirs.add(dir1);
            }
            IndexDeletionPolicy policy = keepCommits ? new KeepAllIndexDeletionPolicy() : new KeepLastIndexDeletionPolicy();
            ArrayList<DirectoryReader> readers = new ArrayList<DirectoryReader>();
            for (Directory dd : dirs) {
                DirectoryReader reader = tiiDivisor > 1 ? DirectoryReader.open(dd, tiiDivisor) : DirectoryReader.open(dd);
                readers.add(reader);
            }
            if (readers.size() == 1) {
                this.ir = (IndexReader)readers.get(0);
                this.dir = ((DirectoryReader)this.ir).directory();
            } else {
                this.ir = new MultiReader(readers.toArray(new IndexReader[readers.size()]));
            }
            this.is = new IndexSearcher(this.ir);
            this.slowAccess = false;
            this.initOverview();
            this.initPlugins();
            this.showStatus("Index successfully open.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg(e.getMessage());
            return;
        }
    }

    public Directory openDirectory(String dirImpl, String file, boolean create) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            throw new Exception("Index directory doesn't exist.");
        }
        Directory res = null;
        if (dirImpl == null || dirImpl.equals(Directory.class.getName()) || dirImpl.equals(FSDirectory.class.getName())) {
            return FSDirectory.open(f);
        }
        try {
            Class<?> implClass = Class.forName(dirImpl);
            Constructor<?> constr = implClass.getConstructor(File.class);
            if (constr != null) {
                res = (Directory)constr.newInstance(f);
            } else {
                constr = implClass.getConstructor(File.class, LockFactory.class);
                res = (Directory)constr.newInstance(f, null);
            }
        }
        catch (Throwable e) {
            this.errorMsg("Invalid directory implementation class: " + dirImpl + " " + e);
            return null;
        }
        if (res != null) {
            return res;
        }
        return FSDirectory.open(f);
    }

    public boolean isSlowAccess() {
        return this.slowAccess;
    }

    public void setSlowAccess(boolean slowAccess) {
        this.slowAccess = slowAccess;
        if (slowAccess) {
            // empty if block
        }
    }

    public void initPlugins() {
        Object pluginsTabs = this.find("pluginsTabs");
        this.removeAll(pluginsTabs);
        for (int i = 0; i < this.plugins.size(); ++i) {
            LukePlugin plugin = this.plugins.get(i);
            this.addPluginTab(pluginsTabs, plugin);
            plugin.setDirectory(this.dir);
            plugin.setReader(this.ir);
            try {
                plugin.init();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showStatus("PLUGIN ERROR: " + e.getMessage());
            }
        }
    }

    private void initOverview() {
        try {
            Map<String, String> userDataMap;
            List<AtomicReaderContext> readers;
            IndexCommit ic;
            this.initSolrTypes();
            this.courier = new Font("Courier", this.getFont().getStyle(), this.getFont().getSize());
            this.lastST = this.find("lastST");
            this.setBoolean(this.find("bReload"), "enabled", true);
            this.setBoolean(this.find("bClose"), "enabled", true);
            this.setBoolean(this.find("bCommit"), "enabled", true);
            Object sTable = this.find("sTable");
            this.removeAll(sTable);
            Object docTable = this.find("docTable");
            this.removeAll(docTable);
            Object cbType = this.find("cbType");
            this.populateAnalyzers(cbType);
            Object pOver = this.find("pOver");
            Object iName = this.find("idx");
            String idxName = this.pName.length() > 40 ? this.pName.substring(0, 10) + "..." + this.pName.substring(this.pName.length() - 27) : this.pName;
            this.setString(iName, "text", idxName + (this.readOnly ? " (R)" : ""));
            iName = this.find(pOver, "iName");
            this.setString(iName, "text", this.pName + (this.readOnly ? " (Read-Only)" : ""));
            Object dirImpl = this.find("dirImpl");
            String implName = "N/A";
            if (this.dir == null) {
                if (this.ir != null) {
                    implName = "N/A (reader is " + this.ir.getClass().getName() + ")";
                }
            } else {
                implName = this.dir.getClass().getName();
            }
            this.setString(dirImpl, "text", implName);
            Object fileSize = this.find("iFileSize");
            long totalFileSize = Util.calcTotalFileSize(this.pName, this.dir);
            this.setString(fileSize, "text", Util.normalizeSize(totalFileSize) + Util.normalizeUnit(totalFileSize));
            Object iFormat = this.find(pOver, "iFormat");
            Object iCaps = this.find(pOver, "iCaps");
            String formatText = "N/A";
            String formatCaps = "N/A";
            if (this.dir != null) {
                IndexGate.FormatDetails formatDetails = IndexGate.getIndexFormat(this.dir);
                formatText = formatDetails.genericName;
                formatCaps = formatDetails.capabilities;
            }
            this.setString(iFormat, "text", formatText);
            this.setString(iCaps, "text", formatCaps);
            if (this.ir == null) {
                return;
            }
            this.idxInfo = new IndexInfo(this.ir, this.pName);
            Object iDocs = this.find(pOver, "iDocs");
            String numdocs = String.valueOf(this.ir.numDocs());
            this.setString(iDocs, "text", numdocs);
            iDocs = this.find("iDocs1");
            this.setString(iDocs, "text", String.valueOf(this.ir.maxDoc() - 1));
            Object iFields = this.find(pOver, "iFields");
            this.fn = this.idxInfo.getFieldNames();
            if (this.fn.size() == 0) {
                this.showStatus("Empty index.");
            }
            this.showFiles(this.dir, null);
            if (this.ir instanceof CompositeReader) {
                this.ar = SlowCompositeReaderWrapper.wrap(this.ir);
            } else if (this.ir instanceof AtomicReader) {
                this.ar = (AtomicReader)this.ir;
            }
            if (this.ar != null) {
                this.infos = this.ar.getFieldInfos();
            }
            this.showCommits();
            final Object fList = this.find(pOver, "fList");
            final Object defFld = this.find("defFld");
            final Object fCombo = this.find("fCombo");
            this.idxFields = this.fn.toArray(new String[this.fn.size()]);
            this.setString(iFields, "text", String.valueOf(this.idxFields.length));
            final Object iTerms = this.find(pOver, "iTerms");
            if (!this.slowAccess) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        Object r = Thinlet.create("row");
                        Object cell = Thinlet.create("cell");
                        Luke.this.add(r, cell);
                        Luke.this.add(fList, r);
                        Luke.this.setBoolean(cell, "enabled", false);
                        Luke.this.setString(cell, "text", "..wait..");
                        try {
                            Luke.this.numTerms = Luke.this.idxInfo.getNumTerms();
                            Luke.this.termCounts = Luke.this.idxInfo.getFieldTermCounts();
                            Luke.this.setString(iTerms, "text", String.valueOf(Luke.this.numTerms));
                            Luke.this.initFieldList(fList, fCombo, defFld);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Luke.this.numTerms = -1;
                            Luke.this.termCounts = Collections.emptyMap();
                            Luke.this.showStatus("ERROR: can't count terms per field");
                            Luke.this.setString(cell, "text", e.getMessage());
                        }
                    }
                };
                t.start();
            } else {
                this.setString(iTerms, "text", "N/A");
                this.initFieldList(fList, fCombo, defFld);
            }
            Object iDel = this.find(pOver, "iDelOpt");
            String sDel = this.ir.hasDeletions() ? "Yes (" + this.ir.numDeletedDocs() + ")" : "No";
            IndexCommit indexCommit = ic = this.ir instanceof DirectoryReader ? ((DirectoryReader)this.ir).getIndexCommit() : null;
            String opt = ic != null ? (ic.getSegmentCount() == 1 ? "Yes" : "No") : "?";
            String sDelOpt = sDel + " / " + opt;
            this.setString(iDel, "text", sDelOpt);
            Object iVer = this.find(pOver, "iVer");
            String verText = "N/A";
            if (ic != null) {
                verText = Long.toHexString(((DirectoryReader)this.ir).getVersion());
            }
            this.setString(iVer, "text", verText);
            Object iTiiDiv = this.find(pOver, "iTiiDiv");
            String divText = "N/A";
            if (this.ir instanceof DirectoryReader && (readers = ((DirectoryReader)this.ir).leaves()).size() > 0 && readers.get(0).reader() instanceof SegmentReader) {
                divText = String.valueOf(((SegmentReader)readers.get(0).reader()).getTermInfosIndexDivisor());
            }
            this.setString(iTiiDiv, "text", divText);
            Object iCommit = this.find(pOver, "iCommit");
            String commitText = "N/A";
            if (ic != null) {
                commitText = ic.getSegmentsFileName() + " (generation=" + ic.getGeneration() + ", segs=" + ic.getSegmentCount() + ")";
            }
            this.setString(iCommit, "text", commitText);
            Object iUser = this.find(pOver, "iUser");
            String userData = null;
            userData = ic != null ? ((userDataMap = ic.getUserData()) != null && !userDataMap.isEmpty() ? userDataMap.toString() : "--") : "(not supported)";
            this.setString(iUser, "text", userData);
            final Object nTerms = this.find("nTerms");
            if (!this.slowAccess) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        Luke.this.actionTopTerms(nTerms);
                    }
                };
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg(e.getMessage());
        }
    }

    private void initFieldList(Object fList, Object fCombo, Object defFld) {
        this.removeAll(fList);
        this.removeAll(fCombo);
        this.removeAll(defFld);
        this.setString(fCombo, "text", this.idxFields[0]);
        this.setString(defFld, "text", this.idxFields[0]);
        NumberFormat intCountFormat = NumberFormat.getIntegerInstance();
        NumberFormat percentFormat = NumberFormat.getNumberInstance();
        intCountFormat.setGroupingUsed(true);
        percentFormat.setMaximumFractionDigits(2);
        String[] idxFieldsCopy = (String[])this.idxFields.clone();
        ValueComparator bvc = new ValueComparator(this.termCounts);
        TreeMap<String, FieldTermCount> termCountsSorted = new TreeMap<String, FieldTermCount>(bvc);
        termCountsSorted.putAll(this.termCounts);
        String[] idxFieldsCopySorted = termCountsSorted.keySet().toArray(new String[idxFieldsCopy.length]);
        this.populateFieldGrid(fList, fCombo, defFld, intCountFormat, percentFormat, idxFieldsCopySorted);
        this.setString(this.find("defFld"), "text", this.idxFields[0]);
        Object header = Luke.get(this.find("sTable"), "header");
        this.removeAll(header);
        Object c = Luke.create("column");
        this.setString(c, "text", "#");
        this.setInteger(c, "width", 40);
        this.add(header, c);
        c = Luke.create("column");
        this.setString(c, "text", "Score");
        this.setInteger(c, "width", 50);
        this.add(header, c);
        c = Luke.create("column");
        this.setString(c, "text", "Doc. Id");
        this.setInteger(c, "width", 60);
        this.add(header, c);
        for (int j = 0; j < this.idxFields.length; ++j) {
            c = Luke.create("column");
            this.setString(c, "text", this.idxFields[j]);
            this.add(header, c);
        }
    }

    private void populateFieldGrid(Object fList, Object fCombo, Object defFld, NumberFormat intCountFormat, NumberFormat percentFormat, String[] idxFieldsCopy) {
        for (String s : idxFieldsCopy) {
            Object row = Luke.create("row");
            this.putProperty(row, "fName", s);
            this.add(fList, row);
            Object cell = Luke.create("cell");
            this.setString(cell, "text", s);
            this.add(row, cell);
            if (this.termCounts != null) {
                cell = Luke.create("cell");
                FieldTermCount ftc = this.termCounts.get(s);
                if (ftc != null) {
                    long cnt = ftc.termCount;
                    this.setString(cell, "text", intCountFormat.format(cnt));
                    this.setChoice(cell, "alignment", "right");
                    this.add(row, cell);
                    float pcent = (float)(cnt * 100L) / (float)this.numTerms;
                    cell = Luke.create("cell");
                    this.setString(cell, "text", percentFormat.format(pcent) + " %");
                    this.setChoice(cell, "alignment", "right");
                    this.add(row, cell);
                } else {
                    this.setString(cell, "text", "0");
                    this.setChoice(cell, "alignment", "right");
                    this.add(row, cell);
                    cell = Luke.create("cell");
                    this.setString(cell, "text", "0.00 %");
                    this.setChoice(cell, "alignment", "right");
                    this.add(row, cell);
                }
            } else {
                cell = Luke.create("cell");
                this.setString(cell, "text", "N/A");
                this.add(row, cell);
                cell = Luke.create("cell");
                this.add(row, cell);
            }
            cell = Luke.create("cell");
            this.setChoice(cell, "alignment", "right");
            Decoder dec = this.decoders.get(s);
            if (dec == null) {
                dec = this.defDecoder;
            }
            this.setString(cell, "text", dec.toString());
            this.add(row, cell);
            Object choice = Luke.create("choice");
            this.add(fCombo, choice);
            this.setString(choice, "text", s);
            this.putProperty(choice, "fName", s);
            choice = Luke.create("choice");
            this.add(defFld, choice);
            this.setString(choice, "text", s);
            this.putProperty(choice, "fName", s);
        }
    }

    private void showCommits() throws Exception {
        Object commitsTable = this.find("commitsTable");
        this.removeAll(commitsTable);
        if (this.dir == null) {
            Object row = Luke.create("row");
            Object cell = Luke.create("cell");
            this.setString(cell, "text", "<not available>");
            this.setBoolean(cell, "enabled", false);
            this.add(row, cell);
            this.add(commitsTable, row);
            return;
        }
        List<IndexCommit> commits = DirectoryReader.listCommits(this.dir);
        IndexCommit current = this.ir instanceof DirectoryReader ? ((DirectoryReader)this.ir).getIndexCommit() : null;
        Iterator<IndexCommit> it = commits.iterator();
        int rowNum = 0;
        while (it.hasNext()) {
            Object[] cells;
            IndexCommit commit = it.next();
            Collection<String> files = commit.getFileNames();
            Iterator<String> itf = files.iterator();
            Object row = Luke.create("row");
            boolean enabled = rowNum < commits.size() - 1;
            Color color = Color.BLUE;
            ++rowNum;
            this.add(commitsTable, row);
            this.putProperty(row, "commit", commit);
            if (enabled) {
                this.putProperty(row, "commitDeletable", Boolean.TRUE);
            }
            Object cell = Luke.create("cell");
            String gen = String.valueOf(commit.getGeneration());
            this.setString(cell, "text", gen);
            this.add(row, cell);
            cell = Luke.create("cell");
            this.setString(cell, "text", commit.isDeleted() ? "Y" : "N");
            this.add(row, cell);
            cell = Luke.create("cell");
            this.setString(cell, "text", String.valueOf(commit.getSegmentCount()));
            this.add(row, cell);
            cell = Luke.create("cell");
            Map<String, String> userData = commit.getUserData();
            if (userData != null && !userData.isEmpty()) {
                this.setString(cell, "text", userData.toString());
            } else {
                this.setString(cell, "text", "");
            }
            this.add(row, cell);
            if (!commit.equals(current)) continue;
            for (Object c : cells = this.getItems(row)) {
                this.setColor(c, "foreground", color);
            }
        }
    }

    public void showSegments(Object commitsTable) throws Exception {
        Object segTable = this.find("segmentsTable");
        this.removeAll(segTable);
        Object[] rows = this.getSelectedItems(commitsTable);
        if (rows == null || rows.length == 0) {
            this.showStatus("No commit point selected.");
            return;
        }
        Object row = rows[0];
        IndexCommit commit = (IndexCommit)this.getProperty(row, "commit");
        if (commit == null) {
            this.showStatus("Can't retrieve commit point (application error)");
            return;
        }
        Object segGen = this.find("segGen");
        this.setString(segGen, "text", commit.getSegmentsFileName() + " (gen " + commit.getGeneration() + ")");
        String segName = commit.getSegmentsFileName();
        SegmentInfos infos = new SegmentInfos();
        try {
            infos.read(this.dir, segName);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg("Error reading segment infos for '" + segName + ": " + e.toString());
            return;
        }
        for (SegmentCommitInfo si : infos.asList()) {
            Object r = Luke.create("row");
            this.add(segTable, r);
            Object cell = Luke.create("cell");
            this.add(r, cell);
            this.setString(cell, "text", si.info.name);
            cell = Luke.create("cell");
            this.add(r, cell);
            this.setString(cell, "text", String.valueOf(si.getDelGen()));
            this.setChoice(cell, "alignment", "right");
            cell = Luke.create("cell");
            this.add(r, cell);
            this.setString(cell, "text", String.valueOf(si.getDelCount()));
            this.setChoice(cell, "alignment", "right");
            cell = Luke.create("cell");
            this.add(r, cell);
            this.setString(cell, "text", String.valueOf(si.info.getDocCount()));
            this.setChoice(cell, "alignment", "right");
            cell = Luke.create("cell");
            this.add(r, cell);
            this.setString(cell, "text", si.info.getVersion().toString());
            cell = Luke.create("cell");
            this.add(r, cell);
            this.setString(cell, "text", si.info.getCodec().getName());
            long size = si.sizeInBytes();
            cell = Luke.create("cell");
            this.add(r, cell);
            this.setString(cell, "text", Util.normalizeSize(size) + Util.normalizeUnit(size));
            this.setChoice(cell, "alignment", "right");
            cell = Luke.create("cell");
            this.add(r, cell);
            this.setString(cell, "text", si.info.getUseCompoundFile() ? "Y" : "N");
            this.putProperty(r, "si", si);
        }
        Object diagsTable = this.find("diagsTable");
        this.removeAll(diagsTable);
    }

    public void showDiagnostics(Object segmentsTable) {
        Object cell;
        Object r;
        Object diagsTable = this.find("diagsTable");
        this.removeAll(diagsTable);
        Object row = this.getSelectedItem(segmentsTable);
        if (row == null) {
            return;
        }
        SegmentCommitInfo si = (SegmentCommitInfo)this.getProperty(row, "si");
        if (si == null) {
            this.showStatus("Missing SegmentInfoPerCommit???");
            return;
        }
        Map<String, String> map = si.info.attributes();
        if (map != null) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                r = Luke.create("row");
                this.add(diagsTable, r);
                cell = Luke.create("cell");
                this.setString(cell, "text", "A");
                this.add(r, cell);
                cell = Luke.create("cell");
                this.setString(cell, "text", e.getKey());
                this.add(r, cell);
                cell = Luke.create("cell");
                this.setString(cell, "text", e.getValue());
                this.add(r, cell);
            }
        }
        if ((map = si.info.getDiagnostics()) != null) {
            for (Map.Entry<String, String> e : map.entrySet()) {
                r = Luke.create("row");
                this.add(diagsTable, r);
                cell = Luke.create("cell");
                this.setString(cell, "text", "D");
                this.add(r, cell);
                cell = Luke.create("cell");
                this.setString(cell, "text", e.getKey());
                this.add(r, cell);
                cell = Luke.create("cell");
                this.setString(cell, "text", e.getValue());
                this.add(r, cell);
            }
        }
        Object r1 = Luke.create("row");
        this.add(diagsTable, r1);
        Object c1 = Luke.create("cell");
        this.setBoolean(c1, "enabled", false);
        this.add(r1, c1);
        Codec codec = si.info.getCodec();
        map = new LinkedHashMap<String, String>();
        map.put("codecName", codec.getName());
        map.put("codecClassName", codec.getClass().getName());
        map.put("docValuesFormat", codec.docValuesFormat().getClass().getName());
        map.put("fieldInfosFormat", codec.fieldInfosFormat().getClass().getName());
        map.put("liveDocsFormat", codec.liveDocsFormat().getClass().getName());
        map.put("normsFormat", codec.normsFormat().getClass().getName());
        map.put("postingsFormat", codec.postingsFormat().toString() + " " + codec.postingsFormat().getClass().getName());
        map.put("segmentInfoFormat", codec.segmentInfoFormat().getClass().getName());
        map.put("storedFieldsFormat", codec.storedFieldsFormat().getClass().getName());
        map.put("termVectorsFormat", codec.termVectorsFormat().getClass().getName());
        try {
            ArrayList<String> files = new ArrayList<String>(si.files());
            Collections.sort(files);
            map.put("---files---", ((Object)files).toString());
            if (si.info.getUseCompoundFile()) {
                CompoundFileDirectory d = new CompoundFileDirectory(this.dir, IndexFileNames.segmentFileName(si.info.name, "", "cfs"), IOContext.READ, false);
                files.clear();
                files.addAll(Arrays.asList(((Directory)d).listAll()));
                ((Directory)d).close();
                Collections.sort(files);
                map.put("-CFS-files-", ((Object)files).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            map.put("---files---", "Exception: " + e.toString());
        }
        for (Map.Entry<String, String> e : map.entrySet()) {
            Object r2 = Luke.create("row");
            this.add(diagsTable, r2);
            Object cell2 = Luke.create("cell");
            this.setString(cell2, "text", "C");
            this.add(r2, cell2);
            cell2 = Luke.create("cell");
            this.setString(cell2, "text", e.getKey());
            this.add(r2, cell2);
            cell2 = Luke.create("cell");
            this.setString(cell2, "text", e.getValue());
            this.add(r2, cell2);
        }
        try {
            FieldInfo fi;
            SegmentReader sr = new SegmentReader(si, 1, IOContext.READ);
            FieldInfos fis = sr.getFieldInfos();
            map = new LinkedHashMap<String, String>();
            ArrayList<String> flds = new ArrayList<String>(fis.size());
            for (FieldInfo fieldInfo : fis) {
                flds.add(fieldInfo.name);
            }
            Collections.sort(flds);
            map.put("L---fields---", ((Object)flds).toString());
            for (String string : flds) {
                fi = fis.fieldInfo(string);
                map.put("A" + fi.name, fi.attributes().toString());
            }
            map.put("F---flags----", "IdfpoPVNtxxDtxx");
            for (String string : flds) {
                fi = fis.fieldInfo(string);
                map.put("F" + fi.name, Util.fieldFlags(null, fi));
            }
            sr.close();
            r1 = Luke.create("row");
            this.add(diagsTable, r1);
            c1 = Luke.create("cell");
            this.setBoolean(c1, "enabled", false);
            this.add(r1, c1);
            for (Map.Entry entry : map.entrySet()) {
                Object r3 = Luke.create("row");
                this.add(diagsTable, r3);
                Object cell3 = Luke.create("cell");
                this.setString(cell3, "text", "F" + ((String)entry.getKey()).charAt(0));
                this.add(r3, cell3);
                cell3 = Luke.create("cell");
                this.setString(cell3, "text", ((String)entry.getKey()).substring(1));
                this.add(r3, cell3);
                cell3 = Luke.create("cell");
                this.setString(cell3, "text", (String)entry.getValue());
                if (((String)entry.getKey()).startsWith("F")) {
                    this.setFont(cell3, this.courier);
                }
                this.add(r3, cell3);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void openCommit(Object commitsTable) throws IOException {
        IndexCommit current;
        Object row = this.getSelectedItem(commitsTable);
        if (row == null) {
            this.showStatus("No commit point selected.");
            return;
        }
        IndexCommit commit = (IndexCommit)this.getProperty(row, "commit");
        if (commit == null) {
            this.showStatus("Can't retrieve commit point (application error)");
            return;
        }
        IndexCommit indexCommit = current = this.ir instanceof DirectoryReader ? ((DirectoryReader)this.ir).getIndexCommit() : null;
        if (commit.equals(current)) {
            this.showStatus("Already open at this commit point.");
            return;
        }
        this.ir.close();
        if (this.keepCommits) {
            KeepAllIndexDeletionPolicy policy = new KeepAllIndexDeletionPolicy();
        } else {
            KeepLastIndexDeletionPolicy policy = new KeepLastIndexDeletionPolicy();
        }
        this.ir = DirectoryReader.open(commit);
        this.initOverview();
    }

    public void showCommitFiles(Object commitTable) throws Exception {
        ArrayList<IndexCommit> commits = new ArrayList<IndexCommit>();
        Object[] rows = this.getSelectedItems(commitTable);
        if (rows == null || rows.length == 0) {
            this.showFiles(this.dir, commits);
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            IndexCommit commit = (IndexCommit)this.getProperty(rows[i], "commit");
            if (commit == null) continue;
            commits.add(commit);
        }
        this.showFiles(this.dir, commits);
        this.showSegments(commitTable);
    }

    private void showFiles(Directory dir, List<IndexCommit> commits) throws Exception {
        Object filesTable = this.find("filesTable");
        if (dir == null) {
            this.removeAll(filesTable);
            Object row = Luke.create("row");
            Object cell = Luke.create("cell");
            this.setString(cell, "text", "<not available>");
            this.setBoolean(cell, "enabled", false);
            this.add(row, cell);
            this.add(filesTable, row);
            return;
        }
        Object iFileSize = this.find("iFileSize");
        long totalSize = 0L;
        String[] physFiles = dir.listAll();
        HashSet<String> files = new HashSet<String>();
        if (commits != null && commits.size() > 0) {
            for (int i = 0; i < commits.size(); ++i) {
                IndexCommit commit = commits.get(i);
                files.addAll(commit.getFileNames());
            }
        } else {
            files.addAll(Arrays.asList(physFiles));
        }
        ArrayList uFiles = new ArrayList(files);
        Collections.sort(uFiles);
        List<String> segs = this.getIndexFileNames(dir);
        List<String> dels = this.getIndexDeletableNames(dir);
        Font courier2 = this.courier.deriveFont((float)this.courier.getSize() * 1.1f);
        this.removeAll(filesTable);
        for (int i = 0; i < uFiles.size(); ++i) {
            String fileName = (String)uFiles.get(i);
            String pathName = this.pName.endsWith(File.separator) ? this.pName : this.pName + File.separator;
            File file = new File(pathName + fileName);
            boolean deletable = dels.contains(fileName.intern());
            String inuse = this.getFileFunction(fileName);
            Object row = Luke.create("row");
            Object nameCell = Luke.create("cell");
            this.setString(nameCell, "text", fileName);
            this.setString(nameCell, "tooltip", inuse);
            this.add(row, nameCell);
            Object sizeCell = Luke.create("cell");
            long length = file.length();
            totalSize += length;
            this.setString(sizeCell, "text", Util.normalizeSize(length) + Util.normalizeUnit(length));
            this.setChoice(sizeCell, "alignment", "right");
            this.setFont(sizeCell, courier2);
            this.add(row, sizeCell);
            Object delCell = Luke.create("cell");
            this.setString(delCell, "text", deletable ? "YES" : "-");
            this.add(row, delCell);
            Object inuseCell = Luke.create("cell");
            this.setString(inuseCell, "text", inuse);
            this.add(row, inuseCell);
            this.add(filesTable, row);
        }
        this.setString(iFileSize, "text", Util.normalizeSize(totalSize) + Util.normalizeUnit(totalSize));
    }

    private String getFileFunction(String file) {
        String res = IndexGate.getFileFunction(file);
        if (res == null) {
            res = "YES";
        }
        return res;
    }

    private void syncMRU(Object path) {
        this.removeAll(path);
        for (String element : Prefs.getMruList()) {
            Object choice = Luke.create("choice");
            this.setString(choice, "text", element);
            this.add(path, choice);
        }
    }

    public void actionTopTerms(Object nTerms) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        String sndoc = this.getString(nTerms, "text");
        int nd = 50;
        try {
            nd = Integer.parseInt(sndoc);
        }
        catch (Exception e) {
            // empty catch block
        }
        final int ndoc = nd;
        Object[] fields = this.getSelectedItems(this.find("fList"));
        String[] flds = null;
        if (fields == null || fields.length == 0) {
            flds = this.idxFields;
        } else {
            flds = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                flds[i] = (String)this.getProperty(fields[i], "fName");
            }
        }
        final String[] fflds = flds;
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    TermStats[] topTerms = HighFreqTerms.getHighFreqTerms(Luke.this.ir, ndoc, fflds);
                    Object table = Luke.this.find("tTable");
                    Luke.this.removeAll(table);
                    if (topTerms == null || topTerms.length == 0) {
                        Object row = Thinlet.create("row");
                        Object cell = Thinlet.create("cell");
                        Luke.this.add(row, cell);
                        cell = Thinlet.create("cell");
                        Luke.this.add(row, cell);
                        cell = Thinlet.create("cell");
                        Luke.this.add(row, cell);
                        cell = Thinlet.create("cell");
                        Luke.this.setBoolean(cell, "enabled", false);
                        Luke.this.setString(cell, "text", "No Results");
                        Luke.this.add(row, cell);
                        Luke.this.add(table, row);
                        return;
                    }
                    for (int i = 0; i < topTerms.length; ++i) {
                        String s;
                        Object row = Thinlet.create("row");
                        Luke.this.add(table, row);
                        Luke.this.putProperty(row, "term", new Term(topTerms[i].field, topTerms[i].termtext));
                        Luke.this.putProperty(row, "ti", topTerms[i]);
                        Object cell = Thinlet.create("cell");
                        Luke.this.setChoice(cell, "alignment", "right");
                        Luke.this.setString(cell, "text", String.valueOf(i + 1));
                        Luke.this.add(row, cell);
                        cell = Thinlet.create("cell");
                        Luke.this.setChoice(cell, "alignment", "right");
                        Luke.this.setString(cell, "text", String.valueOf(topTerms[i].docFreq) + "  ");
                        Luke.this.add(row, cell);
                        cell = Thinlet.create("cell");
                        Luke.this.setString(cell, "text", topTerms[i].field);
                        Luke.this.add(row, cell);
                        cell = Thinlet.create("cell");
                        Decoder dec = (Decoder)Luke.this.decoders.get(topTerms[i].field);
                        if (dec == null) {
                            dec = Luke.this.defDecoder;
                        }
                        try {
                            s = dec.decodeTerm(topTerms[i].field, topTerms[i].termtext.utf8ToString());
                        }
                        catch (Throwable e) {
                            s = topTerms[i].termtext.utf8ToString();
                            Luke.this.setColor(cell, "foreground", Color.RED);
                        }
                        Luke.this.setString(cell, "text", "  " + s);
                        Luke.this.add(row, cell);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.errorMsg(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void clipTopTerms(Object tTable) {
        Object[] rows = this.getItems(tTable);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rows.length; ++i) {
            TermStats ti = (TermStats)this.getProperty(rows[i], "ti");
            if (ti == null) continue;
            sb.append(ti.docFreq + "\t" + ti.field + "\t" + ti.termtext.utf8ToString() + "\n");
        }
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    public void browseTermDocs(Object tTable) {
        Object row = this.getSelectedItem(tTable);
        if (row == null) {
            return;
        }
        Term t = (Term)this.getProperty(row, "term");
        if (t == null) {
            return;
        }
        Object tabpane = this.find("maintpane");
        this.setInteger(tabpane, "selected", 1);
        this._showTerm(this.find("fCombo"), this.find("fText"), t);
        this.showFirstTermDoc(this.find("fText"));
        this.repaint();
    }

    public void showTermDocs(Object tTable) {
        Object row = this.getSelectedItem(tTable);
        if (row == null) {
            return;
        }
        Term t = (Term)this.getProperty(row, "term");
        if (t == null) {
            return;
        }
        Object tabpane = this.find("maintpane");
        this.setInteger(tabpane, "selected", 2);
        Object qField = this.find("qField");
        this.setString(qField, "text", t.field() + ":" + t.text());
        this.search(qField);
        this.repaint();
    }

    public void actionUndelete() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        if (!(this.ir instanceof DirectoryReader)) {
            this.showStatus("Not possible with " + this.ir.getClass().getSimpleName());
            return;
        }
        this.errorMsg("Not supported in Lucene 4 API");
    }

    public void actionConvert(Object method) {
    }

    public List<String> getIndexDeletableNames(Directory d) {
        if (d == null) {
            return null;
        }
        List deletable = null;
        try {
            deletable = IndexGate.getDeletableFiles(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (deletable == null) {
            deletable = Collections.EMPTY_LIST;
        }
        return deletable;
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public IndexReader getIndexReader() {
        return this.ir;
    }

    public void setIndexReader(IndexReader reader, String indexName) {
        if (reader == null) {
            return;
        }
        try {
            if (this.is != null) {
                this.is = null;
            }
            if (this.ir != null) {
                this.ir.close();
                this.ir = null;
            }
            if (this.ar != null) {
                this.ar.close();
                this.ar = null;
            }
            if (this.dir != null) {
                this.dir.close();
                this.dir = null;
            }
            this.dir = reader instanceof DirectoryReader ? ((DirectoryReader)reader).directory() : null;
            this.ir = reader;
            this.is = new IndexSearcher(this.ir);
            this.pName = indexName;
            this.initOverview();
            this.initPlugins();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg("Setting new IndexReader failed: " + e.toString());
        }
    }

    public List<String> getIndexFileNames(Directory d) {
        if (d == null) {
            return null;
        }
        List<String> names = null;
        try {
            names = IndexGate.getIndexFiles(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return names;
    }

    public void actionCheckIndex() {
        if (this.dir == null) {
            this.errorMsg("No directory - open index directory first (you may use the 'no IndexReader' option).");
            return;
        }
        Object dialog = this.addComponent(null, "/xml/checkindex.xml", null, null);
        Object dirName = this.find(dialog, "dirName");
        this.setString(dirName, "text", this.pName);
        this.add(dialog);
    }

    public void checkIndex(final Object dialog) {
        Thread t = new Thread(){

            @Override
            public void run() {
                Object panel = Luke.this.find(dialog, "msg");
                Object fixPanel = Luke.this.find(dialog, "fixPanel");
                PanelPrintWriter ppw = new PanelPrintWriter(Luke.this, panel);
                Object ckRes = Luke.this.find(dialog, "ckRes");
                CheckIndex.Status status = null;
                CheckIndex ci = new CheckIndex(Luke.this.dir);
                ci.setInfoStream(ppw);
                Luke.this.putProperty(dialog, "checkIndex", ci);
                Luke.this.putProperty(dialog, "ppw", ppw);
                try {
                    status = ci.checkIndex();
                }
                catch (Exception e) {
                    ppw.println("ERROR: caught exception, giving up.\n\n");
                    e.printStackTrace();
                    e.printStackTrace(ppw);
                }
                if (status != null) {
                    String statMsg;
                    Luke.this.putProperty(dialog, "checkStatus", status);
                    if (status.clean) {
                        statMsg = "OK";
                    } else if (status.toolOutOfDate) {
                        statMsg = "ERROR: Can't check - tool out-of-date";
                    } else {
                        Luke.this.setBoolean(fixPanel, "visible", true);
                        Luke.this.repaint(dialog);
                        statMsg = "BAD: ";
                        if (status.cantOpenSegments) {
                            statMsg = statMsg + "cantOpenSegments ";
                        }
                        if (status.missingSegments) {
                            statMsg = statMsg + "missingSegments ";
                        }
                        if (status.missingSegmentVersion) {
                            statMsg = statMsg + "missingSegVersion ";
                        }
                        if (status.numBadSegments > 0) {
                            statMsg = statMsg + "numBadSegments=" + status.numBadSegments + " ";
                        }
                        if (status.totLoseDocCount > 0) {
                            statMsg = statMsg + "lostDocCount=" + status.totLoseDocCount + " ";
                        }
                    }
                    Luke.this.setString(ckRes, "text", statMsg);
                }
            }
        };
        t.start();
    }

    public void fixIndex(final Object dialog) {
        Thread t = new Thread(){

            @Override
            public void run() {
                CheckIndex ci = (CheckIndex)Luke.this.getProperty(dialog, "checkIndex");
                if (ci == null) {
                    Luke.this.errorMsg("You need to run 'Check Index' first.");
                    return;
                }
                CheckIndex.Status status = (CheckIndex.Status)Luke.this.getProperty(dialog, "checkStatus");
                if (status == null) {
                    Luke.this.errorMsg("You need to run 'Check Index' first.");
                    return;
                }
                Object fixRes = Luke.this.find(dialog, "fixRes");
                PanelPrintWriter ppw = (PanelPrintWriter)Luke.this.getProperty(dialog, "ppw");
                try {
                    ci.fixIndex(status);
                    Luke.this.setString(fixRes, "text", "DONE. Review the output above.");
                }
                catch (Exception e) {
                    ppw.println("\nERROR during Fix Index:");
                    e.printStackTrace(ppw);
                    Luke.this.setString(fixRes, "text", "FAILED. Review the output above.");
                }
            }
        };
        t.start();
    }

    public boolean isFSBased(Directory dir) {
        if (dir == null) {
            return false;
        }
        return dir instanceof MMapDirectory || dir instanceof NIOFSDirectory || dir instanceof FSDirectory;
    }

    public void actionCleanup() {
        if (this.dir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        try {
            ArrayList<String> allFiles;
            boolean phys = false;
            if (this.isFSBased(this.dir)) {
                File phyDir = new File(this.pName);
                phys = true;
                allFiles = new ArrayList<String>(Arrays.asList(phyDir.list()));
            } else {
                allFiles = new ArrayList<String>(Arrays.asList(this.dir.listAll()));
            }
            List<String> indexFiles = this.getIndexFileNames(this.dir);
            allFiles.removeAll(indexFiles);
            if (allFiles.size() == 0) {
                this.infoMsg("There are no files to be cleaned - target directory contains only index-related files.");
                return;
            }
            Object dialog = this.addComponent(null, "/xml/cleanup.xml", null, null);
            Object filesTable = this.find(dialog, "filesTable");
            for (int i = 0; i < allFiles.size(); ++i) {
                String fileName = (String)allFiles.get(i);
                Object row = Luke.create("row");
                this.add(filesTable, row);
                this.putProperty(row, "fileName", fileName);
                long size = this.dir.fileLength(fileName);
                Object cell = Luke.create("cell");
                this.setString(cell, "text", Util.normalizeSize(size));
                this.add(row, cell);
                cell = Luke.create("cell");
                this.setString(cell, "text", Util.normalizeUnit(size));
                this.add(row, cell);
                cell = Luke.create("cell");
                this.setString(cell, "text", fileName);
                this.add(row, cell);
            }
            this.add(dialog);
        }
        catch (Exception e) {
            this.errorMsg("Error: " + e.toString());
        }
    }

    public void toggleKeep(Object filesTable) {
        Object[] rows = this.getSelectedItems(filesTable);
        if (rows == null || rows.length == 0) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            Boolean Deletable = (Boolean)this.getProperty(rows[i], "deletable");
            boolean deletable = Deletable != null ? Deletable : true;
            deletable = !deletable;
            this.putProperty(rows[i], "deletable", deletable);
            Object[] cells = this.getItems(rows[i]);
            for (int k = 0; k < cells.length; ++k) {
                if (!deletable) {
                    this.setBoolean(cells[k], "enabled", false);
                    continue;
                }
                this.setBoolean(cells[k], "enabled", true);
            }
        }
        this.repaint(filesTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _actionCleanup(Object filesTable) {
        try {
            if (this.is != null) {
                this.is = null;
            }
            if (this.ir != null) {
                this.ir.close();
            }
            if (this.ar != null) {
                this.ar.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> noDel = new ArrayList<String>();
        String errMsg = null;
        boolean phys = this.isFSBased(this.dir);
        int deleted = 0;
        try {
            Object[] rows = this.getItems(filesTable);
            for (int i = 0; i < rows.length; ++i) {
                boolean deletable;
                String name = (String)this.getProperty(rows[i], "fileName");
                Boolean Deletable = (Boolean)this.getProperty(rows[i], "deletable");
                boolean bl = deletable = Deletable != null ? Deletable : true;
                if (!deletable) continue;
                if (phys) {
                    File f = new File(this.pName, name);
                    if (!this.removeFile(f)) {
                        noDel.add(name);
                    }
                    ++deleted;
                    continue;
                }
                this.dir.deleteFile(name);
                ++deleted;
            }
            if (noDel.size() > 0) {
                StringBuffer msg = new StringBuffer("Some files could not be deleted:");
                for (int i = 0; i < noDel.size(); ++i) {
                    msg.append("\n" + noDel.get(i));
                }
                errMsg = msg.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errMsg = "FAILED: " + e.getMessage();
        }
        finally {
            try {
                this.actionReopen();
            }
            catch (Exception e) {
                e.printStackTrace();
                errMsg = "FAILED: " + e.getMessage();
            }
        }
        if (errMsg != null) {
            this.errorMsg(errMsg);
        } else if (deleted == 0) {
            this.infoMsg("No files were deleted.");
        }
    }

    public boolean removeFile(File f) {
        System.out.println("remove " + f);
        if (!f.isDirectory()) {
            return f.delete();
        }
        File[] files = f.listFiles();
        boolean res = true;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                res = res && this.removeFile(files[i]);
            }
        }
        res = res && f.delete();
        return res;
    }

    public void actionExport() {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Object dialog = this.addComponent(this, "/xml/export.xml", null, null);
    }

    public void export(Object dialog) {
        String rs;
        File out;
        Object ckOver = this.find(dialog, "ckOver");
        Object ckGzip = this.find(dialog, "ckGzip");
        Object path = this.find(dialog, "path");
        Object ckRanges = this.find(dialog, "ckRanges");
        Object list = this.find(dialog, "ranges");
        String fileName = this.getString(path, "text");
        if ((fileName = fileName.trim()).length() == 0) {
            this.errorMsg("No output file set.");
            return;
        }
        boolean over = this.getBoolean(ckOver, "selected");
        boolean gzip = this.getBoolean(ckGzip, "selected");
        if (gzip && !fileName.endsWith(".gz")) {
            fileName = fileName + ".gz";
            this.setString(path, "text", fileName);
        }
        if ((out = new File(fileName)).exists()) {
            if (out.isDirectory()) {
                this.errorMsg("Output already exists and is a directory.");
                return;
            }
            if (!over) {
                this.errorMsg("Output already exists.");
                return;
            }
        }
        Ranges ranges = null;
        if (this.getBoolean(ckRanges, "selected") && (rs = this.getString(list, "text")).trim().length() > 0) {
            try {
                ranges = Ranges.parse(rs);
            }
            catch (Exception e) {
                this.errorMsg(e.toString());
                return;
            }
        }
        final Object progressBar = this.find(dialog, "bar");
        final Object counter = this.find(dialog, "counter");
        final Object msg = this.find(dialog, "msg");
        Observer obs = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ProgressNotification pn = (ProgressNotification)arg;
                Luke.this.setInteger(progressBar, "minimum", pn.minValue);
                Luke.this.setInteger(progressBar, "maximum", pn.maxValue);
                Luke.this.setInteger(progressBar, "value", pn.curValue);
                Luke.this.setString(msg, "text", pn.message);
                if (!pn.aborted) {
                    Luke.this.setString(counter, "text", pn.curValue + " of " + pn.maxValue + " done.");
                } else {
                    Luke.this.setString(counter, "text", "ABORTED at " + pn.curValue + " of " + pn.maxValue);
                }
            }
        };
        this.setBoolean(this.find(dialog, "startButton"), "visible", false);
        this.setBoolean(this.find(dialog, "abortButton"), "visible", true);
        this.setBoolean(this.find(dialog, "closeButton"), "enabled", false);
        try {
            this._runExport(out, gzip, obs, dialog, ranges);
        }
        catch (IOException ioe) {
            this.errorMsg("Export failed: " + ioe.toString());
        }
    }

    public void _runExport(final File out, final boolean gzip, Observer obs, final Object dialog, final Ranges ranges) throws IOException {
        this.exporter = new XMLExporter(this.ir, this.pName, this.decoders);
        this.exporter.addObserver(obs);
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputStream os = null;
                try {
                    os = new FileOutputStream(out);
                    if (gzip) {
                        os = new GZIPOutputStream(os);
                    }
                    Luke.this.exporter.export(os, true, true, true, "index", ranges);
                    Luke.this.exporter = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.errorMsg("ERROR occurred, file may be incomplete: " + e.toString());
                }
                finally {
                    Luke.this.setBoolean(Luke.this.find(dialog, "startButton"), "visible", true);
                    Luke.this.setBoolean(Luke.this.find(dialog, "abortButton"), "visible", false);
                    Luke.this.setBoolean(Luke.this.find(dialog, "closeButton"), "enabled", true);
                    if (os != null) {
                        try {
                            os.flush();
                            os.close();
                        }
                        catch (Exception e) {
                            Luke.this.errorMsg("ERROR closing output, file may be incomplete: " + e.toString());
                        }
                    }
                }
            }
        };
        t.start();
    }

    public void abortExport(Object dialog) {
        if (this.exporter != null && this.exporter.isRunning()) {
            this.exporter.abort();
        }
    }

    public void actionOptimize() {
        if (this.dir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        Object dialog = this.addComponent(null, "/xml/optimize.xml", null, null);
        this.setString(this.find(dialog, "dirName"), "text", this.pName);
        this.add(dialog);
    }

    public void optimize(final Object dialog) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IndexWriter iw = null;
                Object optimizeButton = Luke.this.find(dialog, "optimizeButton");
                Luke.this.setBoolean(optimizeButton, "enabled", false);
                Object closeButton = Luke.this.find(dialog, "closeButton");
                Luke.this.setBoolean(closeButton, "enabled", false);
                Object msg = Luke.this.find(dialog, "msg");
                Object stat = Luke.this.find(dialog, "stat");
                Luke.this.setString(stat, "text", "Running ...");
                PanelPrintWriter ppw = new PanelPrintWriter(Luke.this, msg);
                boolean useCompound = Luke.this.getBoolean(Luke.this.find(dialog, "optCompound"), "selected");
                boolean expunge = Luke.this.getBoolean(Luke.this.find(dialog, "optExpunge"), "selected");
                boolean keep = Luke.this.getBoolean(Luke.this.find(dialog, "optKeepAll"), "selected");
                boolean useLast = Luke.this.getBoolean(Luke.this.find(dialog, "optLastCommit"), "selected");
                Object tiiSpin = Luke.this.find(dialog, "tii");
                Object segnumSpin = Luke.this.find(dialog, "segnum");
                int tii = Integer.parseInt(Luke.this.getString(tiiSpin, "text"));
                int segnum = Integer.parseInt(Luke.this.getString(segnumSpin, "text"));
                try {
                    IndexCommit ic;
                    if (Luke.this.is != null) {
                        Luke.this.is = null;
                    }
                    if (Luke.this.ir != null) {
                        Luke.this.ir.close();
                    }
                    if (Luke.this.ar != null) {
                        Luke.this.ar.close();
                    }
                    IndexDeletionPolicy policy = keep ? new KeepAllIndexDeletionPolicy() : new KeepLastIndexDeletionPolicy();
                    IndexWriterConfig cfg = new IndexWriterConfig(LV, new WhitespaceAnalyzer(LV));
                    if (!useLast && (ic = ((DirectoryReader)Luke.this.ir).getIndexCommit()) != null) {
                        cfg.setIndexCommit(ic);
                    }
                    cfg.setIndexDeletionPolicy(policy);
                    cfg.setTermIndexInterval(tii);
                    cfg.setUseCompoundFile(useCompound);
                    cfg.setInfoStream(ppw);
                    iw = new IndexWriter(Luke.this.dir, cfg);
                    long startSize = Util.calcTotalFileSize(Luke.this.pName, Luke.this.dir);
                    long startTime = System.currentTimeMillis();
                    if (expunge) {
                        iw.forceMergeDeletes();
                    } else if (segnum > 1) {
                        iw.forceMerge(segnum, true);
                    } else {
                        iw.forceMerge(1, true);
                    }
                    iw.commit();
                    long endTime = System.currentTimeMillis();
                    long endSize = Util.calcTotalFileSize(Luke.this.pName, Luke.this.dir);
                    long deltaSize = startSize - endSize;
                    String sign = deltaSize < 0L ? " Increased " : " Reduced ";
                    String sizeMsg = sign + Util.normalizeSize(Math.abs(deltaSize)) + Util.normalizeUnit(Math.abs(deltaSize));
                    String timeMsg = String.valueOf(endTime - startTime) + " ms";
                    Luke.this.showStatus(sizeMsg + " in " + timeMsg);
                    iw.close();
                    Luke.this.setString(stat, "text", "Finished OK.");
                }
                catch (Exception e) {
                    e.printStackTrace(ppw);
                    Luke.this.setString(stat, "text", "ERROR - aborted.");
                    Luke.this.errorMsg("ERROR optimizing: " + e.toString());
                    if (iw != null) {
                        try {
                            iw.close();
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    Luke.this.setBoolean(closeButton, "enabled", true);
                }
                try {
                    Luke.this.actionReopen();
                    Luke.this.is = new IndexSearcher(Luke.this.ir);
                    Luke.this.add(dialog);
                }
                catch (Exception e) {
                    e.printStackTrace(ppw);
                    Luke.this.errorMsg("ERROR reopening after optimize:\n" + e.getMessage());
                }
            }
        };
        t.start();
    }

    public void showPrevDoc(Object docNum) {
        this._showDoc(docNum, -1);
    }

    public void showNextDoc(Object docNum) {
        this._showDoc(docNum, 1);
    }

    public void showDoc(Object docNum) {
        this._showDoc(docNum, 0);
    }

    private void _showDoc(Object docNum, int incr) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        String num = this.getString(docNum, "text");
        if (num.trim().equals("")) {
            num = String.valueOf(-incr);
        }
        try {
            this.iNum = Integer.parseInt(num);
            this.iNum += incr;
            if (this.iNum < 0 || this.iNum >= this.ir.maxDoc()) {
                this.showStatus("Document number outside valid range.");
                return;
            }
            this.setString(docNum, "text", String.valueOf(this.iNum));
            Bits live = this.ar.getLiveDocs();
            if (live == null || live.get(this.iNum)) {
                SlowThread st = new SlowThread(this){

                    @Override
                    public void execute() {
                        try {
                            Luke.this.doc = Luke.this.ir.document(Luke.this.iNum);
                            Luke.this._showDocFields(Luke.this.iNum, Luke.this.doc);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Luke.this.showStatus(e.getMessage());
                        }
                    }
                };
                if (this.slowAccess) {
                    st.start();
                } else {
                    st.execute();
                }
            } else {
                this.showStatus("Deleted document - not available.");
                this._showDocFields(this.iNum, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    public void actionAddDocument(Object docTable) {
        if (this.ir == null) {
            this.errorMsg(MSG_NOINDEX);
            return;
        }
        Object dialog = this.addComponent(null, "/xml/editdoc.xml", null, null);
        this.remove(this.find(dialog, "bDelAdd"));
        Object cbAnalyzers = this.find(dialog, "cbAnalyzers");
        this.populateAnalyzers(cbAnalyzers);
        this.setInteger(cbAnalyzers, "selected", 0);
        this.add(dialog);
    }

    public void actionReconstruct(Object docNumText) {
        final int[] nums = new int[1];
        try {
            String numString = this.getString(docNumText, "text");
            nums[0] = Integer.parseInt(numString);
        }
        catch (Exception e) {
            this.showStatus("ERROR: no valid document selected");
            return;
        }
        final Progress progress = new Progress(this);
        progress.setMessage("Reconstructing ...");
        progress.show();
        Thread thr = new Thread(){

            @Override
            public void run() {
                try {
                    int docNum = nums[0];
                    DocReconstructor recon = new DocReconstructor(Luke.this.ir, Luke.this.idxFields, Luke.this.numTerms);
                    recon.addObserver(progress);
                    DocReconstructor.Reconstructed doc = recon.reconstruct(docNum);
                    Object dialog = Luke.this.addComponent(null, "/xml/editdoc.xml", null, null);
                    Luke.this.putProperty(dialog, "docNum", new Integer(docNum));
                    Object cbAnalyzers = Luke.this.find(dialog, "cbAnalyzers");
                    Luke.this.populateAnalyzers(cbAnalyzers);
                    Luke.this.setInteger(cbAnalyzers, "selected", 0);
                    Object editTabs = Luke.this.find(dialog, "editTabs");
                    Luke.this.setString(Luke.this.find(dialog, "docNum"), "text", "Fields of Doc #: " + docNum);
                    for (int p = 0; p < Luke.this.idxFields.length; ++p) {
                        String key = Luke.this.idxFields[p];
                        if (!doc.hasField(key)) continue;
                        IndexableField[] fields = doc.getStoredFields().get(key);
                        GrowableStringArray recField = doc.getReconstructedFields().get(key);
                        int count = 0;
                        if (recField != null) {
                            count = 1;
                        }
                        if (fields != null && fields.length > count) {
                            count = fields.length;
                        }
                        for (int i = 0; i < count; ++i) {
                            if (i > 0) {
                                recField = null;
                            }
                            Object tab = Thinlet.create("tab");
                            Luke.this.setString(tab, "text", key);
                            Luke.this.setFont(tab, Luke.this.getFont().deriveFont(1));
                            Luke.this.add(editTabs, tab);
                            Object editfield = Luke.this.addComponent(tab, "/xml/editfield.xml", null, null);
                            Object fType = Luke.this.find(editfield, "fType");
                            Object sText = Luke.this.find(editfield, "sText");
                            Object rText = Luke.this.find(editfield, "rText");
                            Object fBoost = Luke.this.find(editfield, "fBoost");
                            Object cbStored = Luke.this.find(editfield, "cbStored");
                            Object cbBin = Luke.this.find(editfield, "cbBin");
                            Object cbIndexed = Luke.this.find(editfield, "cbIndexed");
                            Object cbTokenized = Luke.this.find(editfield, "cbTokenized");
                            Object cbTVF = Luke.this.find(editfield, "cbTVF");
                            Object cbTVFp = Luke.this.find(editfield, "cbTVFp");
                            Object cbTVFo = Luke.this.find(editfield, "cbTVFo");
                            Object cbONorms = Luke.this.find(editfield, "cbONorms");
                            Object cbOTF = Luke.this.find(editfield, "cbOTF");
                            Object stored = Luke.this.find(editfield, "stored");
                            Object restored = Luke.this.find(editfield, "restored");
                            if (Luke.this.ar != null) {
                                Luke.this.setBoolean(cbONorms, "selected", Luke.this.ar.getNormValues(key) != null);
                            }
                            org.apache.lucene.document.Field f = null;
                            if (fields != null && fields.length > i) {
                                String text;
                                f = (org.apache.lucene.document.Field)fields[i];
                                Luke.this.setString(fType, "text", "Original stored field content");
                                if (f.binaryValue() != null) {
                                    text = Util.bytesToHex(f.binaryValue(), true);
                                    Luke.this.setBoolean(cbBin, "selected", true);
                                } else {
                                    text = f.stringValue();
                                }
                                Luke.this.setString(sText, "text", text);
                                Luke.this.setString(fBoost, "text", String.valueOf(f.boost()));
                                FieldType t = f.fieldType();
                                Luke.this.setBoolean(cbStored, "selected", t.stored());
                                Luke.this.setBoolean(cbIndexed, "selected", t.indexed());
                                Luke.this.setBoolean(cbTokenized, "selected", t.tokenized());
                                Luke.this.setBoolean(cbTVF, "selected", t.storeTermVectors());
                                Luke.this.setBoolean(cbTVFp, "selected", t.storeTermVectorPositions());
                                Luke.this.setBoolean(cbTVFo, "selected", t.storeTermVectorOffsets());
                            } else {
                                Luke.this.remove(stored);
                            }
                            if (recField != null) {
                                String sep = " ";
                                if (f == null) {
                                    Luke.this.setString(fType, "text", "RESTORED content ONLY - check for errors!");
                                    Luke.this.setColor(fType, "foreground", Color.red);
                                } else {
                                    Luke.this.setBoolean(rText, "editable", false);
                                    Luke.this.setBoolean(rText, "border", false);
                                    Luke.this.setString(restored, "text", "Tokenized (from all '" + key + "' fields)");
                                    sep = ", ";
                                }
                                Luke.this.setBoolean(cbIndexed, "selected", true);
                                Luke.this.setString(fBoost, "text", String.valueOf(1.0f));
                                Luke.this.setString(rText, "text", recField.toString(sep));
                                continue;
                            }
                            Luke.this.remove(restored);
                        }
                    }
                    Luke.this.add(dialog);
                    Luke.this.getPreferredSize(editTabs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
                progress.hide();
            }
        };
        thr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean actionEditAdd(Object editdoc) {
        Document doc = new Document();
        Object cbAnalyzers = this.find(editdoc, "cbAnalyzers");
        Object srchTabs = this.find("srchOptTabs");
        Object cbType = this.find(srchTabs, "cbType");
        String clazz = this.getString(cbAnalyzers, "text");
        this.setString(cbType, "text", clazz);
        Analyzer a = this.createAnalyzer(srchTabs);
        if (a == null) {
            return false;
        }
        Object editTabs = this.find(editdoc, "editTabs");
        Object[] tabs = this.getItems(editTabs);
        for (int i = 0; i < tabs.length; ++i) {
            org.apache.lucene.document.Field f;
            String name = this.getString(tabs[i], "text");
            if (name.trim().equals("")) continue;
            Object fBoost = this.find(tabs[i], "fBoost");
            Object fText = this.find(tabs[i], "sText");
            if (fText == null) {
                fText = this.find(tabs[i], "rText");
            }
            Object cbStored = this.find(tabs[i], "cbStored");
            Object cbIndexed = this.find(tabs[i], "cbIndexed");
            Object cbTokenized = this.find(tabs[i], "cbTokenized");
            Object cbTVF = this.find(tabs[i], "cbTVF");
            Object cbTVFo = this.find(tabs[i], "cbTVFo");
            Object cbTVFp = this.find(tabs[i], "cbTVFp");
            Object cbCmp = this.find(tabs[i], "cbCmp");
            Object cbBin = this.find(tabs[i], "cbBin");
            Object cbONorms = this.find(tabs[i], "cbONorms");
            Object cbOTF = this.find(tabs[i], "cbOTF");
            String text = this.getString(fText, "text");
            boolean binary = this.getBoolean(cbBin, "selected");
            FieldType ft = new FieldType();
            if (this.getBoolean(cbTVF, "selected")) {
                ft.setStoreTermVectors(true);
                if (this.getBoolean(cbTVFo, "selected")) {
                    ft.setStoreTermVectorOffsets(true);
                }
                if (this.getBoolean(cbTVFp, "selected")) {
                    ft.setStoreTermVectorPositions(true);
                }
            } else {
                ft.setStoreTermVectors(false);
            }
            if (this.getBoolean(cbOTF, "selected")) {
                ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            } else {
                ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            }
            ft.setStored(this.getBoolean(cbStored, "selected"));
            ft.setIndexed(this.getBoolean(cbIndexed, "selected"));
            ft.setTokenized(this.getBoolean(cbTokenized, "selected"));
            if (!ft.stored() && !ft.indexed()) {
                this.errorMsg("Field '" + name + "' is neither stored nor indexed.");
                return false;
            }
            ft.setOmitNorms(this.getBoolean(cbONorms, "selected"));
            if (binary) {
                byte[] binValue;
                try {
                    binValue = Util.hexToBytes(text);
                }
                catch (Throwable e) {
                    this.errorMsg("Field '" + name + "': " + e.getMessage());
                    return false;
                }
                f = new org.apache.lucene.document.Field(name, binValue, 0, binValue.length, ft);
            } else {
                f = new org.apache.lucene.document.Field(name, text, ft);
            }
            String boostS = this.getString(fBoost, "text").trim();
            if (!boostS.equals("") && !boostS.equals("1.0")) {
                float boost = 1.0f;
                try {
                    boost = Float.parseFloat(boostS);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                f.setBoost(boost);
            }
            doc.add(f);
        }
        IndexWriter writer = null;
        boolean res = false;
        String msg = null;
        try {
            this.ir.close();
            if (this.ar != null) {
                this.ar.close();
            }
            writer = this.createIndexWriter();
            writer.addDocument(doc);
            res = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            msg = "FAILED: " + e.getMessage();
            res = false;
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                res = false;
                msg = "FAILED: " + e.getMessage();
            }
            this.remove(editdoc);
            try {
                this.actionReopen();
                Object tabpane = this.find("maintpane");
                this.setInteger(tabpane, "selected", 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                res = false;
                msg = "FAILED: " + e.getMessage();
            }
        }
        if (!res) {
            this.errorMsg(msg);
        }
        return res;
    }

    public void actionEditAddField(Object editdoc) {
        String name = this.getString(this.find(editdoc, "fNewName"), "text");
        if (name.trim().equals("")) {
            this.showStatus("FAILED: Field name is required.");
            return;
        }
        name = name.trim();
        Object editTabs = this.find(editdoc, "editTabs");
        Object tab = Luke.create("tab");
        this.setString(tab, "text", name);
        this.setFont(tab, this.getFont().deriveFont(1));
        this.add(editTabs, tab);
        this.addComponent(tab, "/xml/editfield.xml", null, null);
        this.repaint(editTabs);
    }

    public void actionEditDeleteField(Object editfield) {
        Object tab = this.getParent(editfield);
        this.remove(tab);
    }

    public void actionMLT(Object docNum, Object docTable) {
        if (this.ir == null) {
            this.errorMsg(MSG_NOINDEX);
            return;
        }
        int id = 0;
        try {
            id = Integer.parseInt(this.getString(docNum, "text"));
        }
        catch (NumberFormatException nfe) {
            this.errorMsg("Invalid document number");
            return;
        }
        MoreLikeThis mlt = new MoreLikeThis(this.ir);
        try {
            mlt.setFieldNames(Util.fieldNames(this.ir, true).toArray(new String[0]));
        }
        catch (Exception e) {
            this.errorMsg("Exception collecting field names: " + e.toString());
            return;
        }
        mlt.setMinTermFreq(1);
        mlt.setMaxQueryTerms(50);
        Analyzer a = this.createAnalyzer(this.find("srchOptTabs"));
        if (a == null) {
            return;
        }
        mlt.setAnalyzer(a);
        Object[] rows = this.getSelectedItems(docTable);
        BooleanQuery similar = null;
        if (rows != null && rows.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < rows.length; ++i) {
                String s;
                org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)this.getProperty(rows[i], "field");
                if (f == null || (s = f.stringValue()) == null || s.trim().length() == 0) continue;
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(s);
            }
            try {
                similar = (BooleanQuery)mlt.like(new StringReader(sb.toString()), "field");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMsg("FAILED: " + e.getMessage());
                return;
            }
        }
        try {
            similar = (BooleanQuery)mlt.like(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg("FAILED: " + e.getMessage());
            return;
        }
        if (similar.clauses() != null && similar.clauses().size() > 0) {
            Object tabpane = this.find("maintpane");
            this.setInteger(tabpane, "selected", 2);
            Object qField = this.find("qField");
            this.setString(qField, "text", similar.toString());
        } else {
            this.showStatus("WARN: empty query - check Analyzer settings");
        }
    }

    private void _showDocFields(int docid, Document doc) {
        Object table = this.find("docTable");
        Object srchOpts = this.find("srchOptTabs");
        Similarity sim = this.createSimilarity(srchOpts);
        if (sim == null || !(sim instanceof TFIDFSimilarity)) {
            sim = defaultSimilarity;
        }
        this.setString(this.find("docNum"), "text", String.valueOf(docid));
        this.removeAll(table);
        this.putProperty(table, "doc", doc);
        this.putProperty(table, "docNum", new Integer(docid));
        if (doc == null) {
            this.setString(this.find("docNum1"), "text", String.valueOf(docid) + "  DELETED");
            return;
        }
        this.setString(this.find("docNum1"), "text", String.valueOf(docid));
        for (int i = 0; i < this.idxFields.length; ++i) {
            IndexableField[] fields = doc.getFields(this.idxFields[i]);
            if (fields.length == 0) {
                this.addFieldRow(table, this.idxFields[i], null, docid, null);
                continue;
            }
            for (int j = 0; j < fields.length; ++j) {
                this.addFieldRow(table, this.idxFields[i], fields[j], docid, (TFIDFSimilarity)sim);
            }
        }
        this.doLayout(table);
    }

    private void addFieldRow(Object table, String fName, IndexableField ixf, int docid, TFIDFSimilarity sim) {
        org.apache.lucene.document.Field f;
        Object cell;
        Object row;
        block15: {
            row = Luke.create("row");
            this.add(table, row);
            this.putProperty(row, "field", ixf);
            this.putProperty(row, "fName", fName);
            cell = Luke.create("cell");
            this.setString(cell, "text", fName);
            this.add(row, cell);
            cell = Luke.create("cell");
            f = (org.apache.lucene.document.Field)ixf;
            String flags = Util.fieldFlags(f, this.infos.fieldInfo(fName));
            boolean hasVectors = false;
            try {
                hasVectors = this.ar.getTermVector(docid, fName) != null;
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ixf == null && !hasVectors) {
                this.setBoolean(cell, "enabled", false);
            }
            if (hasVectors) {
                flags = flags.substring(0, 7) + "V" + flags.substring(8);
            }
            this.setString(cell, "text", flags);
            this.setFont(cell, "font", this.courier);
            this.setChoice(cell, "alignment", "center");
            this.add(row, cell);
            cell = Luke.create("cell");
            FieldInfo info = this.infos.fieldInfo(fName);
            if (f != null) {
                try {
                    if (this.ar != null && info.hasNorms()) {
                        NumericDocValues norms = this.ar.getNormValues(fName);
                        String val = Long.toString(norms.get(docid));
                        this.setString(cell, "text", val);
                        break block15;
                    }
                    this.setString(cell, "text", "---");
                    this.setBoolean(cell, "enabled", false);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    this.setString(cell, "text", "!?!");
                }
            } else {
                this.setString(cell, "text", "---");
                this.setBoolean(cell, "enabled", false);
            }
        }
        this.add(row, cell);
        cell = Luke.create("cell");
        if (f != null) {
            Decoder dec;
            String text = f.stringValue();
            if (text == null) {
                text = f.binaryValue() != null ? Util.bytesToHex(f.binaryValue(), false) : "(null)";
            }
            if ((dec = this.decoders.get(f.name())) == null) {
                dec = this.defDecoder;
            }
            try {
                text = f.fieldType().stored() ? dec.decodeStored(f.name(), f) : dec.decodeTerm(f.name(), text);
            }
            catch (Throwable e) {
                this.setColor(cell, "foreground", Color.RED);
            }
            this.setString(cell, "text", Util.escape(text));
        } else {
            this.setString(cell, "text", "<not present or not stored>");
            this.setBoolean(cell, "enabled", false);
        }
        this.add(row, cell);
    }

    public void showTV(Object table) {
        final Object row = this.getSelectedItem(table);
        if (row == null) {
            return;
        }
        if (this.ar == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        final Integer DocId = (Integer)this.getProperty(table, "docNum");
        if (DocId == null) {
            this.showStatus("Missing Doc. Id.");
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    String fName = (String)Luke.this.getProperty(row, "fName");
                    Terms tfv = Luke.this.ar.getTermVector(DocId, fName);
                    if (tfv == null) {
                        Luke.this.showStatus("Term Vector not available in field " + fName + " for this doc.");
                        return;
                    }
                    List<IntPair> tvs = TermVectorMapper.map(tfv, null, true, false);
                    if (tvs == null || tvs.isEmpty()) {
                        Luke.this.showStatus("Term Vector not available (empty).");
                        return;
                    }
                    Object dialog = Luke.this.addComponent(null, "/xml/vector.xml", null, null);
                    Luke.this.setString(Luke.this.find(dialog, "fld"), "text", fName);
                    Object vTable = Luke.this.find(dialog, "vTable");
                    Decoder dec = (Decoder)Luke.this.decoders.get(fName);
                    if (dec == null) {
                        dec = Luke.this.defDecoder;
                    }
                    Collections.sort(tvs, new IntPair.PairComparator(false, true));
                    for (int i = 0; i < tvs.size(); ++i) {
                        int k;
                        StringBuilder sb;
                        String s;
                        Object r = Thinlet.create("row");
                        Luke.this.add(vTable, r);
                        IntPair ip = tvs.get(i);
                        Luke.this.putProperty(r, "tf", ip);
                        Object cell = Thinlet.create("cell");
                        try {
                            s = dec.decodeTerm(fName, ip.text);
                        }
                        catch (Throwable e) {
                            s = ip.text;
                            Luke.this.setColor(cell, "foreground", Color.RED);
                        }
                        Luke.this.setString(cell, "text", Util.escape(s));
                        Luke.this.add(r, cell);
                        cell = Thinlet.create("cell");
                        Luke.this.setString(cell, "text", String.valueOf(ip.cnt));
                        Luke.this.add(r, cell);
                        cell = Thinlet.create("cell");
                        if (ip.positions != null) {
                            sb = new StringBuilder();
                            for (k = 0; k < ip.positions.length; ++k) {
                                if (k > 0) {
                                    sb.append(',');
                                }
                                sb.append(String.valueOf(ip.positions[k]));
                            }
                            Luke.this.setString(cell, "text", sb.toString());
                        }
                        Luke.this.add(r, cell);
                        cell = Thinlet.create("cell");
                        if (ip.starts != null) {
                            sb = new StringBuilder();
                            for (k = 0; k < ip.starts.length; ++k) {
                                if (k > 0) {
                                    sb.append(',');
                                }
                                sb.append(ip.starts[k] + "-" + ip.ends[k]);
                            }
                            Luke.this.setString(cell, "text", sb.toString());
                        }
                        Luke.this.add(r, cell);
                    }
                    Luke.this.add(dialog);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void clipTV(Object vTable) {
        Object[] rows = this.getItems(vTable);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rows.length; ++i) {
            int k;
            IntPair tf = (IntPair)this.getProperty(rows[i], "tf");
            sb.append(tf.cnt + "\t" + tf.text);
            if (tf.positions != null) {
                sb.append("\t");
                for (k = 0; k < tf.positions.length; ++k) {
                    if (k > 0) {
                        sb.append(',');
                    }
                    sb.append(String.valueOf(tf.positions[k]));
                }
            }
            if (tf.starts != null) {
                if (tf.positions == null) {
                    sb.append("\t");
                }
                sb.append("\t");
                for (k = 0; k < tf.starts.length; ++k) {
                    if (k > 0) {
                        sb.append(',');
                    }
                    sb.append(tf.starts[i] + "-" + tf.ends[i]);
                }
            }
            sb.append("\n");
        }
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    public void actionExamineNorm(Object table) throws Exception {
        Object row = this.getSelectedItem(table);
        if (row == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)this.getProperty(row, "field");
        if (f == null) {
            this.showStatus("No data available for this field");
            return;
        }
        FieldInfo info = this.infos.fieldInfo(f.name());
        if (!info.isIndexed()) {
            this.showStatus("Cannot examine norm value - this field is not indexed.");
            return;
        }
        if (!info.hasNorms()) {
            this.showStatus("Cannot examine norm value - this field has no norms.");
            return;
        }
        Object dialog = this.addComponent(null, "/xml/fnorm.xml", null, null);
        Integer docNum = (Integer)this.getProperty(table, "docNum");
        this.putProperty(dialog, "docNum", this.getProperty(table, "docNum"));
        this.putProperty(dialog, "field", f);
        Object curNorm = this.find(dialog, "curNorm");
        Object newNorm = this.find(dialog, "newNorm");
        Object encNorm = this.find(dialog, "encNorm");
        Object doc = this.find(dialog, "docNum");
        Object fld = this.find(dialog, "fld");
        Object srchOpts = this.find("srchOptTabs");
        Similarity sim = this.createSimilarity(srchOpts);
        TFIDFSimilarity s = null;
        s = sim != null && sim instanceof TFIDFSimilarity ? (TFIDFSimilarity)sim : defaultSimilarity;
        this.setString(doc, "text", String.valueOf(docNum));
        this.setString(fld, "text", f.name());
        this.putProperty(dialog, "similarity", s);
        if (this.ar != null) {
            try {
                NumericDocValues norms = this.ar.getNormValues(f.name());
                byte curBVal = (byte)norms.get(docNum);
                float curFVal = Util.decodeNormValue(curBVal, f.name(), s);
                this.setString(curNorm, "text", String.valueOf(curFVal));
                this.setString(newNorm, "text", String.valueOf(curFVal));
                this.setString(encNorm, "text", String.valueOf(curFVal) + " (0x" + Util.byteToHex(curBVal) + ")");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMsg("Error reading norm: " + e.toString());
                return;
            }
        }
        this.add(dialog);
        this.displayNewNorm(dialog);
    }

    public void displayNewNorm(Object dialog) {
        Object newNorm = this.find(dialog, "newNorm");
        Object encNorm = this.find(dialog, "encNorm");
        org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)this.getProperty(dialog, "field");
        TFIDFSimilarity s = (TFIDFSimilarity)this.getProperty(dialog, "similarity");
        Object sim = this.find(dialog, "sim");
        String simClassString = this.getString(sim, "text");
        if (simClassString != null && simClassString.trim().length() > 0 && !simClassString.equals(defaultSimilarity.getClass().getName())) {
            try {
                Class<?> cls = Class.forName(simClassString.trim());
                if (TFIDFSimilarity.class.isAssignableFrom(cls)) {
                    s = (TFIDFSimilarity)cls.newInstance();
                    this.putProperty(dialog, "similarity", s);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.showStatus("Invalid similarity class " + simClassString + ", using DefaultSimilarity.");
            }
        }
        if (s == null) {
            s = defaultSimilarity;
        }
        this.setString(sim, "text", s.getClass().getName());
        try {
            float newFVal = Float.parseFloat(this.getString(newNorm, "text"));
            long newBVal = Util.encodeNormValue(newFVal, f.name(), s);
            float encFVal = Util.decodeNormValue(newBVal, f.name(), s);
            this.setString(encNorm, "text", String.valueOf(encFVal) + " (0x" + Util.byteToHex((byte)(newBVal & 0xFFL)) + ")");
            this.putProperty(dialog, "newNorm", new Float(newFVal));
            this.doLayout(dialog);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void showTField(Object table) {
        Object row = this.getSelectedItem(table);
        if (row == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)this.getProperty(row, "field");
        if (f == null) {
            this.showStatus("No data available for this field");
            return;
        }
        Object dialog = this.addComponent(null, "/xml/field.xml", null, null);
        Object fName = this.find(dialog, "fld");
        this.putProperty(dialog, "f", f);
        this.setString(fName, "text", f.name());
        this.add(dialog);
        this._showData(dialog);
    }

    public void _showData(Object dialog) {
        StringBuilder sb;
        Object fDataText = this.find(dialog, "fDataText");
        org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)this.getProperty(dialog, "f");
        String value = null;
        String enc = "cbUtf";
        Object choice = this.getSelectedItem(this.find(dialog, "cbData"));
        String selEnc = this.getString(choice, "name");
        boolean warn = false;
        if (selEnc != null) {
            enc = selEnc;
        }
        int len = 0;
        byte[] data = null;
        if (f.binaryValue() != null) {
            BytesRef bytes = f.binaryValue();
            data = new byte[bytes.length];
            System.arraycopy(bytes.bytes, bytes.offset, data, 0, bytes.length);
        } else if (f.stringValue() != null) {
            try {
                data = f.stringValue().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                warn = true;
                uee.printStackTrace();
                data = f.stringValue().getBytes();
            }
        }
        if (data == null) {
            data = new byte[]{};
        }
        if (enc.equals("cbHex")) {
            this.setString(this.find(dialog, "unit"), "text", " bytes");
            value = Util.bytesToHex(data, 0, data.length, true);
            len = data.length;
        } else if (enc.equals("cbUtf")) {
            this.setString(this.find(dialog, "unit"), "text", " UTF-8 characters");
            value = f.stringValue();
            if (value != null) {
                len = value.length();
            }
        } else if (enc.equals("cbDef")) {
            this.setString(this.find(dialog, "unit"), "text", " characters");
            value = new String(data);
            len = value.length();
        } else if (enc.equals("cbDate")) {
            try {
                Date d = DateTools.stringToDate(f.stringValue());
                value = d.toString();
                len = 1;
            }
            catch (Exception e) {
                warn = true;
                value = Util.bytesToHex(data, 0, data.length, true);
            }
        } else if (enc.equals("cbLong")) {
            try {
                long num = NumericUtils.prefixCodedToLong(new BytesRef(f.stringValue()));
                value = String.valueOf(num);
                len = 1;
            }
            catch (Exception e) {
                warn = true;
                value = Util.bytesToHex(data, 0, data.length, true);
            }
        } else if (enc.equals("cbNum")) {
            if (f.numericValue() != null) {
                value = f.numericValue().toString() + " (" + f.numericValue().getClass().getSimpleName() + ")";
            } else {
                warn = true;
                value = Util.bytesToHex(data, 0, data.length, true);
            }
        } else if (enc.equals("cbInt")) {
            if (data.length % 4 == 0) {
                this.setString(this.find(dialog, "unit"), "text", " int values");
                len = data.length / 4;
                sb = new StringBuilder();
                for (int k = 0; k < data.length; k += 4) {
                    if (k > 0) {
                        sb.append(',');
                    }
                    sb.append(String.valueOf(PayloadHelper.decodeInt(data, k)));
                }
                value = sb.toString();
            } else {
                warn = true;
                value = Util.bytesToHex(data, 0, data.length, true);
            }
        } else if (enc.equals("cbFloat")) {
            if (data.length % 4 == 0) {
                this.setString(this.find(dialog, "unit"), "text", " float values");
                len = data.length / 4;
                sb = new StringBuilder();
                for (int k = 0; k < data.length; k += 4) {
                    if (k > 0) {
                        sb.append(',');
                    }
                    sb.append(String.valueOf(PayloadHelper.decodeFloat(data, k)));
                }
                value = sb.toString();
            } else {
                warn = true;
                value = Util.bytesToHex(data, 0, data.length, true);
            }
        }
        this.setString(fDataText, "text", value);
        this.setString(this.find(dialog, "len"), "text", String.valueOf(len));
        if (warn) {
            this.setBoolean(fDataText, "enabled", false);
            this.errorMsg(MSG_CONV_ERROR);
        } else {
            this.setBoolean(fDataText, "enabled", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveField(Object table) {
        Object row = this.getSelectedItem(table);
        if (row == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)this.getProperty(row, "field");
        if (f == null) {
            this.showStatus("No data available for this field");
            return;
        }
        JFileChooser fd = new JFileChooser();
        fd.setDialogType(1);
        fd.setDialogTitle("Save field content to a file");
        fd.setFileSelectionMode(2);
        fd.setFileHidingEnabled(false);
        if (this.baseDir != null) {
            fd.setCurrentDirectory(new File(this.baseDir));
        } else {
            fd.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        int res = fd.showSaveDialog(this);
        File iFile = null;
        if (res == 0) {
            iFile = fd.getSelectedFile();
        }
        if (iFile == null) {
            return;
        }
        if (iFile.exists() && iFile.isDirectory()) {
            this.errorMsg("Can't overwrite a directory.");
            return;
        }
        Object progress = null;
        try {
            byte[] data = null;
            if (f.binaryValue() != null) {
                BytesRef bytes = f.binaryValue();
                data = new byte[bytes.length];
                System.arraycopy(bytes.bytes, bytes.offset, data, 0, bytes.length);
            } else {
                try {
                    data = f.stringValue().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    uee.printStackTrace();
                    this.errorMsg(uee.toString());
                    data = f.stringValue().getBytes();
                }
            }
            if (data == null || data.length == 0) {
                this.showStatus("No data available");
                return;
            }
            progress = this.addComponent(null, "/xml/progress.xml", null, null);
            this.setString(this.find(progress, "msg"), "text", "Saving...");
            Object bar = this.find(progress, "bar");
            this.setInteger(bar, "maximum", 100);
            FileOutputStream os = new FileOutputStream(iFile);
            int delta = data.length / 100;
            if (delta == 0) {
                delta = 1;
            }
            this.add(progress);
            for (int i = 0; i < data.length; ++i) {
                ((OutputStream)os).write(data[i]);
                if (i % delta != 0) continue;
                this.setInteger(bar, "value", i / delta);
            }
            os.flush();
            ((OutputStream)os).close();
            this.setString(this.find(progress, "msg"), "text", "Done!");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (progress == null) return;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.errorMsg("Can't save: " + ioe);
            return;
        }
        finally {
            if (progress != null) {
                this.remove(progress);
            }
        }
        this.remove(progress);
        return;
    }

    public void clipCopyFields(Object table) {
        Object[] rows = this.getSelectedItems(table);
        if (rows == null || rows.length == 0) {
            return;
        }
        Document doc = (Document)this.getProperty(table, "doc");
        if (doc == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rows.length; ++i) {
            org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)this.getProperty(rows[i], "field");
            if (f == null) continue;
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(f.toString());
        }
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    public void clipCopyDoc(Object table) {
        Document doc = (Document)this.getProperty(table, "doc");
        if (doc == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Object[] rows = this.getItems(table);
        for (int i = 0; i < rows.length; ++i) {
            org.apache.lucene.document.Field f = (org.apache.lucene.document.Field)this.getProperty(rows[i], "field");
            if (f == null) continue;
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(f.toString());
        }
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    public void showFirstTerm(final Object fCombo, final Object fText) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    String fld = Luke.this.getString(fCombo, "text");
                    Terms terms = MultiFields.getTerms(Luke.this.ir, fld);
                    TermsEnum te = terms.iterator(null);
                    Luke.this.putProperty(fCombo, "te", te);
                    Luke.this.putProperty(fCombo, "teField", fld);
                    BytesRef term = te.next();
                    Luke.this._showTerm(fCombo, fText, new Term(fld, term));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void showNextTerm(final Object fCombo, final Object fText) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    String rawString;
                    String text = Luke.this.getString(fText, "text");
                    if (text == null || text.trim().equals("")) {
                        text = "";
                    }
                    if (text.length() == 0) {
                        Luke.this.showFirstTerm(fCombo, fText);
                        return;
                    }
                    TermsEnum te = (TermsEnum)Luke.this.getProperty(fCombo, "te");
                    String fld = Luke.this.getString(fCombo, "text");
                    String teField = (String)Luke.this.getProperty(fCombo, "teField");
                    BytesRef rawTerm = null;
                    if (te != null) {
                        rawTerm = te.term();
                    }
                    String string = rawString = rawTerm != null ? rawTerm.utf8ToString() : null;
                    if (te == null || !teField.equals(fld) || !text.equals(rawString)) {
                        Terms terms = MultiFields.getTerms(Luke.this.ir, fld);
                        te = terms.iterator(null);
                        Luke.this.putProperty(fCombo, "te", te);
                        Luke.this.putProperty(fCombo, "teField", fld);
                        TermsEnum.SeekStatus status = te.seekCeil(new BytesRef(text));
                        rawTerm = status.equals((Object)TermsEnum.SeekStatus.FOUND) ? te.term() : null;
                    } else {
                        rawTerm = te.next();
                    }
                    if (rawTerm == null) {
                        int idx = Luke.this.fn.indexOf(fld);
                        while (idx < Luke.this.fn.size() - 1) {
                            Luke.this.setInteger(fCombo, "selected", ++idx);
                            fld = (String)Luke.this.fn.get(idx);
                            Terms terms = MultiFields.getTerms(Luke.this.ir, fld);
                            if (terms == null) continue;
                            te = terms.iterator(null);
                            rawTerm = te.next();
                            Luke.this.putProperty(fCombo, "te", te);
                            Luke.this.putProperty(fCombo, "teField", fld);
                            break;
                        }
                    }
                    if (rawTerm == null) {
                        Luke.this.showStatus("No more terms");
                        return;
                    }
                    Luke.this._showTerm(fCombo, fText, new Term(fld, rawTerm));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void showTerm(final Object fCombo, final Object fText) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    String s;
                    Term rawTerm = (Term)Luke.this.getProperty(fText, "term");
                    String text = Luke.this.getString(fText, "text");
                    if (rawTerm != null && (s = (String)Luke.this.getProperty(fText, "decText")).equals(text)) {
                        text = rawTerm.text();
                    }
                    String fld = Luke.this.getString(fCombo, "text");
                    if (text == null || text.trim().equals("")) {
                        return;
                    }
                    Term t = new Term(fld, text);
                    if (Luke.this.ir.docFreq(t) == 0) {
                        Terms terms = MultiFields.getTerms(Luke.this.ir, fld);
                        TermsEnum te = terms.iterator(null);
                        te.seekCeil(new BytesRef(text));
                        t = new Term(fld, te.term().utf8ToString());
                    }
                    Luke.this._showTerm(fCombo, fText, t);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    private void _showTerm(Object fCombo, Object fText, final Term t) {
        Decoder dec;
        if (t == null) {
            this.showStatus("No terms?!");
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        Object[] choices = this.getItems(fCombo);
        for (int i = 0; i < choices.length; ++i) {
            if (!t.field().equals(this.getString(choices[i], "text"))) continue;
            this.setInteger(fCombo, "selected", i);
            break;
        }
        if ((dec = this.decoders.get(t.field())) == null) {
            dec = this.defDecoder;
        }
        String s = null;
        boolean decodeErr = false;
        try {
            s = dec.decodeTerm(t.field(), t.text());
        }
        catch (Throwable e) {
            s = e.getMessage();
            decodeErr = true;
        }
        this.setString(fText, "text", t.text());
        Object rawText = this.find("decText");
        if (!s.equals(t.text())) {
            this.setString(rawText, "text", s);
            if (decodeErr) {
                this.setColor(rawText, "foreground", Color.RED);
            } else {
                this.setColor(rawText, "foreground", Color.BLUE);
            }
        } else {
            this.setString(rawText, "text", "");
            this.setColor(rawText, "foreground", Color.BLACK);
        }
        this.putProperty(fText, "term", t);
        this.putProperty(fText, "decText", s);
        this.putProperty(fText, "td", null);
        this.setString(this.find("tdNum"), "text", "?");
        this.setString(this.find("tFreq"), "text", "?");
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                Object dFreq = Luke.this.find("dFreq");
                try {
                    int freq = Luke.this.ir.docFreq(t);
                    Luke.this.setString(dFreq, "text", String.valueOf(freq));
                    dFreq = Luke.this.find("tdMax");
                    Luke.this.setString(dFreq, "text", String.valueOf(freq));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                    Luke.this.setString(dFreq, "text", "?");
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void showFirstTermDoc(final Object fText) {
        final Term t = (Term)this.getProperty(fText, "term");
        if (t == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.ar == null) {
            this.errorMsg(MSG_LUCENE3828);
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    DocsEnum td = Luke.this.ar.getContext().reader().termDocsEnum(t);
                    if (td == null) {
                        Luke.this.showStatus("No such term: " + t);
                        return;
                    }
                    if (td.nextDoc() == Integer.MAX_VALUE) {
                        Luke.this.showStatus("No documents with this term: " + t + " (NO_MORE_DOCS)");
                        return;
                    }
                    Luke.this.setString(Luke.this.find("tdNum"), "text", "1");
                    Luke.this.putProperty(fText, "td", td);
                    Luke.this._showTermDoc(fText, td);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void showNextTermDoc(final Object fText) {
        Term t = (Term)this.getProperty(fText, "term");
        if (t == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    DocsEnum td = (DocsEnum)Luke.this.getProperty(fText, "td");
                    if (td == null) {
                        Luke.this.showFirstTermDoc(fText);
                        return;
                    }
                    if (td.nextDoc() == Integer.MAX_VALUE) {
                        Luke.this.showStatus("No more docs for this term");
                        return;
                    }
                    Object tdNum = Luke.this.find("tdNum");
                    String sCnt = Luke.this.getString(tdNum, "text");
                    int cnt = 1;
                    try {
                        cnt = Integer.parseInt(sCnt);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Luke.this.setString(tdNum, "text", String.valueOf(cnt + 1));
                    Luke.this._showTermDoc(fText, td);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void showPositions(final Object fText) {
        final Term t = (Term)this.getProperty(fText, "term");
        if (t == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.ar == null) {
            this.errorMsg(MSG_LUCENE3828);
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    DocsEnum tdd;
                    FieldInfo.IndexOptions opts;
                    FieldInfo fi = Luke.this.infos.fieldInfo(t.field());
                    boolean withOffsets = false;
                    if (fi != null && (opts = fi.getIndexOptions()) != null && opts.equals((Object)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS)) {
                        withOffsets = true;
                    }
                    if ((tdd = (DocsEnum)Luke.this.getProperty(fText, "td")) == null) {
                        Luke.this.showStatus("Unknown document number.");
                        return;
                    }
                    DocsAndPositionsEnum td = Luke.this.ar.getContext().reader().termPositionsEnum(t);
                    if (td == null) {
                        Luke.this.showStatus("No position information available for this term.");
                        return;
                    }
                    if (td.advance(tdd.docID()) != td.docID()) {
                        Luke.this.showStatus("No position available for this doc and this term.");
                        return;
                    }
                    Object dialog = Luke.this.addComponent(null, "/xml/positions.xml", null, null);
                    Luke.this.setString(Luke.this.find(dialog, "term"), "text", t.toString());
                    String docNum = Luke.this.getString(Luke.this.find("docNum"), "text");
                    Luke.this.setString(Luke.this.find(dialog, "docNum"), "text", docNum);
                    Luke.this.setString(Luke.this.find(dialog, "freq"), "text", String.valueOf(td.freq()));
                    Luke.this.setString(Luke.this.find(dialog, "offs"), "text", String.valueOf(withOffsets));
                    Luke.this.putProperty(dialog, "td", td);
                    Object pTable = Luke.this.find(dialog, "pTable");
                    Luke.this.removeAll(pTable);
                    int freq = td.freq();
                    for (int i = 0; i < freq; ++i) {
                        try {
                            int pos = td.nextPosition();
                            Object r = Thinlet.create("row");
                            Object cell = Thinlet.create("cell");
                            Luke.this.setString(cell, "text", String.valueOf(pos));
                            Luke.this.add(r, cell);
                            cell = Thinlet.create("cell");
                            Luke.this.add(r, cell);
                            if (withOffsets) {
                                Luke.this.setString(cell, "text", td.startOffset() + "-" + td.endOffset());
                            } else {
                                Luke.this.setString(cell, "text", "---");
                                Luke.this.setBoolean(cell, "enabled", false);
                            }
                            cell = Thinlet.create("cell");
                            Luke.this.add(r, cell);
                            BytesRef payload = td.getPayload();
                            if (payload != null) {
                                Luke.this.putProperty(r, "payload", payload.clone());
                            }
                            Luke.this.add(pTable, r);
                            continue;
                        }
                        catch (IOException ioe) {
                            Luke.this.errorMsg("Error: " + ioe.toString());
                            return;
                        }
                    }
                    Luke.this._showPayloads(dialog);
                    Luke.this.add(dialog);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void _showPayloads(Object dialog) {
        Object cbPay = this.find(dialog, "cbPay");
        Object choice = this.getSelectedItem(cbPay);
        String enc = "cbUtf";
        if (choice != null) {
            enc = this.getString(choice, "name");
        }
        Object pTable = this.find(dialog, "pTable");
        Object[] rows = this.getItems(pTable);
        boolean warn = false;
        for (int i = 0; i < rows.length; ++i) {
            int k;
            StringBuilder sb;
            BytesRef payload = (BytesRef)this.getProperty(rows[i], "payload");
            if (payload == null) continue;
            Object cell = this.getItem(rows[i], 2);
            String curEnc = enc;
            if ((enc.equals("cbInt") || enc.equals("cbFloat")) && payload.length % 4 != 0) {
                curEnc = "cbHex";
            }
            String val = "?";
            if (curEnc.equals("cbUtf")) {
                try {
                    val = new String(payload.bytes, payload.offset, payload.length, "UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    val = new String(payload.bytes, payload.offset, payload.length);
                    curEnc = "cbDef";
                }
            } else if (curEnc.equals("cbHex")) {
                val = Util.bytesToHex(payload.bytes, payload.offset, payload.length, false);
            } else if (curEnc.equals("cbDef")) {
                val = new String(payload.bytes, payload.offset, payload.length);
            } else if (curEnc.equals("cbInt")) {
                sb = new StringBuilder();
                for (k = payload.offset; k < payload.offset + payload.length; k += 4) {
                    if (k > 0) {
                        sb.append(',');
                    }
                    sb.append(String.valueOf(PayloadHelper.decodeInt(payload.bytes, k)));
                }
                val = sb.toString();
            } else if (curEnc.equals("cbFloat")) {
                sb = new StringBuilder();
                for (k = payload.offset; k < payload.offset + payload.length; k += 4) {
                    if (k > 0) {
                        sb.append(',');
                    }
                    sb.append(String.valueOf(PayloadHelper.decodeFloat(payload.bytes, k)));
                }
                val = sb.toString();
            }
            this.setString(cell, "text", val);
            if (!curEnc.equals(enc)) {
                this.setBoolean(cell, "enabled", false);
                warn = true;
                continue;
            }
            this.setBoolean(cell, "enabled", true);
        }
        if (warn) {
            this.errorMsg(MSG_CONV_ERROR);
        }
    }

    public void clipPositions(Object pTable) {
        Object[] rows = this.getItems(pTable);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rows.length; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            Object[] cells = this.getItems(rows[i]);
            for (int k = 0; k < cells.length; ++k) {
                if (k > 0) {
                    sb.append('\t');
                }
                sb.append(this.getString(cells[k], "text"));
            }
        }
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    public void showAllTermDoc(Object fText) {
        Term t = (Term)this.getProperty(fText, "term");
        if (t == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus("MSG_NOINDEX");
            return;
        }
        Object tabpane = this.find("maintpane");
        this.setInteger(tabpane, "selected", 2);
        Object qField = this.find("qField");
        this.setString(qField, "text", t.field() + ":" + t.text());
        Object qFieldParsed = this.find("qFieldParsed");
        Object ckScoreRes = this.find("ckScoreRes");
        Object ckOrderRes = this.find("ckOrderRes");
        Object cntRepeat = this.find("cntRepeat");
        final boolean scoreRes = this.getBoolean(ckScoreRes, "selected");
        final boolean orderRes = this.getBoolean(ckOrderRes, "selected");
        final int repeat = Integer.parseInt(this.getString(cntRepeat, "text"));
        final TermQuery q = new TermQuery(t);
        this.setString(qFieldParsed, "text", q.toString());
        SlowThread st = new SlowThread(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                IndexSearcher is = null;
                try {
                    is = new IndexSearcher(Luke.this.ir);
                    Object sTable = Luke.this.find("sTable");
                    Luke.this.removeAll(sTable);
                    AllHitsCollector ahc = new AllHitsCollector(orderRes, scoreRes);
                    Luke.this._search(q, is, ahc, sTable, repeat);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.errorMsg(e.getMessage());
                }
                finally {
                    if (is != null) {
                        is = null;
                    }
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public Analyzer createAnalyzer(Object srchOpts) {
        Analyzer res;
        block21: {
            String arg;
            res = null;
            String sAType = this.getString(this.find(srchOpts, "cbType"), "text");
            if (sAType.trim().equals("")) {
                sAType = "org.apache.lucene.analysis.standard.StandardAnalyzer";
                this.setString(this.find("cbType"), "text", sAType);
            }
            if ((arg = this.getString(this.find(srchOpts, "snoName"), "text")) == null) {
                arg = "";
            }
            try {
                Constructor<?> zeroArg = null;
                Constructor<?> zeroArgV = null;
                Constructor<?> oneArg = null;
                Constructor<?> oneArgV = null;
                try {
                    zeroArgV = Class.forName(sAType).getConstructor(Version.class);
                }
                catch (NoSuchMethodException e) {
                    zeroArgV = null;
                    try {
                        zeroArg = Class.forName(sAType).getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        zeroArg = null;
                    }
                }
                try {
                    oneArgV = Class.forName(sAType).getConstructor(Version.class, String.class);
                }
                catch (NoSuchMethodException e) {
                    oneArgV = null;
                    try {
                        oneArg = Class.forName(sAType).getConstructor(String.class);
                    }
                    catch (NoSuchMethodException e1) {
                        oneArg = null;
                    }
                }
                if (arg.length() == 0) {
                    if (zeroArgV != null) {
                        res = (Analyzer)zeroArgV.newInstance(LV);
                        break block21;
                    }
                    if (zeroArg != null) {
                        res = (Analyzer)zeroArg.newInstance(new Object[0]);
                        break block21;
                    }
                    if (oneArgV != null) {
                        res = (Analyzer)oneArgV.newInstance(LV, arg);
                        break block21;
                    }
                    if (oneArg != null) {
                        res = (Analyzer)oneArg.newInstance(arg);
                        break block21;
                    }
                    throw new Exception("Must have a zero-arg or (Version) or (Version, String) constructor");
                }
                if (oneArgV != null) {
                    res = (Analyzer)oneArgV.newInstance(LV, arg);
                    break block21;
                }
                if (oneArg != null) {
                    res = (Analyzer)oneArg.newInstance(arg);
                    break block21;
                }
                if (zeroArgV != null) {
                    res = (Analyzer)zeroArgV.newInstance(LV);
                    break block21;
                }
                if (zeroArg != null) {
                    res = (Analyzer)zeroArg.newInstance(new Object[0]);
                    break block21;
                }
                throw new Exception("Must have a zero-arg or (String) constructor");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMsg("Analyzer '" + sAType + "' error: " + e.getMessage());
                return null;
            }
        }
        Prefs.setProperty("luke.analyzer", res.getClass().getName());
        return res;
    }

    protected String getDefaultField(Object srchOptTabs) {
        String defField = this.getString(this.find(srchOptTabs, "defFld"), "text");
        if (defField == null || defField.trim().equals("")) {
            if (this.ir != null) {
                defField = this.idxFields[0];
                this.setString(this.find(srchOptTabs, "defFld"), "text", defField);
            } else {
                defField = "DEFAULT";
            }
        }
        return defField;
    }

    public Query createQuery(String queryString) throws Exception {
        Object srchOpts = this.find("srchOptTabs");
        Analyzer analyzer = this.createAnalyzer(srchOpts);
        if (analyzer == null) {
            return null;
        }
        String defField = this.getDefaultField(srchOpts);
        QueryParser qp = new QueryParser(LV, defField, analyzer);
        Object ckXmlParser = this.find(srchOpts, "ckXmlParser");
        Object ckWild = this.find(srchOpts, "ckWild");
        Object ckPosIncr = this.find(srchOpts, "ckPosIncr");
        Object ckLoExp = this.find(srchOpts, "ckLoExp");
        Object cbDateRes = this.find(srchOpts, "cbDateRes");
        DateTools.Resolution resolution = Util.getResolution(this.getString(cbDateRes, "text"));
        Object cbOp = this.find(srchOpts, "cbOp");
        Object bqMaxCount = this.find(srchOpts, "bqMaxCount");
        int maxCount = 1024;
        try {
            maxCount = Integer.parseInt(this.getString(bqMaxCount, "text"));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus("Invalid BooleanQuery max clause count, using default 1024");
        }
        BooleanQuery.setMaxClauseCount(maxCount);
        String opString = this.getString(cbOp, "text");
        QueryParser.Operator op = opString.equalsIgnoreCase("OR") ? QueryParser.OR_OPERATOR : QueryParser.AND_OPERATOR;
        qp.setAllowLeadingWildcard(this.getBoolean(ckWild, "selected"));
        qp.setEnablePositionIncrements(this.getBoolean(ckPosIncr, "selected"));
        qp.setLowercaseExpandedTerms(this.getBoolean(ckLoExp, "selected"));
        qp.setDateResolution(resolution);
        qp.setDefaultOperator(op);
        if (this.getBoolean(ckXmlParser, "selected")) {
            CoreParser cp = this.createParser(defField, analyzer);
            Query q = cp.parse(new ByteArrayInputStream(queryString.getBytes("UTF-8")));
            return q;
        }
        return qp.parse(queryString);
    }

    private CoreParser createParser(String defaultField, Analyzer analyzer) throws Exception {
        if (this.xmlQueryParserFactoryClassName == null) {
            return new CorePlusExtensionsParser(defaultField, analyzer);
        }
        XmlQueryParserFactory parserFactory = (XmlQueryParserFactory)Class.forName(this.xmlQueryParserFactoryClassName).newInstance();
        return parserFactory.createParser(defaultField, analyzer);
    }

    public Similarity createSimilarity(Object srchOpts) {
        Object ckSimDef = this.find(srchOpts, "ckSimDef");
        Object ckSimSweet = this.find(srchOpts, "ckSimSweet");
        Object ckSimOther = this.find(srchOpts, "ckSimOther");
        Object simClass = this.find(srchOpts, "simClass");
        Object ckSimCust = this.find(srchOpts, "ckSimCust");
        if (this.getBoolean(ckSimDef, "selected")) {
            return new DefaultSimilarity();
        }
        if (this.getBoolean(ckSimSweet, "selected")) {
            return new SweetSpotSimilarity();
        }
        if (this.getBoolean(ckSimOther, "selected")) {
            try {
                Class<?> clazz = Class.forName(this.getString(simClass, "text"));
                if (Similarity.class.isAssignableFrom(clazz)) {
                    Similarity sim = (Similarity)clazz.newInstance();
                    return sim;
                }
                throw new Exception("Not a subclass of Similarity: " + clazz.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showStatus("ERROR: invalid Similarity, using default");
                this.setBoolean(ckSimDef, "selected", true);
                this.setBoolean(ckSimOther, "selected", false);
                return new DefaultSimilarity();
            }
        }
        if (this.getBoolean(ckSimCust, "selected")) {
            return this.similarity;
        }
        return new DefaultSimilarity();
    }

    public AccessibleHitCollector createCollector(Object srchOpts) throws Exception {
        Object ckNormRes = this.find(srchOpts, "ckNormRes");
        Object ckAllRes = this.find(srchOpts, "ckAllRes");
        Object ckLimRes = this.find(srchOpts, "ckLimRes");
        Object ckLimTime = this.find(srchOpts, "ckLimTime");
        Object limTime = this.find(srchOpts, "limTime");
        Object ckLimCount = this.find(srchOpts, "ckLimCount");
        Object limCount = this.find(srchOpts, "limCount");
        Object ckScoreRes = this.find(srchOpts, "ckScoreRes");
        Object ckOrderRes = this.find(srchOpts, "ckOrderRes");
        boolean scoreRes = this.getBoolean(ckScoreRes, "selected");
        boolean orderRes = this.getBoolean(ckOrderRes, "selected");
        Object hc = null;
        if (this.getBoolean(ckNormRes, "selected")) {
            return new AccessibleTopHitCollector(1000, orderRes, scoreRes);
        }
        if (this.getBoolean(ckAllRes, "selected")) {
            return new AllHitsCollector(orderRes, scoreRes);
        }
        if (this.getBoolean(ckLimRes, "selected")) {
            if (this.getBoolean(ckLimCount, "selected")) {
                int lim = Integer.parseInt(this.getString(limCount, "text"));
                return new CountLimitedHitCollector(lim, orderRes, scoreRes);
            }
            if (this.getBoolean(ckLimTime, "selected")) {
                int lim = Integer.parseInt(this.getString(limTime, "text"));
                return new IntervalLimitedCollector(lim, orderRes, scoreRes);
            }
            throw new Exception("Unknown LimitedHitCollector type");
        }
        throw new Exception("Unknown HitCollector type");
    }

    public void explainStructure(Object qTabs) {
        Object qField = this.find("qField");
        String queryS = this.getString(qField, "text");
        if (queryS.trim().equals("")) {
            this.showStatus("Empty query");
            return;
        }
        this.showParsed();
        int idx = this.getSelectedIndex(qTabs);
        Query q = null;
        q = idx == 0 ? (Query)this.getProperty(qField, "qParsed") : (Query)this.getProperty(qField, "qRewritten");
        Object dialog = this.addComponent(this, "/xml/qexplain.xml", null, null);
        Object tree = this.find(dialog, "qTree");
        this._explainStructure(tree, q);
    }

    private void _explainStructure(Object parent, Query q) {
        String clazz = q.getClass().getName();
        if (clazz.startsWith("org.apache.lucene.")) {
            clazz = "lucene." + q.getClass().getSimpleName();
        } else if (clazz.startsWith("org.apache.solr.")) {
            clazz = "solr." + q.getClass().getSimpleName();
        }
        float boost = q.getBoost();
        Object n = Luke.create("node");
        this.add(parent, n);
        String msg = clazz;
        if (boost != 1.0f) {
            msg = msg + ": boost=" + this.df.format(boost);
        }
        this.setFont(n, this.getFont().deriveFont(1));
        this.setString(n, "text", msg);
        if (clazz.equals("lucene.TermQuery")) {
            Object n1 = Luke.create("node");
            Term t = ((TermQuery)q).getTerm();
            this.setString(n1, "text", "Term: field='" + t.field() + "' text='" + t.text() + "'");
            this.add(n, n1);
        } else if (clazz.equals("lucene.BooleanQuery")) {
            BooleanQuery bq = (BooleanQuery)q;
            BooleanClause[] clauses = bq.getClauses();
            int max = bq.getMaxClauseCount();
            Object n1 = Luke.create("node");
            String descr = "clauses=" + clauses.length + ", maxClauses=" + max;
            if (bq.isCoordDisabled()) {
                descr = descr + ", coord=false";
            }
            if (bq.getMinimumNumberShouldMatch() > 0) {
                descr = descr + ", minShouldMatch=" + bq.getMinimumNumberShouldMatch();
            }
            this.setString(n1, "text", descr);
            this.add(n, n1);
            for (int i = 0; i < clauses.length; ++i) {
                n1 = Luke.create("node");
                BooleanClause.Occur occ = clauses[i].getOccur();
                String occur = occ.equals((Object)BooleanClause.Occur.MUST) ? "MUST" : (occ.equals((Object)BooleanClause.Occur.MUST_NOT) ? "MUST_NOT" : (occ.equals((Object)BooleanClause.Occur.SHOULD) ? "SHOULD" : occ.toString()));
                this.setString(n1, "text", "Clause " + i + ": " + occur);
                this.add(n, n1);
                this._explainStructure(n1, clauses[i].getQuery());
            }
        } else if (clazz.equals("lucene.PrefixQuery")) {
            Object n1 = Luke.create("node");
            PrefixQuery pq = (PrefixQuery)q;
            Term t = pq.getPrefix();
            this.setString(n1, "text", "Prefix: field='" + t.field() + "' text='" + t.text() + "'");
            this.add(n, n1);
            try {
                this.addTermsEnum(n, PrefixQuery.class, pq.getField(), pq);
            }
            catch (Exception e) {
                e.printStackTrace();
                n1 = Luke.create("node");
                this.setString(n1, "text", "TermEnum: Exception " + e.getMessage());
                this.add(n, n1);
            }
        } else if (clazz.equals("lucene.PhraseQuery")) {
            int i;
            PhraseQuery pq = (PhraseQuery)q;
            this.setString(n, "text", this.getString(n, "text") + ", slop=" + pq.getSlop());
            int[] pos = pq.getPositions();
            Term[] terms = pq.getTerms();
            Object n1 = Luke.create("node");
            StringBuffer sb = new StringBuffer("pos: [");
            for (i = 0; i < pos.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("" + pos[i]);
            }
            sb.append("]");
            this.setString(n1, "text", sb.toString());
            this.add(n, n1);
            for (i = 0; i < terms.length; ++i) {
                n1 = Luke.create("node");
                this.setString(n1, "text", "Term " + i + ": field='" + terms[i].field() + "' text='" + terms[i].text() + "'");
                this.add(n, n1);
            }
        } else if (clazz.equals("lucene.MultiPhraseQuery")) {
            MultiPhraseQuery pq = (MultiPhraseQuery)q;
            this.setString(n, "text", this.getString(n, "text") + ", slop=" + pq.getSlop());
            int[] pos = pq.getPositions();
            Object n1 = Luke.create("node");
            StringBuffer sb = new StringBuffer("pos: [");
            for (int i = 0; i < pos.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("" + pos[i]);
            }
            sb.append("]");
            this.setString(n1, "text", sb.toString());
            this.add(n, n1);
            n1 = Luke.create("node");
            System.err.println("MultiPhraseQuery is missing the public getTermArrays() :-(");
            this.setString(n1, "text", "toString: " + pq.toString());
            this.add(n, n1);
        } else if (clazz.equals("lucene.FuzzyQuery")) {
            FuzzyQuery fq = (FuzzyQuery)q;
            Object n1 = Luke.create("node");
            this.setString(n1, "text", "field=" + fq.getField() + ", prefixLen=" + fq.getPrefixLength() + ", maxEdits=" + this.df.format(fq.getMaxEdits()));
            this.add(n, n1);
            try {
                this.addTermsEnum(n, FuzzyQuery.class, fq.getField(), fq);
            }
            catch (Exception e) {
                e.printStackTrace();
                n1 = Luke.create("node");
                this.setString(n1, "text", "TermEnum: Exception " + e.getMessage());
                this.add(n, n1);
            }
        } else if (clazz.equals("lucene.WildcardQuery")) {
            WildcardQuery wq = (WildcardQuery)q;
            Term t = wq.getTerm();
            this.setString(n, "text", this.getString(n, "text") + ", term=" + t);
            Automaton a = WildcardQuery.toAutomaton(t);
            this.addAutomaton(n, a);
        } else if (clazz.equals("lucene.TermRangeQuery")) {
            TermRangeQuery rq = (TermRangeQuery)q;
            this.setString(n, "text", this.getString(n, "text") + ", inclLower=" + rq.includesLower() + ", inclUpper=" + rq.includesUpper());
            Object n1 = Luke.create("node");
            this.setString(n1, "text", "lowerTerm=" + rq.getField() + ":" + rq.getLowerTerm() + "'");
            this.add(n, n1);
            n1 = Luke.create("node");
            this.setString(n1, "text", "upperTerm=" + rq.getField() + ":" + rq.getUpperTerm() + "'");
            this.add(n, n1);
            try {
                this.addTermsEnum(n, TermRangeQuery.class, rq.getField(), rq);
            }
            catch (Exception e) {
                e.printStackTrace();
                n1 = Luke.create("node");
                this.setString(n1, "text", "TermEnum: Exception " + e.getMessage());
                this.add(n, n1);
            }
        } else if (q instanceof AutomatonQuery) {
            AutomatonQuery aq = (AutomatonQuery)q;
            this.setString(n, "text", this.getString(n, "text") + ", " + aq.toString());
            try {
                Field aField = AutomatonQuery.class.getDeclaredField("automaton");
                aField.setAccessible(true);
                Automaton a = (Automaton)aField.get(aq);
                this.addAutomaton(n, a);
            }
            catch (Exception e) {
                e.printStackTrace();
                Object n1 = Luke.create("node");
                this.setString(n1, "text", "Automaton: Exception " + e.getMessage());
                this.add(n, n1);
            }
        } else if (q instanceof MultiTermQuery) {
            MultiTermQuery mq = (MultiTermQuery)q;
            HashSet<Term> terms = new HashSet<Term>();
            mq.extractTerms(terms);
            this.setString(n, "text", this.getString(n, "text") + ", terms: " + terms);
            try {
                this.addTermsEnum(n, TermRangeQuery.class, mq.getField(), mq);
            }
            catch (Exception e) {
                e.printStackTrace();
                Object n1 = Luke.create("node");
                this.setString(n1, "text", "TermEnum: Exception " + e.getMessage());
                this.add(n, n1);
            }
        } else if (q instanceof ConstantScoreQuery) {
            ConstantScoreQuery cq = (ConstantScoreQuery)q;
            this.setString(n, "text", this.getString(n, "text") + ", " + cq.toString());
            Object n1 = Luke.create("node");
            this.add(n, n1);
            if (cq.getFilter() != null) {
                this.setString(n1, "text", "Filter: " + cq.getFilter().toString());
            } else if (cq.getQuery() != null) {
                this._explainStructure(n, cq.getQuery());
            }
        } else if (q instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)q;
            Object n1 = Luke.create("node");
            this.setString(n1, "text", "Filter: " + fq.getFilter().toString());
            this.add(n, n1);
            this._explainStructure(n, fq.getQuery());
        } else if (q instanceof SpanQuery) {
            SpanQuery snq;
            SpanQuery sq = (SpanQuery)q;
            Class<?> sqlass = sq.getClass();
            this.setString(n, "text", this.getString(n, "text") + ", field=" + sq.getField());
            if (sqlass == SpanOrQuery.class) {
                SpanOrQuery soq = (SpanOrQuery)sq;
                this.setString(n, "text", this.getString(n, "text") + ", " + soq.getClauses().length + " clauses");
                for (SpanQuery sq1 : soq.getClauses()) {
                    this._explainStructure(n, sq1);
                }
            } else if (sqlass == SpanFirstQuery.class) {
                SpanFirstQuery sfq = (SpanFirstQuery)sq;
                this.setString(n, "text", this.getString(n, "text") + ", end=" + sfq.getEnd() + ", match:");
                this._explainStructure(n, sfq.getMatch());
            } else if (q instanceof SpanNearQuery) {
                snq = (SpanNearQuery)sq;
                this.setString(n, "text", this.getString(n, "text") + ", slop=" + ((SpanNearQuery)snq).getSlop());
                if (snq instanceof PayloadNearQuery) {
                    try {
                        Field function = PayloadNearQuery.class.getDeclaredField("function");
                        function.setAccessible(true);
                        Object func = function.get(snq);
                        this.setString(n, "text", this.getString(n, "text") + ", func=" + func.getClass().getSimpleName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (SpanQuery sq1 : ((SpanNearQuery)snq).getClauses()) {
                    this._explainStructure(n, sq1);
                }
            } else if (sqlass == SpanNotQuery.class) {
                snq = (SpanNotQuery)sq;
                Object n1 = Luke.create("node");
                this.add(n, n1);
                this.setString(n1, "text", "Include:");
                this._explainStructure(n1, ((SpanNotQuery)snq).getInclude());
                n1 = Luke.create("node");
                this.add(n, n1);
                this.setString(n1, "text", "Exclude:");
                this._explainStructure(n1, ((SpanNotQuery)snq).getExclude());
            } else if (q instanceof SpanTermQuery) {
                SpanTermQuery stq = (SpanTermQuery)sq;
                this.setString(n, "text", this.getString(n, "text") + ", term=" + stq.getTerm());
                if (stq instanceof PayloadTermQuery) {
                    try {
                        Field function = PayloadTermQuery.class.getDeclaredField("function");
                        function.setAccessible(true);
                        Object func = function.get(stq);
                        this.setString(n, "text", this.getString(n, "text") + ", func=" + func.getClass().getSimpleName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String defField = this.getDefaultField(this.find("srchOptTabs"));
                this.setString(n, "text", "class=" + q.getClass().getName() + ", " + this.getString(n, "text") + ", toString=" + q.toString(defField));
                HashSet<Term> terms = new HashSet<Term>();
                sq.extractTerms(terms);
                Object n1 = null;
                if (terms != null) {
                    n1 = Luke.create("node");
                    this.setString(n1, "text", "Matched terms (" + terms.size() + "):");
                    this.add(n, n1);
                    Iterator<Term> it = terms.iterator();
                    while (it.hasNext()) {
                        Object n2 = Luke.create("node");
                        Term t = it.next();
                        this.setString(n2, "text", "field='" + t.field() + "' text='" + t.text() + "'");
                        this.add(n1, n2);
                    }
                } else {
                    n1 = Luke.create("node");
                    this.setString(n1, "text", "<no terms matched>");
                    this.add(n, n1);
                }
            }
            if (this.ir != null) {
                Object n1 = null;
            }
        } else {
            Object n1 = Luke.create("node");
            String defField = this.getDefaultField(this.find("srchOptTabs"));
            HashSet<Term> terms = new HashSet<Term>();
            q.extractTerms(terms);
            this.setString(n1, "text", q.getClass().getName() + ": " + q.toString(defField));
            this.add(n, n1);
            if (!terms.isEmpty()) {
                n1 = Luke.create("node");
                this.setString(n1, "text", "terms: " + terms);
                this.add(n, n1);
            }
        }
    }

    private void addAutomaton(Object parent, Automaton a) {
        Object n = Luke.create("node");
        this.setString(n, "text", "Automaton: " + a != null ? a.toDot() : "null");
        this.add(parent, n);
        Transition t = new Transition();
        for (int state = 0; state < a.getNumStates(); ++state) {
            Object n1 = Luke.create("node");
            this.add(n, n1);
            StringBuilder msg = new StringBuilder();
            msg.append(String.valueOf(state));
            if (state == 0) {
                msg.append(" INITIAL");
            }
            msg.append(a.isAccept(state) ? " [accept]" : " [reject]");
            int numTransitions = a.initTransition(state, t);
            msg.append(", " + numTransitions + " transitions");
            this.setString(n1, "text", msg.toString());
            for (int i = 0; i < numTransitions; ++i) {
                a.getNextTransition(t);
                Object n2 = Luke.create("node");
                this.add(n1, n2);
                this.setString(n2, "text", t.toString());
                assert (t.max >= t.min);
            }
        }
    }

    private void addTermsEnum(Object parent, Class<? extends Query> clz, String field, Query instance) throws Exception {
        Method m = clz.getDeclaredMethod("getTermsEnum", Terms.class, AttributeSource.class);
        m.setAccessible(true);
        Terms terms = this.ar.terms(field);
        TermsEnum fte = (TermsEnum)m.invoke((Object)instance, terms, new AttributeSource());
        Object n1 = Luke.create("node");
        String clazz = fte.getClass().getName();
        this.setString(n1, "text", clazz);
        this.add(parent, n1);
        while (fte.next() != null) {
            Object n2 = Luke.create("node");
            this.setString(n2, "text", "'" + fte.term().utf8ToString() + "', docFreq=" + fte.docFreq() + ", totalTermFreq=" + fte.totalTermFreq());
            this.add(n1, n2);
        }
    }

    public void clipQExplain(Object qExplain) {
        Object tree = this.find(qExplain, "qTree");
        StringBuilder sb = new StringBuilder();
        this.treeToString(tree, sb);
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    private void treeToString(Object tree, StringBuilder sb) {
        if (tree == null) {
            return;
        }
        Object[] items = this.getItems(tree);
        if (items == null || items.length == 0) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append('\n');
            }
            this.treeNodeToString(items[i], sb, 0);
        }
    }

    private void treeNodeToString(Object node, StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append(' ');
        }
        sb.append(this.getString(node, "text"));
        Object[] items = this.getItems(node);
        if (items != null && items.length > 0) {
            sb.append('\n');
            for (int i = 0; i < items.length; ++i) {
                if (i > 0) {
                    sb.append('\n');
                }
                this.treeNodeToString(items[i], sb, level + 2);
            }
        }
    }

    public void showParsed() {
        Object qField = this.find("qField");
        Object qFieldParsed = this.find("qFieldParsed");
        Object qFieldRewritten = this.find("qFieldRewritten");
        String queryS = this.getString(qField, "text");
        if (queryS.trim().equals("")) {
            this.setString(qFieldParsed, "text", "<empty query>");
            this.setBoolean(qFieldParsed, "enabled", false);
            return;
        }
        this.setBoolean(qFieldParsed, "enabled", true);
        try {
            Query q = this.createQuery(queryS);
            if (q == null) {
                return;
            }
            this.setString(qFieldParsed, "text", q.toString());
            this.putProperty(qField, "qParsed", q);
            q = q.rewrite(this.ir);
            this.setString(qFieldRewritten, "text", q.toString());
            this.putProperty(qField, "qRewritten", q);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.setString(qFieldParsed, "text", t.getMessage());
            this.setString(qFieldRewritten, "text", t.getMessage());
        }
    }

    public void search(Object qField) {
        AccessibleHitCollector col;
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.ir.numDocs() == 0) {
            this.showStatus(MSG_EMPTY_INDEX);
            return;
        }
        String queryS = this.getString(qField, "text");
        if (queryS.trim().equals("")) {
            this.showStatus("FAILED: Empty query.");
            return;
        }
        Object srchOpts = this.find("srchOptTabs");
        Similarity sim = this.createSimilarity(srchOpts);
        try {
            col = this.createCollector(srchOpts);
        }
        catch (Throwable t) {
            this.errorMsg("ERROR creating Collector: " + t.getMessage());
            return;
        }
        Object sTable = this.find("sTable");
        Object cntRepeat = this.find("cntRepeat");
        int repeat = Integer.parseInt(this.getString(cntRepeat, "text"));
        this.removeAll(sTable);
        Query q = null;
        try {
            q = this.createQuery(queryS);
            if (q == null) {
                return;
            }
            this.is.setSimilarity(sim);
            this.showParsed();
            this._search(q, this.is, col, sTable, repeat);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.errorMsg(e.getMessage());
        }
    }

    private void _search(final Query q, final IndexSearcher is, AccessibleHitCollector hc, final Object sTable, final int repeat) throws Exception {
        if (hc == null) {
            hc = new AccessibleTopHitCollector(1000, true, true);
        }
        final AccessibleHitCollector collector = hc;
        this.le = null;
        SlowThread t = new SlowThread(this){

            @Override
            public void execute() {
                long startTime = System.nanoTime();
                for (int i = 0; i < repeat; ++i) {
                    if (i > 0) {
                        collector.reset();
                    }
                    try {
                        is.search(q, collector);
                        continue;
                    }
                    catch (LimitedException e) {
                        Luke.this.le = e;
                        continue;
                    }
                    catch (Throwable th) {
                        th.printStackTrace();
                        Luke.this.errorMsg("ERROR searching: " + th.toString());
                        return;
                    }
                }
                long endTime = System.nanoTime();
                long delta = (endTime - startTime) / 1000L / (long)repeat;
                String msg = delta > 100000L ? delta / 1000L + " ms" : delta + " us";
                if (repeat > 1) {
                    msg = msg + " (avg of " + repeat + " runs)";
                }
                Luke.this.showSearchStatus(msg);
                Object bsPrev = Luke.this.find("bsPrev");
                Object bsNext = Luke.this.find("bsNext");
                Luke.this.setBoolean(bsNext, "enabled", false);
                Luke.this.setBoolean(bsPrev, "enabled", false);
                int resNum = collector.getTotalHits();
                if (resNum == 0) {
                    Object row = Thinlet.create("row");
                    Object cell = Thinlet.create("cell");
                    Luke.this.add(sTable, row);
                    Luke.this.add(row, cell);
                    cell = Thinlet.create("cell");
                    Luke.this.add(row, cell);
                    cell = Thinlet.create("cell");
                    Luke.this.setString(cell, "text", "No Results");
                    Luke.this.setBoolean(cell, "enabled", false);
                    Luke.this.add(row, cell);
                    Luke.this.setString(Luke.this.find("resNum"), "text", "0");
                    return;
                }
                if (resNum > Luke.this.resCount) {
                    Luke.this.setBoolean(bsNext, "enabled", true);
                }
                Luke.this.setString(Luke.this.find("resNum"), "text", String.valueOf(resNum));
                Luke.this.putProperty(sTable, "resNum", new Integer(resNum));
                Luke.this.putProperty(sTable, "query", q);
                Luke.this.putProperty(sTable, "hc", collector);
                if (Luke.this.le != null) {
                    Luke.this.putProperty(sTable, "le", Luke.this.le);
                }
                Luke.this.resStart = 0;
                Luke.this._showSearchPage(sTable);
            }
        };
        if (this.slowAccess) {
            t.start();
        } else {
            t.execute();
        }
    }

    public void prevPage(Object sTable) {
        int resNum = (Integer)this.getProperty(sTable, "resNum");
        if (this.resStart == 0) {
            this.setBoolean(this.find("bsPrev"), "enabled", false);
            return;
        }
        this.resStart -= this.resCount;
        if (this.resStart < 0) {
            this.resStart = 0;
        }
        if (this.resStart - this.resCount < 0) {
            this.setBoolean(this.find("bsPrev"), "enabled", false);
        }
        if (this.resStart + this.resCount < resNum) {
            this.setBoolean(this.find("bsNext"), "enabled", true);
        }
        this._showSearchPage(sTable);
    }

    public void nextPage(Object sTable) {
        int resNum = (Integer)this.getProperty(sTable, "resNum");
        this.resStart += this.resCount;
        if (this.resStart >= resNum) {
            this.resStart -= this.resCount;
            this.setBoolean(this.find("bsNext"), "enabled", false);
            return;
        }
        this.setBoolean(this.find("bsPrev"), "enabled", true);
        if (this.resStart + this.resCount >= resNum) {
            this.setBoolean(this.find("bsNext"), "enabled", false);
        }
        this._showSearchPage(sTable);
    }

    private void _showSearchPage(final Object sTable) {
        SlowThread t = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    Luke.this.removeAll(sTable);
                    AccessibleHitCollector hc = (AccessibleHitCollector)Luke.this.getProperty(sTable, "hc");
                    int resNum = hc.getTotalHits();
                    int max = Math.min(resNum, Luke.this.resStart + Luke.this.resCount);
                    Object posLabel = Luke.this.find("resPos");
                    Luke.this.setString(posLabel, "text", Luke.this.resStart + "-" + (max - 1));
                    for (int i = Luke.this.resStart; i < max; ++i) {
                        int docid = hc.getDocId(i);
                        float score = hc.getScore(i);
                        Luke.this._createResultRow(i, docid, score, sTable);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            t.start();
        } else {
            t.execute();
        }
    }

    private void _createResultRow(int pos, int docId, float score, Object sTable) throws IOException {
        Object row = Luke.create("row");
        Object cell = Luke.create("cell");
        this.add(sTable, row);
        this.setString(cell, "text", String.valueOf(pos));
        this.setChoice(cell, "alignment", "right");
        this.add(row, cell);
        cell = Luke.create("cell");
        this.setString(cell, "text", String.valueOf(this.df.format(score)));
        this.setChoice(cell, "alignment", "right");
        this.add(row, cell);
        cell = Luke.create("cell");
        this.setString(cell, "text", String.valueOf(docId));
        this.setChoice(cell, "alignment", "right");
        this.add(row, cell);
        Document doc = this.ir.document(docId);
        this.putProperty(row, "docid", new Integer(docId));
        StringBuffer vals = new StringBuffer();
        for (int j = 0; j < this.idxFields.length; ++j) {
            cell = Luke.create("cell");
            Decoder dec = this.decoders.get(this.idxFields[j]);
            if (dec == null) {
                dec = this.defDecoder;
            }
            IndexableField[] values = doc.getFields(this.idxFields[j]);
            vals.setLength(0);
            boolean decodeErr = false;
            if (values != null) {
                for (int k = 0; k < values.length; ++k) {
                    String v;
                    if (k > 0) {
                        vals.append(' ');
                    }
                    try {
                        v = dec.decodeStored(this.idxFields[j], (org.apache.lucene.document.Field)values[k]);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        v = values[k].stringValue();
                        decodeErr = true;
                    }
                    vals.append(Util.escape(v));
                }
            }
            this.setString(cell, "text", vals.toString());
            if (decodeErr) {
                this.setColor(cell, "foreground", Color.RED);
            }
            this.add(row, cell);
        }
    }

    public void explainResult(Object sTable) {
        Object row = this.getSelectedItem(sTable);
        if (row == null) {
            return;
        }
        final Integer docid = (Integer)this.getProperty(row, "docid");
        if (docid == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        final Query q = (Query)this.getProperty(sTable, "query");
        if (q == null) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    IndexSearcher is = new IndexSearcher(Luke.this.ir);
                    Similarity sim = Luke.this.createSimilarity(Luke.this.find("srchOptTabs"));
                    is.setSimilarity(sim);
                    Explanation expl = is.explain(q, (int)docid);
                    Object dialog = Luke.this.addComponent(null, "/xml/explain.xml", null, null);
                    Object eTree = Luke.this.find(dialog, "eTree");
                    Luke.this.addNode(eTree, expl);
                    Luke.this.add(dialog);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.errorMsg(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            t.start();
        } else {
            t.run();
        }
    }

    public void clipExplain(Object explain) {
        Object eTree = this.find(explain, "eTree");
        StringBuilder sb = new StringBuilder();
        this.treeToString(eTree, sb);
        StringSelection sel = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, this);
    }

    private void addNode(Object tree, Explanation expl) {
        Explanation[] kids;
        Object node = Luke.create("node");
        this.setString(node, "text", this.df.format(expl.getValue()) + "  " + expl.getDescription());
        this.add(tree, node);
        if (Luke.getClass(tree) == "tree") {
            this.setFont(node, this.getFont().deriveFont(1));
        }
        if ((kids = expl.getDetails()) != null && kids.length > 0) {
            for (int i = 0; i < kids.length; ++i) {
                this.addNode(node, kids[i]);
            }
        }
    }

    public void gotoDoc(Object sTable) {
        Object row = this.getSelectedItem(sTable);
        if (row == null) {
            return;
        }
        final Integer docid = (Integer)this.getProperty(row, "docid");
        if (docid == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                Document doc = null;
                try {
                    doc = Luke.this.ir.document(docid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                    return;
                }
                Luke.this._showDocFields(docid, doc);
                Object tabpane = Luke.this.find("maintpane");
                Luke.this.setInteger(tabpane, "selected", 1);
                Luke.this.repaint();
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    private void _showTermDoc(Object fText, final DocsEnum td) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        SlowThread st = new SlowThread(this){

            @Override
            public void execute() {
                try {
                    Document doc = Luke.this.ir.document(td.docID());
                    Luke.this.setString(Luke.this.find("docNum"), "text", String.valueOf(td.docID()));
                    Luke.this.setString(Luke.this.find("tFreq"), "text", String.valueOf(td.freq()));
                    Luke.this._showDocFields(td.docID(), doc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Luke.this.showStatus(e.getMessage());
                }
            }
        };
        if (this.slowAccess) {
            st.start();
        } else {
            st.execute();
        }
    }

    public void deleteTermDoc(Object fText) {
        Term t = (Term)this.getProperty(fText, "term");
        if (t == null) {
            return;
        }
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        try {
            IndexWriter iw = this.createIndexWriter();
            iw.deleteDocuments(t);
            iw.close();
            this.refreshAfterWrite();
            this.infoMsg("Deleted docs for query '" + t + "'. Term dictionary and statistics will be incorrect until next merge or expunge deletes.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMsg("Error deleting doc: " + e.toString());
        }
    }

    public void deleteDocs(Object sTable) {
        if (this.ir == null) {
            this.showStatus(MSG_NOINDEX);
            return;
        }
        if (this.readOnly) {
            this.showStatus(MSG_READONLY);
            return;
        }
        Query q = (Query)this.getProperty(sTable, "query");
        if (q == null) {
            this.errorMsg("Empty query.");
            return;
        }
        this.removeAll(sTable);
        try {
            IndexWriter iw = this.createIndexWriter();
            iw.deleteDocuments(q);
            iw.close();
            this.refreshAfterWrite();
            this.infoMsg("Deleted docs for query '" + q + "'. Term dictionary and statistics will be incorrect until next merge or expunge deletes.");
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.errorMsg("Error deleting documents: " + e.toString());
        }
    }

    public void actionAbout() {
        Object about = this.addComponent(this, "/xml/about.xml", null, null);
        Object lver = this.find(about, "lver");
        this.setString(lver, "text", "Lucene version: " + LV.toString());
    }

    public void actionShowFonts() {
        this.addComponent(this, "/xml/selfont.xml", null, null);
    }

    public void setupSelFont(Object selfont) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        Object cbFonts = this.find(selfont, "fonts");
        String curfont = this.getFont().getFontName();
        float cursize = this.getFont().getSize2D();
        Object fsize = this.find(selfont, "fsize");
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(1);
        this.setString(fsize, "text", nf.format(cursize));
        this.removeAll(cbFonts);
        Object def = Luke.create("choice");
        this.setFont(def, "font", this.getFont().deriveFont(15.0f));
        this.setString(def, "text", curfont + " (default)");
        this.putProperty(def, "fnt", this.getFont());
        this.add(cbFonts, def);
        this.setInteger(cbFonts, "selected", 0);
        for (int i = 0; i < fonts.length; ++i) {
            Object choice = Luke.create("choice");
            this.setFont(choice, "font", fonts[i].deriveFont(15.0f));
            this.setString(choice, "text", fonts[i].getFontName());
            this.putProperty(choice, "fnt", fonts[i]);
            this.add(cbFonts, choice);
            if (!curfont.equalsIgnoreCase(fonts[i].getFontName())) continue;
            this.setInteger(cbFonts, "selected", i + 1);
        }
    }

    public void selectFont(Object selfont) {
        Object preview = this.find(selfont, "fpreview");
        Object cbFonts = this.find(selfont, "fonts");
        Object fsize = this.find(selfont, "fsize");
        Font f = (Font)this.getProperty(this.getSelectedItem(cbFonts), "fnt");
        float size = this.getFont().getSize2D();
        try {
            size = Float.parseFloat(this.getString(fsize, "text"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f = f.deriveFont(size);
        Object[] items = this.getItems(preview);
        for (int i = 0; i < items.length; ++i) {
            this.setPreviewFont(f, items[i]);
        }
    }

    private void setPreviewFont(Font f, Object item) {
        try {
            this.setFont(item, "font", f);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Object[] items = this.getItems(item);
        for (int i = 0; i < items.length; ++i) {
            this.setPreviewFont(f, items[i]);
        }
    }

    public void actionSetFont(Object selfont) {
        Object cbFonts = this.find(selfont, "fonts");
        Object fsize = this.find(selfont, "fsize");
        Font f = (Font)this.getProperty(this.getSelectedItem(cbFonts), "fnt");
        float size = this.getFont().getSize2D();
        try {
            size = Float.parseFloat(this.getString(fsize, "text"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f = f.deriveFont(size);
        this.remove(selfont);
        this.setFont(f);
        this.courier = new Font("Courier", this.getFont().getStyle(), this.getFont().getSize());
        this.repaint();
    }

    public void actionSetDecoder(Object fList, Object combo) {
        Object row = this.getSelectedItem(fList);
        if (row == null) {
            return;
        }
        String fName = (String)this.getProperty(row, "fName");
        Object choice = this.getSelectedItem(combo);
        String decName = this.getString(choice, "name");
        Decoder dec = null;
        if (decName.equals("s")) {
            dec = new StringDecoder();
        } else if (decName.equals("b")) {
            dec = new BinaryDecoder();
        } else if (decName.equals("d")) {
            dec = new DateDecoder();
        } else if (decName.equals("nl")) {
            dec = new NumLongDecoder();
        } else if (decName.equals("ni")) {
            dec = new NumIntDecoder();
        } else if (decName.startsWith("solr.")) {
            try {
                dec = new SolrDecoder(decName);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.errorMsg("Error setting decoder: " + e.toString());
            }
        } else {
            dec = this.defDecoder;
        }
        this.decoders.put(fName, dec);
        Object cell = this.getItem(row, 3);
        this.setString(cell, "text", ((Object)dec).toString());
        this.repaint(fList);
        this.actionTopTerms(this.find("nTerms"));
    }

    public Similarity getCustomSimilarity() {
        return this.similarity;
    }

    public void setCustomSimilarity(Similarity s) {
        this.similarity = s;
        Object cbSimCust = this.find("ckSimCust");
        Object cbSimDef = this.find("ckSimDef");
        Object simName = this.find("simName");
        if (this.similarity != null) {
            this.setString(simName, "text", this.similarity.getClass().getName());
            this.setBoolean(cbSimCust, "enabled", true);
        } else {
            this.setString(simName, "text", "");
            this.setBoolean(cbSimCust, "enabled", false);
            this.setBoolean(cbSimDef, "selected", true);
            this.setBoolean(cbSimCust, "selected", false);
        }
    }

    public void actionDesignSimilarity() {
        LukePlugin designer = null;
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (!this.plugins.get(i).getClass().getName().equals("org.getopt.luke.plugins.SimilarityDesignerPlugin")) continue;
            designer = this.plugins.get(i);
            break;
        }
        if (designer == null) {
            this.showStatus("Designer Plugin not available");
            return;
        }
        Object pluginsTab = this.find("pluginsTab");
        Object maintab = this.getParent(pluginsTab);
        int index = this.getIndex(maintab, pluginsTab);
        this.setInteger(maintab, "selected", index);
        Object pluginsTabs = this.find("pluginsTabs");
        Object tab = this.getParent(this.getParent(designer.getMyUi()));
        index = this.getIndex(pluginsTabs, tab);
        this.setInteger(pluginsTabs, "selected", index);
        this.repaint();
    }

    @Override
    public boolean destroy() {
        if (this.ir != null) {
            try {
                this.ir.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.ar != null) {
            try {
                this.ar.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.dir != null) {
            try {
                this.dir.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            Prefs.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exitOnDestroy) {
            System.exit(0);
        }
        return super.destroy();
    }

    public void actionExit() {
        this.destroy();
    }

    public void goUrl(Object url) {
        String u = (String)this.getProperty(url, "url");
        if (u == null) {
            return;
        }
        try {
            BrowserLauncher.openURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showStatus(e.getMessage());
        }
    }

    public static Luke startLuke(String[] args) {
        Luke luke = new Luke();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
        Calendar cal = Calendar.getInstance();
        FrameLauncher f = new FrameLauncher("Luke - Lucene Index Toolbox (" + LV.toString() + ")", luke, 850, 650);
        f.setIconImage(Toolkit.getDefaultToolkit().createImage(Luke.class.getResource("/img/luke.gif")));
        if (args.length > 0) {
            boolean force = false;
            boolean ro = false;
            boolean ramdir = false;
            String pName = null;
            String script = null;
            String xmlQueryParserFactoryClassName = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-ro")) {
                    ro = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-force")) {
                    force = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-ramdir")) {
                    ramdir = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-index")) {
                    pName = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-script")) {
                    script = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-xmlQueryParserFactory")) {
                    xmlQueryParserFactoryClassName = args[++i];
                    continue;
                }
                System.err.println("Unknown argument: " + args[i]);
                Luke.usage();
                luke.actionExit();
                return null;
            }
            if (pName != null) {
                luke.openIndex(pName, force, null, ro, ramdir, false, null, 1);
            }
            if (xmlQueryParserFactoryClassName != null) {
                luke.setParserFactoryClassName(xmlQueryParserFactoryClassName);
            }
            if (script != null) {
                LukePlugin plugin = luke.getPlugin("org.getopt.luke.plugins.ScriptingPlugin");
                if (plugin == null) {
                    String msg = "ScriptingPlugin not present - cannot execute scripts.";
                    System.err.println(msg);
                    luke.actionExit();
                } else {
                    ((ScriptingPlugin)plugin).execute("load('" + script + "');");
                }
            }
        } else {
            luke.actionOpen();
        }
        return luke;
    }

    private void setParserFactoryClassName(String xmlQueryParserFactoryClassName) {
        this.xmlQueryParserFactoryClassName = xmlQueryParserFactoryClassName;
    }

    public static void main(String[] args) {
        exitOnDestroy = true;
        Luke.startLuke(args);
    }

    public static void usage() {
        System.err.println("Command-line usage:\n");
        System.err.println("Luke [-index path_to_index] [-ro] [-force] [-mmap] [-script filename]\n");
        System.err.println("\t-index path_to_index\topen this index");
        System.err.println("\t-ro\topen index read-only");
        System.err.println("\t-force\tforce unlock if the index is locked (use with caution)");
        System.err.println("\t-xmlQueryParserFactory\tFactory for loading custom XMLQueryParsers. E.g.:");
        System.err.println("\t\t\torg.getopt.luke.xmlQuery.CoreParserFactory (default)");
        System.err.println("\t\t\torg.getopt.luke.xmlQuery.CorePlusExtensionsParserFactory");
        System.err.println("\t-mmap\tuse MMapDirectory");
        System.err.println("\t-script filename\trun this script using the ScriptingPlugin.");
        System.err.println("\t\tIf an index name is specified, the index is open prior to");
        System.err.println("\t\tstarting the script. Note that you need to escape special");
        System.err.println("\t\tcharacters twice - first for shell and then for JavaScript.");
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public void sort(Object grid, Object header) {
        Object defFld = this.find("defFld");
        Object fCombo = this.find("fCombo");
        this.initFieldList(grid, fCombo, defFld);
    }

    public void setColumn(String name) {
        System.out.println("name=" + name);
    }

    class ValueComparator
    implements Comparator<String> {
        Map<String, FieldTermCount> base;

        public ValueComparator(Map<String, FieldTermCount> base) {
            this.base = base;
        }

        @Override
        public int compare(String a, String b) {
            return this.base.get(a).compareToValues(this.base.get(b));
        }
    }
}

