/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.getopt.luke.LimitedException;
import org.getopt.luke.LimitedHitCollector;
import org.getopt.luke.NoScoringScorer;

public class IntervalLimitedCollector
extends LimitedHitCollector {
    private long maxTime;
    private long lastDoc = 0L;
    private TopScoreDocCollector tdc;
    private TopDocs topDocs = null;
    private TimeLimitingCollector thc;

    public IntervalLimitedCollector(int maxTime, boolean outOfOrder, boolean shouldScore) {
        this.maxTime = maxTime;
        this.outOfOrder = outOfOrder;
        this.shouldScore = shouldScore;
        this.tdc = TopScoreDocCollector.create(1000, outOfOrder);
        this.thc = new TimeLimitingCollector(this.tdc, TimeLimitingCollector.getGlobalCounter(), maxTime);
    }

    @Override
    public long limitSize() {
        return this.maxTime;
    }

    @Override
    public int limitType() {
        return 0;
    }

    @Override
    public int getDocId(int pos) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[pos].doc;
    }

    @Override
    public float getScore(int pos) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[pos].score;
    }

    @Override
    public int getTotalHits() {
        return this.tdc.getTotalHits();
    }

    @Override
    public void collect(int docNum) throws IOException {
        try {
            this.thc.collect(docNum);
        }
        catch (TimeLimitingCollector.TimeExceededException tee) {
            throw new LimitedException(0, this.maxTime, tee.getTimeElapsed(), tee.getLastDocCollected());
        }
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.outOfOrder;
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.docBase = context.docBase;
        this.thc.setNextReader(context);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        if (this.shouldScore) {
            this.thc.setScorer(scorer);
        } else {
            this.thc.setScorer(NoScoringScorer.INSTANCE);
        }
    }

    @Override
    public void reset() {
        this.lastDoc = 0L;
        this.tdc = TopScoreDocCollector.create(1000, this.outOfOrder);
        this.thc = new TimeLimitingCollector(this.tdc, TimeLimitingCollector.getGlobalCounter(), this.maxTime);
    }
}

