/*
 * Decompiled with CFR 0.152.
 */
package org.getopt.luke;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.getopt.luke.LimitedException;
import org.getopt.luke.LimitedHitCollector;
import org.getopt.luke.NoScoringScorer;

public class CountLimitedHitCollector
extends LimitedHitCollector {
    private int maxSize;
    private int count;
    private int lastDoc;
    private TopScoreDocCollector tdc;
    private TopDocs topDocs = null;

    public CountLimitedHitCollector(int maxSize, boolean outOfOrder, boolean shouldScore) {
        this.maxSize = maxSize;
        this.outOfOrder = outOfOrder;
        this.shouldScore = shouldScore;
        this.count = 0;
        this.tdc = TopScoreDocCollector.create(maxSize, outOfOrder);
    }

    @Override
    public long limitSize() {
        return this.maxSize;
    }

    @Override
    public int limitType() {
        return 1;
    }

    @Override
    public void collect(int doc) throws IOException {
        ++this.count;
        if (this.count > this.maxSize) {
            --this.count;
            throw new LimitedException(1, this.maxSize, this.count, this.lastDoc);
        }
        this.lastDoc = this.docBase + doc;
        this.tdc.collect(doc);
    }

    @Override
    public int getDocId(int pos) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[pos].doc;
    }

    @Override
    public float getScore(int pos) {
        if (this.topDocs == null) {
            this.topDocs = this.tdc.topDocs();
        }
        return this.topDocs.scoreDocs[pos].score;
    }

    @Override
    public int getTotalHits() {
        return this.count;
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return this.tdc.acceptsDocsOutOfOrder();
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.docBase = context.docBase;
        this.tdc.setNextReader(context);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.shouldScore) {
            this.tdc.setScorer(scorer);
        } else {
            this.tdc.setScorer(NoScoringScorer.INSTANCE);
        }
    }

    @Override
    public void reset() {
        this.count = 0;
        this.lastDoc = 0;
        this.topDocs = null;
        this.tdc = TopScoreDocCollector.create(this.maxSize, this.outOfOrder);
    }
}

