/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.LocaleUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.processor.AllValuesOrNoneFieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseDateFieldUpdateProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    public static final Logger log = LoggerFactory.getLogger(ParseDateFieldUpdateProcessorFactory.class);
    private static final String FORMATS_PARAM = "format";
    private static final String DEFAULT_TIME_ZONE_PARAM = "defaultTimeZone";
    private static final String LOCALE_PARAM = "locale";
    private Map<String, DateTimeFormatter> formats = new LinkedHashMap<String, DateTimeFormatter>();

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new AllValuesOrNoneFieldMutatingUpdateProcessor(this.getSelector(), next){

            @Override
            protected Object mutateValue(Object srcVal) {
                if (srcVal instanceof CharSequence) {
                    String srcStringVal = srcVal.toString();
                    for (Map.Entry format : ParseDateFieldUpdateProcessorFactory.this.formats.entrySet()) {
                        DateTimeFormatter parser = (DateTimeFormatter)format.getValue();
                        try {
                            DateTime dateTime = parser.parseDateTime(srcStringVal);
                            return dateTime.withZone(DateTimeZone.UTC).toDate();
                        }
                        catch (IllegalArgumentException e) {
                            log.debug("value '{}' is not parseable with format '{}'", new Object[]{srcStringVal, format.getKey()});
                        }
                    }
                    log.debug("value '{}' was not parsed by any configured format, thus was not mutated", (Object)srcStringVal);
                    return SKIP_FIELD_VALUE_LIST_SINGLETON;
                }
                if (srcVal instanceof Date) {
                    return srcVal;
                }
                return SKIP_FIELD_VALUE_LIST_SINGLETON;
            }
        };
    }

    @Override
    public void init(NamedList args) {
        Collection<String> formatsParam;
        Locale locale = Locale.ROOT;
        String localeParam = (String)args.remove(LOCALE_PARAM);
        if (null != localeParam) {
            locale = LocaleUtils.toLocale(localeParam);
        }
        Object defaultTimeZoneParam = args.remove(DEFAULT_TIME_ZONE_PARAM);
        DateTimeZone defaultTimeZone = DateTimeZone.UTC;
        if (null != defaultTimeZoneParam) {
            defaultTimeZone = DateTimeZone.forID(defaultTimeZoneParam.toString());
        }
        if (null != (formatsParam = args.removeConfigArgs(FORMATS_PARAM))) {
            for (String value : formatsParam) {
                this.formats.put(value, DateTimeFormat.forPattern(value).withZone(defaultTimeZone).withLocale(locale));
            }
        }
        super.init(args);
    }

    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(final SolrCore core) {
        return new FieldMutatingUpdateProcessor.FieldNameSelector(){

            @Override
            public boolean shouldMutate(String fieldName) {
                IndexSchema schema = core.getLatestSchema();
                FieldType type = schema.getFieldTypeNoEx(fieldName);
                return null == type || type instanceof DateValueFieldType;
            }
        };
    }
}

