/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.TransactionLog;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLog
implements PluginInfoInitialized {
    public static String LOG_FILENAME_PATTERN = "%s.%019d";
    public static String TLOG_NAME = "tlog";
    public static Logger log = LoggerFactory.getLogger(UpdateLog.class);
    public boolean debug = log.isDebugEnabled();
    public boolean trace = log.isTraceEnabled();
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int DELETE_BY_QUERY = 3;
    public static final int COMMIT = 4;
    public static final int FLAG_GAP = 16;
    public static final int OPERATION_MASK = 15;
    long id = -1L;
    protected State state = State.ACTIVE;
    protected int operationFlags;
    protected TransactionLog tlog;
    protected TransactionLog prevTlog;
    protected Deque<TransactionLog> logs = new LinkedList<TransactionLog>();
    protected LinkedList<TransactionLog> newestLogsOnStartup = new LinkedList();
    protected int numOldRecords;
    protected Map<BytesRef, LogPtr> map = new HashMap<BytesRef, LogPtr>();
    protected Map<BytesRef, LogPtr> prevMap;
    protected Map<BytesRef, LogPtr> prevMap2;
    protected TransactionLog prevMapLog;
    protected TransactionLog prevMapLog2;
    protected final int numDeletesToKeep = 1000;
    protected final int numDeletesByQueryToKeep = 100;
    public final int numRecordsToKeep = 100;
    protected LinkedHashMap<BytesRef, LogPtr> oldDeletes = new LinkedHashMap<BytesRef, LogPtr>(1000){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    };
    protected LinkedList<DBQ> deleteByQueries = new LinkedList();
    protected String[] tlogFiles;
    protected File tlogDir;
    protected Collection<String> globalStrings;
    protected String dataDir;
    protected String lastDataDir;
    protected VersionInfo versionInfo;
    protected SyncLevel defaultSyncLevel = SyncLevel.FLUSH;
    volatile UpdateHandler uhandler;
    protected volatile boolean cancelApplyBufferUpdate;
    List<Long> startingVersions;
    int startingOperation;
    public static Runnable testing_logReplayHook;
    public static Runnable testing_logReplayFinishHook;
    protected RecoveryInfo recoveryInfo;
    ThreadPoolExecutor recoveryExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultSolrThreadFactory("recoveryExecutor"));

    public FileSystem getFs() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalLogsSize() {
        long size = 0L;
        Deque<TransactionLog> deque = this.logs;
        synchronized (deque) {
            for (TransactionLog log : this.logs) {
                size += log.getLogSize();
            }
        }
        return size;
    }

    public long getTotalLogsNumber() {
        return this.logs.size();
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public void init(PluginInfo info) {
        this.dataDir = (String)info.initArgs.get("dir");
        this.defaultSyncLevel = SyncLevel.getSyncLevel((String)info.initArgs.get("syncLevel"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(UpdateHandler uhandler, SolrCore core) {
        String ulogDir = core.getCoreDescriptor().getUlogDir();
        if (ulogDir != null) {
            this.dataDir = ulogDir;
        }
        if (this.dataDir == null || this.dataDir.length() == 0) {
            this.dataDir = core.getDataDir();
        }
        this.uhandler = uhandler;
        if (this.dataDir.equals(this.lastDataDir)) {
            if (this.debug) {
                log.debug("UpdateHandler init: tlogDir=" + this.tlogDir + ", next id=" + this.id, (Object)" this is a reopen... nothing else to do.");
            }
            this.versionInfo.reload();
            return;
        }
        this.lastDataDir = this.dataDir;
        this.tlogDir = new File(this.dataDir, TLOG_NAME);
        this.tlogDir.mkdirs();
        this.tlogFiles = this.getLogList(this.tlogDir);
        this.id = this.getLastLogId() + 1L;
        if (this.debug) {
            log.debug("UpdateHandler init: tlogDir=" + this.tlogDir + ", existing tlogs=" + Arrays.asList(this.tlogFiles) + ", next id=" + this.id);
        }
        TransactionLog oldLog = null;
        for (String oldLogName : this.tlogFiles) {
            File f = new File(this.tlogDir, oldLogName);
            try {
                oldLog = new TransactionLog(f, null, true);
                this.addOldLog(oldLog, false);
            }
            catch (Exception e) {
                SolrException.log(log, "Failure to open existing log file (non fatal) " + f, e);
                UpdateLog.deleteFile(f);
            }
        }
        for (TransactionLog ll : this.logs) {
            this.newestLogsOnStartup.addFirst(ll);
            if (this.newestLogsOnStartup.size() < 2) continue;
            break;
        }
        try {
            this.versionInfo = new VersionInfo(this, 256);
        }
        catch (SolrException e) {
            log.error("Unable to use updateLog: " + e.getMessage(), e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to use updateLog: " + e.getMessage(), (Throwable)e);
        }
        try (RecentUpdates startingUpdates = this.getRecentUpdates();){
            int i;
            this.startingVersions = startingUpdates.getVersions(100);
            this.startingOperation = startingUpdates.getLatestOperation();
            for (i = startingUpdates.deleteList.size() - 1; i >= 0; --i) {
                DeleteUpdate du = startingUpdates.deleteList.get(i);
                this.oldDeletes.put(new BytesRef(du.id), new LogPtr(-1L, du.version));
            }
            for (i = startingUpdates.deleteByQueryList.size() - 1; i >= 0; --i) {
                Update update = startingUpdates.deleteByQueryList.get(i);
                List dbq = (List)update.log.lookup(update.pointer);
                long version = (Long)dbq.get(1);
                String q = (String)dbq.get(2);
                this.trackDeleteByQuery(q, version);
            }
        }
    }

    public String getLogDir() {
        return this.tlogDir.getAbsolutePath();
    }

    public List<Long> getStartingVersions() {
        return this.startingVersions;
    }

    public int getStartingOperation() {
        return this.startingOperation;
    }

    protected void addOldLog(TransactionLog oldLog, boolean removeOld) {
        TransactionLog log;
        int nrec;
        if (oldLog == null) {
            return;
        }
        this.numOldRecords += oldLog.numRecords();
        int currRecords = this.numOldRecords;
        if (oldLog != this.tlog && this.tlog != null) {
            currRecords += this.tlog.numRecords();
        }
        while (removeOld && this.logs.size() > 0 && (currRecords - (nrec = (log = this.logs.peekLast()).numRecords()) >= 100 || this.logs.size() >= 10)) {
            currRecords -= nrec;
            this.numOldRecords -= nrec;
            this.logs.removeLast().decref();
        }
        this.logs.addFirst(oldLog);
    }

    public String[] getLogList(File directory) {
        final String prefix = TLOG_NAME + '.';
        Object[] names = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix);
            }
        });
        if (names == null) {
            throw new RuntimeException(new FileNotFoundException(directory.getAbsolutePath()));
        }
        Arrays.sort(names);
        return names;
    }

    public long getLastLogId() {
        if (this.id != -1L) {
            return this.id;
        }
        if (this.tlogFiles.length == 0) {
            return -1L;
        }
        String last = this.tlogFiles[this.tlogFiles.length - 1];
        return Long.parseLong(last.substring(TLOG_NAME.length() + 1));
    }

    public void add(AddUpdateCommand cmd) {
        this.add(cmd, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddUpdateCommand cmd, boolean clearCaches) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            long pos = -1L;
            if ((cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                this.ensureLog();
                pos = this.tlog.write(cmd, this.operationFlags);
            }
            if (!clearCaches) {
                LogPtr ptr = new LogPtr(pos, cmd.getVersion());
                if ((cmd.getFlags() & UpdateCommand.BUFFERING) == 0) {
                    this.map.put(cmd.getIndexedId(), ptr);
                }
                if (this.trace) {
                    log.trace("TLOG: added id " + cmd.getPrintableId() + " to " + this.tlog + " " + ptr + " map=" + System.identityHashCode(this.map));
                }
            } else {
                if (this.map != null) {
                    this.map.clear();
                }
                if (this.prevMap != null) {
                    this.prevMap.clear();
                }
                if (this.prevMap2 != null) {
                    this.prevMap2.clear();
                }
                try {
                    RefCounted<SolrIndexSearcher> holder = this.uhandler.core.openNewSearcher(true, true);
                    holder.decref();
                }
                catch (Exception e) {
                    SolrException.log(log, "Error opening realtime searcher for deleteByQuery", e);
                }
                if (this.trace) {
                    log.trace("TLOG: added id " + cmd.getPrintableId() + " to " + this.tlog + " clearCaches=true");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DeleteUpdateCommand cmd) {
        BytesRef br = cmd.getIndexedId();
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            long pos = -1L;
            if ((cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                this.ensureLog();
                pos = this.tlog.writeDelete(cmd, this.operationFlags);
            }
            LogPtr ptr = new LogPtr(pos, cmd.version);
            if ((cmd.getFlags() & UpdateCommand.BUFFERING) == 0) {
                this.map.put(br, ptr);
                this.oldDeletes.put(br, ptr);
            }
            if (this.trace) {
                log.trace("TLOG: added delete for id " + cmd.id + " to " + this.tlog + " " + ptr + " map=" + System.identityHashCode(this.map));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByQuery(DeleteUpdateCommand cmd) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            long pos = -1L;
            if ((cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                this.ensureLog();
                pos = this.tlog.writeDeleteByQuery(cmd, this.operationFlags);
            }
            if ((cmd.getFlags() & UpdateCommand.BUFFERING) == 0) {
                if (this.map != null) {
                    this.map.clear();
                }
                if (this.prevMap != null) {
                    this.prevMap.clear();
                }
                if (this.prevMap2 != null) {
                    this.prevMap2.clear();
                }
                this.trackDeleteByQuery(cmd.getQuery(), cmd.getVersion());
                try {
                    RefCounted<SolrIndexSearcher> holder = this.uhandler.core.openNewSearcher(true, true);
                    holder.decref();
                }
                catch (Exception e) {
                    SolrException.log(log, "Error opening realtime searcher for deleteByQuery", e);
                }
            }
            LogPtr ptr = new LogPtr(pos, cmd.getVersion());
            if (this.trace) {
                log.trace("TLOG: added deleteByQuery " + cmd.query + " to " + this.tlog + " " + ptr + " map=" + System.identityHashCode(this.map));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            try {
                RefCounted<SolrIndexSearcher> holder = this.uhandler.core.openNewSearcher(true, true);
                holder.decref();
            }
            catch (Exception e) {
                SolrException.log(log, "Error opening realtime searcher for deleteByQuery", e);
            }
            if (this.map != null) {
                this.map.clear();
            }
            if (this.prevMap != null) {
                this.prevMap.clear();
            }
            if (this.prevMap2 != null) {
                this.prevMap2.clear();
            }
            this.oldDeletes.clear();
            this.deleteByQueries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackDeleteByQuery(String q, long version) {
        version = Math.abs(version);
        DBQ dbq = new DBQ();
        dbq.q = q;
        dbq.version = version;
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.deleteByQueries.isEmpty() || this.deleteByQueries.getFirst().version < version) {
                this.deleteByQueries.addFirst(dbq);
            } else {
                ListIterator<DBQ> iter = this.deleteByQueries.listIterator();
                iter.next();
                while (iter.hasNext()) {
                    DBQ oldDBQ = (DBQ)iter.next();
                    if (oldDBQ.version < version) {
                        iter.previous();
                        break;
                    }
                    if (oldDBQ.version != version || !oldDBQ.q.equals(q)) continue;
                    return;
                }
                iter.add(dbq);
            }
            if (this.deleteByQueries.size() > 100) {
                this.deleteByQueries.removeLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBQ> getDBQNewer(long version) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.deleteByQueries.isEmpty() || this.deleteByQueries.getFirst().version < version) {
                return null;
            }
            ArrayList<DBQ> dbqList = new ArrayList<DBQ>();
            for (DBQ dbq : this.deleteByQueries) {
                if (dbq.version <= version) break;
                dbqList.add(dbq);
            }
            return dbqList;
        }
    }

    protected void newMap() {
        this.prevMap2 = this.prevMap;
        this.prevMapLog2 = this.prevMapLog;
        this.prevMap = this.map;
        this.prevMapLog = this.tlog;
        this.map = new HashMap<BytesRef, LogPtr>();
    }

    private void clearOldMaps() {
        this.prevMap = null;
        this.prevMap2 = null;
    }

    public boolean hasUncommittedChanges() {
        return this.tlog != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCommit(CommitUpdateCommand cmd) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.debug) {
                log.debug("TLOG: preCommit");
            }
            if (this.getState() != State.ACTIVE && (cmd.getFlags() & UpdateCommand.REPLAY) == 0) {
                return;
            }
            this.newMap();
            if (this.prevTlog != null) {
                this.globalStrings = this.prevTlog.getGlobalStrings();
            }
            this.prevTlog = this.tlog;
            this.tlog = null;
            ++this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCommit(CommitUpdateCommand cmd) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.debug) {
                log.debug("TLOG: postCommit");
            }
            if (this.prevTlog != null) {
                this.prevTlog.writeCommit(cmd, this.operationFlags);
                this.addOldLog(this.prevTlog, true);
                this.prevTlog = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSoftCommit(CommitUpdateCommand cmd) {
        this.debug = log.isDebugEnabled();
        this.trace = log.isTraceEnabled();
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (!cmd.softCommit) {
                return;
            }
            this.newMap();
            this.map = new HashMap<BytesRef, LogPtr>();
            if (this.debug) {
                log.debug("TLOG: preSoftCommit: prevMap=" + System.identityHashCode(this.prevMap) + " new map=" + System.identityHashCode(this.map));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSoftCommit(CommitUpdateCommand cmd) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            if (this.debug) {
                SolrCore.verbose("TLOG: postSoftCommit: disposing of prevMap=" + System.identityHashCode(this.prevMap) + ", prevMap2=" + System.identityHashCode(this.prevMap2));
            }
            this.clearOldMaps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(BytesRef indexedId) {
        TransactionLog lookupLog;
        LogPtr entry;
        Object object = this;
        synchronized (object) {
            entry = this.map.get(indexedId);
            lookupLog = this.tlog;
            if (entry == null && this.prevMap != null) {
                entry = this.prevMap.get(indexedId);
                lookupLog = this.prevMapLog;
            }
            if (entry == null && this.prevMap2 != null) {
                entry = this.prevMap2.get(indexedId);
                lookupLog = this.prevMapLog2;
            }
            if (entry == null) {
                return null;
            }
            lookupLog.incref();
        }
        try {
            object = lookupLog.lookup(entry.pointer);
            return object;
        }
        finally {
            lookupLog.decref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lookupVersion(BytesRef indexedId) {
        LogPtr entry;
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            entry = this.map.get(indexedId);
            TransactionLog lookupLog = this.tlog;
            if (entry == null && this.prevMap != null) {
                entry = this.prevMap.get(indexedId);
                lookupLog = this.prevMapLog;
            }
            if (entry == null && this.prevMap2 != null) {
                entry = this.prevMap2.get(indexedId);
                lookupLog = this.prevMapLog2;
            }
        }
        if (entry != null) {
            return entry.version;
        }
        Long version = this.versionInfo.getVersionFromIndex(indexedId);
        if (version != null) {
            return version;
        }
        UpdateLog updateLog2 = this;
        synchronized (updateLog2) {
            entry = this.oldDeletes.get(indexedId);
        }
        if (entry != null) {
            return entry.version;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(SyncLevel syncLevel) {
        TransactionLog currLog;
        if (syncLevel == null) {
            syncLevel = this.defaultSyncLevel;
        }
        if (syncLevel == SyncLevel.NONE) {
            return;
        }
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            currLog = this.tlog;
            if (currLog == null) {
                return;
            }
            currLog.incref();
        }
        try {
            currLog.finish(syncLevel);
        }
        finally {
            currLog.decref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RecoveryInfo> recoverFromLog() {
        this.recoveryInfo = new RecoveryInfo();
        ArrayList<TransactionLog> recoverLogs = new ArrayList<TransactionLog>(1);
        for (TransactionLog ll : this.newestLogsOnStartup) {
            block8: {
                if (!ll.try_incref()) continue;
                try {
                    if (ll.endsWithCommit()) {
                        ll.decref();
                    }
                    break block8;
                }
                catch (IOException e) {
                    log.error("Error inspecting tlog " + ll, e);
                    ll.decref();
                }
                continue;
            }
            recoverLogs.add(ll);
        }
        if (recoverLogs.isEmpty()) {
            return null;
        }
        ExecutorCompletionService<RecoveryInfo> cs = new ExecutorCompletionService<RecoveryInfo>(this.recoveryExecutor);
        LogReplayer replayer = new LogReplayer(recoverLogs, false);
        this.versionInfo.blockUpdates();
        try {
            this.state = State.REPLAYING;
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
        return cs.submit(replayer, this.recoveryInfo);
    }

    protected void ensureLog() {
        if (this.tlog == null) {
            String newLogName = String.format(Locale.ROOT, LOG_FILENAME_PATTERN, TLOG_NAME, this.id);
            this.tlog = new TransactionLog(new File(this.tlogDir, newLogName), this.globalStrings);
        }
    }

    private void doClose(TransactionLog theLog, boolean writeCommit) {
        if (theLog != null) {
            if (writeCommit) {
                log.info("Recording current closed for " + this.uhandler.core + " log=" + theLog);
                CommitUpdateCommand cmd = new CommitUpdateCommand(new LocalSolrQueryRequest(this.uhandler.core, new ModifiableSolrParams((SolrParams)null)), false);
                theLog.writeCommit(cmd, this.operationFlags);
            }
            theLog.deleteOnClose = false;
            theLog.decref();
            theLog.forceClose();
        }
    }

    public void close(boolean committed) {
        this.close(committed, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean committed, boolean deleteOnClose) {
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            try {
                ExecutorUtil.shutdownNowAndAwaitTermination(this.recoveryExecutor);
            }
            catch (Exception e) {
                SolrException.log(log, e);
            }
            this.doClose(this.prevTlog, committed);
            this.doClose(this.tlog, committed);
            for (TransactionLog log : this.logs) {
                if (log == this.prevTlog || log == this.tlog) continue;
                log.deleteOnClose = false;
                log.decref();
                log.forceClose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecentUpdates getRecentUpdates() {
        LinkedList<TransactionLog> logList;
        UpdateLog updateLog = this;
        synchronized (updateLog) {
            logList = new LinkedList<TransactionLog>(this.logs);
            for (TransactionLog log : logList) {
                log.incref();
            }
            if (this.prevTlog != null) {
                this.prevTlog.incref();
                logList.addFirst(this.prevTlog);
            }
            if (this.tlog != null) {
                this.tlog.incref();
                logList.addFirst(this.tlog);
            }
        }
        boolean success = false;
        RecentUpdates recentUpdates = null;
        try {
            recentUpdates = new RecentUpdates();
            recentUpdates.logList = logList;
            recentUpdates.update();
            success = true;
        }
        finally {
            if (!success && recentUpdates != null) {
                recentUpdates.close();
            }
        }
        return recentUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferUpdates() {
        this.recoveryInfo = new RecoveryInfo();
        this.versionInfo.blockUpdates();
        try {
            if (this.state != State.ACTIVE) {
                return;
            }
            if (log.isInfoEnabled()) {
                log.info("Starting to buffer updates. " + this);
            }
            UpdateLog updateLog = this;
            synchronized (updateLog) {
                this.recoveryInfo.positionOfStart = this.tlog == null ? 0L : this.tlog.snapshot();
            }
            this.state = State.BUFFERING;
            this.operationFlags |= 0x10;
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropBufferedUpdates() {
        this.versionInfo.blockUpdates();
        try {
            if (this.state != State.BUFFERING) {
                boolean bl = false;
                return bl;
            }
            if (log.isInfoEnabled()) {
                log.info("Dropping buffered updates " + this);
            }
            UpdateLog updateLog = this;
            synchronized (updateLog) {
                if (this.tlog != null) {
                    this.tlog.rollback(this.recoveryInfo.positionOfStart);
                }
            }
            this.state = State.ACTIVE;
            this.operationFlags &= 0xFFFFFFEF;
        }
        catch (IOException e) {
            SolrException.log(log, "Error attempting to roll back log", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RecoveryInfo> applyBufferedUpdates() {
        this.versionInfo.blockUpdates();
        try {
            this.cancelApplyBufferUpdate = false;
            if (this.state != State.BUFFERING) {
                Future<RecoveryInfo> future = null;
                return future;
            }
            this.operationFlags &= 0xFFFFFFEF;
            if (this.tlog == null) {
                this.state = State.ACTIVE;
                Future<RecoveryInfo> future = null;
                return future;
            }
            this.tlog.incref();
            this.state = State.APPLYING_BUFFERED;
        }
        finally {
            this.versionInfo.unblockUpdates();
        }
        if (this.recoveryExecutor.isShutdown()) {
            this.tlog.decref();
            throw new RuntimeException("executor is not running...");
        }
        ExecutorCompletionService<RecoveryInfo> cs = new ExecutorCompletionService<RecoveryInfo>(this.recoveryExecutor);
        LogReplayer replayer = new LogReplayer(Arrays.asList(this.tlog), true);
        return cs.submit(replayer, this.recoveryInfo);
    }

    public State getState() {
        return this.state;
    }

    public String toString() {
        return "FSUpdateLog{state=" + (Object)((Object)this.getState()) + ", tlog=" + this.tlog + "}";
    }

    public void cancelApplyBufferedUpdates() {
        this.cancelApplyBufferUpdate = true;
    }

    public static void deleteFile(File file) {
        boolean success = false;
        try {
            success = file.delete();
            if (!success) {
                log.error("Error deleting file: " + file);
            }
        }
        catch (Exception e) {
            log.error("Error deleting file: " + file, e);
        }
        if (!success) {
            try {
                file.deleteOnExit();
            }
            catch (Exception e) {
                log.error("Error deleting file on exit: " + file, e);
            }
        }
    }

    protected String getTlogDir(SolrCore core, PluginInfo info) {
        String dataDir = (String)info.initArgs.get("dir");
        String ulogDir = core.getCoreDescriptor().getUlogDir();
        if (ulogDir != null) {
            dataDir = ulogDir;
        }
        if (dataDir == null || dataDir.length() == 0) {
            dataDir = core.getDataDir();
        }
        return dataDir + "/" + TLOG_NAME;
    }

    public void clearLog(SolrCore core, PluginInfo ulogPluginInfo) {
        if (ulogPluginInfo == null) {
            return;
        }
        File tlogDir = new File(this.getTlogDir(core, ulogPluginInfo));
        if (tlogDir.exists()) {
            String[] files;
            for (String file : files = this.getLogList(tlogDir)) {
                File f = new File(tlogDir, file);
                boolean s = f.delete();
                if (s) continue;
                log.error("Could not remove tlog file:" + f);
            }
        }
    }

    class LogReplayer
    implements Runnable {
        private Logger loglog = log;
        Deque<TransactionLog> translogs;
        TransactionLog.LogReader tlogReader;
        boolean activeLog;
        boolean finishing = false;
        boolean debug = this.loglog.isDebugEnabled();
        private SolrQueryRequest req;
        private SolrQueryResponse rsp;

        public LogReplayer(List<TransactionLog> translogs, boolean activeLog) {
            this.translogs = new LinkedList<TransactionLog>();
            this.translogs.addAll(translogs);
            this.activeLog = activeLog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("update.distrib", DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString());
            params.set("log_replay", "true");
            this.req = new LocalSolrQueryRequest(UpdateLog.this.uhandler.core, params);
            this.rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(this.req, this.rsp));
            try {
                TransactionLog translog;
                while ((translog = this.translogs.pollFirst()) != null) {
                    this.doReplay(translog);
                }
            }
            catch (SolrException e) {
                if (e.code() == SolrException.ErrorCode.SERVICE_UNAVAILABLE.code) {
                    SolrException.log(log, e);
                    UpdateLog.this.recoveryInfo.failed = true;
                }
                ++UpdateLog.this.recoveryInfo.errors;
                SolrException.log(log, e);
            }
            catch (Exception e) {
                ++UpdateLog.this.recoveryInfo.errors;
                SolrException.log(log, e);
            }
            finally {
                UpdateLog.this.state = State.ACTIVE;
                if (this.finishing) {
                    UpdateLog.this.versionInfo.unblockUpdates();
                }
                for (TransactionLog translog : this.translogs) {
                    log.error("ERROR: didn't get to recover from tlog " + translog);
                    translog.decref();
                }
            }
            this.loglog.warn("Log replay finished. recoveryInfo=" + UpdateLog.this.recoveryInfo);
            if (testing_logReplayFinishHook != null) {
                testing_logReplayFinishHook.run();
            }
            SolrRequestInfo.clearRequestInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void doReplay(TransactionLog translog) {
            try {
                this.loglog.warn("Starting log replay " + translog + " active=" + this.activeLog + " starting pos=" + UpdateLog.this.recoveryInfo.positionOfStart);
                this.tlogReader = translog.getReader(UpdateLog.this.recoveryInfo.positionOfStart);
                processorChain = this.req.getCore().getUpdateProcessingChain(null);
                proc = processorChain.createProcessor(this.req, this.rsp);
                commitVersion = 0L;
                operationAndFlags = 0;
                while (true) lbl-1000:
                // 6 sources

                {
                    o = null;
                    if (UpdateLog.this.cancelApplyBufferUpdate) ** break;
                    try {
                        if (UpdateLog.testing_logReplayHook != null) {
                            UpdateLog.testing_logReplayHook.run();
                        }
                        o = null;
                        o = this.tlogReader.next();
                        if (o == null && this.activeLog && !this.finishing) {
                            UpdateLog.this.versionInfo.blockUpdates();
                            this.finishing = true;
                            o = this.tlogReader.next();
                        }
                    }
                    catch (InterruptedException e) {
                        SolrException.log(UpdateLog.log, e);
                    }
                    catch (IOException e) {
                        SolrException.log(UpdateLog.log, e);
                    }
                    catch (Exception e) {
                        SolrException.log(UpdateLog.log, e);
                    }
                    if (o == null) ** break;
                    try {
                        entry = (List)o;
                        operationAndFlags = (Integer)entry.get(0);
                        oper = operationAndFlags & 15;
                        version = (Long)entry.get(1);
                        switch (oper) {
                            case 1: {
                                ++UpdateLog.this.recoveryInfo.adds;
                                sdoc = (SolrInputDocument)entry.get(entry.size() - 1);
                                cmd = new AddUpdateCommand(this.req);
                                cmd.solrDoc = sdoc;
                                cmd.setVersion(version);
                                cmd.setFlags(UpdateCommand.REPLAY | UpdateCommand.IGNORE_AUTOCOMMIT);
                                if (this.debug) {
                                    UpdateLog.log.debug("add " + cmd);
                                }
                                proc.processAdd((AddUpdateCommand)cmd);
                                break;
                            }
                            case 2: {
                                ++UpdateLog.this.recoveryInfo.deletes;
                                idBytes = (byte[])entry.get(2);
                                cmd = new DeleteUpdateCommand(this.req);
                                cmd.setIndexedId(new BytesRef(idBytes));
                                cmd.setVersion(version);
                                cmd.setFlags(UpdateCommand.REPLAY | UpdateCommand.IGNORE_AUTOCOMMIT);
                                if (this.debug) {
                                    UpdateLog.log.debug("delete " + cmd);
                                }
                                proc.processDelete((DeleteUpdateCommand)cmd);
                                break;
                            }
                            case 3: {
                                ++UpdateLog.this.recoveryInfo.deleteByQuery;
                                query = (String)entry.get(2);
                                cmd = new DeleteUpdateCommand(this.req);
                                cmd.query = query;
                                cmd.setVersion(version);
                                cmd.setFlags(UpdateCommand.REPLAY | UpdateCommand.IGNORE_AUTOCOMMIT);
                                if (this.debug) {
                                    UpdateLog.log.debug("deleteByQuery " + cmd);
                                }
                                proc.processDelete((DeleteUpdateCommand)cmd);
                                break;
                            }
                            case 4: {
                                commitVersion = version;
                                break;
                            }
                            default: {
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                            }
                        }
                        if (this.rsp.getException() == null) ** GOTO lbl-1000
                        this.loglog.error("REPLAY_ERR: Exception replaying log", this.rsp.getException());
                        throw this.rsp.getException();
                    }
                    catch (IOException ex) {
                        ++UpdateLog.this.recoveryInfo.errors;
                        this.loglog.warn("REYPLAY_ERR: IOException reading log", ex);
                    }
                    catch (ClassCastException cl) {
                        ++UpdateLog.this.recoveryInfo.errors;
                        this.loglog.warn("REPLAY_ERR: Unexpected log entry or corrupt log.  Entry=" + o, cl);
                    }
                    catch (SolrException ex) {
                        if (ex.code() == SolrException.ErrorCode.SERVICE_UNAVAILABLE.code) {
                            throw ex;
                        }
                        ++UpdateLog.this.recoveryInfo.errors;
                        this.loglog.warn("REYPLAY_ERR: IOException reading log", ex);
                    }
                    catch (Exception ex) {
                        ++UpdateLog.this.recoveryInfo.errors;
                        this.loglog.warn("REPLAY_ERR: Exception replaying log", ex);
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                cmd = new CommitUpdateCommand(this.req, false);
                cmd.setVersion(commitVersion);
                cmd.softCommit = false;
                cmd.waitSearcher = true;
                cmd.setFlags(UpdateCommand.REPLAY);
                try {
                    if (this.debug) {
                        UpdateLog.log.debug("commit " + cmd);
                    }
                    UpdateLog.this.uhandler.commit(cmd);
                }
                catch (IOException ex) {
                    ++UpdateLog.this.recoveryInfo.errors;
                    this.loglog.error("Replay exception: final commit.", ex);
                }
                if (!this.activeLog) {
                    translog.writeCommit(cmd, UpdateLog.this.operationFlags | operationAndFlags & -16);
                }
                try {
                    proc.finish();
                }
                catch (IOException ex) {
                    ++UpdateLog.this.recoveryInfo.errors;
                    this.loglog.error("Replay exception: finish()", ex);
                }
            }
            finally {
                if (this.tlogReader != null) {
                    this.tlogReader.close();
                }
                translog.decref();
            }
        }
    }

    public class RecentUpdates {
        Deque<TransactionLog> logList;
        List<List<Update>> updateList;
        HashMap<Long, Update> updates;
        List<Update> deleteByQueryList;
        List<DeleteUpdate> deleteList;
        int latestOperation;

        public List<Long> getVersions(int n) {
            ArrayList<Long> ret = new ArrayList<Long>(n);
            for (List<Update> singleList : this.updateList) {
                for (Update ptr : singleList) {
                    ret.add(ptr.version);
                    if (--n > 0) continue;
                    return ret;
                }
            }
            return ret;
        }

        public Object lookup(long version) {
            Update update = this.updates.get(version);
            if (update == null) {
                return null;
            }
            return update.log.lookup(update.pointer);
        }

        public List<Object> getDeleteByQuery(long afterVersion) {
            ArrayList<Object> result = new ArrayList<Object>(this.deleteByQueryList.size());
            for (Update update : this.deleteByQueryList) {
                if (Math.abs(update.version) <= afterVersion) continue;
                Object dbq = update.log.lookup(update.pointer);
                result.add(dbq);
            }
            return result;
        }

        public int getLatestOperation() {
            return this.latestOperation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update() {
            int numUpdates = 0;
            this.updateList = new ArrayList<List<Update>>(this.logList.size());
            this.deleteByQueryList = new ArrayList<Update>();
            this.deleteList = new ArrayList<DeleteUpdate>();
            this.updates = new HashMap(100);
            for (TransactionLog oldLog : this.logList) {
                ArrayList<Update> updatesForLog = new ArrayList<Update>();
                try (TransactionLog.ReverseReader reader = null;){
                    reader = oldLog.getReverseReader();
                    while (numUpdates < 100) {
                        Object o = null;
                        try {
                            o = reader.next();
                            if (o == null) {
                                break;
                            }
                            List entry = (List)o;
                            int opAndFlags = (Integer)entry.get(0);
                            if (this.latestOperation == 0) {
                                this.latestOperation = opAndFlags;
                            }
                            int oper = opAndFlags & 0xF;
                            long version = (Long)entry.get(1);
                            switch (oper) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    Update update = new Update();
                                    update.log = oldLog;
                                    update.pointer = reader.position();
                                    update.version = version;
                                    updatesForLog.add(update);
                                    this.updates.put(version, update);
                                    if (oper == 3) {
                                        this.deleteByQueryList.add(update);
                                        break;
                                    }
                                    if (oper == 2) {
                                        this.deleteList.add(new DeleteUpdate(version, (byte[])entry.get(2)));
                                    }
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                default: {
                                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown Operation! " + oper);
                                }
                            }
                        }
                        catch (ClassCastException cl) {
                            log.warn("Unexpected log entry or corrupt log.  Entry=" + o, cl);
                        }
                        catch (Exception ex) {
                            log.warn("Exception reverse reading log", ex);
                            break;
                        }
                        ++numUpdates;
                    }
                }
                this.updateList.add(updatesForLog);
            }
        }

        public void close() {
            for (TransactionLog log : this.logList) {
                log.decref();
            }
        }
    }

    static class DeleteUpdate {
        long version;
        byte[] id;

        public DeleteUpdate(long version, byte[] id) {
            this.version = version;
            this.id = id;
        }
    }

    static class Update {
        TransactionLog log;
        long version;
        long pointer;

        Update() {
        }
    }

    public static class LogPtr {
        final long pointer;
        final long version;

        public LogPtr(long pointer, long version) {
            this.pointer = pointer;
            this.version = version;
        }

        public String toString() {
            return "LogPtr(" + this.pointer + ")";
        }
    }

    public class DBQ {
        public String q;
        public long version;

        public String toString() {
            return "DBQ{version=" + this.version + ",q=" + this.q + "}";
        }
    }

    public static class RecoveryInfo {
        public long positionOfStart;
        public int adds;
        public int deletes;
        public int deleteByQuery;
        public int errors;
        public boolean failed;

        public String toString() {
            return "RecoveryInfo{adds=" + this.adds + " deletes=" + this.deletes + " deleteByQuery=" + this.deleteByQuery + " errors=" + this.errors + " positionOfStart=" + this.positionOfStart + "}";
        }
    }

    public static enum State {
        REPLAYING,
        BUFFERING,
        APPLYING_BUFFERED,
        ACTIVE;

    }

    public static enum SyncLevel {
        NONE,
        FLUSH,
        FSYNC;


        public static SyncLevel getSyncLevel(String level) {
            if (level == null) {
                return FLUSH;
            }
            try {
                return SyncLevel.valueOf(level.toUpperCase(Locale.ROOT));
            }
            catch (Exception ex) {
                log.warn("There was an error reading the SyncLevel - default to " + (Object)((Object)FLUSH), ex);
                return FLUSH;
            }
        }
    }
}

