/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrServer;
import org.apache.solr.common.SolrException;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.UpdateShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSolrServers {
    public static Logger log = LoggerFactory.getLogger(StreamingSolrServers.class);
    private HttpClient httpClient;
    private Map<String, ConcurrentUpdateSolrServer> solrServers = new HashMap<String, ConcurrentUpdateSolrServer>();
    private List<SolrCmdDistributor.Error> errors = Collections.synchronizedList(new ArrayList());
    private ExecutorService updateExecutor;

    public StreamingSolrServers(UpdateShardHandler updateShardHandler) {
        this.updateExecutor = updateShardHandler.getUpdateExecutor();
        this.httpClient = updateShardHandler.getHttpClient();
    }

    public List<SolrCmdDistributor.Error> getErrors() {
        return this.errors;
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public synchronized SolrServer getSolrServer(final SolrCmdDistributor.Req req) {
        String url = this.getFullUrl(req.node.getUrl());
        ConcurrentUpdateSolrServer server = this.solrServers.get(url);
        if (server == null) {
            server = new ConcurrentUpdateSolrServer(url, this.httpClient, 100, 1, this.updateExecutor, true){

                @Override
                public void handleError(Throwable ex) {
                    req.trackRequestResult(null, false);
                    log.error("error", ex);
                    SolrCmdDistributor.Error error = new SolrCmdDistributor.Error();
                    error.e = (Exception)ex;
                    if (ex instanceof SolrException) {
                        error.statusCode = ((SolrException)ex).code();
                    }
                    error.req = req;
                    StreamingSolrServers.this.errors.add(error);
                }

                @Override
                public void onSuccess(HttpResponse resp) {
                    req.trackRequestResult(resp, true);
                }
            };
            server.setParser(new BinaryResponseParser());
            server.setRequestWriter(new BinaryRequestWriter());
            server.setPollQueueTime(0);
            HashSet<String> queryParams = new HashSet<String>(2);
            queryParams.add("distrib.from");
            queryParams.add("update.distrib");
            server.setQueryParams(queryParams);
            this.solrServers.put(url, server);
        }
        return server;
    }

    public synchronized void blockUntilFinished() {
        for (ConcurrentUpdateSolrServer server : this.solrServers.values()) {
            server.blockUntilFinished();
        }
    }

    public synchronized void shutdown() {
        for (ConcurrentUpdateSolrServer server : this.solrServers.values()) {
            server.shutdown();
        }
    }

    private String getFullUrl(String url) {
        String fullUrl = !url.startsWith("http://") && !url.startsWith("https://") ? "http://" + url : url;
        return fullUrl;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }
}

