/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.HashBasedRouter;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexSplitter {
    public static Logger log = LoggerFactory.getLogger(SolrIndexSplitter.class);
    SolrIndexSearcher searcher;
    SchemaField field;
    List<DocRouter.Range> ranges;
    DocRouter.Range[] rangesArr;
    List<String> paths;
    List<SolrCore> cores;
    DocRouter router;
    HashBasedRouter hashRouter;
    int numPieces;
    int currPartition = 0;
    String routeFieldName;
    String splitKey;

    public SolrIndexSplitter(SplitIndexCommand cmd) {
        this.searcher = cmd.getReq().getSearcher();
        this.ranges = cmd.ranges;
        this.paths = cmd.paths;
        this.cores = cmd.cores;
        this.router = cmd.router;
        HashBasedRouter hashBasedRouter = this.hashRouter = this.router instanceof HashBasedRouter ? (HashBasedRouter)this.router : null;
        if (this.ranges == null) {
            this.numPieces = this.paths != null ? this.paths.size() : this.cores.size();
        } else {
            this.numPieces = this.ranges.size();
            this.rangesArr = this.ranges.toArray(new DocRouter.Range[this.ranges.size()]);
        }
        this.routeFieldName = cmd.routeFieldName;
        this.field = this.routeFieldName == null ? this.searcher.getSchema().getUniqueKeyField() : this.searcher.getSchema().getField(this.routeFieldName);
        if (cmd.splitKey != null) {
            this.splitKey = SolrIndexSplitter.getRouteKey(cmd.splitKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void split() throws IOException {
        List<AtomicReaderContext> leaves = this.searcher.getTopReaderContext().leaves();
        ArrayList<FixedBitSet[]> segmentDocSets = new ArrayList<FixedBitSet[]>(leaves.size());
        log.info("SolrIndexSplitter: partitions=" + this.numPieces + " segments=" + leaves.size());
        for (AtomicReaderContext readerContext : leaves) {
            assert (readerContext.ordInParent == segmentDocSets.size());
            FixedBitSet[] docSets = this.split(readerContext);
            segmentDocSets.add(docSets);
        }
        for (int partitionNumber = 0; partitionNumber < this.numPieces; ++partitionNumber) {
            IndexWriter iw;
            block13: {
                log.info("SolrIndexSplitter: partition #" + partitionNumber + " partitionCount=" + this.numPieces + (this.ranges != null ? " range=" + this.ranges.get(partitionNumber) : ""));
                boolean success = false;
                RefCounted<IndexWriter> iwRef = null;
                iw = null;
                if (this.cores != null) {
                    SolrCore subCore = this.cores.get(partitionNumber);
                    iwRef = subCore.getUpdateHandler().getSolrCoreState().getIndexWriter(subCore);
                    iw = iwRef.get();
                } else {
                    SolrCore core = this.searcher.getCore();
                    String path = this.paths.get(partitionNumber);
                    iw = SolrIndexWriter.create("SplittingIndexWriter" + partitionNumber + (this.ranges != null ? " " + this.ranges.get(partitionNumber) : ""), path, core.getDirectoryFactory(), true, core.getLatestSchema(), core.getSolrConfig().indexConfig, core.getDeletionPolicy(), core.getCodec());
                }
                try {
                    for (int segmentNumber = 0; segmentNumber < leaves.size(); ++segmentNumber) {
                        log.info("SolrIndexSplitter: partition #" + partitionNumber + " partitionCount=" + this.numPieces + (this.ranges != null ? " range=" + this.ranges.get(partitionNumber) : "") + " segment #" + segmentNumber + " segmentCount=" + leaves.size());
                        LiveDocsReader subReader = new LiveDocsReader(leaves.get(segmentNumber), ((FixedBitSet[])segmentDocSets.get(segmentNumber))[partitionNumber]);
                        iw.addIndexes(subReader);
                    }
                    success = true;
                    if (iwRef != null) {
                        iwRef.decref();
                        continue;
                    }
                    if (!success) break block13;
                }
                catch (Throwable throwable) {
                    if (iwRef != null) {
                        iwRef.decref();
                    } else if (success) {
                        IOUtils.close(iw);
                    } else {
                        IOUtils.closeWhileHandlingException(iw);
                    }
                    throw throwable;
                }
                IOUtils.close(iw);
                continue;
            }
            IOUtils.closeWhileHandlingException(iw);
        }
    }

    FixedBitSet[] split(AtomicReaderContext readerContext) throws IOException {
        TermsEnum termsEnum;
        AtomicReader reader = readerContext.reader();
        FixedBitSet[] docSets = new FixedBitSet[this.numPieces];
        for (int i = 0; i < docSets.length; ++i) {
            docSets[i] = new FixedBitSet(reader.maxDoc());
        }
        Bits liveDocs = reader.getLiveDocs();
        Fields fields = reader.fields();
        Terms terms = fields == null ? null : fields.terms(this.field.getName());
        TermsEnum termsEnum2 = termsEnum = terms == null ? null : terms.iterator(null);
        if (termsEnum == null) {
            return docSets;
        }
        BytesRef term = null;
        DocsEnum docsEnum = null;
        CharsRef idRef = new CharsRef();
        while ((term = termsEnum.next()) != null) {
            int doc;
            String part1;
            this.field.getType().indexedToReadable(term, idRef);
            String idString = idRef.toString();
            if (this.splitKey != null && ((part1 = SolrIndexSplitter.getRouteKey(idString)) == null || !this.splitKey.equals(part1))) continue;
            int hash = 0;
            if (this.hashRouter != null) {
                hash = this.hashRouter.sliceHash(idString, null, null, null);
            }
            docsEnum = termsEnum.docs(liveDocs, docsEnum, 0);
            while ((doc = docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (this.ranges == null) {
                    docSets[this.currPartition].set(doc);
                    this.currPartition = (this.currPartition + 1) % this.numPieces;
                    continue;
                }
                for (int i = 0; i < this.rangesArr.length; ++i) {
                    if (!this.rangesArr[i].includes(hash)) continue;
                    docSets[i].set(doc);
                }
            }
        }
        return docSets;
    }

    public static String getRouteKey(String idString) {
        char ch;
        int idx = idString.indexOf("!");
        if (idx <= 0) {
            return null;
        }
        String part1 = idString.substring(0, idx);
        int commaIdx = part1.indexOf(47);
        if (commaIdx > 0 && commaIdx + 1 < part1.length() && (ch = part1.charAt(commaIdx + 1)) >= '0' && ch <= '9') {
            part1 = part1.substring(0, commaIdx);
        }
        return part1;
    }

    static class LiveDocsReader
    extends FilterAtomicReader {
        final FixedBitSet liveDocs;
        final int numDocs;

        public LiveDocsReader(AtomicReaderContext context, FixedBitSet liveDocs) throws IOException {
            super(context.reader());
            this.liveDocs = liveDocs;
            this.numDocs = liveDocs.cardinality();
        }

        @Override
        public int numDocs() {
            return this.numDocs;
        }

        @Override
        public Bits getLiveDocs() {
            return this.liveDocs;
        }
    }
}

