/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.UpdateCommand;

public class MergeIndexesCommand
extends UpdateCommand {
    public List<DirectoryReader> readers;

    public MergeIndexesCommand(List<DirectoryReader> readers, SolrQueryRequest req) {
        super(req);
        this.readers = readers;
    }

    @Override
    public String name() {
        return "mergeIndexes";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        Joiner joiner = Joiner.on(",");
        Iterable<String> directories = Iterables.transform(this.readers, new Function<DirectoryReader, String>(){

            @Override
            public String apply(DirectoryReader reader) {
                return reader.directory().toString();
            }
        });
        joiner.skipNulls().join(sb, directories, new Object[0]);
        sb.append('}');
        return sb.toString();
    }
}

