/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionRangeQuery;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitTracker;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;

public class DirectUpdateHandler2
extends UpdateHandler
implements SolrCoreState.IndexWriterCloser {
    protected final SolrCoreState solrCoreState;
    AtomicLong addCommands = new AtomicLong();
    AtomicLong addCommandsCumulative = new AtomicLong();
    AtomicLong deleteByIdCommands = new AtomicLong();
    AtomicLong deleteByIdCommandsCumulative = new AtomicLong();
    AtomicLong deleteByQueryCommands = new AtomicLong();
    AtomicLong deleteByQueryCommandsCumulative = new AtomicLong();
    AtomicLong expungeDeleteCommands = new AtomicLong();
    AtomicLong mergeIndexesCommands = new AtomicLong();
    AtomicLong commitCommands = new AtomicLong();
    AtomicLong optimizeCommands = new AtomicLong();
    AtomicLong rollbackCommands = new AtomicLong();
    AtomicLong numDocsPending = new AtomicLong();
    AtomicLong numErrors = new AtomicLong();
    AtomicLong numErrorsCumulative = new AtomicLong();
    protected final CommitTracker commitTracker;
    protected final CommitTracker softCommitTracker;
    protected boolean commitWithinSoftCommit;
    protected boolean indexWriterCloseWaitsForMerges;
    public static boolean commitOnClose = true;

    public DirectUpdateHandler2(SolrCore core) {
        super(core);
        this.solrCoreState = core.getSolrCoreState();
        SolrConfig.UpdateHandlerInfo updateHandlerInfo = core.getSolrConfig().getUpdateHandlerInfo();
        int docsUpperBound = updateHandlerInfo.autoCommmitMaxDocs;
        int timeUpperBound = updateHandlerInfo.autoCommmitMaxTime;
        this.commitTracker = new CommitTracker("Hard", core, docsUpperBound, timeUpperBound, updateHandlerInfo.openSearcher, false);
        int softCommitDocsUpperBound = updateHandlerInfo.autoSoftCommmitMaxDocs;
        int softCommitTimeUpperBound = updateHandlerInfo.autoSoftCommmitMaxTime;
        this.softCommitTracker = new CommitTracker("Soft", core, softCommitDocsUpperBound, softCommitTimeUpperBound, true, true);
        this.commitWithinSoftCommit = updateHandlerInfo.commitWithinSoftCommit;
        this.indexWriterCloseWaitsForMerges = updateHandlerInfo.indexWriterCloseWaitsForMerges;
    }

    public DirectUpdateHandler2(SolrCore core, UpdateHandler updateHandler) {
        super(core, updateHandler.getUpdateLog());
        this.solrCoreState = core.getSolrCoreState();
        SolrConfig.UpdateHandlerInfo updateHandlerInfo = core.getSolrConfig().getUpdateHandlerInfo();
        int docsUpperBound = updateHandlerInfo.autoCommmitMaxDocs;
        int timeUpperBound = updateHandlerInfo.autoCommmitMaxTime;
        this.commitTracker = new CommitTracker("Hard", core, docsUpperBound, timeUpperBound, updateHandlerInfo.openSearcher, false);
        int softCommitDocsUpperBound = updateHandlerInfo.autoSoftCommmitMaxDocs;
        int softCommitTimeUpperBound = updateHandlerInfo.autoSoftCommmitMaxTime;
        this.softCommitTracker = new CommitTracker("Soft", core, softCommitDocsUpperBound, softCommitTimeUpperBound, updateHandlerInfo.openSearcher, true);
        this.commitWithinSoftCommit = updateHandlerInfo.commitWithinSoftCommit;
        this.indexWriterCloseWaitsForMerges = updateHandlerInfo.indexWriterCloseWaitsForMerges;
        UpdateLog existingLog = updateHandler.getUpdateLog();
        if (this.ulog != null && this.ulog == existingLog) {
            this.ulog.init(this, core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAll() throws IOException {
        SolrCore.log.info(this.core.getLogId() + "REMOVING ALL DOCUMENTS FROM INDEX");
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            iw.get().deleteAll();
        }
        finally {
            iw.decref();
        }
    }

    protected void rollbackWriter() throws IOException {
        this.numDocsPending.set(0L);
        this.solrCoreState.rollbackIndexWriter(this.core);
    }

    @Override
    public int addDoc(AddUpdateCommand cmd) throws IOException {
        try {
            return this.addDoc0(cmd);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (RuntimeException t) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Exception writing document id %s to the index; possible analysis error.", cmd.getPrintableId()), (Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addDoc0(AddUpdateCommand cmd) throws IOException {
        int rc = -1;
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            IndexWriter writer = iw.get();
            this.addCommands.incrementAndGet();
            this.addCommandsCumulative.incrementAndGet();
            if (this.idField == null) {
                cmd.overwrite = false;
            }
            try {
                IndexSchema schema = cmd.getReq().getSchema();
                if (cmd.overwrite) {
                    List<UpdateLog.DBQ> deletesAfter = null;
                    if (this.ulog != null && cmd.version > 0L) {
                        deletesAfter = this.ulog.getDBQNewer(cmd.version);
                    }
                    if (deletesAfter != null) {
                        log.info("Reordered DBQs detected.  Update=" + cmd + " DBQs=" + deletesAfter);
                        ArrayList<Query> dbqList = new ArrayList<Query>(deletesAfter.size());
                        for (UpdateLog.DBQ dbq : deletesAfter) {
                            try {
                                DeleteUpdateCommand tmpDel = new DeleteUpdateCommand(cmd.req);
                                tmpDel.query = dbq.q;
                                tmpDel.version = -dbq.version;
                                dbqList.add(this.getQuery(tmpDel));
                            }
                            catch (Exception e) {
                                log.error("Exception parsing reordered query : " + dbq, e);
                            }
                        }
                        this.addAndDelete(cmd, dbqList);
                    } else {
                        Term updateTerm;
                        Term idTerm = new Term(cmd.isBlock() ? "_root_" : this.idField.getName(), cmd.getIndexedId());
                        boolean del = false;
                        if (cmd.updateTerm == null) {
                            updateTerm = idTerm;
                        } else {
                            del = true;
                            updateTerm = cmd.updateTerm;
                        }
                        if (cmd.isBlock()) {
                            writer.updateDocuments(updateTerm, cmd, schema.getIndexAnalyzer());
                        } else {
                            Document luceneDocument = cmd.getLuceneDocument();
                            writer.updateDocument(updateTerm, luceneDocument, schema.getIndexAnalyzer());
                        }
                        if (del) {
                            BooleanQuery bq = new BooleanQuery();
                            bq.add(new BooleanClause(new TermQuery(updateTerm), BooleanClause.Occur.MUST_NOT));
                            bq.add(new BooleanClause(new TermQuery(idTerm), BooleanClause.Occur.MUST));
                            writer.deleteDocuments(bq);
                        }
                        if (this.ulog != null) {
                            this.ulog.add(cmd);
                        }
                    }
                } else {
                    if (cmd.isBlock()) {
                        writer.addDocuments(cmd, schema.getIndexAnalyzer());
                    } else {
                        writer.addDocument(cmd.getLuceneDocument(), schema.getIndexAnalyzer());
                    }
                    if (this.ulog != null) {
                        this.ulog.add(cmd);
                    }
                }
                if ((cmd.getFlags() & UpdateCommand.IGNORE_AUTOCOMMIT) == 0) {
                    if (this.commitWithinSoftCommit) {
                        this.commitTracker.addedDocument(-1);
                        this.softCommitTracker.addedDocument(cmd.commitWithin);
                    } else {
                        this.softCommitTracker.addedDocument(-1);
                        this.commitTracker.addedDocument(cmd.commitWithin);
                    }
                }
                rc = 1;
            }
            finally {
                if (rc != 1) {
                    this.numErrors.incrementAndGet();
                    this.numErrorsCumulative.incrementAndGet();
                } else {
                    this.numDocsPending.incrementAndGet();
                }
            }
        }
        finally {
            iw.decref();
        }
        return rc;
    }

    private void updateDeleteTrackers(DeleteUpdateCommand cmd) {
        if ((cmd.getFlags() & UpdateCommand.IGNORE_AUTOCOMMIT) == 0) {
            if (this.commitWithinSoftCommit) {
                this.softCommitTracker.deletedDocument(cmd.commitWithin);
            } else {
                this.commitTracker.deletedDocument(cmd.commitWithin);
            }
            if (this.commitTracker.getTimeUpperBound() > 0L) {
                this.commitTracker.scheduleCommitWithin(this.commitTracker.getTimeUpperBound());
            }
            if (this.softCommitTracker.getTimeUpperBound() > 0L) {
                this.softCommitTracker.scheduleCommitWithin(this.softCommitTracker.getTimeUpperBound());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(DeleteUpdateCommand cmd) throws IOException {
        this.deleteByIdCommands.incrementAndGet();
        this.deleteByIdCommandsCumulative.incrementAndGet();
        Term deleteTerm = new Term(this.idField.getName(), cmd.getIndexedId());
        RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
        try {
            iw.get().deleteDocuments(deleteTerm);
        }
        finally {
            iw.decref();
        }
        if (this.ulog != null) {
            this.ulog.delete(cmd);
        }
        this.updateDeleteTrackers(cmd);
    }

    public void clearIndex() throws IOException {
        this.deleteAll();
        if (this.ulog != null) {
            this.ulog.deleteAll();
        }
    }

    private Query getQuery(DeleteUpdateCommand cmd) {
        try {
            QParser parser = QParser.getParser(cmd.getQuery(), "lucene", cmd.req);
            Query q = parser.getQuery();
            q = QueryUtils.makeQueryable(q);
            if (this.ulog != null && cmd.getVersion() != 0L && cmd.getVersion() != -9223372036854775807L) {
                BooleanQuery bq = new BooleanQuery();
                bq.add(q, BooleanClause.Occur.MUST);
                SchemaField sf = this.ulog.getVersionInfo().getVersionField();
                ValueSource vs = sf.getType().getValueSource(sf, null);
                ValueSourceRangeFilter filt = new ValueSourceRangeFilter(vs, null, Long.toString(Math.abs(cmd.getVersion())), true, true);
                FunctionRangeQuery range = new FunctionRangeQuery(filt);
                bq.add(range, BooleanClause.Occur.MUST);
                q = bq;
            }
            return q;
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByQuery(DeleteUpdateCommand cmd) throws IOException {
        boolean delAll;
        this.deleteByQueryCommands.incrementAndGet();
        this.deleteByQueryCommandsCumulative.incrementAndGet();
        boolean madeIt = false;
        Query q = this.getQuery(cmd);
        boolean bl = delAll = MatchAllDocsQuery.class == q.getClass();
        if (delAll && cmd.getVersion() == -9223372036854775807L) {
            Object object = this.solrCoreState.getUpdateLock();
            synchronized (object) {
                this.deleteAll();
                this.ulog.deleteAll();
                return;
            }
        }
        Object object = this.solrCoreState.getUpdateLock();
        synchronized (object) {
            if (delAll) {
                this.deleteAll();
            } else {
                RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
                try {
                    iw.get().deleteDocuments(q);
                }
                finally {
                    iw.decref();
                }
            }
            if (this.ulog != null) {
                this.ulog.deleteByQuery(cmd);
            }
        }
        finally {
            if (!madeIt) {
                this.numErrors.incrementAndGet();
                this.numErrorsCumulative.incrementAndGet();
            }
        }
        madeIt = true;
        this.updateDeleteTrackers(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAndDelete(AddUpdateCommand cmd, List<Query> dbqList) throws IOException {
        Document luceneDocument = cmd.getLuceneDocument();
        Term idTerm = new Term(this.idField.getName(), cmd.getIndexedId());
        Object object = this.solrCoreState.getUpdateLock();
        synchronized (object) {
            RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
            try {
                IndexWriter writer = iw.get();
                writer.updateDocument(idTerm, luceneDocument, cmd.getReq().getSchema().getIndexAnalyzer());
                for (Query q : dbqList) {
                    writer.deleteDocuments(q);
                }
            }
            finally {
                iw.decref();
            }
            if (this.ulog != null) {
                this.ulog.add(cmd, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mergeIndexes(MergeIndexesCommand cmd) throws IOException {
        int rc;
        this.mergeIndexesCommands.incrementAndGet();
        log.info("start " + cmd);
        List<DirectoryReader> readers = cmd.readers;
        if (readers != null && readers.size() > 0) {
            RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
            try {
                iw.get().addIndexes(readers.toArray(new IndexReader[readers.size()]));
            }
            finally {
                iw.decref();
            }
            rc = 1;
        } else {
            rc = 0;
        }
        log.info("end_mergeIndexes");
        if (rc == 1 && this.commitTracker.getTimeUpperBound() > 0L) {
            this.commitTracker.scheduleCommitWithin(this.commitTracker.getTimeUpperBound());
        } else if (rc == 1 && this.softCommitTracker.getTimeUpperBound() > 0L) {
            this.softCommitTracker.scheduleCommitWithin(this.softCommitTracker.getTimeUpperBound());
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommit(CommitUpdateCommand cmd) throws IOException {
        boolean error = true;
        try {
            log.info("start " + cmd);
            RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
            try {
                HashMap<String, String> commitData = new HashMap<String, String>();
                commitData.put("commitTimeMSec", String.valueOf(System.currentTimeMillis()));
                iw.get().setCommitData(commitData);
                iw.get().prepareCommit();
            }
            finally {
                iw.decref();
            }
            log.info("end_prepareCommit");
            error = false;
        }
        finally {
            if (error) {
                this.numErrors.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(CommitUpdateCommand cmd) throws IOException {
        if (cmd.prepareCommit) {
            this.prepareCommit(cmd);
            return;
        }
        if (cmd.optimize) {
            this.optimizeCommands.incrementAndGet();
        } else {
            this.commitCommands.incrementAndGet();
            if (cmd.expungeDeletes) {
                this.expungeDeleteCommands.incrementAndGet();
            }
        }
        Future[] waitSearcher = null;
        if (cmd.waitSearcher) {
            waitSearcher = new Future[1];
        }
        boolean error = true;
        try {
            Object object;
            block47: {
                if (!cmd.softCommit) {
                    this.solrCoreState.getCommitLock().lock();
                }
                log.info("start " + cmd);
                if (cmd.openSearcher) {
                    this.softCommitTracker.cancelPendingCommit();
                }
                if (!(cmd.softCommit || !cmd.openSearcher && this.commitTracker.getOpenSearcher())) {
                    this.commitTracker.cancelPendingCommit();
                }
                RefCounted<IndexWriter> iw = this.solrCoreState.getIndexWriter(this.core);
                try {
                    IndexWriter writer = iw.get();
                    if (cmd.optimize) {
                        writer.forceMerge(cmd.maxOptimizeSegments);
                    } else if (cmd.expungeDeletes) {
                        writer.forceMergeDeletes();
                    }
                    if (!cmd.softCommit) {
                        Object object2 = this.solrCoreState.getUpdateLock();
                        synchronized (object2) {
                            if (this.ulog != null) {
                                this.ulog.preCommit(cmd);
                            }
                        }
                        if (writer.hasUncommittedChanges()) {
                            HashMap<String, String> commitData = new HashMap<String, String>();
                            commitData.put("commitTimeMSec", String.valueOf(System.currentTimeMillis()));
                            writer.setCommitData(commitData);
                            writer.commit();
                        } else {
                            log.info("No uncommitted changes. Skipping IW.commit.");
                        }
                        this.numDocsPending.set(0L);
                        this.callPostCommitCallbacks();
                        break block47;
                    }
                    this.callPostSoftCommitCallbacks();
                }
                finally {
                    iw.decref();
                }
            }
            if (cmd.optimize) {
                this.callPostOptimizeCallbacks();
            }
            if (cmd.softCommit) {
                object = this.solrCoreState.getUpdateLock();
                synchronized (object) {
                    if (this.ulog != null) {
                        this.ulog.preSoftCommit(cmd);
                    }
                    this.core.getSearcher(true, false, waitSearcher, true);
                    if (this.ulog != null) {
                        this.ulog.postSoftCommit(cmd);
                    }
                }
            }
            object = this.solrCoreState.getUpdateLock();
            synchronized (object) {
                if (this.ulog != null) {
                    this.ulog.preSoftCommit(cmd);
                }
                if (cmd.openSearcher) {
                    this.core.getSearcher(true, false, waitSearcher);
                } else {
                    RefCounted<SolrIndexSearcher> searchHolder = this.core.openNewSearcher(true, true);
                    searchHolder.decref();
                }
                if (this.ulog != null) {
                    this.ulog.postSoftCommit(cmd);
                }
            }
            if (this.ulog != null) {
                this.ulog.postCommit(cmd);
            }
            if (cmd.softCommit) {
                this.softCommitTracker.didCommit();
            } else {
                this.commitTracker.didCommit();
            }
            log.info("end_commit_flush");
            error = false;
        }
        finally {
            if (!cmd.softCommit) {
                this.solrCoreState.getCommitLock().unlock();
            }
            this.addCommands.set(0L);
            this.deleteByIdCommands.set(0L);
            this.deleteByQueryCommands.set(0L);
            if (error) {
                this.numErrors.incrementAndGet();
            }
        }
        if (waitSearcher != null && waitSearcher[0] != null) {
            try {
                waitSearcher[0].get();
            }
            catch (InterruptedException e) {
                SolrException.log(log, e);
            }
            catch (ExecutionException e) {
                SolrException.log(log, e);
            }
        }
    }

    @Override
    public void newIndexWriter(boolean rollback) throws IOException {
        this.solrCoreState.newIndexWriter(this.core, rollback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(RollbackUpdateCommand cmd) throws IOException {
        this.rollbackCommands.incrementAndGet();
        boolean error = true;
        try {
            log.info("start " + cmd);
            this.rollbackWriter();
            this.commitTracker.didRollback();
            this.softCommitTracker.didRollback();
            log.info("end_rollback");
            error = false;
        }
        finally {
            this.addCommandsCumulative.set(this.addCommandsCumulative.get() - this.addCommands.getAndSet(0L));
            this.deleteByIdCommandsCumulative.set(this.deleteByIdCommandsCumulative.get() - this.deleteByIdCommands.getAndSet(0L));
            this.deleteByQueryCommandsCumulative.set(this.deleteByQueryCommandsCumulative.get() - this.deleteByQueryCommands.getAndSet(0L));
            if (error) {
                this.numErrors.incrementAndGet();
            }
        }
    }

    @Override
    public UpdateLog getUpdateLog() {
        return this.ulog;
    }

    @Override
    public void close() throws IOException {
        log.info("closing " + this);
        this.commitTracker.close();
        this.softCommitTracker.close();
        this.numDocsPending.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeWriter(IndexWriter writer) throws IOException {
        block26: {
            boolean clearRequestInfo = false;
            this.solrCoreState.getCommitLock().lock();
            try {
                block25: {
                    block24: {
                        LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.core, new ModifiableSolrParams());
                        SolrQueryResponse rsp = new SolrQueryResponse();
                        if (SolrRequestInfo.getRequestInfo() == null) {
                            clearRequestInfo = true;
                            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
                        }
                        if (!commitOnClose) {
                            if (writer != null) {
                                writer.rollback();
                            }
                            if (this.ulog != null) {
                                this.ulog.close(false);
                            }
                            return;
                        }
                        boolean tryToCommit = writer != null && this.ulog != null && this.ulog.hasUncommittedChanges() && this.ulog.getState() == UpdateLog.State.ACTIVE;
                        try {
                            if (!tryToCommit) break block24;
                            log.info("Committing on IndexWriter close.");
                            CommitUpdateCommand cmd = new CommitUpdateCommand(req, false);
                            cmd.openSearcher = false;
                            cmd.waitSearcher = false;
                            cmd.softCommit = false;
                            Object object = this.solrCoreState.getUpdateLock();
                            synchronized (object) {
                                this.ulog.preCommit(cmd);
                            }
                            HashMap<String, String> commitData = new HashMap<String, String>();
                            commitData.put("commitTimeMSec", String.valueOf(System.currentTimeMillis()));
                            writer.setCommitData(commitData);
                            writer.commit();
                            Object object2 = this.solrCoreState.getUpdateLock();
                            synchronized (object2) {
                                this.ulog.postCommit(cmd);
                            }
                        }
                        catch (Throwable th) {
                            log.error("Error in final commit", th);
                            if (!(th instanceof OutOfMemoryError)) break block24;
                            throw (OutOfMemoryError)th;
                        }
                    }
                    try {
                        if (this.ulog != null) {
                            this.ulog.close(false);
                        }
                    }
                    catch (Throwable th) {
                        log.error("Error closing log files", th);
                        if (!(th instanceof OutOfMemoryError)) break block25;
                        throw (OutOfMemoryError)th;
                    }
                }
                if (writer == null) break block26;
                try {
                    if (this.indexWriterCloseWaitsForMerges) {
                        writer.waitForMerges();
                    }
                }
                finally {
                    writer.close();
                }
            }
            finally {
                this.solrCoreState.getCommitLock().unlock();
                if (clearRequestInfo) {
                    SolrRequestInfo.clearRequestInfo();
                }
            }
        }
    }

    @Override
    public void split(SplitIndexCommand cmd) throws IOException {
        this.commit(new CommitUpdateCommand(cmd.req, false));
        SolrIndexSplitter splitter = new SolrIndexSplitter(cmd);
        splitter.split();
    }

    @Override
    public String getName() {
        return DirectUpdateHandler2.class.getName();
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public String getDescription() {
        return "Update handler that efficiently directly updates the on-disk main lucene index";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.UPDATEHANDLER;
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap<Object> lst = new SimpleOrderedMap<Object>();
        lst.add("commits", this.commitCommands.get());
        if (this.commitTracker.getDocsUpperBound() > 0) {
            lst.add("autocommit maxDocs", this.commitTracker.getDocsUpperBound());
        }
        if (this.commitTracker.getTimeUpperBound() > 0L) {
            lst.add("autocommit maxTime", "" + this.commitTracker.getTimeUpperBound() + "ms");
        }
        lst.add("autocommits", this.commitTracker.getCommitCount());
        if (this.softCommitTracker.getDocsUpperBound() > 0) {
            lst.add("soft autocommit maxDocs", this.softCommitTracker.getDocsUpperBound());
        }
        if (this.softCommitTracker.getTimeUpperBound() > 0L) {
            lst.add("soft autocommit maxTime", "" + this.softCommitTracker.getTimeUpperBound() + "ms");
        }
        lst.add("soft autocommits", this.softCommitTracker.getCommitCount());
        lst.add("optimizes", this.optimizeCommands.get());
        lst.add("rollbacks", this.rollbackCommands.get());
        lst.add("expungeDeletes", this.expungeDeleteCommands.get());
        lst.add("docsPending", this.numDocsPending.get());
        lst.add("adds", this.addCommands.get());
        lst.add("deletesById", this.deleteByIdCommands.get());
        lst.add("deletesByQuery", this.deleteByQueryCommands.get());
        lst.add("errors", this.numErrors.get());
        lst.add("cumulative_adds", this.addCommandsCumulative.get());
        lst.add("cumulative_deletesById", this.deleteByIdCommandsCumulative.get());
        lst.add("cumulative_deletesByQuery", this.deleteByQueryCommandsCumulative.get());
        lst.add("cumulative_errors", this.numErrorsCumulative.get());
        if (this.ulog != null) {
            lst.add("transaction_logs_total_size", this.ulog.getTotalLogsSize());
            lst.add("transaction_logs_total_number", this.ulog.getTotalLogsNumber());
        }
        return lst;
    }

    public String toString() {
        return "DirectUpdateHandler2" + this.getStatistics();
    }

    @Override
    public SolrCoreState getSolrCoreState() {
        return this.solrCoreState;
    }

    public CommitTracker getCommitTracker() {
        return this.commitTracker;
    }

    public CommitTracker getSoftCommitTracker() {
        return this.softCommitTracker;
    }
}

