/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.solr.store.blockcache.BufferStore;
import org.apache.solr.store.blockcache.Cache;
import org.apache.solr.store.blockcache.CachedIndexOutput;
import org.apache.solr.store.blockcache.CustomBufferedIndexInput;
import org.apache.solr.store.blockcache.Store;
import org.apache.solr.store.hdfs.HdfsDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockDirectory
extends Directory {
    public static Logger LOG = LoggerFactory.getLogger(BlockDirectory.class);
    public static final long BLOCK_SHIFT = 13L;
    public static final long BLOCK_MOD = 8191L;
    public static final int BLOCK_SIZE = 8192;
    public static Cache NO_CACHE = new Cache(){

        @Override
        public void update(String name, long blockId, int blockOffset, byte[] buffer, int offset, int length) {
        }

        @Override
        public boolean fetch(String name, long blockId, int blockOffset, byte[] b, int off, int lengthToReadInBlock) {
            return false;
        }

        @Override
        public void delete(String name) {
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public void renameCacheFile(String source, String dest) {
        }

        @Override
        public void releaseResources() {
        }
    };
    private final Directory directory;
    private final int blockSize;
    private final String dirName;
    private final Cache cache;
    private final Set<String> blockCacheFileTypes;
    private final boolean blockCacheReadEnabled;
    private final boolean blockCacheWriteEnabled;

    public static long getBlock(long pos) {
        return pos >>> 13;
    }

    public static long getPosition(long pos) {
        return pos & 0x1FFFL;
    }

    public static long getRealPosition(long block, long positionInBlock) {
        return (block << 13) + positionInBlock;
    }

    public BlockDirectory(String dirName, Directory directory, Cache cache, Set<String> blockCacheFileTypes, boolean blockCacheReadEnabled, boolean blockCacheWriteEnabled) throws IOException {
        this.dirName = dirName;
        this.directory = directory;
        this.blockSize = 8192;
        this.cache = cache;
        this.blockCacheFileTypes = blockCacheFileTypes == null || blockCacheFileTypes.isEmpty() ? null : blockCacheFileTypes;
        this.blockCacheReadEnabled = blockCacheReadEnabled;
        if (!blockCacheReadEnabled) {
            LOG.info("Block cache on read is disabled");
        }
        this.blockCacheWriteEnabled = blockCacheWriteEnabled;
        if (!blockCacheWriteEnabled) {
            LOG.info("Block cache on write is disabled");
        }
        if (directory.getLockFactory() != null) {
            this.setLockFactory(directory.getLockFactory());
        }
    }

    private IndexInput openInput(String name, int bufferSize, IOContext context) throws IOException {
        IndexInput source = this.directory.openInput(name, context);
        if (this.useReadCache(name, context)) {
            return new CachedIndexInput(source, this.blockSize, name, this.getFileCacheName(name), this.cache, bufferSize);
        }
        return source;
    }

    private boolean isCachableFile(String name) {
        for (String ext : this.blockCacheFileTypes) {
            if (!name.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        return this.openInput(name, this.blockSize, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            String[] files;
            for (String file : files = this.listAll()) {
                this.cache.delete(this.getFileCacheName(file));
            }
            this.cache.delete(this.dirName + "/" + "segments.gen");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            this.directory.close();
            this.cache.releaseResources();
        }
    }

    String getFileCacheName(String name) throws IOException {
        return this.getFileCacheLocation(name) + ":" + this.getFileModified(name);
    }

    private long getFileModified(String name) throws IOException {
        if (this.directory instanceof FSDirectory) {
            File directory = ((FSDirectory)this.directory).getDirectory();
            File file = new File(directory, name);
            if (!file.exists()) {
                throw new FileNotFoundException("File [" + name + "] not found");
            }
            return file.lastModified();
        }
        if (this.directory instanceof HdfsDirectory) {
            return ((HdfsDirectory)this.directory).fileModified(name);
        }
        throw new RuntimeException("Not supported");
    }

    @Override
    public void clearLock(String name) throws IOException {
        this.directory.clearLock(name);
    }

    String getFileCacheLocation(String name) {
        return this.dirName + "/" + name;
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public void copy(Directory to, String src, String dest, IOContext context) throws IOException {
        this.directory.copy(to, src, dest, context);
    }

    @Override
    public LockFactory getLockFactory() {
        return this.directory.getLockFactory();
    }

    @Override
    public String getLockID() {
        return this.directory.getLockID();
    }

    @Override
    public Lock makeLock(String name) {
        return this.directory.makeLock(name);
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.directory.setLockFactory(lockFactory);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.directory.sync(names);
    }

    @Override
    public String toString() {
        return this.directory.toString();
    }

    boolean useReadCache(String name, IOContext context) {
        if (!this.blockCacheReadEnabled) {
            return false;
        }
        if (this.blockCacheFileTypes != null && !this.isCachableFile(name)) {
            return false;
        }
        switch (context.context) {
            default: 
        }
        return true;
    }

    boolean useWriteCache(String name, IOContext context) {
        if (!this.blockCacheWriteEnabled) {
            return false;
        }
        if (this.blockCacheFileTypes != null && !this.isCachableFile(name)) {
            return false;
        }
        switch (context.context) {
            case MERGE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        IndexOutput dest = this.directory.createOutput(name, context);
        if (this.useWriteCache(name, context)) {
            return new CachedIndexOutput(this, dest, this.blockSize, name, this.cache, this.blockSize);
        }
        return dest;
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.cache.delete(this.getFileCacheName(name));
        this.directory.deleteFile(name);
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        return this.directory.fileExists(name);
    }

    @Override
    public long fileLength(String name) throws IOException {
        return this.directory.fileLength(name);
    }

    @Override
    public String[] listAll() throws IOException {
        return this.directory.listAll();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public boolean isBlockCacheReadEnabled() {
        return this.blockCacheReadEnabled;
    }

    public boolean isBlockCacheWriteEnabled() {
        return this.blockCacheWriteEnabled;
    }

    static class CachedIndexInput
    extends CustomBufferedIndexInput {
        private final Store store;
        private IndexInput source;
        private final int blockSize;
        private final long fileLength;
        private final String cacheName;
        private final Cache cache;

        public CachedIndexInput(IndexInput source, int blockSize, String name, String cacheName, Cache cache, int bufferSize) {
            super(name, bufferSize);
            this.source = source;
            this.blockSize = blockSize;
            this.fileLength = source.length();
            this.cacheName = cacheName;
            this.cache = cache;
            this.store = BufferStore.instance(blockSize);
        }

        @Override
        public IndexInput clone() {
            CachedIndexInput clone = (CachedIndexInput)super.clone();
            clone.source = this.source.clone();
            return clone;
        }

        @Override
        public long length() {
            return this.source.length();
        }

        @Override
        protected void seekInternal(long pos) throws IOException {
        }

        @Override
        protected void readInternal(byte[] b, int off, int len) throws IOException {
            long position = this.getFilePointer();
            while (len > 0) {
                int length = this.fetchBlock(position, b, off, len);
                position += (long)length;
                len -= length;
                off += length;
            }
        }

        private int fetchBlock(long position, byte[] b, int off, int len) throws IOException {
            int lengthToReadInBlock;
            int blockOffset;
            long blockId = BlockDirectory.getBlock(position);
            if (this.checkCache(blockId, blockOffset = (int)BlockDirectory.getPosition(position), b, off, lengthToReadInBlock = Math.min(len, this.blockSize - blockOffset))) {
                return lengthToReadInBlock;
            }
            this.readIntoCacheAndResult(blockId, blockOffset, b, off, lengthToReadInBlock);
            return lengthToReadInBlock;
        }

        private void readIntoCacheAndResult(long blockId, int blockOffset, byte[] b, int off, int lengthToReadInBlock) throws IOException {
            long position = BlockDirectory.getRealPosition(blockId, 0L);
            int length = (int)Math.min((long)this.blockSize, this.fileLength - position);
            this.source.seek(position);
            byte[] buf = this.store.takeBuffer(this.blockSize);
            this.source.readBytes(buf, 0, length);
            System.arraycopy(buf, blockOffset, b, off, lengthToReadInBlock);
            this.cache.update(this.cacheName, blockId, 0, buf, 0, this.blockSize);
            this.store.putBuffer(buf);
        }

        private boolean checkCache(long blockId, int blockOffset, byte[] b, int off, int lengthToReadInBlock) {
            return this.cache.fetch(this.cacheName, blockId, blockOffset, b, off, lengthToReadInBlock);
        }

        @Override
        protected void closeInternal() throws IOException {
            this.source.close();
        }
    }
}

