/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest.fst;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.spelling.suggest.LookupFactory;

public class AnalyzingInfixLookupFactory
extends LookupFactory {
    protected static final String QUERY_ANALYZER = "suggestAnalyzerFieldType";
    protected static final String INDEX_PATH = "indexPath";
    protected static final String MIN_PREFIX_CHARS = "minPrefixChars";
    private static final String DEFAULT_INDEX_PATH = "analyzingInfixSuggesterIndexDir";
    private static final String FILENAME = "iwfsta.bin";

    @Override
    public Lookup create(NamedList params, SolrCore core) {
        String indexPath;
        Object fieldTypeName = params.get(QUERY_ANALYZER);
        if (fieldTypeName == null) {
            throw new IllegalArgumentException("Error in configuration: suggestAnalyzerFieldType parameter is mandatory");
        }
        FieldType ft = core.getLatestSchema().getFieldTypeByName(fieldTypeName.toString());
        if (ft == null) {
            throw new IllegalArgumentException("Error in configuration: " + fieldTypeName.toString() + " is not defined in the schema");
        }
        Analyzer indexAnalyzer = ft.getIndexAnalyzer();
        Analyzer queryAnalyzer = ft.getQueryAnalyzer();
        String string = indexPath = params.get(INDEX_PATH) != null ? params.get(INDEX_PATH).toString() : DEFAULT_INDEX_PATH;
        if (!new File(indexPath).isAbsolute()) {
            indexPath = core.getDataDir() + File.separator + indexPath;
        }
        int minPrefixChars = params.get(MIN_PREFIX_CHARS) != null ? Integer.parseInt(params.get(MIN_PREFIX_CHARS).toString()) : 4;
        try {
            return new AnalyzingInfixSuggester(core.getSolrConfig().luceneMatchVersion, FSDirectory.open(new File(indexPath)), indexAnalyzer, queryAnalyzer, minPrefixChars){

                @Override
                public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, int num, boolean allTermsRequired, boolean doHighlight) throws IOException {
                    List<Lookup.LookupResult> res = super.lookup(key, contexts, num, allTermsRequired, doHighlight);
                    if (doHighlight) {
                        ArrayList<Lookup.LookupResult> res2 = new ArrayList<Lookup.LookupResult>();
                        for (Lookup.LookupResult hit : res) {
                            res2.add(new Lookup.LookupResult(hit.highlightKey.toString(), hit.highlightKey, hit.value, hit.payload, hit.contexts));
                        }
                        res = res2;
                    }
                    return res;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public String storeFileName() {
        return FILENAME;
    }
}

