/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.servlet.BaseSolrServlet;

public class RedirectServlet
extends BaseSolrServlet {
    static final String CONTEXT_KEY = "${context}";
    String destination;
    int code = 301;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.destination = config.getInitParameter("destination");
        if (this.destination == null) {
            throw new ServletException("RedirectServlet missing destination configuration");
        }
        if ("false".equals(config.getInitParameter("permanent"))) {
            this.code = 302;
        }
        if (this.destination.startsWith(CONTEXT_KEY)) {
            this.destination = config.getServletContext().getContextPath() + this.destination.substring(CONTEXT_KEY.length());
        }
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(this.code);
        res.setHeader("Location", this.destination);
    }
}

