/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;

public class StoredFieldsShardResponseProcessor
implements ShardResponseProcessor {
    @Override
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        boolean returnScores = (rb.getFieldFlags() & 1) != 0;
        ShardResponse srsp = shardRequest.responses.get(0);
        SolrDocumentList docs = (SolrDocumentList)srsp.getSolrResponse().getResponse().get("response");
        String uniqueIdFieldName = rb.req.getSchema().getUniqueKeyField().getName();
        for (SolrDocument doc : docs) {
            ShardDoc shardDoc;
            String id = doc.getFieldValue(uniqueIdFieldName).toString();
            ShardDoc fieldDoc = shardDoc = rb.resultIds.get(id);
            if (shardDoc == null) continue;
            if (returnScores && !Float.isNaN(fieldDoc.score)) {
                doc.setField("score", Float.valueOf(fieldDoc.score));
            }
            rb.retrievedDocuments.put(id, doc);
        }
    }
}

